/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.awt.Color;
import java.util.Locale;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;

public class ColorProperty
extends AbstractToStringProperty<Color> {
    private final String name;

    public ColorProperty(String string, String string2) {
        this(string, ColorHelper.html2color(string2));
    }

    public ColorProperty(String string, Color color) {
        super(ColorProperty.getColorKey(string), color);
        CheckParameterUtil.ensureParameterNotNull(color, "defaultValue");
        this.name = string;
        this.getPreferences().registerColor(ColorProperty.getColorKey(string), string);
    }

    @Override
    public Color get() {
        return (Color)super.get();
    }

    @Override
    public boolean put(Color color) {
        return super.put(color);
    }

    @Override
    protected Color fromString(String string) {
        return ColorHelper.html2color(string);
    }

    @Override
    protected String toString(Color color) {
        return ColorHelper.color2html(color, true);
    }

    public AbstractToStringProperty<Color> getChildColor(String string) {
        return this.getChildProperty(ColorProperty.getColorKey(string));
    }

    public String getName() {
        return this.name;
    }

    public static String getColorKey(String string) {
        return string == null ? null : "color." + string.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]+", ".");
    }

    public String toString() {
        return "ColorProperty [name=" + this.name + ", defaultValue=" + this.getDefaultValue() + "]";
    }
}

