/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.runtime.Signature;

public class IRFor
extends IRClosure {
    public IRFor(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, String labelPrefix) {
        super(manager, lexicalParent, lineNumber, StaticScopeFactory.newIRBlockScope(staticScope), signature, labelPrefix, labelPrefix == "_BEGIN_");
    }

    public IRFor(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature) {
        this(manager, lexicalParent, lineNumber, StaticScopeFactory.newIRBlockScope(staticScope), signature, "_FOR_LOOP_");
    }

    private IRFor(IRClosure c, IRScope lexicalParent, int id2, String fullName) {
        super(c, lexicalParent, id2, fullName);
    }

    @Override
    public IRScopeType getScopeType() {
        return IRScopeType.FOR;
    }

    @Override
    public IRClosure cloneForInlining(CloneInfo ii) {
        IRFor clonedClosure;
        IRScope lexicalParent = ii.getScope();
        if (ii instanceof SimpleCloneInfo) {
            clonedClosure = new IRFor(this, lexicalParent, this.closureId, this.getName());
        } else {
            int id2 = lexicalParent.getNextClosureId();
            String fullName = lexicalParent.getName() + "_FOR_LOOP_CLONE_" + id2;
            clonedClosure = new IRFor(this, lexicalParent, id2, fullName);
        }
        return this.cloneForInlining(ii, clonedClosure);
    }
}

