/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesKt;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.ClosureGenerationStrategy;
import org.jetbrains.kotlin.codegen.CodegenStatementVisitor;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.FieldAccessorKind;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionReferenceGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InterfaceImplBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.RangeCodegenUtil;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.StackValueWithLeaveTask;
import org.jetbrains.kotlin.codegen.TailRecursionCodegen;
import org.jetbrains.kotlin.codegen.TypeAndNullability;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegen;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.ResolvedCallWithRealDescriptor;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.inline.InlineCodegen;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenForDefaultBody;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.ReificationArgument;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.TypeParameterMappings;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicCallable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicPropertyGetter;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KCallableNameProperty;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenUtil;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.kotlin.TypeSignatureMappingKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.CastImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ExpressionCodegen
extends KtVisitor<StackValue, StackValue>
implements LocalLookup {
    private final GenerationState state;
    final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    public final InstructionAdapter v;
    public final FrameMap myFrameMap;
    public final MethodContext context;
    private final Type returnType;
    private final CodegenStatementVisitor statementVisitor;
    private final MemberCodegen<?> parentCodegen;
    private final TailRecursionCodegen tailRecursionCodegen;
    public final CallGenerator defaultCallGenerator;
    private final Stack<BlockStackElement> blockStackElements;
    public final Map<KtElement, StackValue> tempVariables;
    private int myLastLineNumber;
    private boolean shouldMarkLineNumbers;
    private int finallyDepth;

    public ExpressionCodegen(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull Type returnType, @NotNull MethodContext context, @NotNull GenerationState state2, @NotNull MemberCodegen<?> parentCodegen) {
        if (mv == null) {
            ExpressionCodegen.$$$reportNull$$$0(0);
        }
        if (frameMap == null) {
            ExpressionCodegen.$$$reportNull$$$0(1);
        }
        if (returnType == null) {
            ExpressionCodegen.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ExpressionCodegen.$$$reportNull$$$0(3);
        }
        if (state2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(4);
        }
        if (parentCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(5);
        }
        this.statementVisitor = new CodegenStatementVisitor(this);
        this.defaultCallGenerator = new CallGenerator.DefaultCallGenerator(this);
        this.blockStackElements = new Stack();
        this.tempVariables = Maps.newHashMap();
        this.myLastLineNumber = -1;
        this.shouldMarkLineNumbers = true;
        this.finallyDepth = 0;
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = state2.getBindingContext();
        this.v = new InstructionAdapter(mv);
        this.myFrameMap = frameMap;
        this.context = context;
        this.returnType = returnType;
        this.parentCodegen = parentCodegen;
        this.tailRecursionCodegen = new TailRecursionCodegen(context, this, this.v, state2);
    }

    @Nullable
    private static FunctionDescriptor getOriginalSuspendLambdaDescriptorFromContext(MethodContext context) {
        if (context.getParentContext() instanceof ClosureContext && context.getParentContext().closure != null && context.getParentContext().closure.isSuspend()) {
            return ((ClosureContext)context.getParentContext()).getOriginalSuspendLambdaDescriptor();
        }
        return null;
    }

    @NotNull
    public GenerationState getState() {
        GenerationState generationState = this.state;
        if (generationState == null) {
            ExpressionCodegen.$$$reportNull$$$0(6);
        }
        return generationState;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(7);
        }
        return bindingContext;
    }

    @NotNull
    public MemberCodegen<?> getParentCodegen() {
        MemberCodegen<?> memberCodegen = this.parentCodegen;
        if (memberCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(8);
        }
        return memberCodegen;
    }

    @NotNull
    public ObjectLiteralResult generateObjectLiteral(@NotNull KtObjectLiteralExpression literal) {
        if (literal == null) {
            ExpressionCodegen.$$$reportNull$$$0(9);
        }
        KtObjectDeclaration objectDeclaration = literal.getObjectDeclaration();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, objectDeclaration);
        assert (classDescriptor != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, objectDeclaration);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(objectDeclaration, (DeclarationDescriptor)classDescriptor), asmType, literal.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION);
        ImplementationBodyCodegen literalCodegen = new ImplementationBodyCodegen(objectDeclaration, objectContext, classBuilder2, this.state, this.getParentCodegen(), true);
        literalCodegen.generate();
        ExpressionCodegen.addReifiedParametersFromSignature(literalCodegen, classDescriptor);
        this.propagateChildReifiedTypeParametersUsages(literalCodegen.getReifiedTypeParametersUsages());
        ObjectLiteralResult objectLiteralResult = new ObjectLiteralResult(literalCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters(), classDescriptor);
        if (objectLiteralResult == null) {
            ExpressionCodegen.$$$reportNull$$$0(10);
        }
        return objectLiteralResult;
    }

    private static void addReifiedParametersFromSignature(@NotNull MemberCodegen member, @NotNull ClassDescriptor descriptor2) {
        if (member == null) {
            ExpressionCodegen.$$$reportNull$$$0(11);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(12);
        }
        for (KotlinType type2 : descriptor2.getTypeConstructor().getSupertypes()) {
            for (TypeProjection supertypeArgument : type2.getArguments()) {
                TypeParameterDescriptor parameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(supertypeArgument.getType());
                if (parameterDescriptor == null || !parameterDescriptor.isReified()) continue;
                member.getReifiedTypeParametersUsages().addUsedReifiedParameter(parameterDescriptor.getName().asString());
            }
        }
    }

    @NotNull
    private StackValue castToRequiredTypeOfInterfaceIfNeeded(StackValue inner, @NotNull ClassDescriptor provided, @NotNull ClassDescriptor required) {
        if (provided == null) {
            ExpressionCodegen.$$$reportNull$$$0(13);
        }
        if (required == null) {
            ExpressionCodegen.$$$reportNull$$$0(14);
        }
        if (!JvmCodegenUtil.isJvmInterface(provided) && JvmCodegenUtil.isJvmInterface(required)) {
            StackValue stackValue = StackValue.coercion(inner, this.asmType(required.getDefaultType()));
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(15);
            }
            return stackValue;
        }
        StackValue stackValue = inner;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(16);
        }
        return stackValue;
    }

    public StackValue genQualified(StackValue receiver, KtElement selector) {
        return this.genQualified(receiver, selector, this);
    }

    private StackValue genQualified(StackValue receiver, KtElement selector, KtVisitor<StackValue, StackValue> visitor2) {
        if (this.tempVariables.containsKey(selector)) {
            throw new IllegalStateException("Inconsistent state: expression saved to a temporary variable is a selector");
        }
        if (!(selector instanceof KtBlockExpression)) {
            this.markStartLineNumber(selector);
        }
        try {
            StackValue samValue;
            if (selector instanceof KtExpression && (samValue = this.genSamInterfaceValue((KtExpression)selector, visitor2)) != null) {
                return samValue;
            }
            StackValue stackValue = selector.accept(visitor2, receiver);
            RuntimeAssertionInfo runtimeAssertionInfo = null;
            if (selector instanceof KtExpression) {
                runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, (KtExpression)selector);
            }
            if (BuiltinSpecialBridgesKt.isValueArgumentForCallToMethodWithTypeCheckBarrier(selector, this.bindingContext)) {
                return stackValue;
            }
            return AsmUtil.genNotNullAssertions(this.state, stackValue, runtimeAssertionInfo);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Throwable error) {
            String message = error.getMessage();
            throw new CompilationException(message != null ? message : "null", error, selector);
        }
    }

    public StackValue gen(KtElement expr) {
        StackValue tempVar = this.tempVariables.get(expr);
        return tempVar != null ? tempVar : this.genQualified(StackValue.none(), expr);
    }

    public void gen(KtElement expr, Type type2) {
        StackValue value = Type.VOID_TYPE.equals(type2) ? this.genStatement(expr) : this.gen(expr);
        this.putStackValue(expr, type2, value);
    }

    private void putStackValue(@Nullable KtElement expr, @NotNull Type type2, @NotNull StackValue value) {
        ScriptContext context;
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(17);
        }
        if (value == null) {
            ExpressionCodegen.$$$reportNull$$$0(18);
        }
        if (value.type != Type.VOID_TYPE && this.state.getReplSpecific().getShouldGenerateScriptResultValue() && expr == (context = this.getScriptContext()).getLastStatement()) {
            StackValue.Field resultValue = StackValue.field(context.getResultFieldInfo(), (StackValue)StackValue.LOCAL_0);
            resultValue.store(value, this.v);
            this.state.getReplSpecific().setHasResult(true);
            return;
        }
        value.put(type2, this.v);
    }

    @NotNull
    private ScriptContext getScriptContext() {
        CodegenContext context = this.getContext();
        while (!(context instanceof ScriptContext)) {
            context = ((CodegenContext)context).getParentContext();
        }
        ScriptContext scriptContext = (ScriptContext)context;
        if (scriptContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(19);
        }
        return scriptContext;
    }

    public StackValue genLazy(KtElement expr, Type type2) {
        StackValue value = this.gen(expr);
        return StackValue.coercion(value, type2);
    }

    private StackValue genStatement(KtElement statement) {
        return this.genQualified(StackValue.none(), statement, this.statementVisitor);
    }

    @Override
    public StackValue visitClass(@NotNull KtClass klass2, StackValue data) {
        if (klass2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(20);
        }
        return this.visitClassOrObject(klass2);
    }

    @Override
    public StackValue visitTypeAlias(@NotNull KtTypeAlias typeAlias, StackValue data) {
        if (typeAlias == null) {
            ExpressionCodegen.$$$reportNull$$$0(21);
        }
        return StackValue.none();
    }

    private StackValue visitClassOrObject(KtClassOrObject declaration) {
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, declaration);
        assert (descriptor2 != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, declaration);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration, (DeclarationDescriptor)descriptor2), asmType, declaration.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(descriptor2, this, OwnerKind.IMPLEMENTATION);
        new ImplementationBodyCodegen(declaration, objectContext, classBuilder2, this.state, this.getParentCodegen(), true).generate();
        if (declaration instanceof KtClass && ((KtClass)declaration).isInterface()) {
            Type traitImplType = this.state.getTypeMapper().mapDefaultImpls(descriptor2);
            ClassBuilder traitImplBuilder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.DefaultImpls(declaration, descriptor2), traitImplType, declaration.getContainingFile());
            ClassContext traitImplContext = this.context.intoAnonymousClass(descriptor2, this, OwnerKind.DEFAULT_IMPLS);
            new InterfaceImplBodyCodegen(declaration, traitImplContext, traitImplBuilder, this.state, this.parentCodegen).generate();
        }
        return StackValue.none();
    }

    @Override
    public StackValue visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, StackValue data) {
        if (declaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(22);
        }
        return this.visitClassOrObject(declaration);
    }

    @Override
    public StackValue visitExpression(@NotNull KtExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException("Codegen for " + expression + " is not yet implemented");
    }

    @Override
    public StackValue visitSuperExpression(@NotNull KtSuperExpression expression, StackValue data) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(24);
        }
        return StackValue.thisOrOuter(this, ExpressionCodegen.getSuperCallLabelTarget(this.context, expression), true, false);
    }

    @NotNull
    public static ClassDescriptor getSuperCallLabelTarget(@NotNull CodegenContext<?> context, @NotNull KtSuperExpression expression) {
        if (context == null) {
            ExpressionCodegen.$$$reportNull$$$0(25);
        }
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(26);
        }
        KotlinType thisTypeForSuperCall = context.getState().getBindingContext().get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression);
        assert (thisTypeForSuperCall != null) : "This type for superCall ''" + expression.getText() + "'' should be not null!";
        ClassifierDescriptor descriptor2 = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
        assert (descriptor2 instanceof ClassDescriptor) : "'This' reference target for ''" + expression.getText() + "''should be class descriptor, but was " + descriptor2;
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
        if (classDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(27);
        }
        return classDescriptor;
    }

    @NotNull
    private Type asmType(@NotNull KotlinType type2) {
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(28);
        }
        Type type3 = this.typeMapper.mapType(type2);
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(29);
        }
        return type3;
    }

    @NotNull
    private Type expressionTypeForBranchingOperation(@Nullable KtExpression expression) {
        if (this.context.getFunctionDescriptor().isSuspend() && !CoroutineCodegenUtilKt.isStateMachineNeeded(this.context.getFunctionDescriptor(), this.bindingContext) && Boolean.TRUE.equals(this.bindingContext.get(BindingContext.IS_TAIL_EXPRESSION_IN_SUSPEND_FUNCTION, expression))) {
            Type type2 = AsmTypes.OBJECT_TYPE;
            if (type2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(30);
            }
            return type2;
        }
        Type type3 = this.expressionType(expression);
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(31);
        }
        return type3;
    }

    @NotNull
    public Type expressionType(@Nullable KtExpression expression) {
        Type type2 = CodegenUtilKt.asmType(expression, this.typeMapper, this.bindingContext);
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(32);
        }
        return type2;
    }

    @Nullable
    private KotlinType expressionJetType(@Nullable KtExpression expression) {
        return CodegenUtilKt.kotlinType(expression, this.bindingContext);
    }

    @Override
    public StackValue visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(33);
        }
        return this.genQualified(receiver, expression.getExpression());
    }

    @Override
    public StackValue visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(34);
        }
        return this.genQualified(receiver, expression.getBaseExpression());
    }

    private static boolean isEmptyExpression(@Nullable KtElement expr) {
        KtBlockExpression blockExpression;
        List<KtExpression> statements;
        if (expr == null) {
            return true;
        }
        return expr instanceof KtBlockExpression && ((statements = (blockExpression = (KtBlockExpression)expr).getStatements()).size() == 0 || statements.size() == 1 && ExpressionCodegen.isEmptyExpression(statements.get(0)));
    }

    @Override
    public StackValue visitIfExpression(@NotNull KtIfExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(35);
        }
        return this.generateIfExpression(expression, false);
    }

    StackValue generateIfExpression(final @NotNull KtIfExpression expression, final boolean isStatement) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(36);
        }
        final Type asmType = isStatement ? Type.VOID_TYPE : this.expressionTypeForBranchingOperation(expression);
        final StackValue condition = this.gen(expression.getCondition());
        final KtExpression thenExpression = expression.getThen();
        final KtExpression elseExpression = expression.getElse();
        if (ExpressionCodegen.isEmptyExpression(thenExpression)) {
            if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
                return StackValue.coercion(condition, asmType);
            }
            return this.generateSingleBranchIf(condition, expression, elseExpression, false, isStatement);
        }
        if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
            return this.generateSingleBranchIf(condition, expression, thenExpression, true, isStatement);
        }
        return StackValue.operation(asmType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                Label elseLabel = new Label();
                BranchedValue.Companion.condJump(condition, elseLabel, true, v);
                Label end = new Label();
                ExpressionCodegen.this.gen(thenExpression, asmType);
                v.goTo(end);
                v.mark(elseLabel);
                ExpressionCodegen.this.gen(elseExpression, asmType);
                ExpressionCodegen.this.markLineNumber(expression, isStatement);
                v.mark(end);
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitWhileExpression(final @NotNull KtWhileExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(37);
        }
        return StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter adapter) {
                ExpressionCodegen.this.generateWhile(expression);
                return Unit.INSTANCE;
            }
        });
    }

    private void generateWhile(@NotNull KtWhileExpression expression) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(38);
        }
        Label condition = new Label();
        this.v.mark(condition);
        Label end = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(end, condition, ExpressionCodegen.targetLabel(expression)));
        StackValue conditionValue = this.gen(expression.getCondition());
        BranchedValue.Companion.loopJump(conditionValue, end, true, this.v);
        this.generateLoopBody(expression.getBody());
        this.markStartLineNumber(expression);
        this.v.goTo(condition);
        this.v.mark(end);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitDoWhileExpression(final @NotNull KtDoWhileExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(39);
        }
        return StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter adapter) {
                ExpressionCodegen.this.generateDoWhile(expression);
                return Unit.INSTANCE;
            }
        });
    }

    private void generateDoWhile(@NotNull KtDoWhileExpression expression) {
        StackValue conditionValue;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(40);
        }
        Label beginLoopLabel = new Label();
        this.v.mark(beginLoopLabel);
        Label breakLabel = new Label();
        Label continueLabel = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(breakLabel, continueLabel, ExpressionCodegen.targetLabel(expression)));
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, breakLabel);
        KtExpression body = expression.getBody();
        KtExpression condition = expression.getCondition();
        StackValueWithLeaveTask leaveTask = null;
        if (body instanceof KtBlockExpression) {
            List<KtExpression> doWhileStatements = ((KtBlockExpression)body).getStatements();
            ArrayList<KtExpression> statements = new ArrayList<KtExpression>(doWhileStatements.size() + 1);
            statements.addAll(doWhileStatements);
            statements.add(condition);
            leaveTask = this.generateBlock(statements, false, continueLabel, null);
            conditionValue = leaveTask.getStackValue();
        } else {
            if (body != null) {
                this.gen(body, Type.VOID_TYPE);
            }
            this.v.mark(continueLabel);
            conditionValue = this.gen(condition);
        }
        BranchedValue.Companion.loopJump(conditionValue, beginLoopLabel, false, this.v);
        if (leaveTask != null) {
            leaveTask.getLeaveTasks().invoke(conditionValue);
        }
        this.v.mark(breakLabel);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitForExpression(final @NotNull KtForExpression forExpression, StackValue receiver) {
        if (forExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(41);
        }
        return StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter adapter) {
                ExpressionCodegen.this.generateFor(forExpression);
                return Unit.INSTANCE;
            }
        });
    }

    private void generateFor(@NotNull KtForExpression forExpression) {
        AbstractForLoopGenerator optimizedForLoopGenerator;
        ResolvedCall<? extends CallableDescriptor> loopRangeCall;
        if (forExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(42);
        }
        if ((loopRangeCall = RangeCodegenUtil.getLoopRangeResolvedCall(forExpression, this.bindingContext)) != null && (optimizedForLoopGenerator = this.createOptimizedForLoopGeneratorOrNull(forExpression, loopRangeCall)) != null) {
            this.generateForLoop(optimizedForLoopGenerator);
            return;
        }
        KtExpression loopRange = forExpression.getLoopRange();
        assert (loopRange != null);
        KotlinType loopRangeType = this.bindingContext.getType(loopRange);
        assert (loopRangeType != null);
        Type asmLoopRangeType = this.asmType(loopRangeType);
        if (asmLoopRangeType.getSort() == 9) {
            this.generateForLoop(new ForInArrayLoopGenerator(forExpression));
        } else if (RangeCodegenUtil.isRange(loopRangeType)) {
            this.generateForLoop(new ForInRangeInstanceLoopGenerator(forExpression));
        } else if (RangeCodegenUtil.isProgression(loopRangeType)) {
            this.generateForLoop(new ForInProgressionExpressionLoopGenerator(forExpression));
        } else {
            this.generateForLoop(new IteratorForLoopGenerator(forExpression));
        }
    }

    @Nullable
    private AbstractForLoopGenerator createOptimizedForLoopGeneratorOrNull(@NotNull KtForExpression forExpression, @NotNull ResolvedCall<? extends CallableDescriptor> loopRangeCall) {
        CallableDescriptor loopRangeCallee;
        if (forExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(43);
        }
        if (loopRangeCall == null) {
            ExpressionCodegen.$$$reportNull$$$0(44);
        }
        if (RangeCodegenUtil.isPrimitiveNumberRangeTo(loopRangeCallee = loopRangeCall.getResultingDescriptor())) {
            return new ForInRangeLiteralLoopGenerator(forExpression, loopRangeCall);
        }
        if (RangeCodegenUtil.isPrimitiveNumberDownTo(loopRangeCallee)) {
            return new ForInDownToProgressionLoopGenerator(forExpression, loopRangeCall);
        }
        if (RangeCodegenUtil.isArrayOrPrimitiveArrayIndices(loopRangeCallee)) {
            return new ForInArrayIndicesRangeLoopGenerator(forExpression, loopRangeCall);
        }
        if (RangeCodegenUtil.isCollectionIndices(loopRangeCallee)) {
            return new ForInCollectionIndicesRangeLoopGenerator(forExpression, loopRangeCall);
        }
        if (RangeCodegenUtil.isCharSequenceIndices(loopRangeCallee)) {
            return new ForInCharSequenceIndicesRangeLoopGenerator(forExpression, loopRangeCall);
        }
        return null;
    }

    @NotNull
    private static KotlinType getExpectedReceiverType(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(45);
        }
        ReceiverParameterDescriptor extensionReceiver = resolvedCall2.getResultingDescriptor().getExtensionReceiverParameter();
        assert (extensionReceiver != null) : "Extension receiver should be non-null";
        KotlinType kotlinType = extensionReceiver.getType();
        if (kotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(46);
        }
        return kotlinType;
    }

    @Nullable
    private static KtExpression getSingleArgumentExpression(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        List<ResolvedValueArgument> resolvedValueArguments;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(47);
        }
        if ((resolvedValueArguments = resolvedCall2.getValueArgumentsByIndex()) == null) {
            return null;
        }
        if (resolvedValueArguments.size() != 1) {
            return null;
        }
        List<ValueArgument> valueArguments2 = resolvedValueArguments.get(0).getArguments();
        if (valueArguments2.size() != 1) {
            return null;
        }
        return valueArguments2.get(0).getArgumentExpression();
    }

    private OwnerKind contextKind() {
        return this.context.getContextKind();
    }

    private void generateForLoop(AbstractForLoopGenerator generator) {
        Label loopExit = new Label();
        Label loopEntry = new Label();
        Label continueLabel = new Label();
        generator.beforeLoop();
        generator.checkEmptyLoop(loopExit);
        this.v.mark(loopEntry);
        generator.checkPreCondition(loopExit);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        generator.beforeBody();
        this.blockStackElements.push(new LoopBlockStackElement(loopExit, continueLabel, ExpressionCodegen.targetLabel(generator.forExpression)));
        generator.body();
        this.blockStackElements.pop();
        this.v.mark(continueLabel);
        generator.afterBody(loopExit);
        this.v.goTo(loopEntry);
        this.v.mark(loopExit);
        generator.afterLoop();
    }

    private void generateLoopBody(@Nullable KtExpression body) {
        if (body != null) {
            this.gen(body, Type.VOID_TYPE);
        }
    }

    @Override
    public StackValue visitBreakExpression(@NotNull KtBreakExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(48);
        }
        return this.generateBreakOrContinueExpression(expression, true, new Label());
    }

    @Override
    public StackValue visitContinueExpression(@NotNull KtContinueExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(49);
        }
        return this.generateBreakOrContinueExpression(expression, false, new Label());
    }

    @NotNull
    private StackValue generateBreakOrContinueExpression(@NotNull KtExpressionWithLabel expression, boolean isBreak, final @NotNull Label afterBreakContinueLabel) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(50);
        }
        if (afterBreakContinueLabel == null) {
            ExpressionCodegen.$$$reportNull$$$0(51);
        }
        assert (expression instanceof KtContinueExpression || expression instanceof KtBreakExpression);
        if (this.blockStackElements.isEmpty()) {
            throw new UnsupportedOperationException("Target label for break/continue not found");
        }
        BlockStackElement stackElement = this.blockStackElements.peek();
        if (stackElement instanceof FinallyBlockStackElement) {
            FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
            this.genFinallyBlockOrGoto(finallyBlockStackElement, null, afterBreakContinueLabel);
        } else if (stackElement instanceof LoopBlockStackElement) {
            LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement;
            KtSimpleNameExpression labelElement = expression.getTargetLabel();
            if (labelElement == null || loopBlockStackElement.targetLabel != null && labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName())) {
                final Label label = isBreak ? loopBlockStackElement.breakLabel : loopBlockStackElement.continueLabel;
                StackValue stackValue = StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

                    @Override
                    public Unit invoke(InstructionAdapter adapter) {
                        PseudoInsnsKt.fixStackAndJump(ExpressionCodegen.this.v, label);
                        ExpressionCodegen.this.v.mark(afterBreakContinueLabel);
                        return Unit.INSTANCE;
                    }
                });
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(52);
                }
                return stackValue;
            }
        } else {
            throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
        }
        this.blockStackElements.pop();
        StackValue result2 = this.generateBreakOrContinueExpression(expression, isBreak, afterBreakContinueLabel);
        this.blockStackElements.push(stackElement);
        StackValue stackValue = result2;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(53);
        }
        return stackValue;
    }

    private StackValue generateSingleBranchIf(final StackValue condition, final KtIfExpression ifExpression, final KtExpression expression, final boolean inverse, final boolean isStatement) {
        Type targetType = isStatement ? Type.VOID_TYPE : this.expressionType(ifExpression);
        return StackValue.operation(targetType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                Label elseLabel = new Label();
                BranchedValue.Companion.condJump(condition, elseLabel, inverse, v);
                if (isStatement) {
                    ExpressionCodegen.this.gen(expression, Type.VOID_TYPE);
                    v.mark(elseLabel);
                } else {
                    Type targetType = ExpressionCodegen.this.expressionType(ifExpression);
                    ExpressionCodegen.this.gen(expression, targetType);
                    Label end = new Label();
                    v.goTo(end);
                    v.mark(elseLabel);
                    StackValue.putUnitInstance(v);
                    ExpressionCodegen.this.markStartLineNumber(ifExpression);
                    v.mark(end);
                }
                return null;
            }
        });
    }

    @Override
    public StackValue visitConstantExpression(@NotNull KtConstantExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(54);
        }
        ConstantValue<?> compileTimeValue = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expression, this.bindingContext, this.state.getShouldInlineConstVals());
        assert (compileTimeValue != null);
        return StackValue.constant(compileTimeValue.getValue(), this.expressionType(expression));
    }

    @Nullable
    public static ConstantValue<?> getPrimitiveOrStringCompileTimeConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        ConstantValue<?> constant;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(55);
        }
        if (bindingContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(56);
        }
        if ((constant = ExpressionCodegen.getCompileTimeConstant(expression, bindingContext, false, shouldInlineConstVals)) == null || ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constant)) {
            return null;
        }
        return constant;
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(57);
        }
        if (bindingContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(58);
        }
        return ExpressionCodegen.getCompileTimeConstant(expression, bindingContext, false, shouldInlineConstVals);
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression, final @NotNull BindingContext bindingContext, boolean takeUpConstValsAsConst, boolean shouldInlineConstVals) {
        KotlinType expectedType;
        CompileTimeConstant<?> compileTimeValue;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(59);
        }
        if (bindingContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(60);
        }
        if ((compileTimeValue = ConstantExpressionEvaluator.getConstant(expression, bindingContext)) == null || compileTimeValue.getUsesNonConstValAsConstant()) {
            return null;
        }
        if (!shouldInlineConstVals && !takeUpConstValsAsConst && compileTimeValue.getUsesVariableAsConstant()) {
            final Ref<Boolean> containsNonInlinedVals = new Ref<Boolean>(false);
            KtVisitor constantChecker = new KtVisitor(){

                public Object visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, Object data) {
                    CallableDescriptor callableDescriptor;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    if (expression == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if ((resolvedCall2 = CallUtilKt.getResolvedCall(expression, bindingContext)) != null && (callableDescriptor = resolvedCall2.getResultingDescriptor()) instanceof PropertyDescriptor && !JvmCodegenUtil.isInlinedJavaConstProperty((VariableDescriptor)callableDescriptor)) {
                        containsNonInlinedVals.set(true);
                    }
                    return null;
                }

                public Object visitKtElement(@NotNull KtElement element, Object data) {
                    if (element == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    if (!((Boolean)containsNonInlinedVals.get()).booleanValue()) {
                        element.acceptChildren(this);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$7";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitSimpleNameExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitKtElement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            expression.accept(constantChecker);
            if (containsNonInlinedVals.get().booleanValue()) {
                return null;
            }
        }
        if ((expectedType = bindingContext.getType(expression)) == null) {
            return null;
        }
        return compileTimeValue.toConstantValue(expectedType);
    }

    @Override
    public StackValue visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(61);
        }
        StringBuilder constantValue = new StringBuilder("");
        final KtStringTemplateEntry[] entries = expression.getEntries();
        if (entries.length == 1 && entries[0] instanceof KtStringTemplateEntryWithExpression) {
            KtExpression expr = entries[0].getExpression();
            return AsmUtil.genToString(this.gen(expr), this.expressionType(expr));
        }
        for (KtStringTemplateEntry entry : entries) {
            if (entry instanceof KtLiteralStringTemplateEntry) {
                constantValue.append(entry.getText());
                continue;
            }
            if (entry instanceof KtEscapeStringTemplateEntry) {
                constantValue.append(((KtEscapeStringTemplateEntry)entry).getUnescapedValue());
                continue;
            }
            constantValue = null;
            break;
        }
        if (constantValue != null) {
            Type type2 = this.expressionType(expression);
            return StackValue.constant(constantValue.toString(), type2);
        }
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                AsmUtil.genStringBuilderConstructor(v);
                for (KtStringTemplateEntry entry : entries) {
                    if (entry instanceof KtStringTemplateEntryWithExpression) {
                        ExpressionCodegen.this.invokeAppend(entry.getExpression());
                        continue;
                    }
                    String text2 = entry instanceof KtEscapeStringTemplateEntry ? ((KtEscapeStringTemplateEntry)entry).getUnescapedValue() : entry.getText();
                    v.aconst(text2);
                    AsmUtil.genInvokeAppendMethod(v, AsmTypes.JAVA_STRING_TYPE);
                }
                v.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitBlockExpression(@NotNull KtBlockExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(62);
        }
        return this.generateBlock(expression, false);
    }

    @Override
    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data) {
        if (function2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(63);
        }
        return this.visitNamedFunction(function2, data, false);
    }

    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data, boolean isStatement) {
        if (function2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(64);
        }
        assert (data == StackValue.none());
        if (KtPsiUtil.isScriptDeclaration(function2)) {
            return StackValue.none();
        }
        StackValue closure = this.genClosure(function2, null);
        if (isStatement) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            int index2 = this.lookupLocalIndex(descriptor2);
            closure.put(AsmTypes.OBJECT_TYPE, this.v);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
            return StackValue.none();
        }
        return closure;
    }

    @Override
    public StackValue visitLambdaExpression(@NotNull KtLambdaExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(65);
        }
        if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BLOCK, expression))) {
            return this.gen(expression.getFunctionLiteral().getBodyExpression());
        }
        return this.genClosure(expression.getFunctionLiteral(), null);
    }

    @NotNull
    private StackValue genClosure(KtDeclarationWithBody declaration, @Nullable SamType samType) {
        FunctionDescriptor descriptor2 = this.bindingContext.get(BindingContext.FUNCTION, declaration);
        assert (descriptor2 != null) : "Function is not resolved to descriptor: " + declaration.getText();
        StackValue stackValue = this.genClosure(declaration, descriptor2, new ClosureGenerationStrategy(this.state, declaration), samType, null, null);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(66);
        }
        return stackValue;
    }

    @NotNull
    private StackValue genClosure(@NotNull KtElement declaration, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy, @Nullable SamType samType, @Nullable FunctionDescriptor functionReferenceTarget, @Nullable StackValue functionReferenceReceiver) {
        ClassBuilder cv;
        ClosureCodegen coroutineCodegen;
        if (declaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(67);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(68);
        }
        if (strategy == null) {
            ExpressionCodegen.$$$reportNull$$$0(69);
        }
        ClosureCodegen closureCodegen = (coroutineCodegen = CoroutineCodegen.createByLambda(this, descriptor2, declaration, cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration, (DeclarationDescriptor)descriptor2), CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, descriptor2), declaration.getContainingFile()))) != null ? coroutineCodegen : new ClosureCodegen(this.state, declaration, samType, this.context.intoClosure(descriptor2, this, this.typeMapper), functionReferenceTarget, strategy, this.parentCodegen, cv);
        closureCodegen.generate();
        StackValue stackValue = this.putClosureInstanceOnStack(closureCodegen, functionReferenceReceiver);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(70);
        }
        return stackValue;
    }

    @NotNull
    public StackValue putClosureInstanceOnStack(@NotNull ClosureCodegen closureCodegen, @Nullable StackValue functionReferenceReceiver) {
        if (closureCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(71);
        }
        if (closureCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters()) {
            ReifiedTypeInliner.putNeedClassReificationMarker(this.v);
            this.propagateChildReifiedTypeParametersUsages(closureCodegen.getReifiedTypeParametersUsages());
        }
        StackValue stackValue = closureCodegen.putInstanceOnStack(this, functionReferenceReceiver);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(72);
        }
        return stackValue;
    }

    @Override
    public StackValue visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(73);
        }
        final ObjectLiteralResult objectLiteralResult = this.generateObjectLiteral(expression);
        final ClassDescriptor classDescriptor = objectLiteralResult.classDescriptor;
        final Type type2 = this.typeMapper.mapType(classDescriptor);
        return StackValue.operation(type2, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                if (objectLiteralResult.wereReifiedMarkers) {
                    ReifiedTypeInliner.putNeedClassReificationMarker(v);
                }
                v.anew(type2);
                v.dup();
                ExpressionCodegen.this.pushClosureOnStack(classDescriptor, true, ExpressionCodegen.this.defaultCallGenerator, null);
                ClassConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
                assert (primaryConstructor2 != null) : "There should be primary constructor for object literal";
                ResolvedCall<ConstructorDescriptor> superCall = BindingContextUtils.getDelegationConstructorCall(ExpressionCodegen.this.bindingContext, primaryConstructor2);
                if (superCall != null) {
                    ConstructorDescriptor superConstructor = superCall.getResultingDescriptor();
                    ConstructorDescriptor constructorToCall = SamCodegenUtil.resolveSamAdapter(superConstructor);
                    List<ValueParameterDescriptor> superValueParameters = superConstructor.getValueParameters();
                    int params = superValueParameters.size();
                    List<Type> superMappedTypes = ExpressionCodegen.this.typeMapper.mapToCallableMethod(constructorToCall, false).getValueParameterTypes();
                    assert (superMappedTypes.size() >= params) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", superMappedTypes.size(), params, classDescriptor);
                    ArrayList<ResolvedValueArgument> valueArguments2 = new ArrayList<ResolvedValueArgument>(params);
                    ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(params);
                    ArrayList<Type> mappedTypes = new ArrayList<Type>(params);
                    for (ValueParameterDescriptor parameter : superValueParameters) {
                        ResolvedValueArgument argument = superCall.getValueArguments().get(parameter);
                        if (argument instanceof DefaultValueArgument) continue;
                        valueArguments2.add(argument);
                        valueParameters.add(parameter);
                        mappedTypes.add(superMappedTypes.get(parameter.getIndex()));
                    }
                    CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(ExpressionCodegen.this, ExpressionCodegen.this.defaultCallGenerator, valueParameters, mappedTypes);
                    ((ArgumentGenerator)argumentGenerator).generate(valueArguments2, valueArguments2, null);
                }
                Collection<ClassConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
                assert (constructors2.size() == 1) : "Unexpected number of constructors for class: " + classDescriptor + " " + constructors2;
                ConstructorDescriptor constructorDescriptor = CollectionsKt.single(constructors2);
                Method constructor = ExpressionCodegen.this.typeMapper.mapAsmMethod(SamCodegenUtil.resolveSamAdapter(constructorDescriptor));
                v.invokespecial(type2.getInternalName(), "<init>", constructor.getDescriptor(), false);
                return Unit.INSTANCE;
            }
        });
    }

    public void pushClosureOnStack(@NotNull ClassDescriptor classDescriptor, boolean putThis, @NotNull CallGenerator callGenerator, @Nullable StackValue functionReferenceReceiver) {
        KotlinType captureReceiver;
        ClassDescriptor captureThis;
        CalculatedClosure closure;
        if (classDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(74);
        }
        if (callGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(75);
        }
        if ((closure = (CalculatedClosure)this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor)) == null) {
            return;
        }
        int paramIndex = 0;
        if (putThis && (captureThis = closure.getCaptureThis()) != null) {
            StackValue thisOrOuter = this.generateThisOrOuter(captureThis, false);
            assert (!AsmUtil.isPrimitive(thisOrOuter.type)) : "This or outer should be non primitive: " + thisOrOuter.type;
            callGenerator.putCapturedValueOnStack(thisOrOuter, thisOrOuter.type, paramIndex++);
        }
        if ((captureReceiver = closure.getCaptureReceiverType()) != null) {
            StackValue capturedReceiver = functionReferenceReceiver != null ? functionReferenceReceiver : this.generateExtensionReceiver(ExpressionCodegen.unwrapOriginalReceiverOwnerForSuspendFunction(this.context));
            callGenerator.putCapturedValueOnStack(capturedReceiver, capturedReceiver.type, paramIndex++);
        }
        for (Map.Entry entry : closure.getCaptureVariables().entrySet()) {
            Type sharedVarType = this.typeMapper.getSharedVarType((DeclarationDescriptor)entry.getKey());
            if (sharedVarType == null) {
                sharedVarType = this.typeMapper.mapType((VariableDescriptor)entry.getKey());
            }
            StackValue capturedVar = this.lookupOuterValue((EnclosedValueDescriptor)entry.getValue());
            callGenerator.putCapturedValueOnStack(capturedVar, sharedVarType, paramIndex++);
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassNotAny(classDescriptor);
        if (superClass != null) {
            this.pushClosureOnStack(superClass, putThis && closure.getCaptureThis() == null, callGenerator, null);
        }
        if (closure.isSuspend()) {
            if (closure.isSuspendLambda()) {
                this.v.aconst(null);
            } else {
                assert (this.context.getFunctionDescriptor().isSuspend()) : "Coroutines closure must be created only inside suspend functions";
                ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.last(this.context.getFunctionDescriptor().getValueParameters());
                StackValue continuationValue = this.findLocalOrCapturedValue(valueParameterDescriptor);
                assert (continuationValue != null) : "Couldn't find a value for continuation parameter of " + this.context.getFunctionDescriptor();
                callGenerator.putCapturedValueOnStack(continuationValue, continuationValue.type, paramIndex++);
            }
        }
    }

    @NotNull
    private static CallableDescriptor unwrapOriginalReceiverOwnerForSuspendFunction(@NotNull MethodContext context) {
        FunctionDescriptor originalForDoResume;
        if (context == null) {
            ExpressionCodegen.$$$reportNull$$$0(76);
        }
        if ((originalForDoResume = context.getFunctionDescriptor().getUserData(CoroutineCodegenUtilKt.INITIAL_SUSPEND_DESCRIPTOR_FOR_DO_RESUME)) != null) {
            FunctionDescriptor functionDescriptor = originalForDoResume;
            if (functionDescriptor == null) {
                ExpressionCodegen.$$$reportNull$$$0(77);
            }
            return functionDescriptor;
        }
        if (context.getFunctionDescriptor().isSuspend()) {
            FunctionDescriptor functionDescriptor = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(context.getFunctionDescriptor());
            if (functionDescriptor == null) {
                ExpressionCodegen.$$$reportNull$$$0(78);
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = context.getFunctionDescriptor();
        if (functionDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(79);
        }
        return functionDescriptor;
    }

    StackValue generateBlock(@NotNull KtBlockExpression expression, boolean isStatement) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(80);
        }
        if (expression.getParent() instanceof KtNamedFunction) {
            return this.generateBlock(expression.getStatements(), isStatement, null, this.context.getMethodEndLabel());
        }
        return this.generateBlock(expression.getStatements(), isStatement, null, null);
    }

    @NotNull
    public StackValue lookupOuterValue(EnclosedValueDescriptor d) {
        DeclarationDescriptor descriptor2 = d.getDescriptor();
        for (LocalLookup.LocalLookupCase aCase : LocalLookup.LocalLookupCase.values()) {
            if (!aCase.isCase(descriptor2)) continue;
            StackValue stackValue = aCase.outerValue(d, this);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(81);
            }
            return stackValue;
        }
        throw new IllegalStateException("Can't get outer value in " + this + " for " + d);
    }

    private StackValueWithLeaveTask generateBlock(@NotNull List<KtExpression> statements, boolean isStatement, @Nullable Label labelBeforeLastExpression, final @Nullable Label labelBlockEnd) {
        if (statements == null) {
            ExpressionCodegen.$$$reportNull$$$0(82);
        }
        final Label blockEnd = labelBlockEnd != null ? labelBlockEnd : new Label();
        final ArrayList<Function<StackValue, Void>> leaveTasks = Lists.newArrayList();
        StackValue blockResult = null;
        Iterator<KtExpression> iterator2 = statements.iterator();
        while (iterator2.hasNext()) {
            StackValue statementResult;
            boolean isExpression;
            KtNamedDeclaration declaration;
            KtExpression possiblyLabeledStatement = iterator2.next();
            KtExpression statement = KtPsiUtil.safeDeparenthesize(possiblyLabeledStatement);
            if (statement instanceof KtNamedDeclaration && KtPsiUtil.isScriptDeclaration(declaration = (KtNamedDeclaration)statement)) continue;
            this.putDescriptorIntoFrameMap(statement);
            boolean bl = isExpression = !iterator2.hasNext() && !isStatement;
            if (isExpression && labelBeforeLastExpression != null) {
                this.v.mark(labelBeforeLastExpression);
            }
            StackValue stackValue = statementResult = isExpression ? this.gen(possiblyLabeledStatement) : this.genStatement(possiblyLabeledStatement);
            if (!iterator2.hasNext()) {
                blockResult = statementResult;
            } else {
                statementResult.put(Type.VOID_TYPE, this.v);
            }
            this.addLeaveTaskToRemoveDescriptorFromFrameMap(statement, blockEnd, leaveTasks);
        }
        if (statements.isEmpty()) {
            blockResult = StackValue.none();
        }
        assert (blockResult != null) : "Block result should be initialized in the loop or the condition above";
        return new StackValueWithLeaveTask(blockResult, (Function1<? super StackValue, Unit>)new Function1<StackValue, Unit>(){

            @Override
            public Unit invoke(StackValue value) {
                if (labelBlockEnd == null) {
                    ExpressionCodegen.this.v.mark(blockEnd);
                }
                for (Function task : Lists.reverse(leaveTasks)) {
                    task.fun(value);
                }
                return Unit.INSTANCE;
            }
        });
    }

    @Nullable
    private StackValue getCoroutineInstanceValueForSuspensionPoint(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor enclosingSuspendLambdaForSuspensionPoint;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(83);
        }
        if ((enclosingSuspendLambdaForSuspensionPoint = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall())) == null) {
            return null;
        }
        return this.genCoroutineInstanceBySuspendFunction(enclosingSuspendLambdaForSuspensionPoint);
    }

    @Nullable
    private StackValue genCoroutineInstanceBySuspendFunction(@NotNull FunctionDescriptor suspendFunction) {
        if (suspendFunction == null) {
            ExpressionCodegen.$$$reportNull$$$0(84);
        }
        if (!CoroutineCodegenUtilKt.isStateMachineNeeded(suspendFunction, this.bindingContext)) {
            return null;
        }
        ClassDescriptor suspendLambdaClassDescriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_CALLABLE, suspendFunction);
        assert (suspendLambdaClassDescriptor != null) : "Coroutine class descriptor should not be null";
        return StackValue.thisOrOuter(this, suspendLambdaClassDescriptor, false, false);
    }

    @NotNull
    private Type getVariableType(@NotNull VariableDescriptor variableDescriptor) {
        Type sharedVarType;
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(85);
        }
        Type type2 = (sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor)) != null ? sharedVarType : this.getVariableTypeNoSharing(variableDescriptor);
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(86);
        }
        return type2;
    }

    @NotNull
    private Type getVariableTypeNoSharing(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(87);
        }
        KotlinType varType = JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor) ? JvmCodegenUtil.getPropertyDelegateType((VariableDescriptorWithAccessors)variableDescriptor, this.bindingContext) : variableDescriptor.getType();
        Type type2 = this.asmType(varType);
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(88);
        }
        return type2;
    }

    private void putDescriptorIntoFrameMap(@NotNull KtElement statement) {
        if (statement == null) {
            ExpressionCodegen.$$$reportNull$$$0(89);
        }
        if (statement instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.putLocalVariableIntoFrameMap(entry);
            }
        }
        if (statement instanceof KtVariableDeclaration) {
            this.putLocalVariableIntoFrameMap((KtVariableDeclaration)statement);
        }
        if (statement instanceof KtNamedFunction) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement);
            assert (descriptor2 instanceof FunctionDescriptor) : "Couldn't find function declaration in binding context " + statement.getText();
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            this.myFrameMap.enter(descriptor2, type2);
        }
    }

    private void putLocalVariableIntoFrameMap(@NotNull KtVariableDeclaration statement) {
        VariableDescriptor variableDescriptor;
        if (statement == null) {
            ExpressionCodegen.$$$reportNull$$$0(90);
        }
        if ((variableDescriptor = this.getVariableDescriptorNotNull(statement)).getName().isSpecial()) {
            return;
        }
        Type type2 = this.getVariableType(variableDescriptor);
        int index2 = this.myFrameMap.enter(variableDescriptor, type2);
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            this.myFrameMap.enter(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext), AsmTypes.K_PROPERTY0_TYPE);
        }
        if (AsmTypes.isSharedVarType(type2)) {
            this.markLineNumber(statement, false);
            this.v.anew(type2);
            this.v.dup();
            this.v.invokespecial(type2.getInternalName(), "<init>", "()V", false);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
        }
    }

    private void addLeaveTaskToRemoveDescriptorFromFrameMap(@NotNull KtElement statement, @NotNull Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement == null) {
            ExpressionCodegen.$$$reportNull$$$0(91);
        }
        if (blockEnd == null) {
            ExpressionCodegen.$$$reportNull$$$0(92);
        }
        if (leaveTasks == null) {
            ExpressionCodegen.$$$reportNull$$$0(93);
        }
        if (statement instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.addLeaveTaskToRemoveLocalVariableFromFrameMap(entry, blockEnd, leaveTasks);
            }
        }
        if (statement instanceof KtVariableDeclaration) {
            this.addLeaveTaskToRemoveLocalVariableFromFrameMap((KtVariableDeclaration)statement, blockEnd, leaveTasks);
        }
        if (statement instanceof KtNamedFunction) {
            this.addLeaveTaskToRemoveNamedFunctionFromFrameMap((KtNamedFunction)statement, blockEnd, leaveTasks);
        }
    }

    private void addLeaveTaskToRemoveLocalVariableFromFrameMap(@NotNull KtVariableDeclaration statement, final Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        VariableDescriptor variableDescriptor;
        if (statement == null) {
            ExpressionCodegen.$$$reportNull$$$0(94);
        }
        if (leaveTasks == null) {
            ExpressionCodegen.$$$reportNull$$$0(95);
        }
        if ((variableDescriptor = this.getVariableDescriptorNotNull(statement)).getName().isSpecial()) {
            return;
        }
        final Type type2 = this.getVariableType(variableDescriptor);
        final Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add(new Function<StackValue, Void>(){

            @Override
            public Void fun(StackValue answer) {
                if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
                    ExpressionCodegen.this.myFrameMap.leave(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, ExpressionCodegen.this.bindingContext));
                }
                int index2 = ExpressionCodegen.this.myFrameMap.leave(variableDescriptor);
                if (AsmTypes.isSharedVarType(type2)) {
                    ExpressionCodegen.this.v.aconst(null);
                    ExpressionCodegen.this.v.store(index2, AsmTypes.OBJECT_TYPE);
                }
                ExpressionCodegen.this.v.visitLocalVariable(variableDescriptor.getName().asString(), type2.getDescriptor(), null, scopeStart, blockEnd, index2);
                return null;
            }
        });
    }

    private void addLeaveTaskToRemoveNamedFunctionFromFrameMap(final @NotNull KtNamedFunction statement, final Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement == null) {
            ExpressionCodegen.$$$reportNull$$$0(96);
        }
        if (leaveTasks == null) {
            ExpressionCodegen.$$$reportNull$$$0(97);
        }
        final FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement);
        assert (functionDescriptor != null);
        final Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, functionDescriptor);
        final Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add(new Function<StackValue, Void>(){

            @Override
            public Void fun(StackValue answer) {
                int index2 = ExpressionCodegen.this.myFrameMap.leave(functionDescriptor);
                assert (!functionDescriptor.getName().isSpecial()) : "Local variable should be generated only for function with name: " + statement.getText();
                ExpressionCodegen.this.v.visitLocalVariable(functionDescriptor.getName().asString() + "$", type2.getDescriptor(), null, scopeStart, blockEnd, index2);
                return null;
            }
        });
    }

    public boolean isShouldMarkLineNumbers() {
        return this.shouldMarkLineNumbers;
    }

    public void setShouldMarkLineNumbers(boolean shouldMarkLineNumbers) {
        this.shouldMarkLineNumbers = shouldMarkLineNumbers;
    }

    public void markStartLineNumber(@NotNull KtElement element) {
        if (element == null) {
            ExpressionCodegen.$$$reportNull$$$0(98);
        }
        this.markLineNumber(element, false);
    }

    public void markLineNumber(@NotNull KtElement statement, boolean markEndOffset) {
        if (statement == null) {
            ExpressionCodegen.$$$reportNull$$$0(99);
        }
        if (!this.shouldMarkLineNumbers) {
            return;
        }
        Integer lineNumber = CodegenUtil.getLineNumberForElement(statement, markEndOffset);
        if (lineNumber == null || lineNumber == this.myLastLineNumber) {
            return;
        }
        this.myLastLineNumber = lineNumber;
        Label label = new Label();
        this.v.visitLabel(label);
        this.v.visitLineNumber(lineNumber, label);
    }

    public void markLineNumberAfterInlineIfNeeded() {
        if (!this.shouldMarkLineNumbers) {
            if (this.myLastLineNumber > -1) {
                Label label = new Label();
                this.v.visitLabel(label);
                this.v.visitLineNumber(this.myLastLineNumber, label);
            }
        } else {
            this.myLastLineNumber = -1;
        }
    }

    public int getLastLineNumber() {
        return this.myLastLineNumber;
    }

    private void doFinallyOnReturn(@NotNull Label afterReturnLabel) {
        if (afterReturnLabel == null) {
            ExpressionCodegen.$$$reportNull$$$0(100);
        }
        if (!this.blockStackElements.isEmpty()) {
            BlockStackElement stackElement = this.blockStackElements.peek();
            if (stackElement instanceof FinallyBlockStackElement) {
                FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
                this.genFinallyBlockOrGoto(finallyBlockStackElement, null, afterReturnLabel);
            } else if (!(stackElement instanceof LoopBlockStackElement)) {
                throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
            }
            this.blockStackElements.pop();
            this.doFinallyOnReturn(afterReturnLabel);
            this.blockStackElements.push(stackElement);
        }
    }

    public boolean hasFinallyBlocks() {
        for (BlockStackElement element : this.blockStackElements) {
            if (!(element instanceof FinallyBlockStackElement)) continue;
            return true;
        }
        return false;
    }

    private void genFinallyBlockOrGoto(@Nullable FinallyBlockStackElement finallyBlockStackElement, @Nullable Label tryCatchBlockEnd, @Nullable Label afterJumpLabel) {
        if (finallyBlockStackElement != null) {
            ++this.finallyDepth;
            assert (finallyBlockStackElement.gaps.size() % 2 == 0) : "Finally block gaps are inconsistent";
            BlockStackElement topOfStack = this.blockStackElements.pop();
            assert (topOfStack == finallyBlockStackElement) : "Top element of stack doesn't equals processing finally block";
            KtTryExpression jetTryExpression = finallyBlockStackElement.expression;
            Label finallyStart = new Label();
            this.v.mark(finallyStart);
            finallyBlockStackElement.addGapLabel(finallyStart);
            if (InlineCodegenUtil.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtil.generateFinallyMarker(this.v, this.finallyDepth, true);
            }
            this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
            if (InlineCodegenUtil.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtil.generateFinallyMarker(this.v, this.finallyDepth, false);
            }
        }
        if (tryCatchBlockEnd != null) {
            this.v.goTo(tryCatchBlockEnd);
        }
        if (finallyBlockStackElement != null) {
            Label finallyEnd;
            --this.finallyDepth;
            Label label = finallyEnd = afterJumpLabel != null ? afterJumpLabel : new Label();
            if (afterJumpLabel == null) {
                this.v.mark(finallyEnd);
            }
            finallyBlockStackElement.addGapLabel(finallyEnd);
            this.blockStackElements.push(finallyBlockStackElement);
        }
    }

    @Override
    public StackValue visitReturnExpression(final @NotNull KtReturnExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(101);
        }
        return StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter adapter) {
                boolean isNonLocalReturn;
                KtExpression returnedExpression = expression.getReturnedExpression();
                CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)ExpressionCodegen.this.getContext().getContextDescriptor();
                NonLocalReturnInfo nonLocalReturn = ExpressionCodegen.this.getNonLocalReturnInfo(descriptor2, expression);
                boolean bl = isNonLocalReturn = nonLocalReturn != null;
                if (isNonLocalReturn && ExpressionCodegen.this.state.isInlineDisabled()) {
                    ExpressionCodegen.this.state.getDiagnostics().report(Errors.NON_LOCAL_RETURN_IN_DISABLED_INLINE.on(expression));
                    AsmUtil.genThrow(ExpressionCodegen.this.v, "java/lang/UnsupportedOperationException", "Non-local returns are not allowed with inlining disabled");
                    return Unit.INSTANCE;
                }
                Type returnType = isNonLocalReturn ? nonLocalReturn.returnType : ExpressionCodegen.this.returnType;
                StackValue valueToReturn = returnedExpression != null ? ExpressionCodegen.this.gen(returnedExpression) : StackValue.none();
                ExpressionCodegen.this.putStackValue(returnedExpression, returnType, valueToReturn);
                Label afterReturnLabel = new Label();
                ExpressionCodegen.this.generateFinallyBlocksIfNeeded(returnType, afterReturnLabel);
                if (isNonLocalReturn) {
                    InlineCodegenUtil.generateGlobalReturnFlag(ExpressionCodegen.this.v, nonLocalReturn.labelName);
                    ExpressionCodegen.this.v.visitInsn(returnType.getOpcode(172));
                } else {
                    ExpressionCodegen.this.v.areturn(ExpressionCodegen.this.returnType);
                }
                ExpressionCodegen.this.v.mark(afterReturnLabel);
                return Unit.INSTANCE;
            }
        });
    }

    public void generateFinallyBlocksIfNeeded(Type returnType, @NotNull Label afterReturnLabel) {
        if (afterReturnLabel == null) {
            ExpressionCodegen.$$$reportNull$$$0(102);
        }
        if (this.hasFinallyBlocks()) {
            if (!Type.VOID_TYPE.equals(returnType)) {
                int returnValIndex = this.myFrameMap.enterTemp(returnType);
                StackValue.Local localForReturnValue = StackValue.local(returnValIndex, returnType);
                localForReturnValue.store(StackValue.onStack(returnType), this.v);
                this.doFinallyOnReturn(afterReturnLabel);
                localForReturnValue.put(returnType, this.v);
                this.myFrameMap.leaveTemp(returnType);
            } else {
                this.doFinallyOnReturn(afterReturnLabel);
            }
        }
    }

    @Nullable
    private NonLocalReturnInfo getNonLocalReturnInfo(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtReturnExpression expression) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(103);
        }
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(104);
        }
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            if (expression.getLabelName() == null) {
                if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
                    FunctionDescriptor containingFunction = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(descriptor2, true).getFirst();
                    return new NonLocalReturnInfo(this.typeMapper.mapReturnType(containingFunction), "$$$$$ROOT$$$$$");
                }
                return null;
            }
            PsiElement element = this.bindingContext.get(BindingContext.LABEL_TARGET, expression.getTargetLabel());
            if (element != DescriptorToSourceUtils.getSourceFromDescriptor(this.context.getContextDescriptor())) {
                DeclarationDescriptor elementDescriptor = this.typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                assert (element != null) : "Expression should be not null " + expression.getText();
                assert (elementDescriptor != null) : "Descriptor should be not null: " + element.getText();
                return new NonLocalReturnInfo(this.typeMapper.mapReturnType((CallableDescriptor)elementDescriptor), expression.getLabelName());
            }
        }
        return null;
    }

    public void returnExpression(KtExpression expr) {
        boolean isBlockedNamedFunction = expr instanceof KtBlockExpression && expr.getParent() instanceof KtNamedFunction;
        FunctionDescriptor originalSuspendLambdaDescriptor = ExpressionCodegen.getOriginalSuspendLambdaDescriptorFromContext(this.context);
        boolean isVoidCoroutineLambda = originalSuspendLambdaDescriptor != null && TypeSignatureMappingKt.hasVoidReturnType(originalSuspendLambdaDescriptor);
        Type typeForExpression = isBlockedNamedFunction || isVoidCoroutineLambda ? Type.VOID_TYPE : this.returnType;
        this.gen(expr, typeForExpression);
        if (!ExpressionCodegen.endsWithReturn(expr)) {
            this.markLineNumber(expr, true);
            if (ExpressionCodegen.isLambdaVoidBody(expr, typeForExpression)) {
                this.markLineNumber((KtFunctionLiteral)expr.getParent(), true);
            }
            if (typeForExpression.getSort() == 0) {
                StackValue.none().put(this.returnType, this.v);
            }
            this.v.areturn(this.returnType);
        }
    }

    private static boolean endsWithReturn(KtElement bodyExpression) {
        if (bodyExpression instanceof KtBlockExpression) {
            List<KtExpression> statements = ((KtBlockExpression)bodyExpression).getStatements();
            return statements.size() > 0 && statements.get(statements.size() - 1) instanceof KtReturnExpression;
        }
        return bodyExpression instanceof KtReturnExpression;
    }

    private static boolean isLambdaVoidBody(KtElement bodyExpression, Type returnType) {
        PsiElement parent2;
        if (bodyExpression instanceof KtBlockExpression && (parent2 = bodyExpression.getParent()) instanceof KtFunctionLiteral) {
            return Type.VOID_TYPE.equals(returnType);
        }
        return false;
    }

    @Override
    public StackValue visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @NotNull StackValue receiver) {
        ClassDescriptor classDescriptor;
        StackValue intrinsicResult;
        DeclarationDescriptor descriptor2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(105);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(106);
        }
        if ((resolvedCall2 = CallUtilKt.getResolvedCall(expression, this.bindingContext)) == null) {
            descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        } else {
            StackValue intrinsicResult2;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall call2 = (VariableAsFunctionResolvedCall)((Object)resolvedCall2);
                resolvedCall2 = call2.getVariableCall();
            }
            if ((intrinsicResult2 = this.applyIntrinsic(descriptor2 = resolvedCall2.getResultingDescriptor(), KCallableNameProperty.class, resolvedCall2, receiver)) != null) {
                return intrinsicResult2;
            }
            receiver = StackValue.receiver(resolvedCall2, receiver, this, null);
            if (descriptor2 instanceof FakeCallableDescriptorForObject) {
                descriptor2 = ((FakeCallableDescriptorForObject)descriptor2).getReferencedDescriptor();
            }
        }
        assert (descriptor2 != null) : "Couldn't find descriptor for '" + expression.getText() + "'";
        boolean isSyntheticField = (descriptor2 = descriptor2.getOriginal()) instanceof SyntheticFieldDescriptor;
        if (isSyntheticField) {
            descriptor2 = ((SyntheticFieldDescriptor)descriptor2).getPropertyDescriptor();
        }
        if ((intrinsicResult = this.applyIntrinsic(descriptor2, IntrinsicPropertyGetter.class, resolvedCall2, receiver)) != null) {
            return intrinsicResult;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            ClassDescriptor superCallTarget;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
            if (!codegenExtensions.isEmpty() && resolvedCall2 != null) {
                ExpressionCodegenExtension.Context context = new ExpressionCodegenExtension.Context(this.typeMapper, this.v);
                KotlinType returnType = propertyDescriptor.getReturnType();
                for (ExpressionCodegenExtension extension : codegenExtensions) {
                    StackValue value;
                    if (returnType == null || (value = extension.applyProperty(receiver, resolvedCall2, context)) == null) continue;
                    return value;
                }
            }
            boolean directToField = isSyntheticField && this.contextKind() != OwnerKind.DEFAULT_IMPLS;
            ClassDescriptor classDescriptor2 = superCallTarget = resolvedCall2 == null ? null : this.getSuperCallTarget(resolvedCall2.getCall());
            if (directToField) {
                receiver = StackValue.receiverWithoutReceiverArgument(receiver);
            }
            return this.intermediateValueForProperty(propertyDescriptor, directToField, directToField, superCallTarget, false, receiver, resolvedCall2);
        }
        if (descriptor2 instanceof TypeAliasDescriptor) {
            classDescriptor = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            if (classDescriptor == null) {
                throw new IllegalStateException("Type alias " + descriptor2 + " static member refernece should be rejected by type checker, since there is no class corresponding to this type alias.");
            }
            descriptor2 = classDescriptor;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            classDescriptor = (ClassDescriptor)descriptor2;
            if (DescriptorUtils.isObject(classDescriptor)) {
                return StackValue.singleton(classDescriptor, this.typeMapper);
            }
            if (DescriptorUtils.isEnumEntry(classDescriptor)) {
                return StackValue.enumEntry(classDescriptor, this.typeMapper);
            }
            ClassDescriptor companionObjectDescriptor2 = classDescriptor.getCompanionObjectDescriptor();
            if (companionObjectDescriptor2 != null) {
                return StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            }
            return StackValue.none();
        }
        StackValue localOrCaptured = this.findLocalOrCapturedValue(descriptor2);
        if (localOrCaptured != null) {
            return localOrCaptured;
        }
        throw new UnsupportedOperationException("don't know how to generate reference " + descriptor2);
    }

    @Nullable
    private StackValue applyIntrinsic(DeclarationDescriptor descriptor2, Class<? extends IntrinsicPropertyGetter> intrinsicType, ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(107);
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor memberDescriptor = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
            IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(memberDescriptor);
            if (intrinsicType.isInstance(intrinsic)) {
                Type returnType = this.typeMapper.mapType(memberDescriptor);
                return ((IntrinsicPropertyGetter)intrinsic).generate(resolvedCall2, this, returnType, receiver);
            }
        }
        return null;
    }

    @Nullable
    private ClassDescriptor getSuperCallTarget(@NotNull Call call2) {
        KtSuperExpression superExpression;
        if (call2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(108);
        }
        return (superExpression = CallResolverUtilKt.getSuperCallExpression(call2)) == null ? null : ExpressionCodegen.getSuperCallLabelTarget(this.context, superExpression);
    }

    @Nullable
    public StackValue findLocalOrCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        int index2;
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(109);
        }
        if ((index2 = this.lookupLocalIndex(descriptor2)) >= 0) {
            return this.stackValueForLocal(descriptor2, index2);
        }
        return this.findCapturedValue(descriptor2);
    }

    @Nullable
    public StackValue findCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(110);
        }
        if (this.context instanceof ConstructorContext) {
            return this.lookupCapturedValueInConstructorParameters(descriptor2);
        }
        return ExpressionCodegen.lookupValuaAndLocalVariableMetadata(descriptor2, StackValue.LOCAL_0, this.state, false, this.context, this);
    }

    @Nullable
    static StackValue lookupValuaAndLocalVariableMetadata(@NotNull DeclarationDescriptor descriptor2, @NotNull StackValue prefix, @NotNull GenerationState state2, boolean ignoreNoOuter, @NotNull CodegenContext context, @Nullable ExpressionCodegen codegen) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(111);
        }
        if (prefix == null) {
            ExpressionCodegen.$$$reportNull$$$0(112);
        }
        if (state2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(113);
        }
        if (context == null) {
            ExpressionCodegen.$$$reportNull$$$0(114);
        }
        StackValue value = context.lookupInContext(descriptor2, prefix, state2, ignoreNoOuter);
        if (!JvmCodegenUtil.isDelegatedLocalVariable(descriptor2) || value == null) {
            return value;
        }
        VariableDescriptor metadata2 = CodegenBinding.getDelegatedLocalVariableMetadata((VariableDescriptor)descriptor2, state2.getBindingContext());
        StackValue metadataValue = context.lookupInContext(metadata2, prefix, state2, ignoreNoOuter);
        assert (metadataValue != null) : "Metadata stack value should be non-null for local delegated property";
        if (codegen == null) {
            return null;
        }
        return codegen.delegatedVariableValue(value, metadataValue, (VariableDescriptorWithAccessors)descriptor2, state2.getTypeMapper());
    }

    @Nullable
    private StackValue lookupCapturedValueInConstructorParameters(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(115);
        }
        StackValue parentResult = this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
        if (this.context.closure == null || parentResult == null) {
            return parentResult;
        }
        int parameterOffsetInConstructor = this.context.closure.getCapturedParameterOffsetInConstructor(descriptor2);
        if (parameterOffsetInConstructor == -1) {
            return parentResult;
        }
        assert (parentResult instanceof StackValue.Field || parentResult instanceof StackValue.FieldForSharedVar) : "Part of closure should be either Field or FieldForSharedVar";
        if (parentResult instanceof StackValue.FieldForSharedVar) {
            return StackValue.shared(parameterOffsetInConstructor, parentResult.type);
        }
        return this.adjustVariableValue(StackValue.local(parameterOffsetInConstructor, parentResult.type), descriptor2);
    }

    private StackValue stackValueForLocal(DeclarationDescriptor descriptor2, int index2) {
        if (descriptor2 instanceof VariableDescriptor) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
            Type sharedVarType = this.typeMapper.getSharedVarType(descriptor2);
            Type varType = this.getVariableTypeNoSharing(variableDescriptor);
            if (sharedVarType != null) {
                return StackValue.shared(index2, varType);
            }
            return this.adjustVariableValue(StackValue.local(index2, varType), variableDescriptor);
        }
        return StackValue.local(index2, AsmTypes.OBJECT_TYPE);
    }

    @Override
    public boolean lookupLocal(DeclarationDescriptor descriptor2) {
        return this.lookupLocalIndex(descriptor2) != -1;
    }

    public int lookupLocalIndex(DeclarationDescriptor descriptor2) {
        int index2 = this.myFrameMap.getIndex(descriptor2);
        if (index2 != -1) {
            return index2;
        }
        if (!(descriptor2 instanceof ValueParameterDescriptor)) {
            return -1;
        }
        DeclarationDescriptor synonym = this.bindingContext.get(CodegenBinding.PARAMETER_SYNONYM, (ValueParameterDescriptor)descriptor2);
        if (synonym == null) {
            return -1;
        }
        return this.myFrameMap.getIndex(synonym);
    }

    @NotNull
    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, @Nullable ClassDescriptor superCallTarget, @NotNull StackValue receiver) {
        if (propertyDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(116);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(117);
        }
        StackValue.Property property = this.intermediateValueForProperty(propertyDescriptor, forceField, false, superCallTarget, false, receiver, null);
        if (property == null) {
            ExpressionCodegen.$$$reportNull$$$0(118);
        }
        return property;
    }

    private CodegenContext getBackingFieldContext(@NotNull FieldAccessorKind accessorKind, @NotNull DeclarationDescriptor containingDeclaration) {
        if (accessorKind == null) {
            ExpressionCodegen.$$$reportNull$$$0(119);
        }
        if (containingDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(120);
        }
        switch (accessorKind) {
            case NORMAL: {
                return this.context.getParentContext();
            }
            case IN_CLASS_COMPANION: {
                return this.context.findParentContextWithDescriptor(containingDeclaration.getContainingDeclaration());
            }
            case FIELD_FROM_LOCAL: {
                return this.context.findParentContextWithDescriptor(containingDeclaration);
            }
        }
        throw new IllegalStateException();
    }

    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, boolean syntheticBackingField, @Nullable ClassDescriptor superCallTarget, boolean skipAccessorsForPrivateFieldInOuterClass, @NotNull StackValue receiver, @Nullable ResolvedCall resolvedCall2) {
        String fieldName;
        boolean skipPropertyAccessors;
        if (propertyDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(121);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(122);
        }
        if (propertyDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return this.intermediateValueForSyntheticExtensionProperty((SyntheticJavaPropertyDescriptor)propertyDescriptor, receiver);
        }
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        FieldAccessorKind fieldAccessorKind = FieldAccessorKind.NORMAL;
        boolean isBackingFieldInClassCompanion = JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor);
        if (isBackingFieldInClassCompanion && (forceField || propertyDescriptor.isConst() && Visibilities.isPrivate(propertyDescriptor.getVisibility()))) {
            fieldAccessorKind = FieldAccessorKind.IN_CLASS_COMPANION;
        } else if (syntheticBackingField && this.context.getFirstCrossInlineOrNonInlineContext().getParentContext().getContextDescriptor() != containingDeclaration) {
            fieldAccessorKind = FieldAccessorKind.FIELD_FROM_LOCAL;
        }
        boolean isStaticBackingField = DescriptorUtils.isStaticDeclaration(propertyDescriptor) || AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor);
        boolean isSuper = superCallTarget != null;
        boolean isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType(propertyDescriptor, this.bindingContext);
        boolean isDelegatedProperty = delegateType != null;
        CallableMethod callableGetter = null;
        CallableMethod callableSetter = null;
        CodegenContext backingFieldContext = this.getBackingFieldContext(fieldAccessorKind, containingDeclaration);
        DeclarationDescriptor ownerDescriptor = containingDeclaration;
        PropertyDescriptor originalPropertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        if (fieldAccessorKind != FieldAccessorKind.NORMAL) {
            int flags = AsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegatedProperty);
            boolean isInlinedConst = propertyDescriptor.isConst() && this.state.getShouldInlineConstVals();
            boolean bl = skipPropertyAccessors = isInlinedConst || (flags & 2) == 0 || skipAccessorsForPrivateFieldInOuterClass;
            if (!skipPropertyAccessors) {
                propertyDescriptor = backingFieldContext.getAccessor(propertyDescriptor, fieldAccessorKind, delegateType, superCallTarget);
                assert (propertyDescriptor instanceof AccessorForPropertyBackingField) : "Unexpected accessor descriptor: " + propertyDescriptor;
                ownerDescriptor = propertyDescriptor;
            }
        } else {
            if (!isBackingFieldInClassCompanion) {
                ownerDescriptor = propertyDescriptor;
            }
            skipPropertyAccessors = forceField;
        }
        if (!skipPropertyAccessors) {
            PropertySetterDescriptor setter2;
            if (!JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals())) {
                propertyDescriptor = this.context.getAccessorForSuperCallIfNeeded(propertyDescriptor, superCallTarget, this.state);
                PropertyGetterDescriptor getter2 = (propertyDescriptor = this.context.accessibleDescriptor(propertyDescriptor, superCallTarget)).getGetter();
                if (getter2 != null && !JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor)) {
                    callableGetter = this.typeMapper.mapToCallableMethod(getter2, isSuper);
                }
            }
            if (propertyDescriptor.isVar() && (setter2 = propertyDescriptor.getSetter()) != null && !JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, false, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals()) && !JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor)) {
                callableSetter = this.typeMapper.mapToCallableMethod(setter2, isSuper);
            }
        }
        if (!isStaticBackingField) {
            propertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        }
        Type backingFieldOwner = this.typeMapper.mapOwner(ownerDescriptor);
        if (isExtensionProperty && !isDelegatedProperty) {
            fieldName = null;
        } else if (originalPropertyDescriptor.getContainingDeclaration() == backingFieldContext.getContextDescriptor()) {
            assert (backingFieldContext instanceof FieldOwnerContext) : "Actual context is " + backingFieldContext + " but should be instance of FieldOwnerContext";
            fieldName = ((FieldOwnerContext)backingFieldContext).getFieldName(propertyDescriptor, isDelegatedProperty);
        } else {
            fieldName = KotlinTypeMapper.mapDefaultFieldName(propertyDescriptor, isDelegatedProperty);
        }
        return StackValue.property(propertyDescriptor, backingFieldOwner, this.typeMapper.mapType(isDelegatedProperty && forceField ? delegateType : propertyDescriptor.getOriginal().getType()), isStaticBackingField, fieldName, callableGetter, callableSetter, receiver, this, resolvedCall2);
    }

    @NotNull
    private StackValue.Property intermediateValueForSyntheticExtensionProperty(@NotNull SyntheticJavaPropertyDescriptor propertyDescriptor, @NotNull StackValue receiver) {
        if (propertyDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(123);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(124);
        }
        Type type2 = this.typeMapper.mapType(propertyDescriptor.getOriginal().getType());
        CallableMethod callableGetter = this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(propertyDescriptor.getGetMethod(), null), false);
        FunctionDescriptor setMethod = propertyDescriptor.getSetMethod();
        CallableMethod callableSetter = setMethod != null ? this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(setMethod, null), false) : null;
        StackValue.Property property = StackValue.property(propertyDescriptor, null, type2, false, null, callableGetter, callableSetter, receiver, this, null);
        if (property == null) {
            ExpressionCodegen.$$$reportNull$$$0(125);
        }
        return property;
    }

    @Override
    public StackValue visitCallExpression(@NotNull KtCallExpression expression, StackValue receiver) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        FunctionDescriptor descriptor2;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(126);
        }
        if ((descriptor2 = this.accessibleFunctionDescriptor(resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext))) instanceof ConstructorDescriptor) {
            return this.generateNewCall(expression, resolvedCall2);
        }
        if (descriptor2.getOriginal() instanceof SamConstructorDescriptor) {
            KtExpression argumentExpression = this.bindingContext.get(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression);
            assert (argumentExpression != null) : "Argument expression is not saved for a SAM constructor: " + descriptor2;
            return this.genSamInterfaceValue(argumentExpression, this);
        }
        return this.invokeFunction(resolvedCall2, receiver);
    }

    @Override
    public StackValue visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression, StackValue data) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(127);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COLLECTION_LITERAL_CALL, expression);
        assert (resolvedCall2 != null) : "No resolved call for " + PsiUtilsKt.getTextWithLocation(expression);
        return this.invokeFunction(resolvedCall2, data);
    }

    @Nullable
    private StackValue genSamInterfaceValue(@NotNull KtExpression probablyParenthesizedExpression, final @NotNull KtVisitor<StackValue, StackValue> visitor2) {
        if (probablyParenthesizedExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(128);
        }
        if (visitor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(129);
        }
        final KtExpression expression = KtPsiUtil.deparenthesize(probablyParenthesizedExpression);
        final SamType samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, probablyParenthesizedExpression);
        if (samType == null || expression == null) {
            return null;
        }
        if (expression instanceof KtLambdaExpression) {
            return this.genClosure(((KtLambdaExpression)expression).getFunctionLiteral(), samType);
        }
        if (expression instanceof KtNamedFunction) {
            return this.genClosure((KtNamedFunction)expression, samType);
        }
        final Type asmType = this.state.getSamWrapperClasses().getSamWrapperClass(samType, expression.getContainingKtFile(), this);
        return StackValue.operation(asmType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                v.anew(asmType);
                v.dup();
                Type functionType = ExpressionCodegen.this.typeMapper.mapType(samType.getKotlinFunctionType());
                ((StackValue)expression.accept(visitor2, StackValue.none())).put(functionType, v);
                Label ifNonNull = new Label();
                Label afterAll = new Label();
                v.dup();
                v.ifnonnull(ifNonNull);
                v.pop();
                v.pop2();
                v.aconst(null);
                v.goTo(afterAll);
                v.mark(ifNonNull);
                v.invokespecial(asmType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), false);
                v.mark(afterAll);
                return null;
            }
        });
    }

    @NotNull
    protected FunctionDescriptor accessibleFunctionDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor originalIfSamAdapter;
        FunctionDescriptor descriptor2;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(130);
        }
        if ((descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor()) instanceof TypeAliasConstructorDescriptor) {
            descriptor2 = ((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor();
        }
        if ((originalIfSamAdapter = SamCodegenUtil.getOriginalIfSamAdapter(descriptor2)) != null) {
            descriptor2 = originalIfSamAdapter;
        }
        descriptor2 = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(descriptor2);
        FunctionDescriptor functionDescriptor = CallUtilKt.usesDefaultArguments(resolvedCall2) ? descriptor2 : this.context.accessibleDescriptor(descriptor2, this.getSuperCallTarget(resolvedCall2.getCall()));
        if (functionDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(131);
        }
        return functionDescriptor;
    }

    @NotNull
    public StackValue invokeFunction(@NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(132);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(133);
        }
        StackValue stackValue = this.invokeFunction(resolvedCall2.getCall(), resolvedCall2, receiver);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(134);
        }
        return stackValue;
    }

    @NotNull
    public StackValue invokeFunction(@NotNull Call call2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        ResolvedCallWithRealDescriptor callWithRealDescriptor;
        if (call2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(135);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(136);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(137);
        }
        if ((callWithRealDescriptor = CoroutineCodegenUtilKt.replaceSuspensionFunctionWithRealDescriptor(resolvedCall2, this.state.getProject(), this.state.getBindingContext())) != null) {
            StackValue coroutineInstanceValueForSuspensionPoint = this.getCoroutineInstanceValueForSuspensionPoint(resolvedCall2);
            StackValue coroutineInstanceValue = coroutineInstanceValueForSuspensionPoint != null ? coroutineInstanceValueForSuspensionPoint : this.getContinuationParameterFromEnclosingSuspendFunction(resolvedCall2);
            this.tempVariables.put(callWithRealDescriptor.getFakeContinuationExpression(), coroutineInstanceValue);
            StackValue stackValue = this.invokeFunction(callWithRealDescriptor.getResolvedCall(), receiver);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(138);
            }
            return stackValue;
        }
        FunctionDescriptor fd = this.accessibleFunctionDescriptor(resolvedCall2);
        ClassDescriptor superCallTarget = this.getSuperCallTarget(call2);
        fd = this.context.getAccessorForSuperCallIfNeeded(fd, superCallTarget, this.state);
        List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
        if (!codegenExtensions.isEmpty()) {
            ExpressionCodegenExtension.Context context = new ExpressionCodegenExtension.Context(this.typeMapper, this.v);
            for (ExpressionCodegenExtension extension : codegenExtensions) {
                StackValue stackValue = extension.applyFunction(receiver, resolvedCall2, context);
                if (stackValue == null) continue;
                StackValue stackValue2 = stackValue;
                if (stackValue2 == null) {
                    ExpressionCodegen.$$$reportNull$$$0(139);
                }
                return stackValue2;
            }
        }
        Callable callable = this.resolveToCallable(fd, superCallTarget != null, resolvedCall2);
        StackValue stackValue = callable.invokeMethodWithArguments(resolvedCall2, receiver, this);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(140);
        }
        return stackValue;
    }

    private StackValue getContinuationParameterFromEnclosingSuspendFunction(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(141);
        }
        FunctionDescriptor enclosingSuspendFunction = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall());
        assert (enclosingSuspendFunction != null) : "Suspend functions may be called either as suspension points or from another suspend function";
        FunctionDescriptor enclosingSuspendFunctionJvmView = this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, enclosingSuspendFunction);
        assert (enclosingSuspendFunctionJvmView != null) : "No JVM view function found for " + enclosingSuspendFunction;
        ValueParameterDescriptor continuationParameter = enclosingSuspendFunctionJvmView.getValueParameters().get(enclosingSuspendFunctionJvmView.getValueParameters().size() - 1);
        return this.findLocalOrCapturedValue(continuationParameter);
    }

    @Nullable
    public static CodegenContext getParentContextSubclassOf(ClassDescriptor descriptor2, CodegenContext context) {
        for (CodegenContext c = context; c != null; c = c.getParentContext()) {
            if (!(c instanceof ClassContext) || !DescriptorUtils.isSubclass(c.getThisDescriptor(), descriptor2)) continue;
            return c;
        }
        return null;
    }

    @NotNull
    Callable resolveToCallable(@NotNull FunctionDescriptor fd, boolean superCall, @NotNull ResolvedCall resolvedCall2) {
        IntrinsicMethod intrinsic;
        if (fd == null) {
            ExpressionCodegen.$$$reportNull$$$0(142);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(143);
        }
        if ((intrinsic = this.state.getIntrinsics().getIntrinsic(fd)) != null) {
            Callable callable = intrinsic.toCallable(fd, superCall, resolvedCall2, this);
            if (callable == null) {
                ExpressionCodegen.$$$reportNull$$$0(144);
            }
            return callable;
        }
        CallableMethod callableMethod = this.resolveToCallableMethod(fd, superCall);
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(145);
        }
        return callableMethod;
    }

    @NotNull
    private CallableMethod resolveToCallableMethod(@NotNull FunctionDescriptor fd, boolean superCall) {
        if (fd == null) {
            ExpressionCodegen.$$$reportNull$$$0(146);
        }
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(SamCodegenUtil.resolveSamAdapter(fd), superCall);
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(147);
        }
        return callableMethod;
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(148);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(149);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(150);
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(resolvedCall2);
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        assert (callGenerator == this.defaultCallGenerator || !this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) : "Tail recursive method can't be inlined: " + descriptor2;
        CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, callGenerator, descriptor2.getValueParameters(), callableMethod.getValueParameterTypes());
        this.invokeMethodWithArguments(callableMethod, resolvedCall2, receiver, callGenerator, argumentGenerator);
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver, @NotNull CallGenerator callGenerator, @NotNull ArgumentGenerator argumentGenerator) {
        KotlinType returnType;
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(151);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(152);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(153);
        }
        if (callGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(154);
        }
        if (argumentGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(155);
        }
        boolean isSuspensionPoint = CoroutineCodegenUtilKt.isSuspensionPointInStateMachine(resolvedCall2, this.bindingContext);
        boolean isConstructor = resolvedCall2.getResultingDescriptor() instanceof ConstructorDescriptor;
        this.putReceiverAndInlineMarkerIfNeeded(callableMethod, resolvedCall2, receiver, isSuspensionPoint, isConstructor);
        callGenerator.processAndPutHiddenParameters(false);
        List<ResolvedValueArgument> valueArguments2 = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + resolvedCall2.getResultingDescriptor();
        DefaultCallArgs defaultArgs = argumentGenerator.generate((List<? extends ResolvedValueArgument>)valueArguments2, (List<? extends ResolvedValueArgument>)new ArrayList<ResolvedValueArgument>(resolvedCall2.getValueArguments().values()), (CallableDescriptor)resolvedCall2.getResultingDescriptor());
        if (this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) {
            this.tailRecursionCodegen.generateTailRecursion(resolvedCall2);
            return;
        }
        boolean defaultMaskWasGenerated = defaultArgs.generateOnStackIfNeeded(callGenerator, isConstructor);
        if (callableMethod instanceof CallableMethod) {
            List<JvmMethodParameterSignature> callableParameters = ((CallableMethod)callableMethod).getValueParameters();
            for (JvmMethodParameterSignature parameter : callableParameters) {
                if (parameter.getKind() != JvmMethodParameterKind.CONSTRUCTOR_MARKER) continue;
                callGenerator.putValueIfNeeded(parameter.getAsmType(), StackValue.constant(null, parameter.getAsmType()));
            }
        }
        if (isSuspensionPoint) {
            this.v.invokestatic("kotlin/coroutines/Markers", "beforeSuspensionPoint", "()V", false);
        }
        callGenerator.genCall(callableMethod, resolvedCall2, defaultMaskWasGenerated, this);
        if (isSuspensionPoint) {
            this.v.invokestatic("kotlin/coroutines/Markers", "afterSuspensionPoint", "()V", false);
            InlineCodegenUtil.addInlineMarker(this.v, false);
        }
        if ((returnType = resolvedCall2.getResultingDescriptor().getReturnType()) != null && KotlinBuiltIns.isNothing(returnType)) {
            this.v.aconst(null);
            this.v.athrow();
        }
    }

    private void putReceiverAndInlineMarkerIfNeeded(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver, boolean isSuspensionPoint, boolean isConstructor) {
        boolean isSafeCallOrOnStack;
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(156);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(157);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(158);
        }
        boolean bl = isSafeCallOrOnStack = receiver instanceof StackValue.SafeCall || receiver instanceof StackValue.OnStack;
        if (isSuspensionPoint && !isSafeCallOrOnStack) {
            InlineCodegenUtil.addInlineMarker(this.v, true);
        }
        if (!isConstructor) {
            receiver = StackValue.receiver(resolvedCall2, receiver, this, callableMethod);
            receiver.put(receiver.type, this.v);
            if (isSuspensionPoint && isSafeCallOrOnStack) {
                boolean bothReceivers = receiver instanceof StackValue.CallReceiver && ((StackValue.CallReceiver)receiver).getDispatchReceiver().type.getSort() != 0 && ((StackValue.CallReceiver)receiver).getExtensionReceiver().type.getSort() != 0;
                Type firstReceiverType = bothReceivers ? ((StackValue.CallReceiver)receiver).getDispatchReceiver().type : receiver.type;
                Type secondReceiverType = bothReceivers ? receiver.type : null;
                int tmpVarForFirstReceiver = this.myFrameMap.enterTemp(firstReceiverType);
                int tmpVarForSecondReceiver = -1;
                if (secondReceiverType != null) {
                    tmpVarForSecondReceiver = this.myFrameMap.enterTemp(secondReceiverType);
                    this.v.store(tmpVarForSecondReceiver, secondReceiverType);
                }
                this.v.store(tmpVarForFirstReceiver, firstReceiverType);
                InlineCodegenUtil.addInlineMarker(this.v, true);
                this.v.load(tmpVarForFirstReceiver, firstReceiverType);
                if (secondReceiverType != null) {
                    this.v.load(tmpVarForSecondReceiver, secondReceiverType);
                    this.myFrameMap.leaveTemp(secondReceiverType);
                }
                this.myFrameMap.leaveTemp(firstReceiverType);
            }
            callableMethod.afterReceiverGeneration(this.v);
        }
    }

    @NotNull
    private CallGenerator getOrCreateCallGenerator(@NotNull CallableDescriptor descriptor2, @Nullable KtElement callElement, @Nullable TypeParameterMappings typeParameterMappings, boolean isDefaultCompilation) {
        boolean isInline;
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(159);
        }
        if (callElement == null) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                ExpressionCodegen.$$$reportNull$$$0(160);
            }
            return callGenerator;
        }
        boolean bl = isInline = !(this.state.isInlineDisabled() && !InlineUtil.containsReifiedTypeParameters(descriptor2) || !InlineUtil.isInline(descriptor2) && !InlineUtil.isArrayConstructorWithLambda(descriptor2));
        if (!isInline) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                ExpressionCodegen.$$$reportNull$$$0(161);
            }
            return callGenerator;
        }
        FunctionDescriptor original = ExpressionCodegen.unwrapInitialSignatureDescriptor(DescriptorUtils.unwrapFakeOverride((FunctionDescriptor)descriptor2.getOriginal()));
        if (isDefaultCompilation) {
            InlineCodegenForDefaultBody inlineCodegenForDefaultBody = new InlineCodegenForDefaultBody(original, this, this.state);
            if (inlineCodegenForDefaultBody == null) {
                ExpressionCodegen.$$$reportNull$$$0(162);
            }
            return inlineCodegenForDefaultBody;
        }
        InlineCodegen inlineCodegen = new InlineCodegen(this, this.state, original, callElement, typeParameterMappings);
        if (inlineCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(163);
        }
        return inlineCodegen;
    }

    @NotNull
    private static FunctionDescriptor unwrapInitialSignatureDescriptor(@NotNull FunctionDescriptor function2) {
        if (function2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(164);
        }
        if (function2.getInitialSignatureDescriptor() != null) {
            FunctionDescriptor functionDescriptor = function2.getInitialSignatureDescriptor();
            if (functionDescriptor == null) {
                ExpressionCodegen.$$$reportNull$$$0(165);
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = function2;
        if (functionDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(166);
        }
        return functionDescriptor;
    }

    @NotNull
    protected CallGenerator getOrCreateCallGeneratorForDefaultImplBody(@NotNull FunctionDescriptor descriptor2, @Nullable KtNamedFunction function2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(167);
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(descriptor2, function2, null, true);
        if (callGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(168);
        }
        return callGenerator;
    }

    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(169);
        }
        return this.getOrCreateCallGenerator(resolvedCall2, (CallableDescriptor)resolvedCall2.getResultingDescriptor());
    }

    @NotNull
    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(170);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(171);
        }
        Map<TypeParameterDescriptor, KotlinType> typeArguments = ExpressionCodegen.getTypeArgumentsForResolvedCall(resolvedCall2, descriptor2);
        TypeParameterMappings mappings = new TypeParameterMappings();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments.entrySet()) {
            TypeParameterDescriptor key = entry.getKey();
            KotlinType type2 = entry.getValue();
            boolean isReified = key.isReified() || InlineUtil.isArrayConstructorWithLambda(resolvedCall2.getResultingDescriptor());
            Pair<TypeParameterDescriptor, ReificationArgument> typeParameterAndReificationArgument = ExpressionCodegen.extractReificationArgument(type2);
            if (typeParameterAndReificationArgument == null) {
                KotlinType approximatedType = CapturedTypeApproximationKt.approximateCapturedTypes(entry.getValue()).getUpper();
                BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
                Type asmType = this.typeMapper.mapTypeParameter(approximatedType, signatureWriter);
                mappings.addParameterMappingToType(key.getName().getIdentifier(), approximatedType, asmType, ((JvmSignatureWriter)signatureWriter).toString(), isReified);
                continue;
            }
            mappings.addParameterMappingForFurtherReification(key.getName().getIdentifier(), type2, typeParameterAndReificationArgument.getSecond(), isReified);
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(descriptor2, resolvedCall2.getCall().getCallElement(), mappings, false);
        if (callGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(172);
        }
        return callGenerator;
    }

    @NotNull
    private static Map<TypeParameterDescriptor, KotlinType> getTypeArgumentsForResolvedCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(173);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(174);
        }
        if (!(descriptor2 instanceof TypeAliasConstructorDescriptor)) {
            Map<TypeParameterDescriptor, KotlinType> map2 = resolvedCall2.getTypeArguments();
            if (map2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(175);
            }
            return map2;
        }
        TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = (TypeAliasConstructorDescriptor)descriptor2;
        ClassConstructorDescriptor underlyingConstructorDescriptor = typeAliasConstructorDescriptor.getUnderlyingConstructorDescriptor();
        KotlinType resultingType = typeAliasConstructorDescriptor.getReturnType();
        List<TypeProjection> typeArgumentsForReturnType = resultingType.getArguments();
        List<TypeParameterDescriptor> typeParameters = underlyingConstructorDescriptor.getTypeParameters();
        assert (typeParameters.size() == typeArgumentsForReturnType.size()) : "Type parameters of the underlying constructor " + underlyingConstructorDescriptor + "should correspond to type arguments for the resulting type " + resultingType;
        HashMap<TypeParameterDescriptor, KotlinType> typeArgumentsMap = Maps.newHashMapWithExpectedSize(typeParameters.size());
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            KotlinType typeArgument = typeArgumentsForReturnType.get(typeParameter.getIndex()).getType();
            typeArgumentsMap.put(typeParameter, typeArgument);
        }
        HashMap<TypeParameterDescriptor, KotlinType> hashMap = typeArgumentsMap;
        if (hashMap == null) {
            ExpressionCodegen.$$$reportNull$$$0(176);
        }
        return hashMap;
    }

    @Nullable
    private static Pair<TypeParameterDescriptor, ReificationArgument> extractReificationArgument(@NotNull KotlinType type2) {
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(177);
        }
        int arrayDepth = 0;
        boolean isNullable = type2.isMarkedNullable();
        while (KotlinBuiltIns.isArray(type2)) {
            ++arrayDepth;
            type2 = type2.getArguments().get(0).getType();
        }
        TypeParameterDescriptor parameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        if (parameterDescriptor == null) {
            return null;
        }
        return new Pair<TypeParameterDescriptor, ReificationArgument>(parameterDescriptor, new ReificationArgument(parameterDescriptor.getName().asString(), isNullable, arrayDepth));
    }

    @NotNull
    public StackValue generateReceiverValue(@Nullable ReceiverValue receiverValue, boolean isSuper) {
        if (receiverValue instanceof ImplicitClassReceiver) {
            ClassDescriptor receiverDescriptor = ((ImplicitClassReceiver)receiverValue).getDeclarationDescriptor();
            if (DescriptorUtils.isCompanionObject(receiverDescriptor)) {
                CallableMemberDescriptor contextDescriptor = (CallableMemberDescriptor)this.context.getContextDescriptor();
                if (contextDescriptor instanceof FunctionDescriptor && receiverDescriptor == contextDescriptor.getContainingDeclaration()) {
                    StackValue.Local local = StackValue.LOCAL_0;
                    if (local == null) {
                        ExpressionCodegen.$$$reportNull$$$0(178);
                    }
                    return local;
                }
                StackValue.Field field = StackValue.singleton(receiverDescriptor, this.typeMapper);
                if (field == null) {
                    ExpressionCodegen.$$$reportNull$$$0(179);
                }
                return field;
            }
            if (receiverDescriptor instanceof ScriptDescriptor) {
                StackValue stackValue = this.generateScriptReceiver((ScriptDescriptor)receiverDescriptor);
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(180);
                }
                return stackValue;
            }
            StackValue stackValue = StackValue.thisOrOuter(this, receiverDescriptor, isSuper, receiverValue instanceof CastImplicitClassReceiver || DescriptorUtils.isEnumEntry(receiverDescriptor));
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(181);
            }
            return stackValue;
        }
        if (receiverValue instanceof ExtensionReceiver) {
            StackValue stackValue = this.generateExtensionReceiver(((ExtensionReceiver)receiverValue).getDeclarationDescriptor());
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(182);
            }
            return stackValue;
        }
        if (receiverValue instanceof ExpressionReceiver) {
            StackValue stackValue = this.gen(((ExpressionReceiver)receiverValue).getExpression());
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(183);
            }
            return stackValue;
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue);
    }

    @NotNull
    private StackValue generateExtensionReceiver(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(184);
        }
        if (this.myFrameMap.getIndex(descriptor2.getExtensionReceiverParameter()) != -1) {
            StackValue.Local local = StackValue.local(this.myFrameMap.getIndex(descriptor2.getExtensionReceiverParameter()), this.typeMapper.mapType(descriptor2.getExtensionReceiverParameter()));
            if (local == null) {
                ExpressionCodegen.$$$reportNull$$$0(185);
            }
            return local;
        }
        StackValue stackValue = this.context.generateReceiver(descriptor2, this.state, false);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(186);
        }
        return stackValue;
    }

    @NotNull
    private StackValue generateScriptReceiver(@NotNull ScriptDescriptor receiver) {
        CodegenContext cur;
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(187);
        }
        StackValue result2 = StackValue.LOCAL_0;
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            if (!inStartConstructorContext) {
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            }
            if (cur instanceof ScriptContext) {
                ScriptContext scriptContext = (ScriptContext)cur;
                if (scriptContext.getScriptDescriptor() == receiver) {
                    StackValue stackValue = result2;
                    if (stackValue == null) {
                        ExpressionCodegen.$$$reportNull$$$0(188);
                    }
                    return stackValue;
                }
                Type currentScriptType = this.typeMapper.mapType(scriptContext.getScriptDescriptor());
                Type classType = this.typeMapper.mapType(receiver);
                String fieldName = scriptContext.getScriptFieldName(receiver);
                StackValue.Field field = StackValue.field(classType, currentScriptType, fieldName, false, result2, receiver);
                if (field == null) {
                    ExpressionCodegen.$$$reportNull$$$0(189);
                }
                return field;
            }
            result2 = cur.getOuterExpression(result2, false);
            if (!inStartConstructorContext) continue;
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            inStartConstructorContext = false;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper) {
        if (calleeContainingClass == null) {
            ExpressionCodegen.$$$reportNull$$$0(190);
        }
        StackValue stackValue = this.generateThisOrOuter(calleeContainingClass, isSuper, false);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(191);
        }
        return stackValue;
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper, boolean forceOuter) {
        CodegenContext cur;
        boolean isSingleton;
        if (calleeContainingClass == null) {
            ExpressionCodegen.$$$reportNull$$$0(192);
        }
        if (isSingleton = calleeContainingClass.getKind().isSingleton()) {
            if (calleeContainingClass.equals(this.context.getThisDescriptor()) && !CodegenUtilKt.isJvmStaticInObjectOrClass(this.context.getFunctionDescriptor())) {
                StackValue.Local local = StackValue.local(0, this.typeMapper.mapType(calleeContainingClass));
                if (local == null) {
                    ExpressionCodegen.$$$reportNull$$$0(193);
                }
                return local;
            }
            if (DescriptorUtils.isEnumEntry(calleeContainingClass)) {
                StackValue.Field field = StackValue.enumEntry(calleeContainingClass, this.typeMapper);
                if (field == null) {
                    ExpressionCodegen.$$$reportNull$$$0(194);
                }
                return field;
            }
            StackValue.Field field = StackValue.singleton(calleeContainingClass, this.typeMapper);
            if (field == null) {
                ExpressionCodegen.$$$reportNull$$$0(195);
            }
            return field;
        }
        Type type2 = this.asmType(calleeContainingClass.getDefaultType());
        StackValue result2 = StackValue.local(0, type2);
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            ClassDescriptor thisDescriptor = cur.getThisDescriptor();
            if (!isSuper && thisDescriptor == calleeContainingClass) {
                StackValue.Local local = result2;
                if (local == null) {
                    ExpressionCodegen.$$$reportNull$$$0(196);
                }
                return local;
            }
            if (!forceOuter && isSuper && DescriptorUtils.isSubclass(thisDescriptor, calleeContainingClass)) {
                StackValue stackValue = this.castToRequiredTypeOfInterfaceIfNeeded(result2, thisDescriptor, calleeContainingClass);
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(197);
                }
                return stackValue;
            }
            forceOuter = false;
            if (inStartConstructorContext) {
                result2 = cur.getOuterExpression(result2, false);
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
                inStartConstructorContext = false;
                continue;
            }
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            result2 = cur.getOuterExpression(result2, false);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static CodegenContext getNotNullParentContextForMethod(CodegenContext cur) {
        if (cur instanceof MethodContext) {
            cur = cur.getParentContext();
        }
        assert (cur != null);
        CodegenContext codegenContext = cur;
        if (codegenContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(198);
        }
        return codegenContext;
    }

    public void genVarargs(@NotNull VarargValueArgument valueArgument, @NotNull KotlinType outType) {
        int i;
        if (valueArgument == null) {
            ExpressionCodegen.$$$reportNull$$$0(199);
        }
        if (outType == null) {
            ExpressionCodegen.$$$reportNull$$$0(200);
        }
        Type type2 = this.asmType(outType);
        assert (type2.getSort() == 9);
        Type elementType = AsmUtil.correctElementType(type2);
        List<ValueArgument> arguments2 = valueArgument.getArguments();
        int size = arguments2.size();
        boolean hasSpread = false;
        for (i = 0; i != size; ++i) {
            if (arguments2.get(i).getSpreadElement() == null) continue;
            hasSpread = true;
            break;
        }
        if (hasSpread) {
            boolean arrayOfReferences = KotlinBuiltIns.isArray(outType);
            if (size == 1) {
                ValueArgument argument = arguments2.get(0);
                Type arrayType = arrayOfReferences ? Type.getType("[Ljava/lang/Object;") : Type.getType("[" + elementType.getDescriptor());
                this.gen(argument.getArgumentExpression(), type2);
                this.v.dup();
                this.v.arraylength();
                this.v.invokestatic("java/util/Arrays", "copyOf", Type.getMethodDescriptor(arrayType, arrayType, Type.INT_TYPE), false);
                if (arrayOfReferences) {
                    this.v.checkcast(type2);
                }
            } else {
                String toArrayDescriptor;
                String addDescriptor;
                String owner;
                if (arrayOfReferences) {
                    owner = "kotlin/jvm/internal/SpreadBuilder";
                    addDescriptor = "(Ljava/lang/Object;)V";
                    toArrayDescriptor = "([Ljava/lang/Object;)[Ljava/lang/Object;";
                } else {
                    String spreadBuilderClassName = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(elementType).getTypeName().getIdentifier() + "SpreadBuilder";
                    owner = "kotlin/jvm/internal/" + spreadBuilderClassName;
                    addDescriptor = "(" + elementType.getDescriptor() + ")V";
                    toArrayDescriptor = "()" + type2.getDescriptor();
                }
                this.v.anew(Type.getObjectType(owner));
                this.v.dup();
                this.v.iconst(size);
                this.v.invokespecial(owner, "<init>", "(I)V", false);
                for (int i2 = 0; i2 != size; ++i2) {
                    this.v.dup();
                    ValueArgument argument = arguments2.get(i2);
                    if (argument.getSpreadElement() != null) {
                        this.gen(argument.getArgumentExpression(), AsmTypes.OBJECT_TYPE);
                        this.v.invokevirtual(owner, "addSpread", "(Ljava/lang/Object;)V", false);
                        continue;
                    }
                    this.gen(argument.getArgumentExpression(), elementType);
                    this.v.invokevirtual(owner, "add", addDescriptor, false);
                }
                if (arrayOfReferences) {
                    this.v.dup();
                    this.v.invokevirtual(owner, "size", "()I", false);
                    this.newArrayInstruction(outType);
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                    this.v.checkcast(type2);
                } else {
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                }
            }
        } else {
            this.v.iconst(arguments2.size());
            this.newArrayInstruction(outType);
            for (i = 0; i != size; ++i) {
                this.v.dup();
                StackValue rightSide = this.gen(arguments2.get(i).getArgumentExpression());
                StackValue.arrayElement(elementType, StackValue.onStack(type2), StackValue.constant(i, Type.INT_TYPE)).store(rightSide, this.v);
            }
        }
    }

    public int indexOfLocalNotDelegated(KtReferenceExpression lhs) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, lhs);
        if (BindingContextUtils.isVarCapturedInClosure(this.bindingContext, declarationDescriptor)) {
            return -1;
        }
        if (declarationDescriptor instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)declarationDescriptor).isDelegated()) {
            return -1;
        }
        return this.lookupLocalIndex(declarationDescriptor);
    }

    @Override
    public StackValue visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, StackValue data) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(201);
        }
        KtExpression receiverExpression = expression.getReceiverExpression();
        assert (receiverExpression != null) : "Class literal expression should have a left-hand side";
        DoubleColonLHS lhs = this.bindingContext.get(BindingContext.DOUBLE_COLON_LHS, receiverExpression);
        assert (lhs != null) : "Class literal expression should have LHS resolved";
        return this.generateClassLiteralReference(lhs, receiverExpression, true);
    }

    @Override
    public StackValue visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression, StackValue data) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(202);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression.getCallableReference(), this.bindingContext);
        KotlinType receiverExpressionType = this.expressionJetType(expression.getReceiverExpression());
        Type receiverAsmType = receiverExpressionType != null ? this.asmType(receiverExpressionType) : null;
        StackValue receiverValue = receiverExpressionType != null ? StackValue.coercion(this.gen(expression.getReceiverExpression()), receiverAsmType) : null;
        FunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression);
        if (functionDescriptor != null) {
            FunctionReferenceGenerationStrategy strategy = new FunctionReferenceGenerationStrategy(this.state, functionDescriptor, resolvedCall2, receiverAsmType, null, false);
            return this.genClosure(expression, functionDescriptor, strategy, null, (FunctionDescriptor)resolvedCall2.getResultingDescriptor(), receiverValue);
        }
        VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(expression);
        return this.generatePropertyReference(expression, variableDescriptor, (VariableDescriptor)resolvedCall2.getResultingDescriptor(), receiverAsmType, receiverValue);
    }

    @NotNull
    private StackValue generatePropertyReference(@NotNull KtElement element, @NotNull VariableDescriptor variableDescriptor, @NotNull VariableDescriptor target, final @Nullable Type receiverAsmType, final @Nullable StackValue receiverValue) {
        if (element == null) {
            ExpressionCodegen.$$$reportNull$$$0(203);
        }
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(204);
        }
        if (target == null) {
            ExpressionCodegen.$$$reportNull$$$0(205);
        }
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForCallable(this.bindingContext, variableDescriptor);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(element), this.typeMapper.mapClass(classDescriptor), element.getContainingFile());
        PropertyReferenceCodegen codegen = new PropertyReferenceCodegen(this.state, this.parentCodegen, this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION), element, classBuilder2, variableDescriptor, target, receiverAsmType);
        codegen.generate();
        StackValue stackValue = codegen.putInstanceOnStack(receiverValue == null ? null : new Function0<Unit>(){

            @Override
            public Unit invoke() {
                assert (receiverAsmType != null) : "Receiver type should not be null when receiver value is not null: " + receiverValue;
                receiverValue.put(receiverAsmType, ExpressionCodegen.this.v);
                return Unit.INSTANCE;
            }
        });
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(206);
        }
        return stackValue;
    }

    @NotNull
    public StackValue generateClassLiteralReference(final @NotNull DoubleColonLHS lhs, final @Nullable KtExpression receiverExpression, final boolean wrapIntoKClass) {
        if (lhs == null) {
            ExpressionCodegen.$$$reportNull$$$0(207);
        }
        StackValue stackValue = StackValue.operation(wrapIntoKClass ? AsmTypes.K_CLASS_TYPE : AsmTypes.JAVA_CLASS_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                KotlinType type2 = lhs.getType();
                if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
                    JavaClassProperty.INSTANCE.generateImpl(v, ExpressionCodegen.this.gen(receiverExpression));
                } else {
                    if (TypeUtils.isTypeParameter(type2)) {
                        assert (TypeUtils.isReifiedTypeParameter(type2)) : "Non-reified type parameter under ::class should be rejected by type checker: " + type2;
                        ExpressionCodegen.this.putReifiedOperationMarkerIfTypeIsReifiedParameter(type2, ReifiedTypeInliner.OperationKind.JAVA_CLASS);
                    }
                    AsmUtil.putJavaLangClassInstance(v, ExpressionCodegen.this.typeMapper.mapType(type2));
                }
                if (wrapIntoKClass) {
                    AsmUtil.wrapJavaClassIntoKClass(v);
                }
                return Unit.INSTANCE;
            }
        });
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(208);
        }
        return stackValue;
    }

    @Override
    public StackValue visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(209);
        }
        StackValue receiverValue = StackValue.none();
        return this.genQualified(receiverValue, expression.getSelectorExpression());
    }

    private StackValue generateExpressionWithNullFallback(@NotNull KtExpression expression, @NotNull Label ifnull) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(210);
        }
        if (ifnull == null) {
            ExpressionCodegen.$$$reportNull$$$0(211);
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression);
        assert (deparenthesized != null) : "Unexpected empty expression";
        expression = deparenthesized;
        Type type2 = this.expressionType(expression);
        if (expression instanceof KtSafeQualifiedExpression && !AsmUtil.isPrimitive(type2)) {
            return StackValue.coercion(this.generateSafeQualifiedExpression((KtSafeQualifiedExpression)expression, ifnull), type2);
        }
        return this.genLazy(expression, type2);
    }

    private StackValue generateSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression, @NotNull Label ifNull) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(212);
        }
        if (ifNull == null) {
            ExpressionCodegen.$$$reportNull$$$0(213);
        }
        KtExpression receiver = expression.getReceiverExpression();
        KtExpression selector = expression.getSelectorExpression();
        Type receiverType = this.expressionType(receiver);
        StackValue receiverValue = this.generateExpressionWithNullFallback(receiver, ifNull);
        StackValue.SafeCall newReceiver = new StackValue.SafeCall(receiverType, receiverValue, AsmUtil.isPrimitive(receiverType) ? null : ifNull);
        return this.genQualified(newReceiver, selector);
    }

    @Override
    public StackValue visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression, StackValue unused) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(214);
        }
        Label ifnull = new Label();
        Type type2 = AsmUtil.boxType(this.expressionType(expression));
        StackValue value = this.generateSafeQualifiedExpression(expression, ifnull);
        StackValue newReceiver = StackValue.coercion(value, type2);
        StackValue result2 = !AsmUtil.isPrimitive(this.expressionType(expression.getReceiverExpression())) ? new StackValue.SafeFallback(type2, ifnull, newReceiver) : newReceiver;
        return result2;
    }

    @Override
    public StackValue visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull StackValue receiver) {
        KtOperationReferenceExpression reference;
        IElementType opToken;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(215);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(216);
        }
        if ((opToken = (reference = expression.getOperationReference()).getReferencedNameElementType()) == KtTokens.EQ) {
            return this.generateAssignmentExpression(expression);
        }
        if (KtTokens.AUGMENTED_ASSIGNMENTS.contains(opToken)) {
            return this.generateAugmentedAssignment(expression);
        }
        if (opToken == KtTokens.ANDAND) {
            return this.generateBooleanAnd(expression);
        }
        if (opToken == KtTokens.OROR) {
            return this.generateBooleanOr(expression);
        }
        if (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ || opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            return this.generateEquals(expression.getLeft(), expression.getRight(), opToken);
        }
        if (opToken == KtTokens.LT || opToken == KtTokens.LTEQ || opToken == KtTokens.GT || opToken == KtTokens.GTEQ) {
            return this.generateComparison(expression, receiver);
        }
        if (opToken == KtTokens.ELVIS) {
            return this.generateElvis(expression);
        }
        if (opToken == KtTokens.IN_KEYWORD || opToken == KtTokens.NOT_IN) {
            return this.generateIn(StackValue.expression(this.expressionType(expression.getLeft()), expression.getLeft(), this), expression.getRight(), reference);
        }
        ConstantValue<?> compileTimeConstant = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expression, this.bindingContext, this.state.getShouldInlineConstVals());
        if (compileTimeConstant != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        FunctionDescriptor descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.generateConstructorCall(resolvedCall2, this.expressionType(expression));
        }
        return this.invokeFunction(resolvedCall2, receiver);
    }

    private StackValue generateIn(final StackValue leftValue, KtExpression rangeExpression, final KtSimpleNameExpression operationReference) {
        final KtExpression deparenthesized = KtPsiUtil.deparenthesize(rangeExpression);
        assert (deparenthesized != null) : "For with empty range expression";
        final boolean isInverted = operationReference.getReferencedNameElementType() == KtTokens.NOT_IN;
        return StackValue.operation(Type.BOOLEAN_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                if (RangeCodegenUtil.isPrimitiveRangeSpecializationOfType(leftValue.type, deparenthesized, ExpressionCodegen.this.bindingContext) || RangeCodegenUtil.isPrimitiveRangeToExtension(operationReference, ExpressionCodegen.this.bindingContext)) {
                    ExpressionCodegen.this.generateInPrimitiveRange(leftValue, (KtBinaryExpression)deparenthesized, isInverted);
                } else {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(operationReference, ExpressionCodegen.this.bindingContext);
                    StackValue result2 = ExpressionCodegen.this.invokeFunction(resolvedCall2.getCall(), resolvedCall2, StackValue.none());
                    result2.put(result2.type, v);
                    if (isInverted) {
                        AsmUtil.genInvertBoolean(v);
                    }
                }
                return null;
            }
        });
    }

    private void generateInPrimitiveRange(StackValue argument, KtBinaryExpression rangeExpression, boolean isInverted) {
        Type rangeType = argument.type;
        int localVarIndex = this.myFrameMap.enterTemp(rangeType);
        this.gen(rangeExpression.getLeft(), rangeType);
        argument.put(rangeType, this.v);
        this.v.store(localVarIndex, rangeType);
        this.v.load(localVarIndex, rangeType);
        Label l1 = new Label();
        this.emitGreaterThan(rangeType, l1);
        this.v.load(localVarIndex, rangeType);
        this.gen(rangeExpression.getRight(), rangeType);
        this.emitGreaterThan(rangeType, l1);
        Label l2 = new Label();
        this.v.iconst(isInverted ? 0 : 1);
        this.v.goTo(l2);
        this.v.mark(l1);
        this.v.iconst(isInverted ? 1 : 0);
        this.v.mark(l2);
        this.myFrameMap.leaveTemp(rangeType);
    }

    private void emitGreaterThan(Type type2, Label label) {
        if (AsmUtil.isIntPrimitive(type2)) {
            this.v.ificmpgt(label);
        } else if (type2 == Type.LONG_TYPE) {
            this.v.lcmp();
            this.v.ifgt(label);
        } else if (type2 == Type.FLOAT_TYPE || type2 == Type.DOUBLE_TYPE) {
            this.v.cmpg(type2);
            this.v.ifgt(label);
        } else {
            throw new UnsupportedOperationException("Unexpected type: " + type2);
        }
    }

    private StackValue generateBooleanAnd(KtBinaryExpression expression) {
        return StackValue.and(this.gen(expression.getLeft()), this.gen(expression.getRight()));
    }

    private StackValue generateBooleanOr(KtBinaryExpression expression) {
        return StackValue.or(this.gen(expression.getLeft()), this.gen(expression.getRight()));
    }

    private StackValue generateEquals(@Nullable KtExpression left, @Nullable KtExpression right, @NotNull IElementType opToken) {
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(217);
        }
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        if (KtPsiUtil.isNullConstant(left)) {
            return this.genCmpWithNull(right, opToken);
        }
        if (KtPsiUtil.isNullConstant(right)) {
            return this.genCmpWithNull(left, opToken);
        }
        if (this.isIntZero(left, leftType) && AsmUtil.isIntPrimitive(rightType)) {
            return this.genCmpWithZero(right, opToken);
        }
        if (this.isIntZero(right, rightType) && AsmUtil.isIntPrimitive(leftType)) {
            return this.genCmpWithZero(left, opToken);
        }
        if (AsmUtil.isPrimitive(leftType) != AsmUtil.isPrimitive(rightType)) {
            leftType = AsmUtil.boxType(leftType);
            rightType = AsmUtil.boxType(rightType);
        }
        if (opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            Type operandType = AsmUtil.isPrimitive(leftType) ? leftType : AsmTypes.OBJECT_TYPE;
            return StackValue.cmp(opToken, operandType, this.genLazy(left, leftType), this.genLazy(right, rightType));
        }
        return this.genEqualsForExpressionsPreferIEEE754Arithmetic(left, right, opToken, leftType, rightType, null);
    }

    private StackValue genEqualsForExpressionsPreferIEEE754Arithmetic(final @Nullable KtExpression left, final @Nullable KtExpression right, final @NotNull IElementType opToken, @NotNull Type leftType, @NotNull Type rightType, final @Nullable StackValue pregeneratedLeft) {
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(218);
        }
        if (leftType == null) {
            ExpressionCodegen.$$$reportNull$$$0(219);
        }
        if (rightType == null) {
            ExpressionCodegen.$$$reportNull$$$0(220);
        }
        assert (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ) : "Optoken should be '==' or '!=', but: " + opToken;
        final TypeAndNullability left754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(left);
        final TypeAndNullability right754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(right);
        if (left754Type != null && right754Type != null && left754Type.type.equals(right754Type.type)) {
            if (left754Type.isNullable || right754Type.isNullable) {
                if (this.state.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_1) >= 0) {
                    return StackValue.operation(Type.BOOLEAN_TYPE, new Function1<InstructionAdapter, Unit>(){

                        @Override
                        public Unit invoke(InstructionAdapter v) {
                            ExpressionCodegen.this.generate754EqualsForNullableTypesViaIntrinsic(v, opToken, pregeneratedLeft, left, left754Type, right, right754Type);
                            return Unit.INSTANCE;
                        }
                    });
                }
                return StackValue.operation(Type.BOOLEAN_TYPE, new Function1<InstructionAdapter, Unit>(){

                    @Override
                    public Unit invoke(InstructionAdapter v) {
                        ExpressionCodegen.this.generate754EqualsForNullableTypes(v, opToken, pregeneratedLeft, left, left754Type, right, right754Type);
                        return Unit.INSTANCE;
                    }
                });
            }
            leftType = left754Type.type;
            rightType = right754Type.type;
        }
        return AsmUtil.genEqualsForExpressionsOnStack(opToken, pregeneratedLeft != null ? StackValue.coercion(pregeneratedLeft, leftType) : this.genLazy(left, leftType), this.genLazy(right, rightType));
    }

    private void generate754EqualsForNullableTypesViaIntrinsic(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right, @NotNull TypeAndNullability right754Type) {
        Type leftType;
        if (v == null) {
            ExpressionCodegen.$$$reportNull$$$0(221);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(222);
        }
        if (left754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(223);
        }
        if (right754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(224);
        }
        Type type2 = leftType = left754Type.isNullable ? AsmUtil.boxType(left754Type.type) : left754Type.type;
        if (pregeneratedLeft != null) {
            StackValue.coercion(pregeneratedLeft, leftType).put(leftType, v);
        } else {
            this.gen(left, leftType);
        }
        Type rightType = right754Type.isNullable ? AsmUtil.boxType(right754Type.type) : right754Type.type;
        this.gen(right, rightType);
        AsmUtil.genIEEE754EqualForNullableTypesCall(v, leftType, rightType);
        if (opToken == KtTokens.EXCLEQ) {
            AsmUtil.genInvertBoolean(v);
        }
    }

    private void generate754EqualsForNullableTypes(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right, @NotNull TypeAndNullability right754Type) {
        if (v == null) {
            ExpressionCodegen.$$$reportNull$$$0(225);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(226);
        }
        if (left754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(227);
        }
        if (right754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(228);
        }
        int equals = opToken == KtTokens.EQEQ ? 1 : 0;
        int notEquals = opToken != KtTokens.EQEQ ? 1 : 0;
        Label end = new Label();
        StackValue leftValue = pregeneratedLeft != null ? pregeneratedLeft : this.gen(left);
        leftValue.put(leftValue.type, v);
        leftValue = StackValue.onStack(leftValue.type);
        Type leftType = left754Type.type;
        Type rightType = right754Type.type;
        if (left754Type.isNullable) {
            leftValue.dup(v, false);
            Label leftIsNull = new Label();
            v.ifnull(leftIsNull);
            StackValue.coercion(leftValue, leftType).put(leftType, v);
            StackValue nonNullLeftValue = StackValue.onStack(leftType);
            StackValue rightValue = this.gen(right);
            rightValue.put(rightValue.type, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                rightValue.dup(v, false);
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                AsmUtil.pop(v, rightValue.type);
                AsmUtil.pop(v, nonNullLeftValue.type);
                v.iconst(notEquals);
                v.goTo(end);
                v.mark(rightIsNotNull);
            }
            StackValue.coercion(rightValue, rightType).put(rightType, v);
            StackValue nonNullRightValue = StackValue.onStack(rightType);
            StackValue.cmp(opToken, leftType, nonNullLeftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, v);
            v.goTo(end);
            v.mark(leftIsNull);
            AsmUtil.pop(v, leftValue.type);
            rightValue = this.gen(right);
            rightValue.put(rightValue.type, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                v.iconst(equals);
                v.goTo(end);
                v.mark(rightIsNotNull);
                v.iconst(notEquals);
            } else {
                AsmUtil.pop(v, rightValue.type);
                v.iconst(notEquals);
            }
            v.mark(end);
            return;
        }
        StackValue.coercion(leftValue, leftType).put(leftType, v);
        leftValue = StackValue.onStack(leftType);
        StackValue rightValue = this.gen(right);
        rightValue.put(rightValue.type, v);
        rightValue = StackValue.onStack(rightValue.type);
        rightValue.dup(v, false);
        Label rightIsNotNull = new Label();
        v.ifnonnull(rightIsNotNull);
        AsmUtil.pop(v, rightValue.type);
        AsmUtil.pop(v, leftValue.type);
        v.iconst(notEquals);
        v.goTo(end);
        v.mark(rightIsNotNull);
        StackValue.coercion(rightValue, rightType).put(rightType, v);
        StackValue nonNullRightValue = StackValue.onStack(rightType);
        StackValue.cmp(opToken, leftType, leftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, v);
        v.mark(end);
    }

    private boolean isIntZero(KtExpression expr, Type exprType) {
        ConstantValue<?> exprValue = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expr, this.bindingContext, this.state.getShouldInlineConstVals());
        return AsmUtil.isIntPrimitive(exprType) && exprValue != null && Integer.valueOf(0).equals(exprValue.getValue());
    }

    private StackValue genCmpWithZero(KtExpression exp, IElementType opToken) {
        return StackValue.compareIntWithZero(this.gen(exp), KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 154 : 153);
    }

    private StackValue genCmpWithNull(KtExpression exp, IElementType opToken) {
        return StackValue.compareWithNull(this.gen(exp), KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 199 : 198);
    }

    private StackValue generateElvis(final @NotNull KtBinaryExpression expression) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(229);
        }
        KtExpression left = expression.getLeft();
        final Type exprType = this.expressionType(expression);
        final Type leftType = this.expressionType(left);
        final Label ifNull = new Label();
        assert (left != null) : "left expression in elvis should be not null: " + expression.getText();
        final StackValue value = this.generateExpressionWithNullFallback(left, ifNull);
        if (AsmUtil.isPrimitive(leftType)) {
            return value;
        }
        return StackValue.operation(exprType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                value.put(value.type, v);
                v.dup();
                v.ifnull(ifNull);
                StackValue.onStack(leftType).put(exprType, v);
                Label end = new Label();
                v.goTo(end);
                v.mark(ifNull);
                v.pop();
                ExpressionCodegen.this.gen(expression.getRight(), exprType);
                v.mark(end);
                return null;
            }
        });
    }

    private StackValue generateComparison(KtBinaryExpression expression, StackValue receiver) {
        StackValue rightValue;
        StackValue leftValue;
        Type type2;
        boolean is754Arithmetic;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        KtExpression left = expression.getLeft();
        KtExpression right = expression.getRight();
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        TypeAndNullability left754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(left);
        TypeAndNullability right754Type = this.calcTypeForIEEE754ArithmeticIfNeeded(right);
        Callable callable = this.resolveToCallable((FunctionDescriptor)resolvedCall2.getResultingDescriptor(), false, resolvedCall2);
        boolean bl = is754Arithmetic = left754Type != null && right754Type != null && left754Type.type.equals(right754Type.type);
        if (callable instanceof IntrinsicCallable && (AsmUtil.isPrimitive(leftType) && AsmUtil.isPrimitive(rightType) || is754Arithmetic)) {
            type2 = is754Arithmetic ? left754Type.type : AsmUtil.comparisonOperandType(leftType, rightType);
            leftValue = this.gen(left);
            rightValue = this.gen(right);
        } else {
            type2 = Type.INT_TYPE;
            leftValue = this.invokeFunction(resolvedCall2, receiver);
            rightValue = StackValue.constant(0, type2);
        }
        return StackValue.cmp(expression.getOperationToken(), type2, leftValue, rightValue);
    }

    private TypeAndNullability calcTypeForIEEE754ArithmeticIfNeeded(@Nullable KtExpression expression) {
        return CodegenUtilKt.calcTypeForIEEE754ArithmeticIfNeeded(expression, this.bindingContext, this.context.getFunctionDescriptor());
    }

    private StackValue generateAssignmentExpression(final KtBinaryExpression expression) {
        return StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter adapter) {
                StackValue stackValue = ExpressionCodegen.this.gen(expression.getLeft());
                KtExpression right = expression.getRight();
                assert (right != null) : expression.getText();
                stackValue.store(ExpressionCodegen.this.gen(right), ExpressionCodegen.this.v);
                return Unit.INSTANCE;
            }
        });
    }

    private StackValue generateAugmentedAssignment(final KtBinaryExpression expression) {
        return StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter adapter) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression, ExpressionCodegen.this.bindingContext);
                FunctionDescriptor descriptor2 = ExpressionCodegen.this.accessibleFunctionDescriptor(resolvedCall2);
                Callable callable = ExpressionCodegen.this.resolveToCallable(descriptor2, false, resolvedCall2);
                KtExpression lhs = expression.getLeft();
                Type lhsType = ExpressionCodegen.this.expressionType(lhs);
                boolean keepReturnValue = Boolean.TRUE.equals(ExpressionCodegen.this.bindingContext.get(BindingContext.VARIABLE_REASSIGNMENT, expression)) || !KotlinBuiltIns.isUnit(descriptor2.getReturnType());
                ExpressionCodegen.this.putCallAugAssignMethod(expression, resolvedCall2, callable, lhsType, keepReturnValue);
                return Unit.INSTANCE;
            }
        });
    }

    private void putCallAugAssignMethod(@NotNull KtBinaryExpression expression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull Callable callable, @NotNull Type lhsType, boolean keepReturnValue) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(230);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(231);
        }
        if (callable == null) {
            ExpressionCodegen.$$$reportNull$$$0(232);
        }
        if (lhsType == null) {
            ExpressionCodegen.$$$reportNull$$$0(233);
        }
        StackValue value = this.gen(expression.getLeft());
        if (keepReturnValue) {
            value = StackValue.complexWriteReadReceiver(value);
        }
        value.put(lhsType, this.v);
        StackValue receiver = StackValue.onStack(lhsType);
        callable.invokeMethodWithArguments(resolvedCall2, receiver, this).put(callable.getReturnType(), this.v);
        if (keepReturnValue) {
            value.store(StackValue.onStack(callable.getReturnType()), this.v, true);
        }
    }

    public void invokeAppend(KtExpression expr) {
        KtBinaryExpression binaryExpression;
        ConstantValue<?> compileTimeConstant = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expr, this.bindingContext, this.state.getShouldInlineConstVals());
        if (compileTimeConstant == null && expr instanceof KtBinaryExpression && (binaryExpression = (KtBinaryExpression)expr).getOperationToken() == KtTokens.PLUS) {
            KtExpression left = binaryExpression.getLeft();
            KtExpression right = binaryExpression.getRight();
            Type leftType = this.expressionType(left);
            if (leftType.equals(AsmTypes.JAVA_STRING_TYPE)) {
                this.invokeAppend(left);
                this.invokeAppend(right);
                return;
            }
        }
        Type exprType = this.expressionType(expr);
        if (compileTimeConstant != null) {
            StackValue.constant(compileTimeConstant.getValue(), exprType).put(exprType, this.v);
        } else {
            this.gen(expr, exprType);
        }
        AsmUtil.genInvokeAppendMethod(this.v, exprType.getSort() == 9 ? AsmTypes.OBJECT_TYPE : exprType);
    }

    @Nullable
    private static KtSimpleNameExpression targetLabel(KtExpression expression) {
        if (expression.getParent() instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression.getParent()).getTargetLabel();
        }
        return null;
    }

    @Override
    public StackValue visitLabeledExpression(@NotNull KtLabeledExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(234);
        }
        return this.genQualified(receiver, expression.getBaseExpression());
    }

    @Override
    public StackValue visitPrefixExpression(@NotNull KtPrefixExpression expression, @NotNull StackValue receiver) {
        String operationName;
        ConstantValue<?> compileTimeConstant;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(235);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(236);
        }
        if ((compileTimeConstant = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expression, this.bindingContext, this.state.getShouldInlineConstVals())) != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression));
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        assert (op instanceof FunctionDescriptor || originalOperation == null) : String.valueOf(op);
        String string = operationName = originalOperation == null ? "" : originalOperation.getName().asString();
        if (!operationName.equals("inc") && !operationName.equals("dec")) {
            return this.invokeFunction(resolvedCall2, receiver);
        }
        int increment = operationName.equals("inc") ? 1 : -1;
        Type type2 = this.expressionType(expression.getBaseExpression());
        StackValue value = this.gen(expression.getBaseExpression());
        return StackValue.preIncrement(type2, value, increment, resolvedCall2, this);
    }

    @Override
    public StackValue visitPostfixExpression(final @NotNull KtPostfixExpression expression, StackValue receiver) {
        int index2;
        KtExpression operand;
        int increment;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(237);
        }
        if (expression.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL) {
            final StackValue base = this.genQualified(receiver, expression.getBaseExpression());
            if (AsmUtil.isPrimitive(base.type)) {
                return base;
            }
            return StackValue.operation(base.type, new Function1<InstructionAdapter, Unit>(){

                @Override
                public Unit invoke(InstructionAdapter v) {
                    base.put(base.type, v);
                    v.dup();
                    Label ok = new Label();
                    v.ifnonnull(ok);
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwNpe", "()V", false);
                    v.mark(ok);
                    return null;
                }
            });
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        String originalOperationName = originalOperation != null ? originalOperation.getName().asString() : null;
        final ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        if (!(op instanceof FunctionDescriptor) || originalOperation == null) {
            throw new UnsupportedOperationException("Don't know how to generate this postfix expression: " + originalOperationName + " " + op);
        }
        Type asmResultType = this.expressionType(expression);
        final Type asmBaseType = this.expressionType(expression.getBaseExpression());
        DeclarationDescriptor cls = op.getContainingDeclaration();
        if (originalOperationName.equals("inc")) {
            increment = 1;
        } else if (originalOperationName.equals("dec")) {
            increment = -1;
        } else {
            throw new UnsupportedOperationException("Unsupported postfix operation: " + originalOperationName + " " + op);
        }
        final boolean isPrimitiveNumberClassDescriptor = AsmUtil.isPrimitiveNumberClassDescriptor(cls);
        if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType) && (operand = expression.getBaseExpression()) instanceof KtReferenceExpression && asmResultType == Type.INT_TYPE && this.bindingContext.get(BindingContext.SMARTCAST, operand) == null && (index2 = this.indexOfLocalNotDelegated((KtReferenceExpression)operand)) >= 0) {
            return StackValue.postIncrement(index2, increment);
        }
        return StackValue.operation(asmBaseType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                Type storeType;
                StackValue value = StackValue.complexWriteReadReceiver(ExpressionCodegen.this.gen(expression.getBaseExpression()));
                value.put(asmBaseType, v);
                AsmUtil.dup(v, asmBaseType);
                StackValue.Local previousValue = StackValue.local(ExpressionCodegen.this.myFrameMap.enterTemp(asmBaseType), asmBaseType);
                previousValue.store(StackValue.onStack(asmBaseType), v);
                if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType)) {
                    AsmUtil.genIncrement(asmBaseType, increment, v);
                    storeType = asmBaseType;
                } else {
                    StackValue result2 = ExpressionCodegen.this.invokeFunction(resolvedCall2, StackValue.onStack(asmBaseType));
                    result2.put(result2.type, v);
                    storeType = result2.type;
                }
                value.store(StackValue.onStack(storeType), v, true);
                previousValue.put(asmBaseType, v);
                ExpressionCodegen.this.myFrameMap.leaveTemp(asmBaseType);
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitProperty(@NotNull KtProperty property, StackValue receiver) {
        if (property == null) {
            ExpressionCodegen.$$$reportNull$$$0(238);
        }
        KtExpression initializer2 = property.getInitializer();
        KtExpression delegateExpression = property.getDelegateExpression();
        if (initializer2 != null) {
            assert (delegateExpression == null) : PsiUtilsKt.getElementTextWithContext(property);
            this.initializeLocalVariable(property, this.gen(initializer2));
        } else if (delegateExpression != null) {
            this.initializeLocalVariable(property, this.gen(delegateExpression));
        }
        return StackValue.none();
    }

    @Override
    public StackValue visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, StackValue receiver) {
        KtExpression initializer2;
        if (multiDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(239);
        }
        if ((initializer2 = multiDeclaration.getInitializer()) == null) {
            return StackValue.none();
        }
        KotlinType initializerType = this.bindingContext.getType(initializer2);
        assert (initializerType != null);
        Type initializerAsmType = this.asmType(initializerType);
        TransientReceiver initializerAsReceiver = new TransientReceiver(initializerType);
        int tempVarIndex = this.myFrameMap.enterTemp(initializerAsmType);
        this.gen(initializer2, initializerAsmType);
        this.v.store(tempVarIndex, initializerAsmType);
        StackValue.Local local = StackValue.local(tempVarIndex, initializerAsmType);
        this.initializeDestructuringDeclarationVariables(multiDeclaration, initializerAsReceiver, local);
        if (initializerAsmType.getSort() == 10 || initializerAsmType.getSort() == 9) {
            this.v.aconst(null);
            this.v.store(tempVarIndex, initializerAsmType);
        }
        this.myFrameMap.leaveTemp(initializerAsmType);
        return StackValue.none();
    }

    public void initializeDestructuringDeclarationVariables(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver, @NotNull StackValue receiverStackValue) {
        if (destructuringDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(240);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(241);
        }
        if (receiverStackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(242);
        }
        for (KtDestructuringDeclarationEntry variableDeclaration : destructuringDeclaration.getEntries()) {
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, variableDeclaration);
            assert (resolvedCall2 != null) : "Resolved call is null for " + variableDeclaration.getText();
            Call call2 = this.makeFakeCall(receiver);
            VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(variableDeclaration);
            if (variableDescriptor.getName().isSpecial()) continue;
            this.initializeLocalVariable(variableDeclaration, this.invokeFunction(call2, resolvedCall2, receiverStackValue));
        }
    }

    @NotNull
    private StackValue getVariableMetadataValue(VariableDescriptor variableDescriptor) {
        StackValue value = this.findLocalOrCapturedValue(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext));
        assert (value != null) : "Can't find stack value for local delegated variable metadata: " + variableDescriptor;
        StackValue stackValue = value;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(243);
        }
        return stackValue;
    }

    @NotNull
    private StackValue adjustVariableValue(@NotNull StackValue varValue, DeclarationDescriptor descriptor2) {
        if (varValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(244);
        }
        if (!JvmCodegenUtil.isDelegatedLocalVariable(descriptor2)) {
            StackValue stackValue = varValue;
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(245);
            }
            return stackValue;
        }
        VariableDescriptorWithAccessors variableDescriptor = (VariableDescriptorWithAccessors)descriptor2;
        StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
        StackValue.Delegate delegate2 = this.delegatedVariableValue(varValue, metadataValue, variableDescriptor, this.typeMapper);
        if (delegate2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(246);
        }
        return delegate2;
    }

    private void initializeLocalVariable(@NotNull KtVariableDeclaration variableDeclaration, @NotNull StackValue initializer2) {
        if (variableDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(247);
        }
        if (initializer2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(248);
        }
        LocalVariableDescriptor variableDescriptor = (LocalVariableDescriptor)this.getVariableDescriptorNotNull(variableDeclaration);
        if (KtPsiUtil.isScriptDeclaration(variableDeclaration)) {
            return;
        }
        int index2 = this.lookupLocalIndex(variableDescriptor);
        if (index2 < 0) {
            throw new IllegalStateException("Local variable not found for " + variableDescriptor);
        }
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        Type varType = this.getVariableTypeNoSharing(variableDescriptor);
        StackValue storeTo = sharedVarType == null ? StackValue.local(index2, varType) : StackValue.shared(index2, varType);
        storeTo.putReceiver(this.v, false);
        initializer2.put(initializer2.type, this.v);
        this.markLineNumber(variableDeclaration, false);
        Type resultType = initializer2.type;
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
            this.initializePropertyMetadata((KtProperty)variableDeclaration, variableDescriptor, metadataValue);
            ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
            if (provideDelegateResolvedCall != null) {
                resultType = this.generateProvideDelegateCallForLocalVariable(initializer2, metadataValue, provideDelegateResolvedCall);
            }
        }
        storeTo.storeSelector(resultType, this.v);
    }

    @NotNull
    private Type generateProvideDelegateCallForLocalVariable(@NotNull StackValue initializer2, final StackValue metadataValue, ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall) {
        if (initializer2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(249);
        }
        StackValue provideDelegateReceiver = StackValue.onStack(initializer2.type);
        List<? extends ValueArgument> arguments2 = provideDelegateResolvedCall.getCall().getValueArguments();
        assert (arguments2.size() == 2) : "Resolved call for '" + OperatorNameConventions.PROVIDE_DELEGATE.asString() + "' should have exactly 2 value parameters";
        this.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
        this.tempVariables.put(arguments2.get(1).asElement(), new StackValue(AsmTypes.K_PROPERTY_TYPE){

            @Override
            public void putSelector(@NotNull Type type2, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    25.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    25.$$$reportNull$$$0(1);
                }
                metadataValue.put(type2, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$25";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        StackValue result2 = this.invokeFunction(provideDelegateResolvedCall, provideDelegateReceiver);
        result2.put(result2.type, this.v);
        this.tempVariables.remove(arguments2.get(0).asElement());
        this.tempVariables.remove(arguments2.get(1).asElement());
        Type type2 = result2.type;
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(250);
        }
        return type2;
    }

    @NotNull
    private VariableDescriptor getVariableDescriptorNotNull(@NotNull KtElement declaration) {
        if (declaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(251);
        }
        VariableDescriptor descriptor2 = this.bindingContext.get(BindingContext.VARIABLE, declaration);
        assert (descriptor2 != null) : "Couldn't find variable declaration in binding context " + declaration.getText();
        VariableDescriptor variableDescriptor = descriptor2;
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(252);
        }
        return variableDescriptor;
    }

    private void initializePropertyMetadata(@NotNull KtProperty variable, @NotNull LocalVariableDescriptor variableDescriptor, @NotNull StackValue metadataVar) {
        if (variable == null) {
            ExpressionCodegen.$$$reportNull$$$0(253);
        }
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(254);
        }
        if (metadataVar == null) {
            ExpressionCodegen.$$$reportNull$$$0(255);
        }
        StackValue value = this.generatePropertyReference(variable.getDelegate(), variableDescriptor, variableDescriptor, null, null);
        value.put(AsmTypes.K_PROPERTY0_TYPE, this.v);
        metadataVar.storeSelector(AsmTypes.K_PROPERTY0_TYPE, this.v);
    }

    @NotNull
    private StackValue generateNewCall(@NotNull KtCallExpression expression, @NotNull ResolvedCall<?> resolvedCall2) {
        Type type2;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(256);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(257);
        }
        if ((type2 = this.expressionType(expression)).getSort() == 9) {
            StackValue stackValue = this.generateNewArray(expression, this.bindingContext.getType(expression), resolvedCall2);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(258);
            }
            return stackValue;
        }
        StackValue stackValue = this.generateConstructorCall(resolvedCall2, type2);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(259);
        }
        return stackValue;
    }

    @NotNull
    public ClassConstructorDescriptor getConstructorDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(260);
        }
        FunctionDescriptor accessibleDescriptor = this.accessibleFunctionDescriptor(resolvedCall2);
        assert (accessibleDescriptor instanceof ClassConstructorDescriptor) : "getConstructorDescriptor must be called only for constructors: " + accessibleDescriptor;
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)accessibleDescriptor;
        if (classConstructorDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(261);
        }
        return classConstructorDescriptor;
    }

    @Nullable
    private static ReceiverValue getConstructorReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        Object constructor;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(262);
        }
        if ((constructor = resolvedCall2.getResultingDescriptor()).getExtensionReceiverParameter() != null) {
            assert (constructor instanceof TypeAliasConstructorDescriptor) : "Only type alias constructor can have an extension receiver: " + constructor;
            return resolvedCall2.getExtensionReceiver();
        }
        if (constructor.getDispatchReceiverParameter() != null) {
            return resolvedCall2.getDispatchReceiver();
        }
        return null;
    }

    @NotNull
    public StackValue generateConstructorCall(final @NotNull ResolvedCall<?> resolvedCall2, final @NotNull Type objectType) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(263);
        }
        if (objectType == null) {
            ExpressionCodegen.$$$reportNull$$$0(264);
        }
        StackValue stackValue = StackValue.functionCall(objectType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                v.anew(objectType);
                v.dup();
                ClassConstructorDescriptor constructor = ExpressionCodegen.this.getConstructorDescriptor(resolvedCall2);
                ReceiverParameterDescriptor dispatchReceiver = constructor.getDispatchReceiverParameter();
                ClassDescriptor containingDeclaration = constructor.getContainingDeclaration();
                if (dispatchReceiver != null) {
                    Type receiverType = ExpressionCodegen.this.typeMapper.mapType(dispatchReceiver.getType());
                    ReceiverValue receiver = ExpressionCodegen.getConstructorReceiver(resolvedCall2);
                    boolean callSuper = containingDeclaration.isInner() && receiver instanceof ImplicitClassReceiver;
                    ExpressionCodegen.this.generateReceiverValue(receiver, callSuper).put(receiverType, v);
                }
                ExpressionCodegen.this.pushClosureOnStack(containingDeclaration, dispatchReceiver == null, ExpressionCodegen.this.defaultCallGenerator, null);
                constructor = SamCodegenUtil.resolveSamAdapter(constructor);
                CallableMethod method = ExpressionCodegen.this.typeMapper.mapToCallableMethod(constructor, false);
                ExpressionCodegen.this.invokeMethodWithArguments(method, resolvedCall2, StackValue.none());
                return Unit.INSTANCE;
            }
        });
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(265);
        }
        return stackValue;
    }

    public StackValue generateNewArray(@NotNull KtCallExpression expression, final @NotNull KotlinType arrayType, @NotNull ResolvedCall<?> resolvedCall2) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(266);
        }
        if (arrayType == null) {
            ExpressionCodegen.$$$reportNull$$$0(267);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(268);
        }
        List<KtValueArgument> args = expression.getValueArguments();
        assert (args.size() == 1 || args.size() == 2) : "Unknown constructor called: " + args.size() + " arguments";
        if (args.size() == 1) {
            final KtExpression sizeExpression = args.get(0).getArgumentExpression();
            return StackValue.operation(this.typeMapper.mapType(arrayType), new Function1<InstructionAdapter, Unit>(){

                @Override
                public Unit invoke(InstructionAdapter v) {
                    ExpressionCodegen.this.gen(sizeExpression, Type.INT_TYPE);
                    ExpressionCodegen.this.newArrayInstruction(arrayType);
                    return Unit.INSTANCE;
                }
            });
        }
        return this.invokeFunction(resolvedCall2, StackValue.none());
    }

    public void newArrayInstruction(@NotNull KotlinType arrayType) {
        if (arrayType == null) {
            ExpressionCodegen.$$$reportNull$$$0(269);
        }
        if (KotlinBuiltIns.isArray(arrayType)) {
            KotlinType elementJetType = arrayType.getArguments().get(0).getType();
            this.putReifiedOperationMarkerIfTypeIsReifiedParameter(elementJetType, ReifiedTypeInliner.OperationKind.NEW_ARRAY);
            this.v.newarray(AsmUtil.boxType(this.asmType(elementJetType)));
        } else {
            Type type2 = this.typeMapper.mapType(arrayType);
            this.v.newarray(AsmUtil.correctElementType(type2));
        }
    }

    @Override
    public StackValue visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression, StackValue receiver) {
        KtExpression array;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(270);
        }
        KotlinType type2 = (array = expression.getArrayExpression()) != null ? this.bindingContext.getType(array) : null;
        Type arrayType = this.expressionType(array);
        List<KtExpression> indices = expression.getIndexExpressions();
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        assert (operationDescriptor != null);
        if (arrayType.getSort() == 9 && indices.size() == 1 && KotlinBuiltIns.isInt(operationDescriptor.getValueParameters().get(0).getType())) {
            Type elementType;
            assert (type2 != null);
            if (KotlinBuiltIns.isArray(type2)) {
                KotlinType jetElementType = type2.getArguments().get(0).getType();
                elementType = AsmUtil.boxType(this.asmType(jetElementType));
            } else {
                elementType = AsmUtil.correctElementType(arrayType);
            }
            StackValue arrayValue = this.genLazy(array, arrayType);
            StackValue index2 = this.genLazy(indices.get(0), Type.INT_TYPE);
            return StackValue.arrayElement(elementType, arrayValue, index2);
        }
        ResolvedCall<FunctionDescriptor> resolvedSetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_SET, expression);
        ResolvedCall<FunctionDescriptor> resolvedGetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_GET, expression);
        boolean isGetter = OperatorNameConventions.GET.equals(operationDescriptor.getName());
        Callable callable = this.resolveToCallable(operationDescriptor, false, isGetter ? resolvedGetCall : resolvedSetCall);
        CallableMethod callableMethod = this.resolveToCallableMethod(operationDescriptor, false);
        Type[] argumentTypes = callableMethod.getParameterTypes();
        StackValue.CollectionElementReceiver collectionElementReceiver = this.createCollectionElementReceiver(expression, receiver, operationDescriptor, isGetter, resolvedGetCall, resolvedSetCall, callable);
        Type elementType = isGetter ? callableMethod.getReturnType() : ArrayUtil.getLastElement(argumentTypes);
        return StackValue.collectionElement(collectionElementReceiver, elementType, resolvedGetCall, resolvedSetCall, this);
    }

    @NotNull
    private StackValue.CollectionElementReceiver createCollectionElementReceiver(@NotNull KtArrayAccessExpression expression, @NotNull StackValue receiver, @NotNull FunctionDescriptor operationDescriptor, boolean isGetter, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull Callable callable) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(271);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(272);
        }
        if (operationDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(273);
        }
        if (callable == null) {
            ExpressionCodegen.$$$reportNull$$$0(274);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall2 != null) : "couldn't find resolved call: " + expression.getText();
        List<ResolvedValueArgument> valueArguments2 = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + operationDescriptor;
        if (!isGetter) {
            assert (valueArguments2.size() >= 2) : "Setter call should have at least 2 arguments: " + operationDescriptor;
            valueArguments2.remove(valueArguments2.size() - 1);
        }
        StackValue.CollectionElementReceiver collectionElementReceiver = new StackValue.CollectionElementReceiver(callable, receiver, resolvedGetCall, resolvedSetCall, isGetter, this, valueArguments2);
        if (collectionElementReceiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(275);
        }
        return collectionElementReceiver;
    }

    @Override
    public StackValue visitThrowExpression(final @NotNull KtThrowExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(276);
        }
        return StackValue.operation(Type.VOID_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter adapter) {
                ExpressionCodegen.this.gen(expression.getThrownExpression(), AsmTypes.JAVA_THROWABLE_TYPE);
                ExpressionCodegen.this.v.athrow();
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitThisExpression(@NotNull KtThisExpression expression, StackValue receiver) {
        DeclarationDescriptor descriptor2;
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(277);
        }
        if ((descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference())) instanceof ClassDescriptor) {
            return StackValue.thisOrOuter(this, (ClassDescriptor)descriptor2, false, true);
        }
        if (descriptor2 instanceof CallableDescriptor) {
            return this.generateExtensionReceiver((CallableDescriptor)descriptor2);
        }
        throw new UnsupportedOperationException("Neither this nor receiver: " + descriptor2 + expression.getParent().getContainingFile().getText());
    }

    @Override
    public StackValue visitTryExpression(@NotNull KtTryExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(278);
        }
        return this.generateTryExpression(expression, false);
    }

    public StackValue generateTryExpression(final KtTryExpression expression, final boolean isStatement) {
        final Type expectedAsmType = isStatement ? Type.VOID_TYPE : this.expressionTypeForBranchingOperation(expression);
        return StackValue.operation(expectedAsmType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                KtFinallySection finallyBlock = expression.getFinallyBlock();
                FinallyBlockStackElement finallyBlockStackElement = null;
                if (finallyBlock != null) {
                    finallyBlockStackElement = new FinallyBlockStackElement(expression);
                    ExpressionCodegen.this.blockStackElements.push(finallyBlockStackElement);
                }
                Label tryStart = new Label();
                v.mark(tryStart);
                v.nop();
                ExpressionCodegen.this.gen(expression.getTryBlock(), expectedAsmType);
                int savedValue = -1;
                if (!isStatement) {
                    savedValue = ExpressionCodegen.this.myFrameMap.enterTemp(expectedAsmType);
                    v.store(savedValue, expectedAsmType);
                }
                Label tryEnd = new Label();
                v.mark(tryEnd);
                List tryBlockRegions = ExpressionCodegen.getCurrentCatchIntervals(finallyBlockStackElement, tryStart, tryEnd);
                Label end = new Label();
                ExpressionCodegen.this.genFinallyBlockOrGoto(finallyBlockStackElement, end, null);
                List<KtCatchClause> clauses = expression.getCatchClauses();
                int size = clauses.size();
                for (int i = 0; i < size; ++i) {
                    KtCatchClause clause = clauses.get(i);
                    Label clauseStart = new Label();
                    v.mark(clauseStart);
                    KtExpression catchBody = clause.getCatchBody();
                    if (catchBody != null) {
                        ExpressionCodegen.this.markLineNumber(catchBody, false);
                    }
                    VariableDescriptor descriptor2 = ExpressionCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER, clause.getCatchParameter());
                    assert (descriptor2 != null);
                    Type descriptorType = ExpressionCodegen.this.asmType(descriptor2.getType());
                    ExpressionCodegen.this.myFrameMap.enter(descriptor2, descriptorType);
                    int index2 = ExpressionCodegen.this.lookupLocalIndex(descriptor2);
                    v.store(index2, descriptorType);
                    Label catchVariableStart = new Label();
                    v.mark(catchVariableStart);
                    ExpressionCodegen.this.gen(catchBody, expectedAsmType);
                    if (!isStatement) {
                        v.store(savedValue, expectedAsmType);
                    }
                    ExpressionCodegen.this.myFrameMap.leave(descriptor2);
                    Label clauseEnd = new Label();
                    v.mark(clauseEnd);
                    v.visitLocalVariable(descriptor2.getName().asString(), descriptorType.getDescriptor(), null, catchVariableStart, clauseEnd, index2);
                    ExpressionCodegen.this.genFinallyBlockOrGoto(finallyBlockStackElement, i != size - 1 || finallyBlock != null ? end : null, null);
                    ExpressionCodegen.this.generateExceptionTable(clauseStart, tryBlockRegions, descriptorType.getInternalName());
                }
                if (finallyBlock != null) {
                    Label defaultCatchStart = new Label();
                    v.mark(defaultCatchStart);
                    int savedException = ExpressionCodegen.this.myFrameMap.enterTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                    v.store(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                    Label defaultCatchEnd = new Label();
                    v.mark(defaultCatchEnd);
                    List defaultCatchRegions = ExpressionCodegen.getCurrentCatchIntervals(finallyBlockStackElement, tryStart, defaultCatchEnd);
                    ExpressionCodegen.this.genFinallyBlockOrGoto(finallyBlockStackElement, null, null);
                    v.load(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                    ExpressionCodegen.this.myFrameMap.leaveTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                    v.athrow();
                    ExpressionCodegen.this.generateExceptionTable(defaultCatchStart, defaultCatchRegions, null);
                }
                ExpressionCodegen.this.markLineNumber(expression, isStatement);
                v.mark(end);
                if (!isStatement) {
                    v.load(savedValue, expectedAsmType);
                    ExpressionCodegen.this.myFrameMap.leaveTemp(expectedAsmType);
                }
                if (finallyBlock != null) {
                    ExpressionCodegen.this.blockStackElements.pop();
                }
                return Unit.INSTANCE;
            }
        });
    }

    private void generateExceptionTable(@NotNull Label catchStart, @NotNull List<Label> catchedRegions, @Nullable String exception) {
        if (catchStart == null) {
            ExpressionCodegen.$$$reportNull$$$0(279);
        }
        if (catchedRegions == null) {
            ExpressionCodegen.$$$reportNull$$$0(280);
        }
        for (int i = 0; i < catchedRegions.size(); i += 2) {
            Label startRegion = catchedRegions.get(i);
            Label endRegion = catchedRegions.get(i + 1);
            this.v.visitTryCatchBlock(startRegion, endRegion, catchStart, exception);
        }
    }

    @NotNull
    private static List<Label> getCurrentCatchIntervals(@Nullable FinallyBlockStackElement finallyBlockStackElement, @NotNull Label blockStart, @NotNull Label blockEnd) {
        ArrayList<Label> gapsInBlock;
        if (blockStart == null) {
            ExpressionCodegen.$$$reportNull$$$0(281);
        }
        if (blockEnd == null) {
            ExpressionCodegen.$$$reportNull$$$0(282);
        }
        ArrayList<Label> arrayList = gapsInBlock = finallyBlockStackElement != null ? new ArrayList<Label>(finallyBlockStackElement.gaps) : Collections.emptyList();
        assert (gapsInBlock.size() % 2 == 0);
        ArrayList<Label> blockRegions = new ArrayList<Label>(gapsInBlock.size() + 2);
        blockRegions.add(blockStart);
        blockRegions.addAll(gapsInBlock);
        blockRegions.add(blockEnd);
        ArrayList<Label> arrayList2 = blockRegions;
        if (arrayList2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(283);
        }
        return arrayList2;
    }

    @Override
    public StackValue visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(284);
        }
        KtExpression left = expression.getLeft();
        final IElementType opToken = expression.getOperationReference().getReferencedNameElementType();
        final KotlinType rightType = this.bindingContext.get(BindingContext.TYPE, expression.getRight());
        assert (rightType != null);
        final StackValue value = this.genQualified(receiver, left);
        return StackValue.operation(AsmUtil.boxType(this.asmType(rightType)), new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                value.put(AsmUtil.boxType(value.type), v);
                if (value.type == Type.VOID_TYPE) {
                    StackValue.putUnitInstance(v);
                }
                boolean safeAs = opToken == KtTokens.AS_SAFE;
                Type type2 = AsmUtil.boxType(ExpressionCodegen.this.asmType(rightType));
                if (TypeUtils.isReifiedTypeParameter(rightType)) {
                    ExpressionCodegen.this.putReifiedOperationMarkerIfTypeIsReifiedParameter(rightType, safeAs ? ReifiedTypeInliner.OperationKind.SAFE_AS : ReifiedTypeInliner.OperationKind.AS);
                    v.checkcast(type2);
                    return Unit.INSTANCE;
                }
                CodegenUtilKt.generateAsCast(v, rightType, type2, safeAs);
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    public StackValue visitIsExpression(@NotNull KtIsExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(285);
        }
        StackValue match2 = StackValue.expression(AsmTypes.OBJECT_TYPE, expression.getLeftHandSide(), this);
        return this.generateIsCheck(match2, expression.getTypeReference(), expression.isNegated());
    }

    private StackValue generateExpressionMatch(StackValue expressionToMatch, KtExpression subjectExpression, KtExpression patternExpression) {
        if (expressionToMatch != null) {
            Type condType;
            Type subjectType = expressionToMatch.type;
            this.markStartLineNumber(patternExpression);
            KotlinType condJetType = this.bindingContext.getType(patternExpression);
            if (AsmUtil.isNumberPrimitiveOrBoolean(subjectType)) {
                assert (condJetType != null);
                condType = this.asmType(condJetType);
                if (!AsmUtil.isNumberPrimitiveOrBoolean(condType)) {
                    subjectType = AsmUtil.boxType(subjectType);
                }
            } else {
                condType = AsmTypes.OBJECT_TYPE;
            }
            return this.genEqualsForExpressionsPreferIEEE754Arithmetic(subjectExpression, patternExpression, KtTokens.EQEQ, subjectType, condType, expressionToMatch);
        }
        return this.gen(patternExpression);
    }

    private StackValue generateIsCheck(StackValue expressionToMatch, KtTypeReference typeReference, boolean negated) {
        KotlinType jetType = this.bindingContext.get(BindingContext.TYPE, typeReference);
        this.markStartLineNumber(typeReference);
        StackValue value = this.generateIsCheck(expressionToMatch, jetType, false);
        return negated ? StackValue.not(value) : value;
    }

    private StackValue generateIsCheck(final StackValue expressionToGen, final KotlinType kotlinType, final boolean leaveExpressionOnStack) {
        return StackValue.operation(Type.BOOLEAN_TYPE, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                expressionToGen.put(AsmTypes.OBJECT_TYPE, v);
                if (leaveExpressionOnStack) {
                    v.dup();
                }
                Type type2 = AsmUtil.boxType(ExpressionCodegen.this.asmType(kotlinType));
                if (TypeUtils.isReifiedTypeParameter(kotlinType)) {
                    ExpressionCodegen.this.putReifiedOperationMarkerIfTypeIsReifiedParameter(kotlinType, ReifiedTypeInliner.OperationKind.IS);
                    v.instanceOf(type2);
                    return null;
                }
                CodegenUtilKt.generateIsCheck(v, kotlinType, type2);
                return null;
            }
        });
    }

    public void putReifiedOperationMarkerIfTypeIsReifiedParameter(@NotNull KotlinType type2, @NotNull ReifiedTypeInliner.OperationKind operationKind) {
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(286);
        }
        if (operationKind == null) {
            ExpressionCodegen.$$$reportNull$$$0(287);
        }
        this.putReifiedOperationMarkerIfTypeIsReifiedParameter(type2, operationKind, this.v);
    }

    public void putReifiedOperationMarkerIfTypeIsReifiedParameter(@NotNull KotlinType type2, @NotNull ReifiedTypeInliner.OperationKind operationKind, @NotNull InstructionAdapter v) {
        Pair<TypeParameterDescriptor, ReificationArgument> typeParameterAndReificationArgument;
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(288);
        }
        if (operationKind == null) {
            ExpressionCodegen.$$$reportNull$$$0(289);
        }
        if (v == null) {
            ExpressionCodegen.$$$reportNull$$$0(290);
        }
        if ((typeParameterAndReificationArgument = ExpressionCodegen.extractReificationArgument(type2)) != null && typeParameterAndReificationArgument.getFirst().isReified()) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameterAndReificationArgument.getFirst();
            if (typeParameterDescriptor.getContainingDeclaration() != this.context.getContextDescriptor()) {
                this.parentCodegen.getReifiedTypeParametersUsages().addUsedReifiedParameter(typeParameterDescriptor.getName().asString());
            }
            v.iconst(operationKind.getId());
            v.visitLdcInsn(typeParameterAndReificationArgument.getSecond().asString());
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "reifiedOperationMarker", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE, Type.getType(String.class)), false);
        }
    }

    public void propagateChildReifiedTypeParametersUsages(@NotNull ReifiedTypeParametersUsages usages) {
        if (usages == null) {
            ExpressionCodegen.$$$reportNull$$$0(291);
        }
        this.parentCodegen.getReifiedTypeParametersUsages().propagateChildUsagesWithinContext(usages, this.context);
    }

    @Override
    public StackValue visitWhenExpression(@NotNull KtWhenExpression expression, StackValue receiver) {
        if (expression == null) {
            ExpressionCodegen.$$$reportNull$$$0(292);
        }
        return this.generateWhenExpression(expression, false);
    }

    public StackValue generateWhenExpression(final KtWhenExpression expression, final boolean isStatement) {
        final KtExpression expr = expression.getSubjectExpression();
        final Type subjectType = this.expressionType(expr);
        final Type resultType = isStatement ? Type.VOID_TYPE : this.expressionTypeForBranchingOperation(expression);
        return StackValue.operation(resultType, new Function1<InstructionAdapter, Unit>(){

            @Override
            public Unit invoke(InstructionAdapter v) {
                int subjectLocal;
                SwitchCodegen switchCodegen = SwitchCodegenUtil.buildAppropriateSwitchCodegenIfPossible(expression, isStatement, CodegenUtil.isExhaustive(ExpressionCodegen.this.bindingContext, expression, isStatement), ExpressionCodegen.this);
                if (switchCodegen != null) {
                    switchCodegen.generate();
                    return Unit.INSTANCE;
                }
                int n = subjectLocal = expr != null ? ExpressionCodegen.this.myFrameMap.enterTemp(subjectType) : -1;
                if (subjectLocal != -1) {
                    ExpressionCodegen.this.gen(expr, subjectType);
                    ExpressionCodegen.this.tempVariables.put(expr, StackValue.local(subjectLocal, subjectType));
                    v.store(subjectLocal, subjectType);
                }
                Label end = new Label();
                boolean hasElse = KtPsiUtil.checkWhenExpressionHasSingleElse(expression);
                Label nextCondition = null;
                for (KtWhenEntry whenEntry : expression.getEntries()) {
                    if (nextCondition != null) {
                        v.mark(nextCondition);
                    }
                    nextCondition = new Label();
                    FrameMap.Mark mark = ExpressionCodegen.this.myFrameMap.mark();
                    Label thisEntry = new Label();
                    if (!whenEntry.isElse()) {
                        KtWhenCondition[] conditions = whenEntry.getConditions();
                        for (int i = 0; i < conditions.length; ++i) {
                            StackValue conditionValue = ExpressionCodegen.this.generateWhenCondition(expr, subjectType, subjectLocal, conditions[i]);
                            BranchedValue.Companion.condJump(conditionValue, nextCondition, true, v);
                            if (i >= conditions.length - 1) continue;
                            v.goTo(thisEntry);
                            v.mark(nextCondition);
                            nextCondition = new Label();
                        }
                    }
                    v.visitLabel(thisEntry);
                    ExpressionCodegen.this.gen(whenEntry.getExpression(), resultType);
                    mark.dropTo();
                    if (whenEntry.isElse()) continue;
                    v.goTo(end);
                }
                if (!hasElse && nextCondition != null) {
                    v.mark(nextCondition);
                    ExpressionCodegen.this.putUnitInstanceOntoStackForNonExhaustiveWhen(expression, isStatement);
                }
                ExpressionCodegen.this.markLineNumber(expression, isStatement);
                v.mark(end);
                ExpressionCodegen.this.myFrameMap.leaveTemp(subjectType);
                ExpressionCodegen.this.tempVariables.remove(expr);
                return null;
            }
        });
    }

    public void putUnitInstanceOntoStackForNonExhaustiveWhen(@NotNull KtWhenExpression whenExpression, boolean isStatement) {
        if (whenExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(293);
        }
        if (CodegenUtil.isExhaustive(this.bindingContext, whenExpression, isStatement)) {
            AsmUtil.genThrow(this.v, "kotlin/NoWhenBranchMatchedException", null);
        } else if (!isStatement) {
            StackValue.putUnitInstance(this.v);
        }
    }

    private StackValue generateWhenCondition(KtExpression subjectExpression, Type subjectType, int subjectLocal, KtWhenCondition condition) {
        StackValue.Local match2;
        if (condition instanceof KtWhenConditionInRange) {
            KtWhenConditionInRange conditionInRange = (KtWhenConditionInRange)condition;
            return this.generateIn(StackValue.local(subjectLocal, subjectType), conditionInRange.getRangeExpression(), conditionInRange.getOperationReference());
        }
        StackValue.Local local = match2 = subjectLocal == -1 ? null : StackValue.local(subjectLocal, subjectType);
        if (condition instanceof KtWhenConditionIsPattern) {
            KtWhenConditionIsPattern patternCondition = (KtWhenConditionIsPattern)condition;
            return this.generateIsCheck((StackValue)match2, patternCondition.getTypeReference(), patternCondition.isNegated());
        }
        if (condition instanceof KtWhenConditionWithExpression) {
            KtExpression patternExpression = ((KtWhenConditionWithExpression)condition).getExpression();
            return this.generateExpressionMatch(match2, subjectExpression, patternExpression);
        }
        throw new UnsupportedOperationException("unsupported kind of when condition");
    }

    private Call makeFakeCall(ReceiverValue initializerAsReceiver) {
        KtSimpleNameExpression fake = KtPsiFactoryKt.KtPsiFactory(this.state.getProject(), false).createSimpleName("fake");
        return CallMaker.makeCall(fake, initializerAsReceiver);
    }

    public String toString() {
        return ((CallableMemberDescriptor)this.context.getContextDescriptor()).toString();
    }

    @NotNull
    public FrameMap getFrameMap() {
        FrameMap frameMap = this.myFrameMap;
        if (frameMap == null) {
            ExpressionCodegen.$$$reportNull$$$0(294);
        }
        return frameMap;
    }

    @NotNull
    public MethodContext getContext() {
        MethodContext methodContext = this.context;
        if (methodContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(295);
        }
        return methodContext;
    }

    @NotNull
    public NameGenerator getInlineNameGenerator() {
        NameGenerator nameGenerator2 = this.getParentCodegen().getInlineNameGenerator();
        Name name = ((CallableMemberDescriptor)this.context.getContextDescriptor()).getName();
        String inlinedName = name.isSpecial() ? "$special" : name.asString();
        NameGenerator nameGenerator3 = nameGenerator2.subGenerator(inlinedName + "$$inlined");
        if (nameGenerator3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(296);
        }
        return nameGenerator3;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Stack<BlockStackElement> getBlockStackElements() {
        return new Stack<BlockStackElement>((Collection<BlockStackElement>)this.blockStackElements);
    }

    public void addBlockStackElementsForNonLocalReturns(@NotNull Stack<BlockStackElement> elements, int finallyDepth) {
        if (elements == null) {
            ExpressionCodegen.$$$reportNull$$$0(297);
        }
        this.blockStackElements.addAll(elements);
        this.finallyDepth = finallyDepth;
    }

    @NotNull
    private StackValue.Delegate delegatedVariableValue(@NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KotlinTypeMapper typeMapper) {
        if (delegateValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(298);
        }
        if (metadataValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(299);
        }
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(300);
        }
        if (typeMapper == null) {
            ExpressionCodegen.$$$reportNull$$$0(301);
        }
        StackValue.Delegate delegate2 = StackValue.delegate(typeMapper.mapType(variableDescriptor.getType()), delegateValue, metadataValue, variableDescriptor, this);
        if (delegate2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(302);
        }
        return delegate2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 52: 
            case 53: 
            case 66: 
            case 70: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 86: 
            case 88: 
            case 118: 
            case 125: 
            case 131: 
            case 134: 
            case 138: 
            case 139: 
            case 140: 
            case 144: 
            case 145: 
            case 147: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 168: 
            case 172: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 188: 
            case 189: 
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 206: 
            case 208: 
            case 243: 
            case 245: 
            case 246: 
            case 250: 
            case 252: 
            case 258: 
            case 259: 
            case 261: 
            case 265: 
            case 275: 
            case 283: 
            case 294: 
            case 295: 
            case 296: 
            case 302: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 52: 
            case 53: 
            case 66: 
            case 70: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 86: 
            case 88: 
            case 118: 
            case 125: 
            case 131: 
            case 134: 
            case 138: 
            case 139: 
            case 140: 
            case 144: 
            case 145: 
            case 147: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 168: 
            case 172: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 188: 
            case 189: 
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 206: 
            case 208: 
            case 243: 
            case 245: 
            case 246: 
            case 250: 
            case 252: 
            case 258: 
            case 259: 
            case 261: 
            case 265: 
            case 275: 
            case 283: 
            case 294: 
            case 295: 
            case 296: 
            case 302: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 3: 
            case 25: 
            case 76: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCodegen";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 52: 
            case 53: 
            case 66: 
            case 70: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 86: 
            case 88: 
            case 118: 
            case 125: 
            case 131: 
            case 134: 
            case 138: 
            case 139: 
            case 140: 
            case 144: 
            case 145: 
            case 147: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 168: 
            case 172: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 188: 
            case 189: 
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 206: 
            case 208: 
            case 243: 
            case 245: 
            case 246: 
            case 250: 
            case 252: 
            case 258: 
            case 259: 
            case 261: 
            case 265: 
            case 275: 
            case 283: 
            case 294: 
            case 295: 
            case 296: 
            case 302: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ExpressionCodegen";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 12: 
            case 68: 
            case 103: 
            case 109: 
            case 110: 
            case 111: 
            case 115: 
            case 159: 
            case 167: 
            case 171: 
            case 174: 
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provided";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "required";
                break;
            }
            case 17: 
            case 28: 
            case 177: 
            case 286: 
            case 288: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 22: 
            case 67: 
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 23: 
            case 24: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 48: 
            case 49: 
            case 50: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 65: 
            case 73: 
            case 80: 
            case 101: 
            case 104: 
            case 105: 
            case 126: 
            case 127: 
            case 201: 
            case 202: 
            case 209: 
            case 210: 
            case 212: 
            case 214: 
            case 215: 
            case 229: 
            case 230: 
            case 234: 
            case 235: 
            case 237: 
            case 256: 
            case 266: 
            case 270: 
            case 271: 
            case 276: 
            case 277: 
            case 278: 
            case 284: 
            case 285: 
            case 292: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forExpression";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopRangeCall";
                break;
            }
            case 45: 
            case 47: 
            case 83: 
            case 130: 
            case 132: 
            case 136: 
            case 141: 
            case 143: 
            case 149: 
            case 152: 
            case 157: 
            case 169: 
            case 170: 
            case 173: 
            case 231: 
            case 257: 
            case 260: 
            case 262: 
            case 263: 
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterBreakContinueLabel";
                break;
            }
            case 56: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 63: 
            case 64: 
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureCodegen";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 75: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callGenerator";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendFunction";
                break;
            }
            case 85: 
            case 87: 
            case 204: 
            case 254: 
            case 300: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 92: 
            case 282: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
            case 93: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaveTasks";
                break;
            }
            case 98: 
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 100: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterReturnLabel";
                break;
            }
            case 106: 
            case 107: 
            case 117: 
            case 122: 
            case 124: 
            case 133: 
            case 137: 
            case 150: 
            case 153: 
            case 158: 
            case 187: 
            case 216: 
            case 236: 
            case 241: 
            case 272: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 108: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 116: 
            case 121: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorKind";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "probablyParenthesizedExpression";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 142: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fd";
                break;
            }
            case 148: 
            case 151: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableMethod";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentGenerator";
                break;
            }
            case 190: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeContainingClass";
                break;
            }
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueArgument";
                break;
            }
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outType";
                break;
            }
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhs";
                break;
            }
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifnull";
                break;
            }
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifNull";
                break;
            }
            case 217: 
            case 218: 
            case 222: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
            case 221: 
            case 225: 
            case 290: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 223: 
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left754Type";
                break;
            }
            case 224: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right754Type";
                break;
            }
            case 232: 
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhsType";
                break;
            }
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiDeclaration";
                break;
            }
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringDeclaration";
                break;
            }
            case 242: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverStackValue";
                break;
            }
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varValue";
                break;
            }
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDeclaration";
                break;
            }
            case 248: 
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataVar";
                break;
            }
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectType";
                break;
            }
            case 267: 
            case 269: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 273: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationDescriptor";
                break;
            }
            case 279: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchStart";
                break;
            }
            case 280: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchedRegions";
                break;
            }
            case 281: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 287: 
            case 289: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationKind";
                break;
            }
            case 291: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 293: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whenExpression";
                break;
            }
            case 297: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 298: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateValue";
                break;
            }
            case 299: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataValue";
                break;
            }
            case 301: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentCodegen";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateObjectLiteral";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "castToRequiredTypeOfInterfaceIfNeeded";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptContext";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperCallLabelTarget";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "asmType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionTypeForBranchingOperation";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedReceiverType";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "generateBreakOrContinueExpression";
                break;
            }
            case 66: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "genClosure";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "putClosureInstanceOnStack";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapOriginalReceiverOwnerForSuspendFunction";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupOuterValue";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableType";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableTypeNoSharing";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "intermediateValueForProperty";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "intermediateValueForSyntheticExtensionProperty";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "accessibleFunctionDescriptor";
                break;
            }
            case 134: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeFunction";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToCallable";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToCallableMethod";
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCallGenerator";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapInitialSignatureDescriptor";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCallGeneratorForDefaultImplBody";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForResolvedCall";
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "generateReceiverValue";
                break;
            }
            case 185: 
            case 186: {
                objectArray = objectArray2;
                objectArray2[1] = "generateExtensionReceiver";
                break;
            }
            case 188: 
            case 189: {
                objectArray = objectArray2;
                objectArray2[1] = "generateScriptReceiver";
                break;
            }
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: {
                objectArray = objectArray2;
                objectArray2[1] = "generateThisOrOuter";
                break;
            }
            case 198: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullParentContextForMethod";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePropertyReference";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClassLiteralReference";
                break;
            }
            case 243: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableMetadataValue";
                break;
            }
            case 245: 
            case 246: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustVariableValue";
                break;
            }
            case 250: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProvideDelegateCallForLocalVariable";
                break;
            }
            case 252: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableDescriptorNotNull";
                break;
            }
            case 258: 
            case 259: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewCall";
                break;
            }
            case 261: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorDescriptor";
                break;
            }
            case 265: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConstructorCall";
                break;
            }
            case 275: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollectionElementReceiver";
                break;
            }
            case 283: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCatchIntervals";
                break;
            }
            case 294: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameMap";
                break;
            }
            case 295: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 296: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineNameGenerator";
                break;
            }
            case 302: {
                objectArray = objectArray2;
                objectArray2[1] = "delegatedVariableValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 52: 
            case 53: 
            case 66: 
            case 70: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 86: 
            case 88: 
            case 118: 
            case 125: 
            case 131: 
            case 134: 
            case 138: 
            case 139: 
            case 140: 
            case 144: 
            case 145: 
            case 147: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 168: 
            case 172: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 188: 
            case 189: 
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 206: 
            case 208: 
            case 243: 
            case 245: 
            case 246: 
            case 250: 
            case 252: 
            case 258: 
            case 259: 
            case 261: 
            case 265: 
            case 275: 
            case 283: 
            case 294: 
            case 295: 
            case 296: 
            case 302: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateObjectLiteral";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addReifiedParametersFromSignature";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "castToRequiredTypeOfInterfaceIfNeeded";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putStackValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeAlias";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectDeclaration";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallLabelTarget";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "asmType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateIfExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "generateWhile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "generateDoWhile";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateFor";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createOptimizedForLoopGeneratorOrNull";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedReceiverType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSingleArgumentExpression";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakExpression";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueExpression";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "generateBreakOrContinueExpression";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantExpression";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveOrStringCompileTimeConstant";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeConstant";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "visitStringTemplateExpression";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "genClosure";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "putClosureInstanceOnStack";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "pushClosureOnStack";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "unwrapOriginalReceiverOwnerForSuspendFunction";
                break;
            }
            case 80: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "generateBlock";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineInstanceValueForSuspensionPoint";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "genCoroutineInstanceBySuspendFunction";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getVariableType";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeNoSharing";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "putDescriptorIntoFrameMap";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "putLocalVariableIntoFrameMap";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "addLeaveTaskToRemoveDescriptorFromFrameMap";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addLeaveTaskToRemoveLocalVariableFromFrameMap";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "addLeaveTaskToRemoveNamedFunctionFromFrameMap";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "markStartLineNumber";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "markLineNumber";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "doFinallyOnReturn";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnExpression";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "generateFinallyBlocksIfNeeded";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getNonLocalReturnInfo";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleNameExpression";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "applyIntrinsic";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallTarget";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "findLocalOrCapturedValue";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "findCapturedValue";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "lookupValuaAndLocalVariableMetadata";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "lookupCapturedValueInConstructorParameters";
                break;
            }
            case 116: 
            case 117: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "intermediateValueForProperty";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getBackingFieldContext";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "intermediateValueForSyntheticExtensionProperty";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "visitCollectionLiteralExpression";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "genSamInterfaceValue";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "accessibleFunctionDescriptor";
                break;
            }
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "invokeFunction";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "getContinuationParameterFromEnclosingSuspendFunction";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "resolveToCallable";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "resolveToCallableMethod";
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethodWithArguments";
                break;
            }
            case 156: 
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "putReceiverAndInlineMarkerIfNeeded";
                break;
            }
            case 159: 
            case 169: 
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCallGenerator";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "unwrapInitialSignatureDescriptor";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCallGeneratorForDefaultImplBody";
                break;
            }
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForResolvedCall";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "extractReificationArgument";
                break;
            }
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "generateExtensionReceiver";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "generateScriptReceiver";
                break;
            }
            case 190: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "generateThisOrOuter";
                break;
            }
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "genVarargs";
                break;
            }
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "visitClassLiteralExpression";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 203: 
            case 204: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "generatePropertyReference";
                break;
            }
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "generateClassLiteralReference";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "visitDotQualifiedExpression";
                break;
            }
            case 210: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "generateExpressionWithNullFallback";
                break;
            }
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "generateSafeQualifiedExpression";
                break;
            }
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "visitSafeQualifiedExpression";
                break;
            }
            case 215: 
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "generateEquals";
                break;
            }
            case 218: 
            case 219: 
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForExpressionsPreferIEEE754Arithmetic";
                break;
            }
            case 221: 
            case 222: 
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "generate754EqualsForNullableTypesViaIntrinsic";
                break;
            }
            case 225: 
            case 226: 
            case 227: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "generate754EqualsForNullableTypes";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "generateElvis";
                break;
            }
            case 230: 
            case 231: 
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "putCallAugAssignMethod";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "visitPrefixExpression";
                break;
            }
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "visitPostfixExpression";
                break;
            }
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "visitDestructuringDeclaration";
                break;
            }
            case 240: 
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "initializeDestructuringDeclarationVariables";
                break;
            }
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "adjustVariableValue";
                break;
            }
            case 247: 
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "initializeLocalVariable";
                break;
            }
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "generateProvideDelegateCallForLocalVariable";
                break;
            }
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "getVariableDescriptorNotNull";
                break;
            }
            case 253: 
            case 254: 
            case 255: {
                objectArray = objectArray;
                objectArray[2] = "initializePropertyMetadata";
                break;
            }
            case 256: 
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "generateNewCall";
                break;
            }
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorDescriptor";
                break;
            }
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorReceiver";
                break;
            }
            case 263: 
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "generateConstructorCall";
                break;
            }
            case 266: 
            case 267: 
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "generateNewArray";
                break;
            }
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "newArrayInstruction";
                break;
            }
            case 270: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 271: 
            case 272: 
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "createCollectionElementReceiver";
                break;
            }
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowExpression";
                break;
            }
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "visitTryExpression";
                break;
            }
            case 279: 
            case 280: {
                objectArray = objectArray;
                objectArray[2] = "generateExceptionTable";
                break;
            }
            case 281: 
            case 282: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentCatchIntervals";
                break;
            }
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "visitIsExpression";
                break;
            }
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: {
                objectArray = objectArray;
                objectArray[2] = "putReifiedOperationMarkerIfTypeIsReifiedParameter";
                break;
            }
            case 291: {
                objectArray = objectArray;
                objectArray[2] = "propagateChildReifiedTypeParametersUsages";
                break;
            }
            case 292: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "putUnitInstanceOntoStackForNonExhaustiveWhen";
                break;
            }
            case 297: {
                objectArray = objectArray;
                objectArray[2] = "addBlockStackElementsForNonLocalReturns";
                break;
            }
            case 298: 
            case 299: 
            case 300: 
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "delegatedVariableValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 52: 
            case 53: 
            case 66: 
            case 70: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 86: 
            case 88: 
            case 118: 
            case 125: 
            case 131: 
            case 134: 
            case 138: 
            case 139: 
            case 140: 
            case 144: 
            case 145: 
            case 147: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 165: 
            case 166: 
            case 168: 
            case 172: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 186: 
            case 188: 
            case 189: 
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 206: 
            case 208: 
            case 243: 
            case 245: 
            case 246: 
            case 250: 
            case 252: 
            case 258: 
            case 259: 
            case 261: 
            case 265: 
            case 275: 
            case 283: 
            case 294: 
            case 295: 
            case 296: 
            case 302: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonLocalReturnInfo {
        private final Type returnType;
        private final String labelName;

        private NonLocalReturnInfo(@NotNull Type type2, @NotNull String name) {
            if (type2 == null) {
                NonLocalReturnInfo.$$$reportNull$$$0(0);
            }
            if (name == null) {
                NonLocalReturnInfo.$$$reportNull$$$0(1);
            }
            this.returnType = type2;
            this.labelName = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$NonLocalReturnInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ForInProgressionExpressionLoopGenerator
    extends AbstractForInProgressionOrRangeLoopGenerator {
        private int incrementVar;
        private Type incrementType;

        private ForInProgressionExpressionLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                ForInProgressionExpressionLoopGenerator.$$$reportNull$$$0(0);
            }
            super(forExpression);
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.incrementVar = this.createLoopTempVariable(this.asmElementType);
            KotlinType loopRangeType = ExpressionCodegen.this.bindingContext.getType(this.forExpression.getLoopRange());
            assert (loopRangeType != null);
            Type asmLoopRangeType = ExpressionCodegen.this.asmType(loopRangeType);
            Collection<PropertyDescriptor> incrementProp = loopRangeType.getMemberScope().getContributedVariables(Name.identifier("step"), NoLookupLocation.FROM_BACKEND);
            assert (incrementProp.size() == 1) : loopRangeType + " " + incrementProp.size();
            this.incrementType = ExpressionCodegen.this.asmType(incrementProp.iterator().next().getType());
            ExpressionCodegen.this.gen(this.forExpression.getLoopRange(), asmLoopRangeType);
            ExpressionCodegen.this.v.dup();
            ExpressionCodegen.this.v.dup();
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getFirst", this.asmElementType, this.loopParameterType, this.loopParameterVar);
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getLast", this.asmElementType, this.asmElementType, this.endVar);
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getStep", this.incrementType, this.incrementType, this.incrementVar);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (loopExit == null) {
                ForInProgressionExpressionLoopGenerator.$$$reportNull$$$0(1);
            }
            this.loopParameter().put(this.asmElementType, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.incrementVar, this.incrementType);
            Label negativeIncrement = new Label();
            Label afterIf = new Label();
            if (this.asmElementType.getSort() == 7) {
                ExpressionCodegen.this.v.lconst(0L);
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifle(negativeIncrement);
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifgt(loopExit);
                ExpressionCodegen.this.v.goTo(afterIf);
                ExpressionCodegen.this.v.mark(negativeIncrement);
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.iflt(loopExit);
                ExpressionCodegen.this.v.mark(afterIf);
            } else {
                ExpressionCodegen.this.v.ifle(negativeIncrement);
                ExpressionCodegen.this.v.ificmpgt(loopExit);
                ExpressionCodegen.this.v.goTo(afterIf);
                ExpressionCodegen.this.v.mark(negativeIncrement);
                ExpressionCodegen.this.v.ificmplt(loopExit);
                ExpressionCodegen.this.v.mark(afterIf);
            }
        }

        @Override
        protected void assignToLoopParameter() {
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (loopExit == null) {
                ForInProgressionExpressionLoopGenerator.$$$reportNull$$$0(2);
            }
            this.checkPostCondition(loopExit);
            StackValue loopParameter = this.loopParameter();
            loopParameter.put(this.asmElementType, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.load(this.incrementVar, this.asmElementType);
            ExpressionCodegen.this.v.add(this.asmElementType);
            if (this.asmElementType == Type.BYTE_TYPE || this.asmElementType == Type.SHORT_TYPE || this.asmElementType == Type.CHAR_TYPE) {
                StackValue.coerce(Type.INT_TYPE, this.asmElementType, ExpressionCodegen.this.v);
            }
            loopParameter.store(StackValue.onStack(this.asmElementType), ExpressionCodegen.this.v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopExit";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInProgressionExpressionLoopGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkEmptyLoop";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "increment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ForInCharSequenceIndicesRangeLoopGenerator
    extends ForInOptimizedIndicesLoopGenerator {
        private ForInCharSequenceIndicesRangeLoopGenerator(@NotNull KtForExpression forExpression, @NotNull ResolvedCall<?> loopRangeCall) {
            if (forExpression == null) {
                ForInCharSequenceIndicesRangeLoopGenerator.$$$reportNull$$$0(0);
            }
            if (loopRangeCall == null) {
                ForInCharSequenceIndicesRangeLoopGenerator.$$$reportNull$$$0(1);
            }
            super(forExpression, loopRangeCall);
        }

        @Override
        protected void getReceiverSizeAsInt() {
            ExpressionCodegen.this.v.invokeinterface("java/lang/CharSequence", "length", "()I");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "forExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loopRangeCall";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInCharSequenceIndicesRangeLoopGenerator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ForInArrayIndicesRangeLoopGenerator
    extends ForInOptimizedIndicesLoopGenerator {
        private ForInArrayIndicesRangeLoopGenerator(@NotNull KtForExpression forExpression, @NotNull ResolvedCall<?> loopRangeCall) {
            if (forExpression == null) {
                ForInArrayIndicesRangeLoopGenerator.$$$reportNull$$$0(0);
            }
            if (loopRangeCall == null) {
                ForInArrayIndicesRangeLoopGenerator.$$$reportNull$$$0(1);
            }
            super(forExpression, loopRangeCall);
        }

        @Override
        protected void getReceiverSizeAsInt() {
            ExpressionCodegen.this.v.arraylength();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "forExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loopRangeCall";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInArrayIndicesRangeLoopGenerator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ForInCollectionIndicesRangeLoopGenerator
    extends ForInOptimizedIndicesLoopGenerator {
        private ForInCollectionIndicesRangeLoopGenerator(@NotNull KtForExpression forExpression, @NotNull ResolvedCall<?> loopRangeCall) {
            if (forExpression == null) {
                ForInCollectionIndicesRangeLoopGenerator.$$$reportNull$$$0(0);
            }
            if (loopRangeCall == null) {
                ForInCollectionIndicesRangeLoopGenerator.$$$reportNull$$$0(1);
            }
            super(forExpression, loopRangeCall);
        }

        @Override
        protected void getReceiverSizeAsInt() {
            ExpressionCodegen.this.v.invokeinterface("java/util/Collection", "size", "()I");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "forExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loopRangeCall";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInCollectionIndicesRangeLoopGenerator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class ForInOptimizedIndicesLoopGenerator
    extends AbstractForInRangeLoopGenerator {
        protected final ReceiverValue receiverValue;
        protected final KotlinType expectedReceiverType;

        private ForInOptimizedIndicesLoopGenerator(@NotNull KtForExpression forExpression, @NotNull ResolvedCall<?> loopRangeCall) {
            if (forExpression == null) {
                ForInOptimizedIndicesLoopGenerator.$$$reportNull$$$0(0);
            }
            if (loopRangeCall == null) {
                ForInOptimizedIndicesLoopGenerator.$$$reportNull$$$0(1);
            }
            super(ExpressionCodegen.this, forExpression);
            this.receiverValue = loopRangeCall.getExtensionReceiver();
            this.expectedReceiverType = ExpressionCodegen.getExpectedReceiverType(loopRangeCall);
        }

        @Override
        protected void storeRangeStartAndEnd() {
            this.loopParameter().store(StackValue.constant(0, this.asmElementType), ExpressionCodegen.this.v);
            StackValue receiver = ExpressionCodegen.this.generateReceiverValue(this.receiverValue, false);
            Type receiverType = ExpressionCodegen.this.asmType(this.expectedReceiverType);
            receiver.put(receiverType, ExpressionCodegen.this.v);
            this.getReceiverSizeAsInt();
            ExpressionCodegen.this.v.iconst(1);
            ExpressionCodegen.this.v.sub(Type.INT_TYPE);
            StackValue.local(this.endVar, this.asmElementType).store(StackValue.onStack(Type.INT_TYPE), ExpressionCodegen.this.v);
        }

        protected abstract void getReceiverSizeAsInt();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "forExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loopRangeCall";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInOptimizedIndicesLoopGenerator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ForInRangeInstanceLoopGenerator
    extends AbstractForInRangeLoopGenerator {
        private ForInRangeInstanceLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                ForInRangeInstanceLoopGenerator.$$$reportNull$$$0(0);
            }
            super(ExpressionCodegen.this, forExpression);
        }

        @Override
        protected void storeRangeStartAndEnd() {
            KotlinType loopRangeType = ExpressionCodegen.this.bindingContext.getType(this.forExpression.getLoopRange());
            assert (loopRangeType != null);
            Type asmLoopRangeType = ExpressionCodegen.this.asmType(loopRangeType);
            ExpressionCodegen.this.gen(this.forExpression.getLoopRange(), asmLoopRangeType);
            ExpressionCodegen.this.v.dup();
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getFirst", this.asmElementType, this.loopParameterType, this.loopParameterVar);
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getLast", this.asmElementType, this.asmElementType, this.endVar);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInRangeInstanceLoopGenerator", "<init>"));
        }
    }

    private class ForInDownToProgressionLoopGenerator
    extends AbstractForInRangeLoopGenerator {
        private final ReceiverValue from;
        private final KtExpression to;

        private ForInDownToProgressionLoopGenerator(@NotNull KtForExpression forExpression, @NotNull ResolvedCall<?> loopRangeCall) {
            if (forExpression == null) {
                ForInDownToProgressionLoopGenerator.$$$reportNull$$$0(0);
            }
            if (loopRangeCall == null) {
                ForInDownToProgressionLoopGenerator.$$$reportNull$$$0(1);
            }
            super(ExpressionCodegen.this, forExpression, -1);
            this.from = loopRangeCall.getExtensionReceiver();
            this.to = ExpressionCodegen.getSingleArgumentExpression(loopRangeCall);
        }

        @Override
        protected void storeRangeStartAndEnd() {
            this.loopParameter().store(ExpressionCodegen.this.generateReceiverValue(this.from, false), ExpressionCodegen.this.v);
            StackValue.local(this.endVar, this.asmElementType).store(ExpressionCodegen.this.gen(this.to), ExpressionCodegen.this.v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "forExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loopRangeCall";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInDownToProgressionLoopGenerator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ForInRangeLiteralLoopGenerator
    extends AbstractForInRangeLoopGenerator {
        private final ReceiverValue from;
        private final KtExpression to;

        private ForInRangeLiteralLoopGenerator(@NotNull KtForExpression forExpression, @NotNull ResolvedCall<?> loopRangeCall) {
            if (forExpression == null) {
                ForInRangeLiteralLoopGenerator.$$$reportNull$$$0(0);
            }
            if (loopRangeCall == null) {
                ForInRangeLiteralLoopGenerator.$$$reportNull$$$0(1);
            }
            super(ExpressionCodegen.this, forExpression);
            this.from = loopRangeCall.getDispatchReceiver();
            this.to = ExpressionCodegen.getSingleArgumentExpression(loopRangeCall);
        }

        @Override
        protected void storeRangeStartAndEnd() {
            this.loopParameter().store(ExpressionCodegen.this.generateReceiverValue(this.from, false), ExpressionCodegen.this.v);
            StackValue.local(this.endVar, this.asmElementType).store(ExpressionCodegen.this.gen(this.to), ExpressionCodegen.this.v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "forExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "loopRangeCall";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInRangeLiteralLoopGenerator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class AbstractForInRangeLoopGenerator
    extends AbstractForInProgressionOrRangeLoopGenerator {
        private final int step;
        final /* synthetic */ ExpressionCodegen this$0;

        private AbstractForInRangeLoopGenerator(ExpressionCodegen expressionCodegen, @NotNull KtForExpression forExpression, int step) {
            if (forExpression == null) {
                AbstractForInRangeLoopGenerator.$$$reportNull$$$0(0);
            }
            this.this$0 = expressionCodegen;
            super(forExpression);
            this.step = step;
            assert (step == 1 || step == -1) : "'step' should be either 1 or -1: " + step;
        }

        private AbstractForInRangeLoopGenerator(ExpressionCodegen expressionCodegen, @NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                AbstractForInRangeLoopGenerator.$$$reportNull$$$0(1);
            }
            this(expressionCodegen, forExpression, 1);
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.storeRangeStartAndEnd();
        }

        protected abstract void storeRangeStartAndEnd();

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (loopExit == null) {
                AbstractForInRangeLoopGenerator.$$$reportNull$$$0(2);
            }
            this.loopParameter().put(this.asmElementType, this.this$0.v);
            this.this$0.v.load(this.endVar, this.asmElementType);
            if (this.asmElementType.getSort() == 7) {
                this.this$0.v.lcmp();
                if (this.step > 0) {
                    this.this$0.v.ifgt(loopExit);
                } else {
                    this.this$0.v.iflt(loopExit);
                }
            } else if (this.step > 0) {
                this.this$0.v.ificmpgt(loopExit);
            } else {
                this.this$0.v.ificmplt(loopExit);
            }
        }

        @Override
        protected void assignToLoopParameter() {
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (loopExit == null) {
                AbstractForInRangeLoopGenerator.$$$reportNull$$$0(3);
            }
            this.checkPostCondition(loopExit);
            if (this.loopParameterType == Type.INT_TYPE) {
                this.this$0.v.iinc(this.loopParameterVar, this.step);
            } else {
                StackValue loopParameter = this.loopParameter();
                loopParameter.put(this.asmElementType, this.this$0.v);
                AsmUtil.genIncrement(this.asmElementType, this.step, this.this$0.v);
                loopParameter.store(StackValue.onStack(this.asmElementType), this.this$0.v);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forExpression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopExit";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForInRangeLoopGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkEmptyLoop";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "increment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class AbstractForInProgressionOrRangeLoopGenerator
    extends AbstractForLoopGenerator {
        protected int endVar;
        private StackValue loopParameter;

        private AbstractForInProgressionOrRangeLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                AbstractForInProgressionOrRangeLoopGenerator.$$$reportNull$$$0(0);
            }
            super(forExpression);
            switch (this.asmElementType.getSort()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected range element type: " + this.asmElementType);
                }
            }
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.endVar = this.createLoopTempVariable(this.asmElementType);
        }

        protected void checkPostCondition(@NotNull Label loopExit) {
            if (loopExit == null) {
                AbstractForInProgressionOrRangeLoopGenerator.$$$reportNull$$$0(1);
            }
            assert (this.endVar != -1) : "endVar must be allocated, endVar = " + this.endVar;
            this.loopParameter().put(this.asmElementType, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            if (this.asmElementType.getSort() == 7) {
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifeq(loopExit);
            } else {
                ExpressionCodegen.this.v.ificmpeq(loopExit);
            }
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            if (loopExit == null) {
                AbstractForInProgressionOrRangeLoopGenerator.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        protected StackValue loopParameter() {
            if (this.loopParameter == null) {
                this.loopParameter = StackValue.local(this.loopParameterVar, this.loopParameterType);
            }
            StackValue stackValue = this.loopParameter;
            if (stackValue == null) {
                AbstractForInProgressionOrRangeLoopGenerator.$$$reportNull$$$0(3);
            }
            return stackValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopExit";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForInProgressionOrRangeLoopGenerator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForInProgressionOrRangeLoopGenerator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loopParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "checkPostCondition";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "checkPreCondition";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ForInArrayLoopGenerator
    extends AbstractForLoopGenerator {
        private int indexVar;
        private int arrayVar;
        private final KotlinType loopRangeType;

        private ForInArrayLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                ForInArrayLoopGenerator.$$$reportNull$$$0(0);
            }
            super(forExpression);
            this.loopRangeType = ExpressionCodegen.this.bindingContext.getType(forExpression.getLoopRange());
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.indexVar = this.createLoopTempVariable(Type.INT_TYPE);
            KtExpression loopRange = this.forExpression.getLoopRange();
            StackValue value = ExpressionCodegen.this.gen(loopRange);
            Type asmLoopRangeType = ExpressionCodegen.this.asmType(this.loopRangeType);
            if (value instanceof StackValue.Local && value.type.equals(asmLoopRangeType)) {
                this.arrayVar = ((StackValue.Local)value).index;
            } else {
                this.arrayVar = this.createLoopTempVariable(AsmTypes.OBJECT_TYPE);
                value.put(asmLoopRangeType, ExpressionCodegen.this.v);
                ExpressionCodegen.this.v.store(this.arrayVar, AsmTypes.OBJECT_TYPE);
            }
            ExpressionCodegen.this.v.iconst(0);
            ExpressionCodegen.this.v.store(this.indexVar, Type.INT_TYPE);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (loopExit == null) {
                ForInArrayLoopGenerator.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            if (loopExit == null) {
                ForInArrayLoopGenerator.$$$reportNull$$$0(2);
            }
            ExpressionCodegen.this.v.load(this.indexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.load(this.arrayVar, AsmTypes.OBJECT_TYPE);
            ExpressionCodegen.this.v.arraylength();
            ExpressionCodegen.this.v.ificmpge(loopExit);
        }

        @Override
        protected void assignToLoopParameter() {
            Type arrayElParamType = KotlinBuiltIns.isArray(this.loopRangeType) ? AsmUtil.boxType(this.asmElementType) : this.asmElementType;
            ExpressionCodegen.this.v.load(this.arrayVar, AsmTypes.OBJECT_TYPE);
            ExpressionCodegen.this.v.load(this.indexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.aload(arrayElParamType);
            StackValue.onStack(arrayElParamType).put(this.asmElementType, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.store(this.loopParameterVar, this.asmElementType);
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (loopExit == null) {
                ForInArrayLoopGenerator.$$$reportNull$$$0(3);
            }
            ExpressionCodegen.this.v.iinc(this.indexVar, 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forExpression";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopExit";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$ForInArrayLoopGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkEmptyLoop";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPreCondition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "increment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class IteratorForLoopGenerator
    extends AbstractForLoopGenerator {
        private int iteratorVarIndex;
        private final ResolvedCall<FunctionDescriptor> iteratorCall;
        private final ResolvedCall<FunctionDescriptor> nextCall;
        private final Type asmTypeForIterator;

        private IteratorForLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                IteratorForLoopGenerator.$$$reportNull$$$0(0);
            }
            super(forExpression);
            KtExpression loopRange = forExpression.getLoopRange();
            assert (loopRange != null);
            this.iteratorCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRange, "No .iterator() function " + DiagnosticUtils.atLocation(loopRange));
            KotlinType iteratorType = this.iteratorCall.getResultingDescriptor().getReturnType();
            assert (iteratorType != null);
            this.asmTypeForIterator = ExpressionCodegen.this.asmType(iteratorType);
            this.nextCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, loopRange, "No next() function " + DiagnosticUtils.atLocation(loopRange));
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.iteratorVarIndex = this.createLoopTempVariable(this.asmTypeForIterator);
            StackValue.local(this.iteratorVarIndex, this.asmTypeForIterator).store(ExpressionCodegen.this.invokeFunction(this.iteratorCall, StackValue.none()), ExpressionCodegen.this.v);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (loopExit == null) {
                IteratorForLoopGenerator.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            if (loopExit == null) {
                IteratorForLoopGenerator.$$$reportNull$$$0(2);
            }
            KtExpression loopRange = this.forExpression.getLoopRange();
            ResolvedCall<FunctionDescriptor> hasNextCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, loopRange, "No hasNext() function " + DiagnosticUtils.atLocation(loopRange));
            Call fakeCall = ExpressionCodegen.this.makeFakeCall(new TransientReceiver(this.iteratorCall.getResultingDescriptor().getReturnType()));
            StackValue result2 = ExpressionCodegen.this.invokeFunction(fakeCall, hasNextCall, StackValue.local(this.iteratorVarIndex, this.asmTypeForIterator));
            result2.put(Type.BOOLEAN_TYPE, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.ifeq(loopExit);
        }

        @Override
        protected void assignToLoopParameter() {
            Call fakeCall = ExpressionCodegen.this.makeFakeCall(new TransientReceiver(this.iteratorCall.getResultingDescriptor().getReturnType()));
            StackValue value = ExpressionCodegen.this.invokeFunction(fakeCall, this.nextCall, StackValue.local(this.iteratorVarIndex, this.asmTypeForIterator));
            StackValue.local(this.loopParameterVar, this.loopParameterType).store(value, ExpressionCodegen.this.v);
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (loopExit == null) {
                IteratorForLoopGenerator.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forExpression";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopExit";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$IteratorForLoopGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkEmptyLoop";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPreCondition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "increment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class AbstractForLoopGenerator {
        protected final KtForExpression forExpression;
        private final Label loopParameterStartLabel;
        private final Label bodyEnd;
        private final List<Runnable> leaveVariableTasks;
        protected final KotlinType elementType;
        protected final Type asmElementType;
        protected int loopParameterVar;
        protected Type loopParameterType;

        private AbstractForLoopGenerator(@NotNull KtForExpression forExpression) {
            if (forExpression == null) {
                AbstractForLoopGenerator.$$$reportNull$$$0(0);
            }
            this.loopParameterStartLabel = new Label();
            this.bodyEnd = new Label();
            this.leaveVariableTasks = Lists.newArrayList();
            this.forExpression = forExpression;
            this.elementType = this.getElementType(forExpression);
            this.asmElementType = ExpressionCodegen.this.asmType(this.elementType);
        }

        @NotNull
        private KotlinType getElementType(KtForExpression forExpression) {
            KtExpression loopRange = forExpression.getLoopRange();
            assert (loopRange != null);
            ResolvedCall<FunctionDescriptor> nextCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, loopRange, "No next() function " + DiagnosticUtils.atLocation(loopRange));
            KotlinType kotlinType = nextCall.getResultingDescriptor().getReturnType();
            if (kotlinType == null) {
                AbstractForLoopGenerator.$$$reportNull$$$0(1);
            }
            return kotlinType;
        }

        public void beforeLoop() {
            KtParameter loopParameter = this.forExpression.getLoopParameter();
            if (loopParameter == null) {
                return;
            }
            KtDestructuringDeclaration multiParameter = loopParameter.getDestructuringDeclaration();
            if (multiParameter != null) {
                this.loopParameterType = this.asmElementType;
                this.loopParameterVar = this.createLoopTempVariable(this.asmElementType);
            } else {
                final VariableDescriptor parameterDescriptor = ExpressionCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER, loopParameter);
                this.loopParameterType = ExpressionCodegen.this.asmType(parameterDescriptor.getType());
                this.loopParameterVar = ExpressionCodegen.this.myFrameMap.enter(parameterDescriptor, this.loopParameterType);
                this.scheduleLeaveVariable(new Runnable(){

                    @Override
                    public void run() {
                        ExpressionCodegen.this.myFrameMap.leave(parameterDescriptor);
                        ExpressionCodegen.this.v.visitLocalVariable(parameterDescriptor.getName().asString(), AbstractForLoopGenerator.this.loopParameterType.getDescriptor(), null, AbstractForLoopGenerator.this.loopParameterStartLabel, AbstractForLoopGenerator.this.bodyEnd, AbstractForLoopGenerator.this.loopParameterVar);
                    }
                });
            }
        }

        public abstract void checkEmptyLoop(@NotNull Label var1);

        public abstract void checkPreCondition(@NotNull Label var1);

        public void beforeBody() {
            this.assignToLoopParameter();
            ExpressionCodegen.this.v.mark(this.loopParameterStartLabel);
            KtDestructuringDeclaration destructuringDeclaration = this.forExpression.getDestructuringDeclaration();
            if (destructuringDeclaration != null) {
                this.generateDestructuringDeclaration(destructuringDeclaration);
            }
        }

        private void generateDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
            if (destructuringDeclaration == null) {
                AbstractForLoopGenerator.$$$reportNull$$$0(2);
            }
            final Label destructuringStartLabel = new Label();
            List<VariableDescriptor> componentDescriptors = CollectionsKt.map(destructuringDeclaration.getEntries(), new Function1<KtDestructuringDeclarationEntry, VariableDescriptor>(){

                @Override
                public VariableDescriptor invoke(KtDestructuringDeclarationEntry entry) {
                    return ExpressionCodegen.this.getVariableDescriptorNotNull(entry);
                }
            });
            for (final VariableDescriptor componentDescriptor : CodegenUtilKt.filterOutDescriptorsWithSpecialNames(componentDescriptors)) {
                final Type componentAsmType = ExpressionCodegen.this.asmType(componentDescriptor.getReturnType());
                final int componentVarIndex = ExpressionCodegen.this.myFrameMap.enter(componentDescriptor, componentAsmType);
                this.scheduleLeaveVariable(new Runnable(){

                    @Override
                    public void run() {
                        ExpressionCodegen.this.myFrameMap.leave(componentDescriptor);
                        ExpressionCodegen.this.v.visitLocalVariable(componentDescriptor.getName().asString(), componentAsmType.getDescriptor(), null, destructuringStartLabel, AbstractForLoopGenerator.this.bodyEnd, componentVarIndex);
                    }
                });
            }
            ExpressionCodegen.this.v.visitLabel(destructuringStartLabel);
            ExpressionCodegen.this.initializeDestructuringDeclarationVariables(destructuringDeclaration, new TransientReceiver(this.elementType), StackValue.local(this.loopParameterVar, this.asmElementType));
        }

        protected abstract void assignToLoopParameter();

        protected abstract void increment(@NotNull Label var1);

        public void body() {
            ExpressionCodegen.this.generateLoopBody(this.forExpression.getBody());
        }

        private void scheduleLeaveVariable(Runnable runnable) {
            this.leaveVariableTasks.add(runnable);
        }

        protected int createLoopTempVariable(final Type type2) {
            int varIndex = ExpressionCodegen.this.myFrameMap.enterTemp(type2);
            this.scheduleLeaveVariable(new Runnable(){

                @Override
                public void run() {
                    ExpressionCodegen.this.myFrameMap.leaveTemp(type2);
                }
            });
            return varIndex;
        }

        public void afterBody(@NotNull Label loopExit) {
            if (loopExit == null) {
                AbstractForLoopGenerator.$$$reportNull$$$0(3);
            }
            ExpressionCodegen.this.markStartLineNumber(this.forExpression);
            this.increment(loopExit);
            ExpressionCodegen.this.v.mark(this.bodyEnd);
        }

        public void afterLoop() {
            for (Runnable task : Lists.reverse(this.leaveVariableTasks)) {
                task.run();
            }
        }

        protected void generateRangeOrProgressionProperty(@NotNull Type loopRangeType, @NotNull String getterName, @NotNull Type getterReturnType, @NotNull Type varType, int varToStore) {
            if (loopRangeType == null) {
                AbstractForLoopGenerator.$$$reportNull$$$0(4);
            }
            if (getterName == null) {
                AbstractForLoopGenerator.$$$reportNull$$$0(5);
            }
            if (getterReturnType == null) {
                AbstractForLoopGenerator.$$$reportNull$$$0(6);
            }
            if (varType == null) {
                AbstractForLoopGenerator.$$$reportNull$$$0(7);
            }
            ExpressionCodegen.this.v.invokevirtual(loopRangeType.getInternalName(), getterName, "()" + getterReturnType.getDescriptor(), false);
            StackValue.local(varToStore, varType).store(StackValue.onStack(getterReturnType), ExpressionCodegen.this.v);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForLoopGenerator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destructuringDeclaration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopExit";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopRangeType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getterName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getterReturnType";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$AbstractForLoopGenerator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "generateDestructuringDeclaration";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "afterBody";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "generateRangeOrProgressionProperty";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ObjectLiteralResult {
        private final boolean wereReifiedMarkers;
        private final ClassDescriptor classDescriptor;

        public ObjectLiteralResult(boolean wereReifiedMarkers, @NotNull ClassDescriptor classDescriptor) {
            if (classDescriptor == null) {
                ObjectLiteralResult.$$$reportNull$$$0(0);
            }
            this.wereReifiedMarkers = wereReifiedMarkers;
            this.classDescriptor = classDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ObjectLiteralResult", "<init>"));
        }
    }

    static class FinallyBlockStackElement
    extends BlockStackElement {
        List<Label> gaps = new ArrayList<Label>();
        final KtTryExpression expression;

        FinallyBlockStackElement(KtTryExpression expression) {
            this.expression = expression;
        }

        private void addGapLabel(Label label) {
            this.gaps.add(label);
        }
    }

    static class LoopBlockStackElement
    extends BlockStackElement {
        final Label continueLabel;
        final Label breakLabel;
        public final KtSimpleNameExpression targetLabel;

        LoopBlockStackElement(Label breakLabel, Label continueLabel, KtSimpleNameExpression targetLabel) {
            this.breakLabel = breakLabel;
            this.continueLabel = continueLabel;
            this.targetLabel = targetLabel;
        }
    }

    static class BlockStackElement {
        BlockStackElement() {
        }
    }
}

