/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InlinePlatformCompatibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "doCheck", "", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "kotlin-compiler"})
public final class InlinePlatformCompatibilityChecker
implements CallChecker {
    private final boolean doCheck;
    @NotNull
    private final JvmTarget jvmTarget;
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        CallableMemberDescriptor propertyOrFun;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!this.doCheck) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        if (!(obj instanceof CallableMemberDescriptor)) {
            obj = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)obj;
        if (callableMemberDescriptor == null) {
            return;
        }
        CallableMemberDescriptor resultingDescriptor = callableMemberDescriptor;
        if (!(InlineUtil.isInline(resultingDescriptor) || resultingDescriptor instanceof PropertyDescriptor && InlineUtil.isInline(((PropertyDescriptor)resultingDescriptor).getGetter()))) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor2 = propertyOrFun = DescriptorUtils.getDirectMember(resultingDescriptor);
        Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor2, "propertyOrFun");
        Integer n = Companion.getBytecodeVersionIfDeserializedDescriptor(callableMemberDescriptor2);
        if (n == null) {
            return;
        }
        int inliningBytecodeVersion = n;
        int compilingBytecodeVersion = this.jvmTarget.getBytecodeVersion();
        if (compilingBytecodeVersion < inliningBytecodeVersion) {
            context.getTrace().report(ErrorsJvm.INLINE_FROM_HIGHER_PLATFORM.on(reportOn, JvmTarget.Companion.getDescription(inliningBytecodeVersion), JvmTarget.Companion.getDescription(compilingBytecodeVersion)));
        }
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public InlinePlatformCompatibilityChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkParameterIsNotNull(jvmTarget, "jvmTarget");
        this.jvmTarget = jvmTarget;
        this.doCheck = Companion.doCheck();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InlinePlatformCompatibilityChecker$Companion;", "", "()V", "doCheck", "", "getBytecodeVersionIfDeserializedDescriptor", "", "funOrProperty", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/lang/Integer;", "kotlin-compiler"})
    public static final class Companion {
        public final boolean doCheck() {
            return Intrinsics.areEqual("true", System.getProperty("kotlin.skip.bytecode.version.check")) ^ true;
        }

        @Nullable
        public final Integer getBytecodeVersionIfDeserializedDescriptor(@NotNull DeclarationDescriptor funOrProperty) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass;
            Intrinsics.checkParameterIsNotNull(funOrProperty, "funOrProperty");
            if (!(funOrProperty instanceof DeserializedCallableMemberDescriptor)) {
                return null;
            }
            DeclarationDescriptor declarationDescriptor = ((DeserializedCallableMemberDescriptor)funOrProperty).getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor");
            }
            ClassOrPackageFragmentDescriptor containingDeclaration = (ClassOrPackageFragmentDescriptor)declarationDescriptor;
            SourceElement source = containingDeclaration.getSource();
            SourceElement sourceElement = source;
            if (!((sourceElement instanceof KotlinJvmBinarySourceElement ? ((KotlinJvmBinarySourceElement)source).getBinaryClass() : (kotlinJvmBinaryClass = sourceElement instanceof KotlinJvmBinaryPackageSourceElement ? ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedCallableMemberDescriptor)funOrProperty) : null)) instanceof FileBasedKotlinClass)) {
                kotlinJvmBinaryClass = null;
            }
            FileBasedKotlinClass fileBasedKotlinClass = (FileBasedKotlinClass)kotlinJvmBinaryClass;
            if (fileBasedKotlinClass == null) {
                return null;
            }
            FileBasedKotlinClass binaryClass = fileBasedKotlinClass;
            return binaryClass.getClassVersion();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

