/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.BorderDecorator;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.ActionTool;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.util.Vector;

public class BorderTool
extends ActionTool {
    public BorderTool(DrawingEditor editor) {
        super(editor);
    }

    public void action(Figure figure) {
        this.setUndoActivity(this.createUndoActivity());
        Vector<Figure> v = new Vector<Figure>();
        v.addElement(figure);
        v.addElement(new BorderDecorator(figure));
        this.getUndoActivity().setAffectedFigures(new FigureEnumerator(v));
        ((UndoActivity)this.getUndoActivity()).replaceAffectedFigures();
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            return this.replaceAffectedFigures();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            return this.replaceAffectedFigures();
        }

        public boolean replaceAffectedFigures() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasMoreElements()) {
                return false;
            }
            Figure oldFigure = fe.nextFigure();
            if (!fe.hasMoreElements()) {
                return false;
            }
            Figure replaceFigure = fe.nextFigure();
            replaceFigure = this.getDrawingView().drawing().replace(oldFigure, replaceFigure);
            Vector<Figure> v = new Vector<Figure>();
            v.addElement(replaceFigure);
            v.addElement(oldFigure);
            this.setAffectedFigures(new FigureEnumerator(v));
            return true;
        }
    }
}

