/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.HashSet;
import java.util.Set;

public class HtmlParameter
implements Comparable<HtmlParameter> {
    private String name;
    private String value;
    private Type type;
    private Set<String> flags;

    public HtmlParameter(Type type, String string, String string2) {
        this.name = string;
        this.value = string2;
        this.type = type;
    }

    public HtmlParameter(String string) {
        String[] stringArray = string.split(";");
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException(string);
        }
        int n = stringArray[0].indexOf("=");
        if (n <= 0) {
            throw new IllegalArgumentException(string);
        }
        this.type = Type.cookie;
        this.name = stringArray[0].substring(0, n).trim();
        this.value = stringArray[0].substring(n + 1).trim();
        if (stringArray.length > 1) {
            for (int i = 1; i < stringArray.length; ++i) {
                this.addFlag(stringArray[i].trim());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Set<String> getFlags() {
        if (this.flags == null) {
            this.flags = new HashSet<String>();
        }
        return this.flags;
    }

    public void addFlag(String string) {
        this.getFlags().add(string);
    }

    @Override
    public int compareTo(HtmlParameter htmlParameter) {
        if (htmlParameter == null) {
            return 1;
        }
        int n = this.type.ordinal() - htmlParameter.getType().ordinal();
        if (n == 0) {
            n = this.name.compareTo(htmlParameter.getName());
        }
        if (n == 0) {
            n = this.value.compareTo(htmlParameter.getValue());
        }
        return n;
    }

    public String toString() {
        return "HtmlParameter type = " + (Object)((Object)this.type) + " name= " + this.name + " value=" + this.value;
    }

    public static enum Flags {
        anticsrf,
        session,
        structural;

    }

    public static enum Type {
        cookie,
        form,
        url,
        header;

    }
}

