/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ClassFilePool;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.INameEnvironmentExtension;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.AnnotatableTypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.ExternalAnnotationSuperimposer;
import org.eclipse.jdt.internal.compiler.lookup.IQualifiedTypeResolutionListener;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier15;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolymorphicMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class LookupEnvironment
implements ProblemReasons,
TypeConstants {
    private Map accessRestrictions;
    ImportBinding[] defaultImports;
    public PackageBinding defaultPackage;
    HashtableOfPackage knownPackages;
    private int lastCompletedUnitIndex = -1;
    private int lastUnitIndex = -1;
    TypeSystem typeSystem;
    public INameEnvironment nameEnvironment;
    public CompilerOptions globalOptions;
    public ProblemReporter problemReporter;
    public ClassFilePool classFilePool;
    private int stepCompleted;
    public ITypeRequestor typeRequestor;
    private SimpleLookupTable uniqueParameterizedGenericMethodBindings;
    private SimpleLookupTable uniquePolymorphicMethodBindings;
    private SimpleLookupTable uniqueGetClassMethodBinding;
    public CompilationUnitDeclaration unitBeingCompleted = null;
    public Object missingClassFileLocation = null;
    private CompilationUnitDeclaration[] units = new CompilationUnitDeclaration[4];
    private MethodVerifier verifier;
    public MethodBinding arrayClone;
    private ArrayList missingTypes;
    Set<SourceTypeBinding> typesBeingConnected;
    public boolean isProcessingAnnotations = false;
    public boolean mayTolerateMissingType = false;
    PackageBinding nullableAnnotationPackage;
    PackageBinding nonnullAnnotationPackage;
    PackageBinding nonnullByDefaultAnnotationPackage;
    AnnotationBinding nonNullAnnotation;
    AnnotationBinding nullableAnnotation;
    Map<String, Integer> allNullAnnotations = null;
    final List<MethodBinding> deferredEnumMethods = new ArrayList<MethodBinding>();
    InferenceContext18 currentInferenceContext;
    static final int BUILD_FIELDS_AND_METHODS = 4;
    static final int BUILD_TYPE_HIERARCHY = 1;
    static final int CHECK_AND_SET_IMPORTS = 2;
    static final int CONNECT_TYPE_HIERARCHY = 3;
    static final ProblemPackageBinding TheNotFoundPackage = new ProblemPackageBinding(CharOperation.NO_CHAR, 1);
    static final ProblemReferenceBinding TheNotFoundType = new ProblemReferenceBinding(CharOperation.NO_CHAR_CHAR, null, 1);
    public IQualifiedTypeResolutionListener[] resolutionListeners = new IQualifiedTypeResolutionListener[0];

    public LookupEnvironment(ITypeRequestor iTypeRequestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, INameEnvironment iNameEnvironment) {
        this.typeRequestor = iTypeRequestor;
        this.globalOptions = compilerOptions;
        this.problemReporter = problemReporter;
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.nameEnvironment = iNameEnvironment;
        this.knownPackages = new HashtableOfPackage();
        this.uniqueParameterizedGenericMethodBindings = new SimpleLookupTable(3);
        this.uniquePolymorphicMethodBindings = new SimpleLookupTable(3);
        this.missingTypes = null;
        this.accessRestrictions = new HashMap(3);
        this.classFilePool = ClassFilePool.newInstance();
        this.typesBeingConnected = new HashSet<SourceTypeBinding>();
        this.typeSystem = this.globalOptions.sourceLevel >= 0x340000L && this.globalOptions.storeAnnotations ? new AnnotatableTypeSystem(this) : new TypeSystem(this);
    }

    public ReferenceBinding askForType(char[][] cArray) {
        NameEnvironmentAnswer nameEnvironmentAnswer = this.nameEnvironment.findType(cArray);
        if (nameEnvironmentAnswer == null) {
            return null;
        }
        if (nameEnvironmentAnswer.isBinaryType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getBinaryType(), this.computePackageFrom(cArray, false), nameEnvironmentAnswer.getAccessRestriction());
        } else if (nameEnvironmentAnswer.isCompilationUnit()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getCompilationUnit(), nameEnvironmentAnswer.getAccessRestriction());
        } else if (nameEnvironmentAnswer.isSourceType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getSourceTypes(), this.computePackageFrom(cArray, false), nameEnvironmentAnswer.getAccessRestriction());
        }
        return this.getCachedType(cArray);
    }

    ReferenceBinding askForType(PackageBinding packageBinding, char[] cArray) {
        NameEnvironmentAnswer nameEnvironmentAnswer;
        if (packageBinding == null) {
            packageBinding = this.defaultPackage;
        }
        if ((nameEnvironmentAnswer = this.nameEnvironment.findType(cArray, packageBinding.compoundName)) == null) {
            return null;
        }
        if (nameEnvironmentAnswer.isBinaryType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getBinaryType(), packageBinding, nameEnvironmentAnswer.getAccessRestriction());
        } else if (nameEnvironmentAnswer.isCompilationUnit()) {
            try {
                this.typeRequestor.accept(nameEnvironmentAnswer.getCompilationUnit(), nameEnvironmentAnswer.getAccessRestriction());
            }
            catch (AbortCompilation abortCompilation) {
                if (CharOperation.equals(cArray, TypeConstants.PACKAGE_INFO_NAME)) {
                    return null;
                }
                throw abortCompilation;
            }
        } else if (nameEnvironmentAnswer.isSourceType()) {
            this.typeRequestor.accept(nameEnvironmentAnswer.getSourceTypes(), packageBinding, nameEnvironmentAnswer.getAccessRestriction());
            ReferenceBinding referenceBinding = packageBinding.getType0(cArray);
            String string = nameEnvironmentAnswer.getExternalAnnotationPath();
            if (string != null && this.globalOptions.isAnnotationBasedNullAnalysisEnabled && referenceBinding instanceof SourceTypeBinding) {
                ExternalAnnotationSuperimposer.apply((SourceTypeBinding)referenceBinding, string);
            }
            return referenceBinding;
        }
        return packageBinding.getType0(cArray);
    }

    public void buildTypeBindings(CompilationUnitDeclaration compilationUnitDeclaration, AccessRestriction accessRestriction) {
        CompilationUnitScope compilationUnitScope = new CompilationUnitScope(compilationUnitDeclaration, this);
        compilationUnitScope.buildTypeBindings(accessRestriction);
        int n = this.units.length;
        if (++this.lastUnitIndex >= n) {
            this.units = new CompilationUnitDeclaration[2 * n];
            System.arraycopy(this.units, 0, this.units, 0, n);
        }
        this.units[this.lastUnitIndex] = compilationUnitDeclaration;
    }

    public BinaryTypeBinding cacheBinaryType(IBinaryType iBinaryType, AccessRestriction accessRestriction) {
        return this.cacheBinaryType(iBinaryType, true, accessRestriction);
    }

    public BinaryTypeBinding cacheBinaryType(IBinaryType iBinaryType, boolean bl, AccessRestriction accessRestriction) {
        char[][] cArray = CharOperation.splitOn('/', iBinaryType.getName());
        ReferenceBinding referenceBinding = this.getCachedType(cArray);
        if (referenceBinding == null || referenceBinding instanceof UnresolvedReferenceBinding) {
            return this.createBinaryTypeFrom(iBinaryType, this.computePackageFrom(cArray, false), bl, accessRestriction);
        }
        return null;
    }

    public void completeTypeBindings() {
        int n;
        this.stepCompleted = 1;
        for (n = this.lastCompletedUnitIndex + 1; n <= this.lastUnitIndex; ++n) {
            this.unitBeingCompleted = this.units[n];
            this.unitBeingCompleted.scope.checkAndSetImports();
        }
        this.stepCompleted = 2;
        for (n = this.lastCompletedUnitIndex + 1; n <= this.lastUnitIndex; ++n) {
            this.unitBeingCompleted = this.units[n];
            this.unitBeingCompleted.scope.connectTypeHierarchy();
        }
        this.stepCompleted = 3;
        for (n = this.lastCompletedUnitIndex + 1; n <= this.lastUnitIndex; ++n) {
            this.unitBeingCompleted = this.units[n];
            CompilationUnitScope compilationUnitScope = this.unitBeingCompleted.scope;
            compilationUnitScope.checkParameterizedTypes();
            compilationUnitScope.buildFieldsAndMethods();
            this.units[n] = null;
        }
        this.stepCompleted = 4;
        this.lastCompletedUnitIndex = this.lastUnitIndex;
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.stepCompleted == 4) {
            this.completeTypeBindings();
        } else {
            if (compilationUnitDeclaration.scope == null) {
                return;
            }
            if (this.stepCompleted >= 2) {
                this.unitBeingCompleted = compilationUnitDeclaration;
                this.unitBeingCompleted.scope.checkAndSetImports();
            }
            if (this.stepCompleted >= 3) {
                this.unitBeingCompleted = compilationUnitDeclaration;
                this.unitBeingCompleted.scope.connectTypeHierarchy();
            }
            this.unitBeingCompleted = null;
        }
    }

    public void completeTypeBindings(CompilationUnitDeclaration compilationUnitDeclaration, boolean bl) {
        if (compilationUnitDeclaration.scope == null) {
            return;
        }
        this.unitBeingCompleted = compilationUnitDeclaration;
        this.unitBeingCompleted.scope.checkAndSetImports();
        compilationUnitDeclaration.scope.connectTypeHierarchy();
        compilationUnitDeclaration.scope.checkParameterizedTypes();
        if (bl) {
            compilationUnitDeclaration.scope.buildFieldsAndMethods();
        }
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(CompilationUnitDeclaration[] compilationUnitDeclarationArray, boolean[] blArray, int n) {
        CompilationUnitDeclaration compilationUnitDeclaration;
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            compilationUnitDeclaration = compilationUnitDeclarationArray[n2];
            if (compilationUnitDeclaration.scope == null) continue;
            this.unitBeingCompleted = compilationUnitDeclaration;
            this.unitBeingCompleted.scope.checkAndSetImports();
        }
        for (n2 = 0; n2 < n; ++n2) {
            compilationUnitDeclaration = compilationUnitDeclarationArray[n2];
            if (compilationUnitDeclaration.scope == null) continue;
            this.unitBeingCompleted = compilationUnitDeclaration;
            this.unitBeingCompleted.scope.connectTypeHierarchy();
        }
        for (n2 = 0; n2 < n; ++n2) {
            compilationUnitDeclaration = compilationUnitDeclarationArray[n2];
            if (compilationUnitDeclaration.scope == null) continue;
            this.unitBeingCompleted = compilationUnitDeclaration;
            this.unitBeingCompleted.scope.checkParameterizedTypes();
            if (!blArray[n2]) continue;
            compilationUnitDeclaration.scope.buildFieldsAndMethods();
        }
        this.unitBeingCompleted = null;
    }

    public MethodBinding computeArrayClone(MethodBinding methodBinding) {
        if (this.arrayClone == null) {
            this.arrayClone = new MethodBinding(methodBinding.modifiers & 0xFFFFFFFB | 1, TypeConstants.CLONE, methodBinding.returnType, Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, (ReferenceBinding)methodBinding.returnType);
        }
        return this.arrayClone;
    }

    public TypeBinding computeBoxingType(TypeBinding typeBinding) {
        switch (typeBinding.id) {
            case 33: {
                return TypeBinding.BOOLEAN;
            }
            case 26: {
                return TypeBinding.BYTE;
            }
            case 28: {
                return TypeBinding.CHAR;
            }
            case 27: {
                return TypeBinding.SHORT;
            }
            case 32: {
                return TypeBinding.DOUBLE;
            }
            case 31: {
                return TypeBinding.FLOAT;
            }
            case 29: {
                return TypeBinding.INT;
            }
            case 30: {
                return TypeBinding.LONG;
            }
            case 10: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_INTEGER);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_INTEGER, null, 1);
            }
            case 3: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_BYTE);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_BYTE, null, 1);
            }
            case 4: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_SHORT);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_SHORT, null, 1);
            }
            case 2: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_CHARACTER);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_CHARACTER, null, 1);
            }
            case 7: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_LONG);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_LONG, null, 1);
            }
            case 9: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_FLOAT);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_FLOAT, null, 1);
            }
            case 8: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_DOUBLE);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_DOUBLE, null, 1);
            }
            case 5: {
                ReferenceBinding referenceBinding = this.getType(JAVA_LANG_BOOLEAN);
                if (referenceBinding != null) {
                    return referenceBinding;
                }
                return new ProblemReferenceBinding(JAVA_LANG_BOOLEAN, null, 1);
            }
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 4100: 
            case 8196: {
                switch (typeBinding.erasure().id) {
                    case 33: {
                        return TypeBinding.BOOLEAN;
                    }
                    case 26: {
                        return TypeBinding.BYTE;
                    }
                    case 28: {
                        return TypeBinding.CHAR;
                    }
                    case 27: {
                        return TypeBinding.SHORT;
                    }
                    case 32: {
                        return TypeBinding.DOUBLE;
                    }
                    case 31: {
                        return TypeBinding.FLOAT;
                    }
                    case 29: {
                        return TypeBinding.INT;
                    }
                    case 30: {
                        return TypeBinding.LONG;
                    }
                }
                break;
            }
            case 65540: {
                return ((PolyTypeBinding)typeBinding).computeBoxingType();
            }
            case 32772: {
                return this.computeBoxingType(typeBinding.getIntersectingTypes()[0]);
            }
        }
        return typeBinding;
    }

    private PackageBinding computePackageFrom(char[][] cArray, boolean bl) {
        if (cArray.length == 1) {
            return this.defaultPackage;
        }
        PackageBinding packageBinding = this.getPackage0(cArray[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            packageBinding = new PackageBinding(cArray[0], this);
            if (bl) {
                packageBinding.tagBits |= 0x80L;
            }
            this.knownPackages.put(cArray[0], packageBinding);
        }
        int n = cArray.length - 1;
        for (int i = 1; i < n; ++i) {
            PackageBinding packageBinding2 = packageBinding;
            if ((packageBinding = packageBinding2.getPackage0(cArray[i])) != null && packageBinding != TheNotFoundPackage) continue;
            packageBinding = new PackageBinding(CharOperation.subarray(cArray, 0, i + 1), packageBinding2, this);
            if (bl) {
                packageBinding.tagBits |= 0x80L;
            }
            packageBinding2.addPackage(packageBinding);
        }
        return packageBinding;
    }

    public ReferenceBinding convertToParameterizedType(ReferenceBinding referenceBinding) {
        if (referenceBinding != null) {
            ReferenceBinding referenceBinding2;
            boolean bl = referenceBinding.isGenericType();
            ReferenceBinding referenceBinding3 = referenceBinding2 = referenceBinding.enclosingType();
            boolean bl2 = bl;
            if (referenceBinding2 != null) {
                referenceBinding3 = referenceBinding.isStatic() ? (ReferenceBinding)this.convertToRawType(referenceBinding2, false) : this.convertToParameterizedType(referenceBinding2);
                bl2 |= TypeBinding.notEquals(referenceBinding2, referenceBinding3);
            }
            if (bl2) {
                return this.createParameterizedType(referenceBinding, bl ? referenceBinding.typeVariables() : null, referenceBinding3);
            }
        }
        return referenceBinding;
    }

    public TypeBinding convertToRawType(TypeBinding typeBinding, boolean bl) {
        TypeBinding typeBinding2;
        ReferenceBinding referenceBinding;
        boolean bl2;
        TypeBinding typeBinding3;
        int n;
        switch (typeBinding.kind()) {
            case 132: 
            case 516: 
            case 1028: 
            case 4100: 
            case 8196: {
                return typeBinding;
            }
            case 68: {
                n = typeBinding.dimensions();
                typeBinding3 = typeBinding.leafComponentType();
                break;
            }
            default: {
                if (typeBinding.id == 1) {
                    return typeBinding;
                }
                n = 0;
                typeBinding3 = typeBinding;
            }
        }
        switch (typeBinding3.kind()) {
            case 132: {
                return typeBinding;
            }
            case 2052: {
                bl2 = true;
                break;
            }
            case 260: {
                referenceBinding = (ParameterizedTypeBinding)typeBinding3;
                bl2 = ((ParameterizedTypeBinding)referenceBinding).genericType().isGenericType();
                break;
            }
            default: {
                bl2 = false;
            }
        }
        referenceBinding = typeBinding3.enclosingType();
        if (referenceBinding == null) {
            typeBinding2 = bl2 ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), null) : typeBinding3;
        } else {
            ReferenceBinding referenceBinding2;
            if (referenceBinding.kind() == 1028) {
                bl2 |= !((ReferenceBinding)typeBinding3).isStatic();
                referenceBinding2 = referenceBinding;
            } else if (bl && !bl2) {
                referenceBinding2 = (ReferenceBinding)this.convertToRawType(referenceBinding, bl);
                bl2 = TypeBinding.notEquals(referenceBinding, referenceBinding2);
            } else {
                referenceBinding2 = bl2 || ((ReferenceBinding)typeBinding3).isStatic() ? (ReferenceBinding)this.convertToRawType(referenceBinding, false) : this.convertToParameterizedType(referenceBinding);
            }
            typeBinding2 = bl2 ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), referenceBinding2) : (TypeBinding.notEquals(referenceBinding, referenceBinding2) ? this.createParameterizedType((ReferenceBinding)typeBinding3.erasure(), null, referenceBinding2) : typeBinding3);
        }
        if (TypeBinding.notEquals(typeBinding3, typeBinding2)) {
            return n > 0 ? this.createArrayType(typeBinding2, n) : typeBinding2;
        }
        return typeBinding;
    }

    public ReferenceBinding[] convertToRawTypes(ReferenceBinding[] referenceBindingArray, boolean bl, boolean bl2) {
        if (referenceBindingArray == null) {
            return null;
        }
        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
        int n = referenceBindingArray.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding = referenceBindingArray[i];
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.convertToRawType(bl ? referenceBinding.erasure() : referenceBinding, bl2);
            if (TypeBinding.notEquals(referenceBinding2, referenceBinding)) {
                if (referenceBindingArray2 == referenceBindingArray) {
                    referenceBindingArray2 = new ReferenceBinding[n];
                    System.arraycopy(referenceBindingArray, 0, referenceBindingArray2, 0, i);
                }
                referenceBindingArray2[i] = referenceBinding2;
                continue;
            }
            if (referenceBindingArray2 == referenceBindingArray) continue;
            referenceBindingArray2[i] = referenceBinding;
        }
        return referenceBindingArray2;
    }

    public TypeBinding convertUnresolvedBinaryToRawType(TypeBinding typeBinding) {
        TypeBinding typeBinding2;
        ReferenceBinding referenceBinding;
        boolean bl;
        TypeBinding typeBinding3;
        int n;
        switch (typeBinding.kind()) {
            case 132: 
            case 516: 
            case 1028: 
            case 4100: 
            case 8196: {
                return typeBinding;
            }
            case 68: {
                n = typeBinding.dimensions();
                typeBinding3 = typeBinding.leafComponentType();
                break;
            }
            default: {
                if (typeBinding.id == 1) {
                    return typeBinding;
                }
                n = 0;
                typeBinding3 = typeBinding;
            }
        }
        switch (typeBinding3.kind()) {
            case 132: {
                return typeBinding;
            }
            case 2052: {
                bl = true;
                break;
            }
            case 260: {
                referenceBinding = (ParameterizedTypeBinding)typeBinding3;
                bl = referenceBinding.genericType().isGenericType();
                break;
            }
            default: {
                bl = false;
            }
        }
        referenceBinding = typeBinding3.enclosingType();
        if (referenceBinding == null) {
            typeBinding2 = bl ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), null) : typeBinding3;
        } else {
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.convertUnresolvedBinaryToRawType(referenceBinding);
            if (TypeBinding.notEquals(referenceBinding2, referenceBinding)) {
                bl |= !((ReferenceBinding)typeBinding3).isStatic();
            }
            typeBinding2 = bl ? this.createRawType((ReferenceBinding)typeBinding3.erasure(), referenceBinding2) : (TypeBinding.notEquals(referenceBinding, referenceBinding2) ? this.createParameterizedType((ReferenceBinding)typeBinding3.erasure(), null, referenceBinding2) : typeBinding3);
        }
        if (TypeBinding.notEquals(typeBinding3, typeBinding2)) {
            return n > 0 ? this.createArrayType(typeBinding2, n) : typeBinding2;
        }
        return typeBinding;
    }

    public AnnotationBinding createAnnotation(ReferenceBinding referenceBinding, ElementValuePair[] elementValuePairArray) {
        if (elementValuePairArray.length != 0) {
            AnnotationBinding.setMethodBindings(referenceBinding, elementValuePairArray);
            return new AnnotationBinding(referenceBinding, elementValuePairArray);
        }
        return this.typeSystem.getAnnotationType(referenceBinding, true);
    }

    public AnnotationBinding createUnresolvedAnnotation(ReferenceBinding referenceBinding, ElementValuePair[] elementValuePairArray) {
        if (elementValuePairArray.length != 0) {
            return new UnresolvedAnnotationBinding(referenceBinding, elementValuePairArray, this);
        }
        return this.typeSystem.getAnnotationType(referenceBinding, false);
    }

    public ArrayBinding createArrayType(TypeBinding typeBinding, int n) {
        return this.typeSystem.getArrayType(typeBinding, n);
    }

    public ArrayBinding createArrayType(TypeBinding typeBinding, int n, AnnotationBinding[] annotationBindingArray) {
        return this.typeSystem.getArrayType(typeBinding, n, annotationBindingArray);
    }

    public TypeBinding createIntersectionType18(ReferenceBinding[] referenceBindingArray) {
        return this.typeSystem.getIntersectionType18(referenceBindingArray);
    }

    public BinaryTypeBinding createBinaryTypeFrom(IBinaryType iBinaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        return this.createBinaryTypeFrom(iBinaryType, packageBinding, true, accessRestriction);
    }

    public BinaryTypeBinding createBinaryTypeFrom(IBinaryType iBinaryType, PackageBinding packageBinding, boolean bl, AccessRestriction accessRestriction) {
        BinaryTypeBinding binaryTypeBinding = new BinaryTypeBinding(packageBinding, iBinaryType, this);
        ReferenceBinding referenceBinding = packageBinding.getType0(binaryTypeBinding.compoundName[binaryTypeBinding.compoundName.length - 1]);
        if (referenceBinding != null && !referenceBinding.isUnresolvedType()) {
            if (referenceBinding.isBinaryBinding()) {
                return (BinaryTypeBinding)referenceBinding;
            }
            return null;
        }
        packageBinding.addType(binaryTypeBinding);
        this.setAccessRestriction(binaryTypeBinding, accessRestriction);
        binaryTypeBinding.cachePartsFrom(iBinaryType, bl);
        return binaryTypeBinding;
    }

    public MissingTypeBinding createMissingType(PackageBinding packageBinding, char[][] cArray) {
        if (packageBinding == null && (packageBinding = this.computePackageFrom(cArray, true)) == TheNotFoundPackage) {
            packageBinding = this.defaultPackage;
        }
        MissingTypeBinding missingTypeBinding = new MissingTypeBinding(packageBinding, cArray, this);
        if (missingTypeBinding.id != 1) {
            ReferenceBinding referenceBinding = this.getType(TypeConstants.JAVA_LANG_OBJECT);
            if (referenceBinding == null) {
                referenceBinding = this.createMissingType(null, TypeConstants.JAVA_LANG_OBJECT);
            }
            missingTypeBinding.setMissingSuperclass(referenceBinding);
        }
        packageBinding.addType(missingTypeBinding);
        if (this.missingTypes == null) {
            this.missingTypes = new ArrayList(3);
        }
        this.missingTypes.add(missingTypeBinding);
        return missingTypeBinding;
    }

    public PackageBinding createPackage(char[][] cArray) {
        PackageBinding packageBinding = this.getPackage0(cArray[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            packageBinding = new PackageBinding(cArray[0], this);
            this.knownPackages.put(cArray[0], packageBinding);
        }
        int n = cArray.length;
        for (int i = 1; i < n; ++i) {
            ReferenceBinding referenceBinding = packageBinding.getType0(cArray[i]);
            if (referenceBinding != null && referenceBinding != TheNotFoundType && !(referenceBinding instanceof UnresolvedReferenceBinding)) {
                return null;
            }
            PackageBinding packageBinding2 = packageBinding;
            if ((packageBinding = packageBinding2.getPackage0(cArray[i])) != null && packageBinding != TheNotFoundPackage) continue;
            if (this.nameEnvironment instanceof INameEnvironmentExtension ? ((INameEnvironmentExtension)this.nameEnvironment).findType(cArray[i], packageBinding2.compoundName, false) != null : this.nameEnvironment.findType(cArray[i], packageBinding2.compoundName) != null) {
                return null;
            }
            packageBinding = new PackageBinding(CharOperation.subarray(cArray, 0, i + 1), packageBinding2, this);
            packageBinding2.addPackage(packageBinding);
        }
        return packageBinding;
    }

    public ParameterizedGenericMethodBinding createParameterizedGenericMethod(MethodBinding methodBinding, RawTypeBinding rawTypeBinding) {
        int n;
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding2;
        ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray = (ParameterizedGenericMethodBinding[])this.uniqueParameterizedGenericMethodBindings.get(methodBinding);
        boolean bl = false;
        if (parameterizedGenericMethodBindingArray != null) {
            for (ParameterizedGenericMethodBinding parameterizedGenericMethodBinding2 : parameterizedGenericMethodBindingArray) {
                if (parameterizedGenericMethodBinding2 == null) break;
                if (!parameterizedGenericMethodBinding2.isRaw || parameterizedGenericMethodBinding2.declaringClass != (rawTypeBinding == null ? methodBinding.declaringClass : rawTypeBinding)) continue;
                return parameterizedGenericMethodBinding2;
            }
            bl = true;
        } else {
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[5];
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        int n2 = parameterizedGenericMethodBindingArray.length;
        if (bl && n == n2) {
            ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray2 = parameterizedGenericMethodBindingArray;
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[n2 * 2];
            System.arraycopy(parameterizedGenericMethodBindingArray2, 0, parameterizedGenericMethodBindingArray, 0, n2);
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        parameterizedGenericMethodBindingArray[n] = parameterizedGenericMethodBinding2 = new ParameterizedGenericMethodBinding(methodBinding, rawTypeBinding, this);
        return parameterizedGenericMethodBinding2;
    }

    public ParameterizedGenericMethodBinding createParameterizedGenericMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray) {
        return this.createParameterizedGenericMethod(methodBinding, typeBindingArray, false, false);
    }

    public ParameterizedGenericMethodBinding createParameterizedGenericMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray, boolean bl, boolean bl2) {
        int n;
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding2;
        ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray = (ParameterizedGenericMethodBinding[])this.uniqueParameterizedGenericMethodBindings.get(methodBinding);
        int n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
        boolean bl3 = false;
        if (parameterizedGenericMethodBindingArray != null) {
            block0: for (ParameterizedGenericMethodBinding parameterizedGenericMethodBinding2 : parameterizedGenericMethodBindingArray) {
                int n3;
                if (parameterizedGenericMethodBinding2 == null) break;
                if (parameterizedGenericMethodBinding2.isRaw || parameterizedGenericMethodBinding2.inferredWithUncheckedConversion != bl) continue;
                TypeBinding[] typeBindingArray2 = parameterizedGenericMethodBinding2.typeArguments;
                int n4 = n3 = typeBindingArray2 == null ? 0 : typeBindingArray2.length;
                if (n2 != n3) continue;
                for (int i = 0; i < n3; ++i) {
                    if (typeBindingArray[i] != typeBindingArray2[i]) continue block0;
                }
                if (bl) {
                    if (parameterizedGenericMethodBinding2.returnType.isParameterizedType() || parameterizedGenericMethodBinding2.returnType.isTypeVariable()) continue;
                    for (ReferenceBinding referenceBinding : parameterizedGenericMethodBinding2.thrownExceptions) {
                        if (referenceBinding.isParameterizedType() || referenceBinding.isTypeVariable()) continue block0;
                    }
                }
                return parameterizedGenericMethodBinding2;
            }
            bl3 = true;
        } else {
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[5];
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        int n5 = parameterizedGenericMethodBindingArray.length;
        if (bl3 && n == n5) {
            ParameterizedGenericMethodBinding[] parameterizedGenericMethodBindingArray2 = parameterizedGenericMethodBindingArray;
            parameterizedGenericMethodBindingArray = new ParameterizedGenericMethodBinding[n5 * 2];
            System.arraycopy(parameterizedGenericMethodBindingArray2, 0, parameterizedGenericMethodBindingArray, 0, n5);
            this.uniqueParameterizedGenericMethodBindings.put(methodBinding, parameterizedGenericMethodBindingArray);
        }
        parameterizedGenericMethodBindingArray[n] = parameterizedGenericMethodBinding2 = new ParameterizedGenericMethodBinding(methodBinding, typeBindingArray, this, bl, bl2);
        return parameterizedGenericMethodBinding2;
    }

    public PolymorphicMethodBinding createPolymorphicMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray) {
        int n;
        PolymorphicMethodBinding polymorphicMethodBinding2;
        int n2;
        String string = new String(methodBinding.selector);
        PolymorphicMethodBinding[] polymorphicMethodBindingArray = (PolymorphicMethodBinding[])this.uniquePolymorphicMethodBindings.get(string);
        int n3 = typeBindingArray == null ? 0 : typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = new TypeBinding[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            TypeBinding typeBinding = typeBindingArray[n2];
            typeBindingArray2[n2] = typeBinding.id == 12 ? this.getType(JAVA_LANG_VOID) : typeBinding.erasure();
        }
        n2 = 0;
        if (polymorphicMethodBindingArray != null) {
            for (PolymorphicMethodBinding polymorphicMethodBinding2 : polymorphicMethodBindingArray) {
                if (polymorphicMethodBinding2 == null) break;
                if (!polymorphicMethodBinding2.matches(typeBindingArray2, methodBinding.returnType)) continue;
                return polymorphicMethodBinding2;
            }
            n2 = 1;
        } else {
            polymorphicMethodBindingArray = new PolymorphicMethodBinding[5];
            this.uniquePolymorphicMethodBindings.put(string, polymorphicMethodBindingArray);
        }
        int n4 = polymorphicMethodBindingArray.length;
        if (n2 != 0 && n == n4) {
            PolymorphicMethodBinding[] polymorphicMethodBindingArray2 = polymorphicMethodBindingArray;
            polymorphicMethodBindingArray = new PolymorphicMethodBinding[n4 * 2];
            System.arraycopy(polymorphicMethodBindingArray2, 0, polymorphicMethodBindingArray, 0, n4);
            this.uniquePolymorphicMethodBindings.put(string, polymorphicMethodBindingArray);
        }
        polymorphicMethodBindingArray[n] = polymorphicMethodBinding2 = new PolymorphicMethodBinding(methodBinding, typeBindingArray2);
        return polymorphicMethodBinding2;
    }

    public boolean usesAnnotatedTypeSystem() {
        return this.typeSystem.isAnnotatedTypeSystem();
    }

    public MethodBinding updatePolymorphicMethodReturnType(PolymorphicMethodBinding polymorphicMethodBinding, TypeBinding typeBinding) {
        int n;
        PolymorphicMethodBinding polymorphicMethodBinding22;
        String string = new String(polymorphicMethodBinding.selector);
        PolymorphicMethodBinding[] polymorphicMethodBindingArray = (PolymorphicMethodBinding[])this.uniquePolymorphicMethodBindings.get(string);
        boolean bl = false;
        TypeBinding[] typeBindingArray = polymorphicMethodBinding.parameters;
        if (polymorphicMethodBindingArray != null) {
            for (PolymorphicMethodBinding polymorphicMethodBinding22 : polymorphicMethodBindingArray) {
                if (polymorphicMethodBinding22 == null) break;
                if (!polymorphicMethodBinding22.matches(typeBindingArray, typeBinding)) continue;
                return polymorphicMethodBinding22;
            }
            bl = true;
        } else {
            polymorphicMethodBindingArray = new PolymorphicMethodBinding[5];
            this.uniquePolymorphicMethodBindings.put(string, polymorphicMethodBindingArray);
        }
        int n2 = polymorphicMethodBindingArray.length;
        if (bl && n == n2) {
            PolymorphicMethodBinding[] polymorphicMethodBindingArray2 = polymorphicMethodBindingArray;
            polymorphicMethodBindingArray = new PolymorphicMethodBinding[n2 * 2];
            System.arraycopy(polymorphicMethodBindingArray2, 0, polymorphicMethodBindingArray, 0, n2);
            this.uniquePolymorphicMethodBindings.put(string, polymorphicMethodBindingArray);
        }
        polymorphicMethodBindingArray[n] = polymorphicMethodBinding22 = new PolymorphicMethodBinding(polymorphicMethodBinding.original(), typeBinding, typeBindingArray);
        return polymorphicMethodBinding22;
    }

    public ParameterizedMethodBinding createGetClassMethod(TypeBinding typeBinding, MethodBinding methodBinding, Scope scope) {
        ParameterizedMethodBinding parameterizedMethodBinding = null;
        if (this.uniqueGetClassMethodBinding == null) {
            this.uniqueGetClassMethodBinding = new SimpleLookupTable(3);
        } else {
            parameterizedMethodBinding = (ParameterizedMethodBinding)this.uniqueGetClassMethodBinding.get(typeBinding);
        }
        if (parameterizedMethodBinding == null) {
            parameterizedMethodBinding = ParameterizedMethodBinding.instantiateGetClass(typeBinding, methodBinding, scope);
            this.uniqueGetClassMethodBinding.put(typeBinding, parameterizedMethodBinding);
        }
        return parameterizedMethodBinding;
    }

    public ReferenceBinding createMemberType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        return this.typeSystem.getMemberType(referenceBinding, referenceBinding2);
    }

    public ParameterizedTypeBinding createParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2) {
        AnnotationBinding[] annotationBindingArray = referenceBinding.typeAnnotations;
        if (annotationBindingArray != Binding.NO_ANNOTATIONS) {
            return this.typeSystem.getParameterizedType((ReferenceBinding)referenceBinding.unannotated(), typeBindingArray, referenceBinding2, annotationBindingArray);
        }
        return this.typeSystem.getParameterizedType(referenceBinding, typeBindingArray, referenceBinding2);
    }

    public ParameterizedTypeBinding createParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        return this.typeSystem.getParameterizedType(referenceBinding, typeBindingArray, referenceBinding2, annotationBindingArray);
    }

    public TypeBinding createAnnotatedType(TypeBinding typeBinding, AnnotationBinding[][] annotationBindingArray) {
        return this.typeSystem.getAnnotatedType(typeBinding, annotationBindingArray);
    }

    public TypeBinding createAnnotatedType(TypeBinding typeBinding, AnnotationBinding[] annotationBindingArray) {
        int n;
        int n2;
        int n3 = n2 = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        if (typeBinding == null || n2 == 0) {
            return typeBinding;
        }
        AnnotationBinding[] annotationBindingArray2 = typeBinding.getTypeAnnotations();
        int n4 = n = annotationBindingArray2 == null ? 0 : annotationBindingArray2.length;
        if (n > 0) {
            AnnotationBinding[] annotationBindingArray3 = annotationBindingArray;
            annotationBindingArray = new AnnotationBinding[n2 + n];
            System.arraycopy(annotationBindingArray3, 0, annotationBindingArray, 0, n2);
            System.arraycopy(annotationBindingArray2, 0, annotationBindingArray, n2, n);
        }
        if (this.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            long l = 0L;
            AnnotationBinding[] annotationBindingArray4 = new AnnotationBinding[annotationBindingArray.length];
            int n5 = 0;
            for (int i = 0; i < annotationBindingArray.length; ++i) {
                if (annotationBindingArray[i] == null) {
                    annotationBindingArray4[n5++] = null;
                    continue;
                }
                long l2 = 0L;
                if (annotationBindingArray[i].type.hasNullBit(32)) {
                    l2 = 0x100000000000000L;
                } else if (annotationBindingArray[i].type.hasNullBit(64)) {
                    l2 = 0x80000000000000L;
                }
                if ((l & l2) != 0L) continue;
                l |= l2;
                annotationBindingArray4[n5++] = annotationBindingArray[i];
            }
            if (n5 < annotationBindingArray.length) {
                annotationBindingArray = new AnnotationBinding[n5];
                System.arraycopy(annotationBindingArray4, 0, annotationBindingArray, 0, n5);
            }
        }
        return this.typeSystem.getAnnotatedType(typeBinding, new AnnotationBinding[][]{annotationBindingArray});
    }

    public RawTypeBinding createRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        AnnotationBinding[] annotationBindingArray = referenceBinding.typeAnnotations;
        if (annotationBindingArray != Binding.NO_ANNOTATIONS) {
            return this.typeSystem.getRawType((ReferenceBinding)referenceBinding.unannotated(), referenceBinding2, annotationBindingArray);
        }
        return this.typeSystem.getRawType(referenceBinding, referenceBinding2);
    }

    public RawTypeBinding createRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        return this.typeSystem.getRawType(referenceBinding, referenceBinding2, annotationBindingArray);
    }

    public WildcardBinding createWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2) {
        AnnotationBinding[] annotationBindingArray;
        if (referenceBinding != null && (annotationBindingArray = referenceBinding.typeAnnotations) != Binding.NO_ANNOTATIONS) {
            return this.typeSystem.getWildcard((ReferenceBinding)referenceBinding.unannotated(), n, typeBinding, typeBindingArray, n2, annotationBindingArray);
        }
        return this.typeSystem.getWildcard(referenceBinding, n, typeBinding, typeBindingArray, n2);
    }

    public CaptureBinding createCapturedWildcard(WildcardBinding wildcardBinding, ReferenceBinding referenceBinding, int n, int n2, ASTNode aSTNode, int n3) {
        return this.typeSystem.getCapturedWildcard(wildcardBinding, referenceBinding, n, n2, aSTNode, n3);
    }

    public WildcardBinding createWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, AnnotationBinding[] annotationBindingArray) {
        return this.typeSystem.getWildcard(referenceBinding, n, typeBinding, typeBindingArray, n2, annotationBindingArray);
    }

    public AccessRestriction getAccessRestriction(TypeBinding typeBinding) {
        return (AccessRestriction)this.accessRestrictions.get(typeBinding);
    }

    public ReferenceBinding getCachedType(char[][] cArray) {
        if (cArray.length == 1) {
            return this.defaultPackage.getType0(cArray[0]);
        }
        PackageBinding packageBinding = this.getPackage0(cArray[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            return null;
        }
        int n = cArray.length - 1;
        for (int i = 1; i < n; ++i) {
            if ((packageBinding = packageBinding.getPackage0(cArray[i])) != null && packageBinding != TheNotFoundPackage) continue;
            return null;
        }
        return packageBinding.getType0(cArray[cArray.length - 1]);
    }

    public AnnotationBinding getNullableAnnotation() {
        if (this.nullableAnnotation != null) {
            return this.nullableAnnotation;
        }
        ReferenceBinding referenceBinding = this.getResolvedType(this.globalOptions.nullableAnnotationName, null);
        this.nullableAnnotation = this.typeSystem.getAnnotationType(referenceBinding, true);
        return this.nullableAnnotation;
    }

    public char[][] getNullableAnnotationName() {
        return this.globalOptions.nullableAnnotationName;
    }

    public AnnotationBinding getNonNullAnnotation() {
        if (this.nonNullAnnotation != null) {
            return this.nonNullAnnotation;
        }
        ReferenceBinding referenceBinding = this.getResolvedType(this.globalOptions.nonNullAnnotationName, null);
        this.nonNullAnnotation = this.typeSystem.getAnnotationType(referenceBinding, true);
        return this.nonNullAnnotation;
    }

    public AnnotationBinding[] nullAnnotationsFromTagBits(long l) {
        if (l == 0x100000000000000L) {
            return new AnnotationBinding[]{this.getNonNullAnnotation()};
        }
        if (l == 0x80000000000000L) {
            return new AnnotationBinding[]{this.getNullableAnnotation()};
        }
        return null;
    }

    public char[][] getNonNullAnnotationName() {
        return this.globalOptions.nonNullAnnotationName;
    }

    public char[][] getNonNullByDefaultAnnotationName() {
        return this.globalOptions.nonNullByDefaultAnnotationName;
    }

    int getNullAnnotationBit(char[][] cArray) {
        Integer n;
        String[] stringArray;
        if (this.allNullAnnotations == null) {
            this.allNullAnnotations = new HashMap<String, Integer>();
            this.allNullAnnotations.put(CharOperation.toString(this.globalOptions.nonNullAnnotationName), 32);
            this.allNullAnnotations.put(CharOperation.toString(this.globalOptions.nullableAnnotationName), 64);
            this.allNullAnnotations.put(CharOperation.toString(this.globalOptions.nonNullByDefaultAnnotationName), 128);
            for (String string : this.globalOptions.nullableAnnotationSecondaryNames) {
                this.allNullAnnotations.put(string, 64);
            }
            for (String string : this.globalOptions.nonNullAnnotationSecondaryNames) {
                this.allNullAnnotations.put(string, 32);
            }
            stringArray = this.globalOptions.nonNullByDefaultAnnotationSecondaryNames;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                String string;
                string = stringArray[i];
                this.allNullAnnotations.put(string, 128);
            }
        }
        return (n = this.allNullAnnotations.get(stringArray = CharOperation.toString(cArray))) == null ? 0 : n;
    }

    public boolean isNullnessAnnotationPackage(PackageBinding packageBinding) {
        return this.nonnullAnnotationPackage == packageBinding || this.nullableAnnotationPackage == packageBinding || this.nonnullByDefaultAnnotationPackage == packageBinding;
    }

    public boolean usesNullTypeAnnotations() {
        if (this.globalOptions.useNullTypeAnnotations != null) {
            return this.globalOptions.useNullTypeAnnotations;
        }
        this.initializeUsesNullTypeAnnotation();
        for (MethodBinding methodBinding : this.deferredEnumMethods) {
            int n = 0;
            if (CharOperation.equals(methodBinding.selector, TypeConstants.VALUEOF)) {
                n = 10;
            } else if (CharOperation.equals(methodBinding.selector, TypeConstants.VALUES)) {
                n = 9;
            }
            if (n == 0) continue;
            SyntheticMethodBinding.markNonNull(methodBinding, n, this);
        }
        this.deferredEnumMethods.clear();
        return this.globalOptions.useNullTypeAnnotations;
    }

    private void initializeUsesNullTypeAnnotation() {
        long l;
        ReferenceBinding referenceBinding;
        this.globalOptions.useNullTypeAnnotations = Boolean.FALSE;
        if (!this.globalOptions.isAnnotationBasedNullAnalysisEnabled || this.globalOptions.originalSourceLevel < 0x340000L) {
            return;
        }
        ReferenceBinding referenceBinding2 = this.nullableAnnotation != null ? this.nullableAnnotation.getAnnotationType() : this.getType(this.getNullableAnnotationName());
        ReferenceBinding referenceBinding3 = referenceBinding = this.nonNullAnnotation != null ? this.nonNullAnnotation.getAnnotationType() : this.getType(this.getNonNullAnnotationName());
        if (referenceBinding2 == null && referenceBinding == null) {
            return;
        }
        if (referenceBinding2 == null || referenceBinding == null) {
            return;
        }
        long l2 = referenceBinding2.getAnnotationTagBits() & 0x20000000000000L;
        if (l2 != (l = referenceBinding.getAnnotationTagBits() & 0x20000000000000L)) {
            return;
        }
        if (l2 == 0L) {
            return;
        }
        this.globalOptions.useNullTypeAnnotations = Boolean.TRUE;
    }

    PackageBinding getPackage0(char[] cArray) {
        return this.knownPackages.get(cArray);
    }

    public ReferenceBinding getResolvedType(char[][] cArray, Scope scope) {
        ReferenceBinding referenceBinding = this.getType(cArray);
        if (referenceBinding != null) {
            return referenceBinding;
        }
        this.problemReporter.isClassPathCorrect(cArray, scope == null ? this.unitBeingCompleted : scope.referenceCompilationUnit(), this.missingClassFileLocation);
        return this.createMissingType(null, cArray);
    }

    PackageBinding getTopLevelPackage(char[] cArray) {
        PackageBinding packageBinding = this.getPackage0(cArray);
        if (packageBinding != null) {
            if (packageBinding == TheNotFoundPackage) {
                return null;
            }
            return packageBinding;
        }
        if (this.nameEnvironment.isPackage(null, cArray)) {
            packageBinding = new PackageBinding(cArray, this);
            this.knownPackages.put(cArray, packageBinding);
            return packageBinding;
        }
        this.knownPackages.put(cArray, TheNotFoundPackage);
        return null;
    }

    public ReferenceBinding getType(char[][] cArray) {
        ReferenceBinding referenceBinding;
        if (cArray.length == 1) {
            referenceBinding = this.defaultPackage.getType0(cArray[0]);
            if (referenceBinding == null) {
                PackageBinding packageBinding = this.getPackage0(cArray[0]);
                if (packageBinding != null && packageBinding != TheNotFoundPackage) {
                    return null;
                }
                referenceBinding = this.askForType(this.defaultPackage, cArray[0]);
            }
        } else {
            PackageBinding packageBinding = this.getPackage0(cArray[0]);
            if (packageBinding == TheNotFoundPackage) {
                return null;
            }
            if (packageBinding != null) {
                int n = cArray.length - 1;
                for (int i = 1; i < n && (packageBinding = packageBinding.getPackage0(cArray[i])) != null; ++i) {
                    if (packageBinding != TheNotFoundPackage) continue;
                    return null;
                }
            }
            if (packageBinding == null) {
                referenceBinding = this.askForType(cArray);
            } else {
                referenceBinding = packageBinding.getType0(cArray[cArray.length - 1]);
                if (referenceBinding == null) {
                    referenceBinding = this.askForType(packageBinding, cArray[cArray.length - 1]);
                }
            }
        }
        if (referenceBinding == null || referenceBinding == TheNotFoundType) {
            return null;
        }
        if ((referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this, false)).isNestedType()) {
            return new ProblemReferenceBinding(cArray, referenceBinding, 4);
        }
        return referenceBinding;
    }

    private TypeBinding[] getTypeArgumentsFromSignature(SignatureWrapper signatureWrapper, TypeVariableBinding[] typeVariableBindingArray, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, char[][][] cArray, ITypeAnnotationWalker iTypeAnnotationWalker) {
        ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>(2);
        int n = 0;
        do {
            arrayList.add(this.getTypeFromVariantTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, referenceBinding2, n, cArray, iTypeAnnotationWalker.toTypeArgument(n++)));
        } while (signatureWrapper.signature[signatureWrapper.start] != '>');
        ++signatureWrapper.start;
        TypeBinding[] typeBindingArray = new TypeBinding[arrayList.size()];
        arrayList.toArray(typeBindingArray);
        return typeBindingArray;
    }

    private ReferenceBinding getTypeFromCompoundName(char[][] cArray, boolean bl, boolean bl2) {
        ReferenceBinding referenceBinding = this.getCachedType(cArray);
        if (referenceBinding == null) {
            PackageBinding packageBinding = this.computePackageFrom(cArray, false);
            referenceBinding = new UnresolvedReferenceBinding(cArray, packageBinding);
            if (bl2) {
                referenceBinding.tagBits |= 0x80L;
            }
            packageBinding.addType(referenceBinding);
        } else if (referenceBinding == TheNotFoundType) {
            if (!bl2) {
                this.problemReporter.isClassPathCorrect(cArray, this.unitBeingCompleted, this.missingClassFileLocation);
            }
            referenceBinding = this.createMissingType(null, cArray);
        } else if (!bl) {
            referenceBinding = (ReferenceBinding)this.convertUnresolvedBinaryToRawType(referenceBinding);
        }
        return referenceBinding;
    }

    ReferenceBinding getTypeFromConstantPoolName(char[] cArray, int n, int n2, boolean bl, char[][][] cArray2, ITypeAnnotationWalker iTypeAnnotationWalker) {
        if (n2 == -1) {
            n2 = cArray.length;
        }
        char[][] cArray3 = CharOperation.splitOn('/', cArray, n, n2);
        boolean bl2 = false;
        if (cArray2 != null) {
            int n3 = cArray2.length;
            for (int i = 0; i < n3; ++i) {
                if (!CharOperation.equals(cArray3, cArray2[i])) continue;
                bl2 = true;
                break;
            }
        }
        ReferenceBinding referenceBinding = this.getTypeFromCompoundName(cArray3, bl, bl2);
        if (iTypeAnnotationWalker != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            referenceBinding = (ReferenceBinding)this.annotateType(referenceBinding, iTypeAnnotationWalker, cArray2);
        }
        return referenceBinding;
    }

    ReferenceBinding getTypeFromConstantPoolName(char[] cArray, int n, int n2, boolean bl, char[][][] cArray2) {
        return this.getTypeFromConstantPoolName(cArray, n, n2, bl, cArray2, ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
    }

    TypeBinding getTypeFromSignature(char[] cArray, int n, int n2, boolean bl, TypeBinding typeBinding, char[][][] cArray2, ITypeAnnotationWalker iTypeAnnotationWalker) {
        int n3 = 0;
        while (cArray[n] == '[') {
            ++n;
            ++n3;
        }
        AnnotationBinding[][] annotationBindingArray = null;
        if (n3 > 0 && iTypeAnnotationWalker != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            for (int i = 0; i < n3; ++i) {
                AnnotationBinding[] annotationBindingArray2 = BinaryTypeBinding.createAnnotations(iTypeAnnotationWalker.getAnnotationsAtCursor(0), this, cArray2);
                if (annotationBindingArray2 != Binding.NO_ANNOTATIONS) {
                    if (annotationBindingArray == null) {
                        annotationBindingArray = new AnnotationBinding[n3][];
                    }
                    annotationBindingArray[i] = annotationBindingArray2;
                }
                iTypeAnnotationWalker = iTypeAnnotationWalker.toNextArrayDimension();
            }
        }
        if (n2 == -1) {
            n2 = cArray.length - 1;
        }
        TypeBinding typeBinding2 = null;
        if (n == n2) {
            switch (cArray[n]) {
                case 'I': {
                    typeBinding2 = TypeBinding.INT;
                    break;
                }
                case 'Z': {
                    typeBinding2 = TypeBinding.BOOLEAN;
                    break;
                }
                case 'V': {
                    typeBinding2 = TypeBinding.VOID;
                    break;
                }
                case 'C': {
                    typeBinding2 = TypeBinding.CHAR;
                    break;
                }
                case 'D': {
                    typeBinding2 = TypeBinding.DOUBLE;
                    break;
                }
                case 'B': {
                    typeBinding2 = TypeBinding.BYTE;
                    break;
                }
                case 'F': {
                    typeBinding2 = TypeBinding.FLOAT;
                    break;
                }
                case 'J': {
                    typeBinding2 = TypeBinding.LONG;
                    break;
                }
                case 'S': {
                    typeBinding2 = TypeBinding.SHORT;
                    break;
                }
                default: {
                    this.problemReporter.corruptedSignature(typeBinding, cArray, n);
                    break;
                }
            }
        } else {
            typeBinding2 = this.getTypeFromConstantPoolName(cArray, n + 1, n2, bl, cArray2);
        }
        if (bl) {
            if (n3 != 0) {
                throw new IllegalStateException();
            }
            return typeBinding2;
        }
        if (iTypeAnnotationWalker != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            typeBinding2 = this.annotateType(typeBinding2, iTypeAnnotationWalker, cArray2);
        }
        if (n3 != 0) {
            typeBinding2 = this.typeSystem.getArrayType(typeBinding2, n3, AnnotatableTypeSystem.flattenedAnnotations(annotationBindingArray));
        }
        return typeBinding2;
    }

    private TypeBinding annotateType(TypeBinding typeBinding, ITypeAnnotationWalker iTypeAnnotationWalker, char[][][] cArray) {
        Object object;
        int n = typeBinding.depth() + 1;
        if (n > 1) {
            if (typeBinding.isUnresolvedType()) {
                typeBinding = ((UnresolvedReferenceBinding)typeBinding).resolve(this, true);
            }
            n = 0;
            for (object = typeBinding; object != null; object = ((TypeBinding)object).enclosingType()) {
                ++n;
                if (((TypeBinding)object).isStatic()) break;
            }
        }
        object = null;
        for (int i = 0; i < n; ++i) {
            AnnotationBinding[] annotationBindingArray = BinaryTypeBinding.createAnnotations(iTypeAnnotationWalker.getAnnotationsAtCursor(typeBinding.id), this, cArray);
            if (annotationBindingArray != null && annotationBindingArray.length > 0) {
                if (object == null) {
                    object = new AnnotationBinding[n][];
                }
                object[i] = annotationBindingArray;
            }
            iTypeAnnotationWalker = iTypeAnnotationWalker.toNextNestedType();
        }
        if (object != null) {
            typeBinding = this.createAnnotatedType(typeBinding, (AnnotationBinding[][])object);
        }
        return typeBinding;
    }

    boolean qualifiedNameMatchesSignature(char[][] cArray, char[] cArray2) {
        int n = 1;
        for (int i = 0; i < cArray.length; ++i) {
            char[] cArray3 = cArray[i];
            for (int j = 0; j < cArray3.length; ++j) {
                if (cArray3[j] == cArray2[n++]) continue;
                return false;
            }
            if (cArray2[n] == ';' && i == cArray.length - 1) {
                return true;
            }
            if (cArray2[n++] == '/') continue;
            return false;
        }
        return false;
    }

    public TypeBinding getTypeFromTypeSignature(SignatureWrapper signatureWrapper, TypeVariableBinding[] typeVariableBindingArray, ReferenceBinding referenceBinding, char[][][] cArray, ITypeAnnotationWalker iTypeAnnotationWalker) {
        ReferenceBinding referenceBinding2;
        Object object;
        int n;
        int n2 = 0;
        while (signatureWrapper.signature[signatureWrapper.start] == '[') {
            ++signatureWrapper.start;
            ++n2;
        }
        AnnotationBinding[][] annotationBindingArray = null;
        if (n2 > 0 && iTypeAnnotationWalker != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            for (n = 0; n < n2; ++n) {
                object = BinaryTypeBinding.createAnnotations(iTypeAnnotationWalker.getAnnotationsAtCursor(0), this, cArray);
                if (object != Binding.NO_ANNOTATIONS) {
                    if (annotationBindingArray == null) {
                        annotationBindingArray = new AnnotationBinding[n2][];
                    }
                    annotationBindingArray[n] = object;
                }
                iTypeAnnotationWalker = iTypeAnnotationWalker.toNextArrayDimension();
            }
        }
        if (signatureWrapper.signature[signatureWrapper.start] == 'T') {
            n = signatureWrapper.start + 1;
            int n3 = signatureWrapper.computeEnd();
            int n4 = typeVariableBindingArray.length;
            while (--n4 >= 0) {
                if (!CharOperation.equals(typeVariableBindingArray[n4].sourceName, signatureWrapper.signature, n, n3)) continue;
                return this.getTypeFromTypeVariable(typeVariableBindingArray[n4], n2, annotationBindingArray, iTypeAnnotationWalker, cArray);
            }
            ReferenceBinding referenceBinding3 = referenceBinding;
            do {
                TypeVariableBinding[] typeVariableBindingArray2 = referenceBinding instanceof BinaryTypeBinding ? ((BinaryTypeBinding)referenceBinding).typeVariables : referenceBinding.typeVariables();
                int n5 = typeVariableBindingArray2.length;
                while (--n5 >= 0) {
                    if (!CharOperation.equals(typeVariableBindingArray2[n5].sourceName, signatureWrapper.signature, n, n3)) continue;
                    return this.getTypeFromTypeVariable(typeVariableBindingArray2[n5], n2, annotationBindingArray, iTypeAnnotationWalker, cArray);
                }
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            this.problemReporter.undefinedTypeVariableSignature(CharOperation.subarray(signatureWrapper.signature, n, n3), referenceBinding3);
            return null;
        }
        n = signatureWrapper.end == signatureWrapper.bracket ? 1 : 0;
        object = this.getTypeFromSignature(signatureWrapper.signature, signatureWrapper.start, signatureWrapper.computeEnd(), n != 0, referenceBinding, cArray, iTypeAnnotationWalker);
        if (n == 0) {
            return n2 == 0 ? object : this.createArrayType((TypeBinding)object, n2, AnnotatableTypeSystem.flattenedAnnotations(annotationBindingArray));
        }
        ReferenceBinding referenceBinding4 = (ReferenceBinding)object;
        if (referenceBinding4 instanceof UnresolvedReferenceBinding && CharOperation.indexOf('$', referenceBinding4.compoundName[referenceBinding4.compoundName.length - 1]) > 0) {
            referenceBinding4 = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding4, this, false);
        }
        if ((referenceBinding2 = referenceBinding4.enclosingType()) != null) {
            referenceBinding2 = (ReferenceBinding)this.convertToRawType(referenceBinding2, false);
        }
        AnnotationBinding[] annotationBindingArray2 = BinaryTypeBinding.createAnnotations(iTypeAnnotationWalker.getAnnotationsAtCursor(referenceBinding4.id), this, cArray);
        TypeBinding[] typeBindingArray = this.getTypeArgumentsFromSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, referenceBinding4, cArray, iTypeAnnotationWalker);
        ParameterizedTypeBinding parameterizedTypeBinding = this.createParameterizedType(referenceBinding4, typeBindingArray, referenceBinding2, annotationBindingArray2);
        while (signatureWrapper.signature[signatureWrapper.start] == '.') {
            int n6 = ++signatureWrapper.start;
            char[] cArray2 = signatureWrapper.nextWord();
            BinaryTypeBinding.resolveType(parameterizedTypeBinding, this, false);
            ReferenceBinding referenceBinding5 = parameterizedTypeBinding.genericType().getMemberType(cArray2);
            if (referenceBinding5 == null) {
                this.problemReporter.corruptedSignature(parameterizedTypeBinding, signatureWrapper.signature, n6);
            }
            iTypeAnnotationWalker = iTypeAnnotationWalker.toNextNestedType();
            annotationBindingArray2 = BinaryTypeBinding.createAnnotations(iTypeAnnotationWalker.getAnnotationsAtCursor(referenceBinding5.id), this, cArray);
            if (signatureWrapper.signature[signatureWrapper.start] == '<') {
                ++signatureWrapper.start;
                typeBindingArray = this.getTypeArgumentsFromSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, referenceBinding5, cArray, iTypeAnnotationWalker);
            } else {
                typeBindingArray = null;
            }
            parameterizedTypeBinding = this.createParameterizedType(referenceBinding5, typeBindingArray, parameterizedTypeBinding, annotationBindingArray2);
        }
        ++signatureWrapper.start;
        return n2 == 0 ? parameterizedTypeBinding : this.createArrayType(parameterizedTypeBinding, n2, AnnotatableTypeSystem.flattenedAnnotations(annotationBindingArray));
    }

    private TypeBinding getTypeFromTypeVariable(TypeVariableBinding typeVariableBinding, int n, AnnotationBinding[][] annotationBindingArray, ITypeAnnotationWalker iTypeAnnotationWalker, char[][][] cArray) {
        AnnotationBinding[] annotationBindingArray2 = BinaryTypeBinding.createAnnotations(iTypeAnnotationWalker.getAnnotationsAtCursor(-1), this, cArray);
        if (annotationBindingArray2 != null && annotationBindingArray2 != Binding.NO_ANNOTATIONS) {
            typeVariableBinding = (TypeVariableBinding)this.createAnnotatedType((TypeBinding)typeVariableBinding, new AnnotationBinding[][]{annotationBindingArray2});
        }
        if (n == 0) {
            return typeVariableBinding;
        }
        return this.typeSystem.getArrayType(typeVariableBinding, n, AnnotatableTypeSystem.flattenedAnnotations(annotationBindingArray));
    }

    TypeBinding getTypeFromVariantTypeSignature(SignatureWrapper signatureWrapper, TypeVariableBinding[] typeVariableBindingArray, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, int n, char[][][] cArray, ITypeAnnotationWalker iTypeAnnotationWalker) {
        switch (signatureWrapper.signature[signatureWrapper.start]) {
            case '-': {
                ++signatureWrapper.start;
                TypeBinding typeBinding = this.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, cArray, iTypeAnnotationWalker.toWildcardBound());
                AnnotationBinding[] annotationBindingArray = BinaryTypeBinding.createAnnotations(iTypeAnnotationWalker.getAnnotationsAtCursor(-1), this, cArray);
                return this.typeSystem.getWildcard(referenceBinding2, n, typeBinding, null, 2, annotationBindingArray);
            }
            case '+': {
                ++signatureWrapper.start;
                TypeBinding typeBinding = this.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, cArray, iTypeAnnotationWalker.toWildcardBound());
                AnnotationBinding[] annotationBindingArray = BinaryTypeBinding.createAnnotations(iTypeAnnotationWalker.getAnnotationsAtCursor(-1), this, cArray);
                return this.typeSystem.getWildcard(referenceBinding2, n, typeBinding, null, 1, annotationBindingArray);
            }
            case '*': {
                ++signatureWrapper.start;
                AnnotationBinding[] annotationBindingArray = BinaryTypeBinding.createAnnotations(iTypeAnnotationWalker.getAnnotationsAtCursor(-1), this, cArray);
                return this.typeSystem.getWildcard(referenceBinding2, n, null, null, 0, annotationBindingArray);
            }
        }
        return this.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, referenceBinding, cArray, iTypeAnnotationWalker);
    }

    boolean isMissingType(char[] cArray) {
        int n;
        int n2 = n = this.missingTypes == null ? 0 : this.missingTypes.size();
        while (--n >= 0) {
            MissingTypeBinding missingTypeBinding = (MissingTypeBinding)this.missingTypes.get(n);
            if (!CharOperation.equals(missingTypeBinding.sourceName, cArray)) continue;
            return true;
        }
        return false;
    }

    boolean isPackage(char[][] cArray, char[] cArray2) {
        if (cArray == null || cArray.length == 0) {
            return this.nameEnvironment.isPackage(null, cArray2);
        }
        return this.nameEnvironment.isPackage(cArray, cArray2);
    }

    public MethodVerifier methodVerifier() {
        if (this.verifier == null) {
            this.verifier = this.newMethodVerifier();
        }
        return this.verifier;
    }

    public MethodVerifier newMethodVerifier() {
        return new MethodVerifier15(this);
    }

    public void releaseClassFiles(ClassFile[] classFileArray) {
        int n = classFileArray.length;
        for (int i = 0; i < n; ++i) {
            this.classFilePool.release(classFileArray[i]);
        }
    }

    public void reset() {
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.knownPackages = new HashtableOfPackage();
        this.accessRestrictions = new HashMap(3);
        this.verifier = null;
        this.uniqueParameterizedGenericMethodBindings = new SimpleLookupTable(3);
        this.uniquePolymorphicMethodBindings = new SimpleLookupTable(3);
        this.uniqueGetClassMethodBinding = null;
        this.missingTypes = null;
        this.typesBeingConnected = new HashSet<SourceTypeBinding>();
        int n = this.units.length;
        while (--n >= 0) {
            this.units[n] = null;
        }
        this.lastUnitIndex = -1;
        this.lastCompletedUnitIndex = -1;
        this.unitBeingCompleted = null;
        this.classFilePool.reset();
        this.typeSystem.reset();
    }

    public void setAccessRestriction(ReferenceBinding referenceBinding, AccessRestriction accessRestriction) {
        if (accessRestriction == null) {
            return;
        }
        referenceBinding.modifiers |= 0x40000;
        this.accessRestrictions.put(referenceBinding, accessRestriction);
    }

    void updateCaches(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding) {
        this.typeSystem.updateCaches(unresolvedReferenceBinding, referenceBinding);
    }

    public void addResolutionListener(IQualifiedTypeResolutionListener iQualifiedTypeResolutionListener) {
        int n = this.resolutionListeners.length;
        for (int i = 0; i < n; ++i) {
            if (!this.resolutionListeners[i].equals(iQualifiedTypeResolutionListener)) continue;
            return;
        }
        this.resolutionListeners = new IQualifiedTypeResolutionListener[n + 1];
        System.arraycopy(this.resolutionListeners, 0, this.resolutionListeners, 0, n);
        this.resolutionListeners[n] = iQualifiedTypeResolutionListener;
    }

    public TypeBinding getUnannotatedType(TypeBinding typeBinding) {
        return this.typeSystem.getUnannotatedType(typeBinding);
    }

    public TypeBinding[] getAnnotatedTypes(TypeBinding typeBinding) {
        return this.typeSystem.getAnnotatedTypes(typeBinding);
    }

    public AnnotationBinding[] filterNullTypeAnnotations(AnnotationBinding[] annotationBindingArray) {
        if (annotationBindingArray.length == 0) {
            return annotationBindingArray;
        }
        AnnotationBinding[] annotationBindingArray2 = new AnnotationBinding[annotationBindingArray.length];
        int n = 0;
        for (int i = 0; i < annotationBindingArray.length; ++i) {
            AnnotationBinding annotationBinding = annotationBindingArray[i];
            if (annotationBinding == null) {
                ++n;
                continue;
            }
            if (annotationBinding.type.hasNullBit(96)) continue;
            annotationBindingArray2[n++] = annotationBinding;
        }
        if (n == 0) {
            return Binding.NO_ANNOTATIONS;
        }
        if (n == annotationBindingArray.length) {
            return annotationBindingArray;
        }
        AnnotationBinding[] annotationBindingArray3 = annotationBindingArray2;
        annotationBindingArray2 = new AnnotationBinding[n];
        System.arraycopy(annotationBindingArray3, 0, annotationBindingArray2, 0, n);
        return annotationBindingArray2;
    }

    public boolean containsNullTypeAnnotation(IBinaryAnnotation[] iBinaryAnnotationArray) {
        if (iBinaryAnnotationArray.length == 0) {
            return false;
        }
        for (int i = 0; i < iBinaryAnnotationArray.length; ++i) {
            char[][] cArray;
            IBinaryAnnotation iBinaryAnnotation = iBinaryAnnotationArray[i];
            char[] cArray2 = iBinaryAnnotation.getTypeName();
            if (cArray2 == null || cArray2.length < 3 || cArray2[0] != 'L' || this.getNullAnnotationBit(cArray = CharOperation.splitOn('/', cArray2, 1, cArray2.length - 1)) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean containsNullTypeAnnotation(AnnotationBinding[] annotationBindingArray) {
        if (annotationBindingArray.length == 0) {
            return false;
        }
        for (int i = 0; i < annotationBindingArray.length; ++i) {
            AnnotationBinding annotationBinding = annotationBindingArray[i];
            if (!annotationBinding.type.hasNullBit(96)) continue;
            return true;
        }
        return false;
    }
}

