/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import com.sun.security.auth.LdapPrincipal;
import com.sun.security.auth.UserPrincipal;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jdk.Exported;

@Exported
public class LdapLoginModule
implements LoginModule {
    private static final ResourceBundle rb = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    private static final String USERNAME_KEY = "javax.security.auth.login.name";
    private static final String PASSWORD_KEY = "javax.security.auth.login.password";
    private static final String USER_PROVIDER = "userProvider";
    private static final String USER_FILTER = "userFilter";
    private static final String AUTHC_IDENTITY = "authIdentity";
    private static final String AUTHZ_IDENTITY = "authzIdentity";
    private static final String USERNAME_TOKEN = "{USERNAME}";
    private static final Pattern USERNAME_PATTERN = Pattern.compile("\\{USERNAME\\}");
    private String userProvider;
    private String userFilter;
    private String authcIdentity;
    private String authzIdentity;
    private String authzIdentityAttr = null;
    private boolean useSSL = true;
    private boolean authFirst = false;
    private boolean authOnly = false;
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private LdapPrincipal ldapPrincipal;
    private UserPrincipal userPrincipal;
    private UserPrincipal authzPrincipal;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, Object> sharedState;
    private Map<String, ?> options;
    private LdapContext ctx;
    private Matcher identityMatcher = null;
    private Matcher filterMatcher = null;
    private Hashtable<String, Object> ldapEnvironment;
    private SearchControls constraints = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.ldapEnvironment = new Hashtable(9);
        this.ldapEnvironment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        for (String string : map2.keySet()) {
            if (string.indexOf(".") <= -1) continue;
            this.ldapEnvironment.put(string, map2.get(string));
        }
        this.userProvider = (String)map2.get(USER_PROVIDER);
        if (this.userProvider != null) {
            this.ldapEnvironment.put("java.naming.provider.url", this.userProvider);
        }
        this.authcIdentity = (String)map2.get(AUTHC_IDENTITY);
        if (this.authcIdentity != null && this.authcIdentity.indexOf(USERNAME_TOKEN) != -1) {
            this.identityMatcher = USERNAME_PATTERN.matcher(this.authcIdentity);
        }
        this.userFilter = (String)map2.get(USER_FILTER);
        if (this.userFilter != null) {
            if (this.userFilter.indexOf(USERNAME_TOKEN) != -1) {
                this.filterMatcher = USERNAME_PATTERN.matcher(this.userFilter);
            }
            this.constraints = new SearchControls();
            this.constraints.setSearchScope(2);
            this.constraints.setReturningAttributes(new String[0]);
        }
        this.authzIdentity = (String)map2.get(AUTHZ_IDENTITY);
        if (this.authzIdentity != null && this.authzIdentity.startsWith("{") && this.authzIdentity.endsWith("}")) {
            if (this.constraints != null) {
                this.authzIdentityAttr = this.authzIdentity.substring(1, this.authzIdentity.length() - 1);
                this.constraints.setReturningAttributes(new String[]{this.authzIdentityAttr});
            }
            this.authzIdentity = null;
        }
        if (this.authcIdentity != null) {
            if (this.userFilter != null) {
                this.authFirst = true;
            } else {
                this.authOnly = true;
            }
        }
        if ("false".equalsIgnoreCase((String)map2.get("useSSL"))) {
            this.useSSL = false;
            this.ldapEnvironment.remove("java.naming.security.protocol");
        } else {
            this.ldapEnvironment.put("java.naming.security.protocol", "ssl");
        }
        this.tryFirstPass = "true".equalsIgnoreCase((String)map2.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)map2.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)map2.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)map2.get("clearPass"));
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        if (this.debug) {
            if (this.authFirst) {
                System.out.println("\t\t[LdapLoginModule] authentication-first mode; " + (this.useSSL ? "SSL enabled" : "SSL disabled"));
            } else if (this.authOnly) {
                System.out.println("\t\t[LdapLoginModule] authentication-only mode; " + (this.useSSL ? "SSL enabled" : "SSL disabled"));
            } else {
                System.out.println("\t\t[LdapLoginModule] search-first mode; " + (this.useSSL ? "SSL enabled" : "SSL disabled"));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean login() throws LoginException {
        if (this.userProvider == null) {
            throw new LoginException("Unable to locate the LDAP directory service");
        }
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] user provider: " + this.userProvider);
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] tryFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException var1_1) {
                this.cleanState();
                if (!this.debug) ** GOTO lbl29
                System.out.println("\t\t[LdapLoginModule] tryFirstPass failed: " + var1_1.toString());
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] useFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException var1_2) {
                this.cleanState();
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] useFirstPass failed");
                }
                throw var1_2;
            }
        }
lbl29:
        // 4 sources

        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] authentication succeeded");
            }
            return true;
        }
        catch (LoginException var1_3) {
            this.cleanState();
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] authentication failed");
            }
            throw var1_3;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.ldapPrincipal)) {
            set.add(this.ldapPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] added LdapPrincipal \"" + this.ldapPrincipal + "\" to Subject");
        }
        if (!set.contains(this.userPrincipal)) {
            set.add(this.userPrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] added UserPrincipal \"" + this.userPrincipal + "\" to Subject");
        }
        if (this.authzPrincipal != null && !set.contains(this.authzPrincipal)) {
            set.add(this.authzPrincipal);
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] added UserPrincipal \"" + this.authzPrincipal + "\" to Subject");
            }
        }
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] aborted authentication");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanState();
            this.ldapPrincipal = null;
            this.userPrincipal = null;
            this.authzPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is read-only");
        }
        Set<Principal> set = this.subject.getPrincipals();
        set.remove(this.ldapPrincipal);
        set.remove(this.userPrincipal);
        if (this.authzIdentity != null) {
            set.remove(this.authzPrincipal);
        }
        this.cleanState();
        this.succeeded = false;
        this.commitSucceeded = false;
        this.ldapPrincipal = null;
        this.userPrincipal = null;
        this.authzPrincipal = null;
        if (this.debug) {
            System.out.println("\t\t[LdapLoginModule] logged out Subject");
        }
        return true;
    }

    private void attemptAuthentication(boolean bl) throws LoginException {
        this.getUsernamePassword(bl);
        if (this.password == null || this.password.length == 0) {
            throw new FailedLoginException("No password was supplied");
        }
        String string = "";
        if (this.authFirst || this.authOnly) {
            String string2 = this.replaceUsernameToken(this.identityMatcher, this.authcIdentity);
            this.ldapEnvironment.put("java.naming.security.credentials", this.password);
            this.ldapEnvironment.put("java.naming.security.principal", string2);
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] attempting to authenticate user: " + this.username);
            }
            try {
                this.ctx = new InitialLdapContext(this.ldapEnvironment, null);
            }
            catch (NamingException namingException) {
                throw (LoginException)new FailedLoginException("Cannot bind to LDAP server").initCause(namingException);
            }
            string = this.userFilter != null ? this.findUserDN(this.ctx) : string2;
        } else {
            try {
                this.ctx = new InitialLdapContext(this.ldapEnvironment, null);
            }
            catch (NamingException namingException) {
                throw (LoginException)new FailedLoginException("Cannot connect to LDAP server").initCause(namingException);
            }
            string = this.findUserDN(this.ctx);
            try {
                this.ctx.addToEnvironment("java.naming.security.authentication", "simple");
                this.ctx.addToEnvironment("java.naming.security.principal", string);
                this.ctx.addToEnvironment("java.naming.security.credentials", this.password);
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] attempting to authenticate user: " + this.username);
                }
                this.ctx.reconnect(null);
            }
            catch (NamingException namingException) {
                throw (LoginException)new FailedLoginException("Cannot bind to LDAP server").initCause(namingException);
            }
        }
        if (this.storePass && !this.sharedState.containsKey(USERNAME_KEY) && !this.sharedState.containsKey(PASSWORD_KEY)) {
            this.sharedState.put(USERNAME_KEY, this.username);
            this.sharedState.put(PASSWORD_KEY, this.password);
        }
        this.userPrincipal = new UserPrincipal(this.username);
        if (this.authzIdentity != null) {
            this.authzPrincipal = new UserPrincipal(this.authzIdentity);
        }
        try {
            this.ldapPrincipal = new LdapPrincipal(string);
        }
        catch (InvalidNameException invalidNameException) {
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] cannot create LdapPrincipal: bad DN");
            }
            throw (LoginException)new FailedLoginException("Cannot create LdapPrincipal").initCause(invalidNameException);
        }
    }

    private String findUserDN(LdapContext ldapContext) throws LoginException {
        String string = "";
        if (this.userFilter != null) {
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] searching for entry belonging to user: " + this.username);
            }
        } else {
            if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] cannot search for entry belonging to user: " + this.username);
            }
            throw new FailedLoginException("Cannot find user's LDAP entry");
        }
        try {
            NamingEnumeration<SearchResult> namingEnumeration = ldapContext.search("", this.replaceUsernameToken(this.filterMatcher, this.userFilter), this.constraints);
            if (namingEnumeration.hasMore()) {
                Object object;
                Attribute attribute;
                SearchResult searchResult = namingEnumeration.next();
                string = searchResult.getNameInNamespace();
                if (this.debug) {
                    System.out.println("\t\t[LdapLoginModule] found entry: " + string);
                }
                if (this.authzIdentityAttr != null && (attribute = searchResult.getAttributes().get(this.authzIdentityAttr)) != null && (object = attribute.get()) instanceof String) {
                    this.authzIdentity = (String)object;
                }
                namingEnumeration.close();
            } else if (this.debug) {
                System.out.println("\t\t[LdapLoginModule] user's entry not found");
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (string.equals("")) {
            throw new FailedLoginException("Cannot find user's LDAP entry");
        }
        return string;
    }

    private String replaceUsernameToken(Matcher matcher, String string) {
        return matcher != null ? matcher.replaceAll(this.username) : string;
    }

    private void getUsernamePassword(boolean bl) throws LoginException {
        if (bl) {
            this.username = (String)this.sharedState.get(USERNAME_KEY);
            this.password = (char[])this.sharedState.get(PASSWORD_KEY);
            return;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to acquire authentication information from the user");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback(rb.getString("username.")), new PasswordCallback(rb.getString("password."), false)};
        try {
            this.callbackHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            char[] cArray = ((PasswordCallback)callbackArray[1]).getPassword();
            this.password = new char[cArray.length];
            System.arraycopy(cArray, 0, this.password, 0, cArray.length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to acquire authentication information from the user");
        }
    }

    private void cleanState() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
        try {
            if (this.ctx != null) {
                this.ctx.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.ctx = null;
        if (this.clearPass) {
            this.sharedState.remove(USERNAME_KEY);
            this.sharedState.remove(PASSWORD_KEY);
        }
    }
}

