/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractCharFilterFactory;

public class HtmlStripCharFilterFactory
extends AbstractCharFilterFactory {
    private final Set<String> escapedTags;

    public HtmlStripCharFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name);
        String[] escapedTags = settings.getAsArray("escaped_tags");
        this.escapedTags = escapedTags.length > 0 ? Collections.unmodifiableSet(Sets.newHashSet(escapedTags)) : null;
    }

    public Set<String> escapedTags() {
        return this.escapedTags;
    }

    @Override
    public Reader create(Reader tokenStream) {
        return new HTMLStripCharFilter(tokenStream, this.escapedTags);
    }
}

