/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeCallSite;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeError
extends IdScriptableObject {
    static final long serialVersionUID = -5338413581437645187L;
    private static final Object ERROR_TAG = "Error";
    private static final Method ERROR_DELEGATE_GET_STACK;
    private static final Method ERROR_DELEGATE_SET_STACK;
    public static final int DEFAULT_STACK_LIMIT = -1;
    private static final String STACK_HIDE_KEY = "_stackHide";
    private RhinoException stackProvider;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int ConstructorId_captureStackTrace = -1;
    private static final int MAX_PROTOTYPE_ID = 3;

    NativeError() {
    }

    static void init(Scriptable scriptable, boolean bl) {
        NativeError nativeError = new NativeError();
        ScriptableObject.putProperty((Scriptable)nativeError, "name", (Object)"Error");
        ScriptableObject.putProperty((Scriptable)nativeError, "message", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "fileName", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "lineNumber", (Object)0);
        nativeError.setAttributes("name", 2);
        nativeError.setAttributes("message", 2);
        nativeError.exportAsJSClass(3, scriptable, bl);
        NativeCallSite.init(nativeError, bl);
    }

    static NativeError make(Context context, Scriptable scriptable, IdFunctionObject idFunctionObject, Object[] objectArray) {
        Scriptable scriptable2 = (Scriptable)idFunctionObject.get("prototype", (Scriptable)idFunctionObject);
        NativeError nativeError = new NativeError();
        nativeError.setPrototype(scriptable2);
        nativeError.setParentScope(scriptable);
        int n = objectArray.length;
        if (n >= 1) {
            if (objectArray[0] != Undefined.instance) {
                ScriptableObject.putProperty((Scriptable)nativeError, "message", (Object)ScriptRuntime.toString(objectArray[0]));
            }
            if (n >= 2) {
                ScriptableObject.putProperty((Scriptable)nativeError, "fileName", objectArray[1]);
                if (n >= 3) {
                    int n2 = ScriptRuntime.toInt32(objectArray[2]);
                    ScriptableObject.putProperty((Scriptable)nativeError, "lineNumber", (Object)n2);
                }
            }
        }
        return nativeError;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, ERROR_TAG, -1, "captureStackTrace", 2);
        ProtoProps protoProps = new ProtoProps();
        this.associateValue("_ErrorPrototypeProps", protoProps);
        idFunctionObject.defineProperty("stackTraceLimit", protoProps, ProtoProps.GET_STACK_LIMIT, ProtoProps.SET_STACK_LIMIT, 0);
        idFunctionObject.defineProperty("prepareStackTrace", protoProps, ProtoProps.GET_PREPARE_STACK, ProtoProps.SET_PREPARE_STACK, 0);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    public String getClassName() {
        return "Error";
    }

    public String toString() {
        Object object = NativeError.js_toString(this);
        return object instanceof String ? (String)object : super.toString();
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(ERROR_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(ERROR_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return NativeError.make(context, scriptable, idFunctionObject, objectArray);
            }
            case 2: {
                return NativeError.js_toString(scriptable2);
            }
            case 3: {
                return NativeError.js_toSource(context, scriptable, scriptable2);
            }
            case -1: {
                NativeError.js_captureStackTrace(context, scriptable2, objectArray);
                return Undefined.instance;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public void setStackProvider(RhinoException rhinoException) {
        if (this.stackProvider == null) {
            this.stackProvider = rhinoException;
            this.defineProperty("stack", this, ERROR_DELEGATE_GET_STACK, ERROR_DELEGATE_SET_STACK, 2);
        }
    }

    public Object getStackDelegated(Scriptable scriptable) {
        if (this.stackProvider == null) {
            return NOT_FOUND;
        }
        int n = -1;
        Function function = null;
        NativeError nativeError = (NativeError)this.getPrototype();
        ProtoProps protoProps = (ProtoProps)nativeError.getAssociatedValue("_ErrorPrototypeProps");
        if (protoProps != null) {
            n = protoProps.getStackTraceLimit();
            function = protoProps.getPrepareStackTrace();
        }
        String string = (String)this.getAssociatedValue(STACK_HIDE_KEY);
        ScriptStackElement[] scriptStackElementArray = this.stackProvider.getScriptStack(n, string);
        Object object = function == null ? RhinoException.formatStackTrace(scriptStackElementArray, this.stackProvider.details()) : this.callPrepareStack(function, scriptStackElementArray);
        this.setStackDelegated(scriptable, object);
        return object;
    }

    public void setStackDelegated(Scriptable scriptable, Object object) {
        scriptable.delete("stack");
        this.stackProvider = null;
        scriptable.put("stack", scriptable, object);
    }

    private Object callPrepareStack(Function function, ScriptStackElement[] scriptStackElementArray) {
        Context context = Context.getCurrentContext();
        Object[] objectArray = new Object[scriptStackElementArray.length];
        for (int i = 0; i < scriptStackElementArray.length; ++i) {
            NativeCallSite nativeCallSite = (NativeCallSite)context.newObject(this, "CallSite");
            nativeCallSite.setElement(scriptStackElementArray[i]);
            objectArray[i] = nativeCallSite;
        }
        Scriptable scriptable = context.newArray((Scriptable)this, objectArray);
        return function.call(context, function, this, new Object[]{this, scriptable});
    }

    private static Object js_toString(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty(scriptable, "name");
        object = object == NOT_FOUND || object == Undefined.instance ? "Error" : ScriptRuntime.toString(object);
        Object object2 = ScriptableObject.getProperty(scriptable, "message");
        object2 = object2 == NOT_FOUND || object2 == Undefined.instance ? "" : ScriptRuntime.toString(object2);
        if (object.toString().length() == 0) {
            return object2;
        }
        if (object2.toString().length() == 0) {
            return object;
        }
        return (String)object + ": " + (String)object2;
    }

    private static String js_toSource(Context context, Scriptable scriptable, Scriptable scriptable2) {
        Object object = ScriptableObject.getProperty(scriptable2, "name");
        Object object2 = ScriptableObject.getProperty(scriptable2, "message");
        Object object3 = ScriptableObject.getProperty(scriptable2, "fileName");
        Object object4 = ScriptableObject.getProperty(scriptable2, "lineNumber");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(new ");
        if (object == NOT_FOUND) {
            object = Undefined.instance;
        }
        stringBuilder.append(ScriptRuntime.toString(object));
        stringBuilder.append("(");
        if (object2 != NOT_FOUND || object3 != NOT_FOUND || object4 != NOT_FOUND) {
            if (object2 == NOT_FOUND) {
                object2 = "";
            }
            stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object2));
            if (object3 != NOT_FOUND || object4 != NOT_FOUND) {
                int n;
                stringBuilder.append(", ");
                if (object3 == NOT_FOUND) {
                    object3 = "";
                }
                stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object3));
                if (object4 != NOT_FOUND && (n = ScriptRuntime.toInt32(object4)) != 0) {
                    stringBuilder.append(", ");
                    stringBuilder.append(ScriptRuntime.toString(n));
                }
            }
        }
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    private static void js_captureStackTrace(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object;
        ScriptableObject scriptableObject = (ScriptableObject)ScriptRuntime.toObjectOrNull(context, objectArray[0], scriptable);
        Function function = null;
        if (objectArray.length > 1) {
            function = (Function)ScriptRuntime.toObjectOrNull(context, objectArray[1], scriptable);
        }
        NativeError nativeError = (NativeError)context.newObject(scriptable, "Error");
        nativeError.setStackProvider(new EvaluatorException("[object Object]"));
        if (function != null && (object = function.get("name", (Scriptable)function)) != null && !Undefined.instance.equals(object)) {
            nativeError.associateValue(STACK_HIDE_KEY, Context.toString(object));
        }
        scriptableObject.defineProperty("stack", nativeError, ERROR_DELEGATE_GET_STACK, ERROR_DELEGATE_SET_STACK, 0);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block6: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 8) {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 3;
                } else if (c == 't') {
                    string2 = "toString";
                    n = 2;
                }
            } else if (n2 == 11) {
                string2 = "constructor";
                n = 1;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block6;
            n = 0;
        }
        return n;
    }

    static {
        try {
            ERROR_DELEGATE_GET_STACK = NativeError.class.getMethod("getStackDelegated", Scriptable.class);
            ERROR_DELEGATE_SET_STACK = NativeError.class.getMethod("setStackDelegated", Scriptable.class, Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    private static final class ProtoProps
    implements Serializable {
        static final String KEY = "_ErrorPrototypeProps";
        static final Method GET_STACK_LIMIT;
        static final Method SET_STACK_LIMIT;
        static final Method GET_PREPARE_STACK;
        static final Method SET_PREPARE_STACK;
        private static final long serialVersionUID = 1907180507775337939L;
        private int stackTraceLimit = -1;
        private Function prepareStackTrace;

        private ProtoProps() {
        }

        public Object getStackTraceLimit(Scriptable scriptable) {
            if (this.stackTraceLimit >= 0) {
                return this.stackTraceLimit;
            }
            return Double.POSITIVE_INFINITY;
        }

        public int getStackTraceLimit() {
            return this.stackTraceLimit;
        }

        public void setStackTraceLimit(Scriptable scriptable, Object object) {
            double d = Context.toNumber(object);
            this.stackTraceLimit = Double.isNaN(d) || Double.isInfinite(d) ? -1 : (int)d;
        }

        public Object getPrepareStackTrace(Scriptable scriptable) {
            Function function = this.getPrepareStackTrace();
            return function == null ? Undefined.instance : function;
        }

        public Function getPrepareStackTrace() {
            return this.prepareStackTrace;
        }

        public void setPrepareStackTrace(Scriptable scriptable, Object object) {
            if (object == null || Undefined.instance.equals(object)) {
                this.prepareStackTrace = null;
            } else if (object instanceof Function) {
                this.prepareStackTrace = (Function)object;
            }
        }

        static {
            try {
                GET_STACK_LIMIT = ProtoProps.class.getMethod("getStackTraceLimit", Scriptable.class);
                SET_STACK_LIMIT = ProtoProps.class.getMethod("setStackTraceLimit", Scriptable.class, Object.class);
                GET_PREPARE_STACK = ProtoProps.class.getMethod("getPrepareStackTrace", Scriptable.class);
                SET_PREPARE_STACK = ProtoProps.class.getMethod("setPrepareStackTrace", Scriptable.class, Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
        }
    }
}

