/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch.sparshui;

import com.sparshui.common.Event;
import com.sparshui.common.messages.events.TouchEvent;
import com.sparshui.gestures.Gesture;
import com.sparshui.server.TouchPoint;
import java.util.ArrayList;
import java.util.List;
import org.jmol.util.Logger;

public class SinglePointGesture
implements Gesture {
    private static final long MAXIMUM_CLICK_TIME = 200L;
    private int _nCurrent;
    private int _nMoves;
    private int _myId;
    private TouchPoint _birth;

    @Override
    public String getName() {
        return "SinglePointGesture";
    }

    @Override
    public int getGestureType() {
        return 4;
    }

    @Override
    public List<Event> processChange(List<TouchPoint> touchPoints, TouchPoint changedTouchPoint) {
        ArrayList<Event> retEvents = new ArrayList<Event>();
        int nPoints = touchPoints.size();
        if (Logger.debugging) {
            Logger.debug((String)("\nSinglePointGesture " + this._myId + " nPoints: " + nPoints));
        }
        if (nPoints > 1) {
            if (this._myId != Integer.MAX_VALUE) {
                this._myId = Integer.MAX_VALUE;
                this._nMoves = 1000;
                this._nCurrent = 0;
                retEvents.add(new TouchEvent());
            }
            return retEvents;
        }
        int id = changedTouchPoint.getID();
        if (Logger.debugging) {
            Logger.debug((String)("\nSinglePointGesture id=" + id + " state=" + changedTouchPoint.getState() + " ncurrent=" + this._nCurrent + " nMoves=" + this._nMoves));
        }
        switch (changedTouchPoint.getState()) {
            case 0: {
                this._myId = id;
                this._birth = new TouchPoint(changedTouchPoint);
                this._nCurrent = 1;
                this._nMoves = 0;
                break;
            }
            case 2: {
                if (id != this._myId) {
                    return retEvents;
                }
                switch (++this._nMoves) {
                    case 2: {
                        if (!this.checkClick(changedTouchPoint, retEvents, false)) break;
                        return retEvents;
                    }
                }
                break;
            }
            case 1: {
                if (id != this._myId) {
                    return retEvents;
                }
                this._nCurrent = 0;
                if (this._nMoves >= 2 || !this.checkClick(changedTouchPoint, retEvents, true)) break;
                return retEvents;
            }
        }
        retEvents.add(new TouchEvent(changedTouchPoint));
        return retEvents;
    }

    private boolean checkClick(TouchPoint tpNew, List<Event> retEvents, boolean isDeath) {
        boolean isSingleClick;
        long dt = tpNew.getTime() - this._birth.getTime();
        boolean bl = isSingleClick = isDeath && dt < 200L;
        if (dt < 500L && !isSingleClick) {
            return false;
        }
        this._nMoves += 2;
        TouchPoint tp = new TouchPoint(this._birth);
        tp.setState(1);
        retEvents.add(new TouchEvent(tp));
        tp.setState(3);
        retEvents.add(new TouchEvent(tp));
        if (isSingleClick) {
            return true;
        }
        tp.setState(0);
        retEvents.add(new TouchEvent(tp));
        if (!isDeath) {
            return true;
        }
        tp.setState(1);
        retEvents.add(new TouchEvent(tp));
        tp.setState(3);
        retEvents.add(new TouchEvent(tp));
        return true;
    }
}

