/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.JSONEncodable;
import javajs.awt.Font;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.STER;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.minimize.Minimizer;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.StateScript;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.script.SV;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptError;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptInterruption;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptParam;
import org.jmol.script.T;
import org.jmol.scriptext.ScriptExt;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class CmdExt
extends ScriptExt {
    static final int ERROR_invalidArgument = 22;

    @Override
    public String dispatch(int iTok, boolean b, T[] st) throws ScriptException {
        this.chk = this.e.chk;
        this.slen = this.e.slen;
        this.st = st;
        switch (iTok) {
            case 1073741866: {
                st[0].value = this.prepareBinaryOutput((SV)st[0]);
                return null;
            }
            case 4098: {
                this.assign();
                break;
            }
            case 134221829: {
                this.cache();
                break;
            }
            case 4102: {
                this.calculate();
                break;
            }
            case 4103: {
                this.capture();
                break;
            }
            case 4105: {
                this.centerAt();
                break;
            }
            case 134221831: {
                this.compare();
                break;
            }
            case 528395: {
                this.console();
                break;
            }
            case 4106: {
                this.connect(1);
                break;
            }
            case 1094717448: {
                this.configuration();
                break;
            }
            case 134221834: {
                this.data();
                break;
            }
            case 1613238294: {
                this.connect(0);
                break;
            }
            case 4120: {
                this.image();
                break;
            }
            case 4124: {
                this.macro();
                break;
            }
            case 4125: {
                this.mapProperty();
                break;
            }
            case 4126: {
                this.minimize();
                break;
            }
            case 1275072532: {
                this.modulation();
                break;
            }
            case 4130: {
                this.mutate();
                break;
            }
            case 4131: {
                this.navigate();
                break;
            }
            case 4133: 
            case 4138: 
            case 134221850: {
                this.plot(st);
                break;
            }
            case 134222350: {
                this.show();
                break;
            }
            case 528443: {
                this.stereo();
                break;
            }
            case 1814695966: {
                this.unitcell(b ? 2 : 1);
                break;
            }
            case 134221856: {
                return this.write((T[])(b ? st : null));
            }
            case 6: {
                this.measure();
                break;
            }
            case 21: {
                this.polyhedra();
                break;
            }
            case 20: {
                this.ellipsoid();
                break;
            }
            case 4: {
                this.struts();
            }
        }
        return null;
    }

    private void macro() throws ScriptException {
        String key = this.e.optParameterAsString(1);
        if (key.length() == 0) {
            return;
        }
        if (this.chk) {
            return;
        }
        String macro = JC.getMacro(key);
        if (macro == null) {
            this.showString("macro " + key + " could not be found. Current macros include:\n" + JC.getMacroList());
            return;
        }
        this.showString("running " + macro);
        this.e.cmdScript(4124, macro, null);
    }

    public boolean evalParallel(ScriptContext context, ShapeManager shapeManager) {
        this.chk = this.e.chk;
        this.slen = this.e.slen;
        ScriptEval se = new ScriptEval().setViewer(this.vwr);
        se.historyDisabled = true;
        se.compiler = new ScriptCompiler(this.vwr);
        se.sm = shapeManager;
        try {
            se.restoreScriptContext(context, true, false, false);
            se.allowJSThreads = false;
            se.dispatchCommands(false, false, false);
        }
        catch (Exception ex) {
            this.e.vwr.setStringProperty("_errormessage", "" + ex);
            if (se.thisContext == null) {
                Logger.error("Error evaluating context " + ex);
                if (!this.vwr.isJS) {
                    ex.printStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    public Object getBitsetIdent(BS bs, String label, Object tokenValue, boolean useAtomMap, int index, boolean isExplicitlyAll) {
        int j;
        Map<String, Object> htValues;
        int[] indices;
        boolean haveIndex;
        boolean isAtoms;
        boolean bl = isAtoms = !(tokenValue instanceof BondSet);
        if (isAtoms) {
            if (label == null) {
                label = this.vwr.getStandardLabelFormat(0);
            } else if (label.length() == 0) {
                label = "%[label]";
            }
        }
        int pt = label == null ? -1 : label.indexOf("%");
        boolean bl2 = haveIndex = index != Integer.MAX_VALUE;
        if (bs == null || this.chk || isAtoms && pt < 0) {
            String[] stringArray;
            if (label == null) {
                label = "";
            }
            if (isExplicitlyAll) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = label;
            } else {
                stringArray = label;
            }
            return stringArray;
        }
        ModelSet modelSet = this.vwr.ms;
        int n = 0;
        LabelToken labeler = modelSet.getLabeler();
        int[] nArray = indices = isAtoms || !useAtomMap ? null : ((BondSet)tokenValue).associatedAtoms;
        if (indices == null && label != null && label.indexOf("%D") > 0) {
            indices = this.vwr.ms.getAtomIndices(bs);
        }
        boolean asIdentity = label == null || label.length() == 0;
        Map<String, Object> map = htValues = isAtoms || asIdentity ? null : LabelToken.getBondLabelValues();
        LabelToken[] tokens = asIdentity ? null : (isAtoms ? LabelToken.compile(this.vwr, (String)label, '\u0000', null) : LabelToken.compile(this.vwr, (String)label, '\u0001', htValues));
        int nmax = haveIndex ? 1 : bs.cardinality();
        String[] sout = new String[nmax];
        P3 ptTemp = new P3();
        int n2 = j = haveIndex ? index : bs.nextSetBit(0);
        while (j >= 0) {
            String str;
            if (isAtoms) {
                str = asIdentity ? modelSet.at[j].getInfo() : LabelToken.formatLabelAtomArray(this.vwr, modelSet.at[j], tokens, '\u0000', indices, ptTemp);
            } else {
                Bond bond = modelSet.bo[j];
                str = asIdentity ? bond.getIdentity() : LabelToken.formatLabelBond(this.vwr, bond, tokens, htValues, indices, ptTemp);
            }
            str = PT.formatStringI(str, "#", n + 1);
            sout[n++] = str;
            if (haveIndex) break;
            j = bs.nextSetBit(j + 1);
        }
        return nmax == 1 && !isExplicitlyAll ? sout[0] : sout;
    }

    public int getLoadSymmetryParams(int i, SB sOptions, Map<String, Object> htParams) throws ScriptException {
        ScriptEval eval = this.e;
        this.chk = eval.chk;
        this.slen = eval.slen;
        P3 lattice = null;
        int tok = this.tokAt(i);
        if (tok == 1073742332 || tok == 8) {
            lattice = this.getPoint3f(i, false);
            i = eval.iToken + 1;
            tok = this.tokAt(i);
        }
        switch (tok) {
            case 1073741938: 
            case 0x40000100: 
            case 1073742114: 
            case 1073742152: 
            case 1073742163: 
            case 1094713350: 
            case 1814695966: {
                if (lattice == null) {
                    lattice = P3.new3(555.0f, 555.0f, -1.0f);
                }
                eval.iToken = i - 1;
            }
        }
        P3 offset = null;
        if (lattice != null) {
            SymmetryInterface sg;
            htParams.put("lattice", lattice);
            i = eval.iToken + 1;
            sOptions.append(" {" + (int)lattice.x + " " + (int)lattice.y + " " + (int)lattice.z + "}");
            i = this.checkPacked(i, htParams, sOptions);
            if (this.tokAt(i) == 1094713350) {
                htParams.put("centroid", Boolean.TRUE);
                sOptions.append(" CENTROID");
                ++i;
                i = this.checkPacked(i, htParams, sOptions);
            }
            if (this.tokAt(i) == 1073742163) {
                Object supercell;
                sOptions.append(" SUPERCELL ");
                if (eval.isPoint3f(++i)) {
                    P3 pt = this.getPoint3f(i, false);
                    if (pt.x != (float)((int)pt.x) || pt.y != (float)((int)pt.y) || pt.z != (float)((int)pt.z) || pt.x < 1.0f || pt.y < 1.0f || pt.z < 1.0f) {
                        eval.iToken = i;
                        this.invArg();
                    }
                    supercell = pt;
                    i = eval.iToken;
                } else {
                    supercell = this.stringParameter(i);
                }
                sOptions.append(Escape.e(supercell));
                htParams.put("supercell", supercell);
                ++i;
                i = this.checkPacked(i, htParams, sOptions);
            }
            float distance = 0.0f;
            if (this.tokAt(i) == 1073742114) {
                int n = ++i;
                ++i;
                distance = this.floatParameter(n);
                sOptions.append(" range " + distance);
            }
            htParams.put("symmetryRange", Float.valueOf(distance));
            String spacegroup = null;
            int iGroup = Integer.MIN_VALUE;
            if (this.tokAt(i) == 1073742152) {
                int n = ++i;
                ++i;
                spacegroup = PT.rep(this.paramAsStr(n), "''", "\"");
                sOptions.append(" spacegroup " + PT.esc(spacegroup));
                if (spacegroup.equalsIgnoreCase("ignoreOperators")) {
                    iGroup = -999;
                } else {
                    if (spacegroup.length() == 0) {
                        sg = this.vwr.getCurrentUnitCell();
                        if (sg != null) {
                            spacegroup = sg.getSpaceGroupName();
                        }
                    } else if (spacegroup.indexOf(",") >= 0 && lattice.x < 9.0f && lattice.y < 9.0f && lattice.z == 0.0f) {
                        spacegroup = spacegroup + "#doNormalize=0";
                    }
                    htParams.put("spaceGroupName", spacegroup);
                    iGroup = -2;
                }
            }
            float[] fparams = null;
            if (this.tokAt(i) == 1814695966) {
                String s;
                if ((s = eval.optParameterAsString(++i)).length() == 0) {
                    sg = this.vwr.getCurrentUnitCell();
                    if (sg != null) {
                        fparams = sg.getUnitCellAsArray(true);
                        offset = sg.getCartesianOffset();
                    }
                } else if (this.tokAt(i) == 4) {
                    fparams = new float[6];
                    SimpleUnitCell.setOabc(s, fparams, null);
                } else {
                    fparams = eval.floatParameterSet(i, 6, 9);
                }
                if (fparams == null || fparams.length != 6 && fparams.length != 9) {
                    this.invArg();
                }
                sOptions.append(" unitcell [");
                for (int j = 0; j < fparams.length; ++j) {
                    sOptions.append((j == 0 ? "" : " ") + fparams[j]);
                }
                sOptions.append("]");
                htParams.put("unitcell", fparams);
                if (iGroup == Integer.MIN_VALUE) {
                    iGroup = -1;
                }
                i = eval.iToken + 1;
            }
            if (iGroup != Integer.MIN_VALUE) {
                htParams.put("spaceGroupIndex", iGroup);
            }
        }
        if (offset != null) {
            eval.coordinatesAreFractional = false;
        } else if (this.tokAt(i) == 1073742066) {
            offset = this.getPoint3f(++i, true);
        }
        if (offset != null) {
            if (eval.coordinatesAreFractional) {
                offset.setT(eval.fractionalPoint);
                htParams.put("unitCellOffsetFractional", eval.coordinatesAreFractional ? Boolean.TRUE : Boolean.FALSE);
                sOptions.append(" offset {" + offset.x + " " + offset.y + " " + offset.z + "/1}");
            } else {
                sOptions.append(" offset " + Escape.eP(offset));
            }
            htParams.put("unitCellOffset", offset);
            i = eval.iToken + 1;
        }
        return i;
    }

    private int checkPacked(int i, Map<String, Object> htParams, SB sOptions) throws ScriptException {
        switch (this.tokAt(i)) {
            case 1073741938: {
                htParams.put("packed", Boolean.TRUE);
                T3[] pts = null;
                int tok = this.tokAt(++i);
                switch (tok) {
                    case 1678381065: 
                    case 1814695966: {
                        break;
                    }
                    default: {
                        if (this.e.isArrayParameter(i)) {
                            pts = this.e.getPointArray(i, -1, false);
                            i = this.e.iToken;
                            break;
                        }
                        if (this.isFloatParameter(i)) {
                            float d = this.floatParameter(i);
                            pts = new P3[]{new P3(), P3.new3(d, d, d)};
                            break;
                        }
                        pts = new P3[]{};
                        --i;
                    }
                }
                ++i;
                if (this.e.chk) {
                    return i;
                }
                switch (tok) {
                    case 1814695966: {
                        SymmetryInterface unitCell = this.vwr.getCurrentUnitCell();
                        if (unitCell != null) {
                            pts = BoxInfo.getUnitCellPoints(unitCell.getUnitCellVerticesNoOffset(), unitCell.getCartesianOffset());
                            break;
                        }
                    }
                    case 1678381065: {
                        pts = BoxInfo.getUnitCellPoints(this.vwr.ms.getBBoxVertices(), null);
                    }
                }
                switch (pts.length) {
                    case 2: {
                        P3 a = pts[1];
                        pts = new T3[]{pts[0], P3.newP(pts[0]), new P3(), new P3()};
                        pts[1].x = a.x;
                        pts[2].y = a.y;
                        pts[3].z = a.z;
                        break;
                    }
                    case 3: {
                        pts = new T3[]{new P3(), pts[0], pts[1], pts[2]};
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        pts = new T3[]{new P3(), P3.new3(10.0f, 0.0f, 0.0f), P3.new3(0.0f, 10.0f, 0.0f), P3.new3(0.0f, 0.0f, 10.0f)};
                    }
                }
                htParams.put("fillRange", pts);
                sOptions.append(" FILL [" + pts[0] + pts[1] + pts[2] + pts[3] + "]");
                break;
            }
            case 0x40000100: {
                float f = Float.NaN;
                if (this.isFloatParameter(++i)) {
                    f = this.floatParameter(i++);
                }
                if (this.e.chk) break;
                htParams.put("packed", Boolean.TRUE);
                sOptions.append(" PACKED");
                if (Float.isNaN(f)) break;
                htParams.put("packingError", Float.valueOf(f));
                sOptions.append(" " + f);
            }
        }
        return i;
    }

    private void cache() throws ScriptException {
        int tok = this.tokAt(1);
        String fileName = null;
        int n = 2;
        switch (tok) {
            case 1073742119: 
            case 1275069441: {
                fileName = this.e.optParameterAsString(n++);
            }
            case 1073741882: {
                int nBytes;
                this.checkLength(n);
                if (this.chk) break;
                if ("all".equals(fileName)) {
                    fileName = null;
                }
                this.showString((nBytes = this.vwr.cacheFileByName(fileName, tok == 1275069441)) < 0 ? "cache cleared" : nBytes + " bytes " + (tok == 1275069441 ? " cached" : " removed"));
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void calculate() throws ScriptException {
        boolean isSurface = false;
        boolean asDSSP = false;
        BS bs1 = null;
        BS bs2 = null;
        ScriptEval eval = this.e;
        int n = Integer.MIN_VALUE;
        int version = 2;
        eval.iToken = eval.slen;
        if (eval.iToken >= 2) {
            eval.clearDefinedVariableAtomSets();
            switch (this.getToken((int)1).tok) {
                case 0x40000000: {
                    this.checkLength(2);
                    break;
                }
                case 1086324752: {
                    eval.iToken = 1;
                    bs1 = this.slen == 2 ? null : this.atomExpressionAt(2);
                    eval.checkLast(eval.iToken);
                    if (!this.chk) {
                        this.vwr.calculateChirality(bs1);
                    }
                    return;
                }
                case 1631586315: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    n = this.vwr.calculateFormalCharges(null);
                    this.showString(GT.i(GT._("{0} charges modified"), n));
                    return;
                }
                case 1075838996: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.ms.assignAromaticBondsBs(true, null);
                    }
                    return;
                }
                case 1613238294: {
                    if (eval.slen != 2) {
                        asDSSP = this.tokAt(++eval.iToken) == 1639976963;
                        bs1 = asDSSP ? this.vwr.bsA() : this.atomExpressionAt(eval.iToken);
                        if (!asDSSP && !(asDSSP = this.tokAt(++eval.iToken) == 1639976963)) {
                            bs2 = this.atomExpressionAt(eval.iToken);
                        }
                    }
                    if (this.chk) {
                        return;
                    }
                    n = this.vwr.autoHbond(bs1, bs2, false);
                    if (n != Integer.MIN_VALUE) {
                        eval.report(GT.i(GT._("{0} hydrogen bonds"), Math.abs(n)), false);
                    }
                    return;
                }
                case 1612709900: {
                    boolean andBond;
                    boolean bl = andBond = this.tokAt(2) == 1073742335;
                    if (andBond) {
                        ++eval.iToken;
                    }
                    bs1 = this.slen == (andBond ? 3 : 2) ? null : this.atomExpressionAt(andBond ? 3 : 2);
                    eval.checkLast(eval.iToken);
                    if (!this.chk) {
                        this.vwr.addHydrogens(bs1, false, false);
                        if (andBond) {
                            if (bs1 == null) {
                                bs1 = this.vwr.bsA();
                            }
                            this.vwr.makeConnections(0.1f, 1.0E8f, 515, 1073742025, bs1, bs1, null, false, false, 0.0f);
                            this.vwr.ms.assignAromaticBondsBs(true, null);
                        }
                    }
                    return;
                }
                case 1111492619: {
                    eval.iToken = 1;
                    bs1 = this.slen == 2 ? null : this.atomExpressionAt(2);
                    eval.checkLast(eval.iToken);
                    if (!this.chk) {
                        eval.getPartialCharges(bs1);
                    }
                    return;
                }
                case 0x8000022: 
                case 1088421903: {
                    if (!this.chk) {
                        if (this.tokAt(2) == 1275203608) {
                            String id = this.tokAt(3) == 4 ? this.stringParameter(3) : null;
                            bs1 = id != null || this.slen == 3 ? null : this.atomExpressionAt(3);
                            Object[] data = new Object[]{id, null, bs1};
                            this.showString(eval.getShapePropertyData(21, "symmetry", data) ? (String)data[1] : "");
                        } else {
                            this.showString(this.vwr.ms.calculatePointGroup(this.vwr.bsA()));
                        }
                    }
                    return;
                }
                case 1111490574: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.calculateStraightness();
                        this.vwr.addStateScript("set quaternionFrame '" + this.vwr.getQuaternionFrame() + "'; calculate straightness", false, true);
                    }
                    return;
                }
                case 1639976963: {
                    bs1 = this.slen < 4 || this.isFloatParameter(3) ? null : this.atomExpressionAt(2);
                    switch (this.tokAt(++eval.iToken)) {
                        case 4138: {
                            break;
                        }
                        case 1111490587: {
                            if (this.chk) {
                                return;
                            }
                            eval.showString(this.vwr.getAnnotationParser(true).calculateDSSRStructure(this.vwr, bs1));
                            return;
                        }
                        case 1073741915: {
                            asDSSP = true;
                            version = this.slen == eval.iToken + 1 ? 2 : (int)this.floatParameter(++eval.iToken);
                            break;
                        }
                        case 0: {
                            asDSSP = this.vwr.getBoolean(603979826);
                            break;
                        }
                        default: {
                            this.invArg();
                        }
                    }
                    if (!this.chk) {
                        this.showString(this.vwr.calculateStructures(bs1, asDSSP, true, version));
                    }
                    return;
                }
                case 659482: {
                    bs1 = eval.iToken + 1 < this.slen ? this.atomExpressionAt(++eval.iToken) : null;
                    bs2 = eval.iToken + 1 < this.slen ? this.atomExpressionAt(++eval.iToken) : null;
                    this.checkLength(++eval.iToken);
                    if (!this.chk) {
                        n = this.vwr.calculateStruts(bs1, bs2);
                        if (n > 0) {
                            this.setShapeProperty(1, "type", 32768);
                            eval.setShapePropertyBs(1, "color", 0xFFFFFF, null);
                            eval.setShapeTranslucency(1, "", "translucent", 0.5f, null);
                            this.setShapeProperty(1, "type", 1023);
                        }
                        this.showString(GT.i(GT._("{0} struts added"), n));
                    }
                    return;
                }
                case 2097180: {
                    isSurface = true;
                }
                case 1111490575: {
                    boolean isFrom = false;
                    switch (this.tokAt(2)) {
                        case 134217759: {
                            ++eval.iToken;
                            break;
                        }
                        case 0: {
                            isFrom = !isSurface;
                            break;
                        }
                        case 0x40000080: {
                            isFrom = true;
                            ++eval.iToken;
                            break;
                        }
                        default: {
                            isFrom = true;
                        }
                    }
                    bs1 = eval.iToken + 1 < this.slen ? this.atomExpressionAt(++eval.iToken) : this.vwr.bsA();
                    this.checkLength(++eval.iToken);
                    if (!this.chk) {
                        this.vwr.calculateSurface(bs1, isFrom ? Float.MAX_VALUE : -1.0f);
                    }
                    return;
                }
            }
        }
        eval.errorStr2(53, "CALCULATE", "aromatic? hbonds? hydrogen? formalCharge? partialCharge? pointgroup? straightness? structure? struts? surfaceDistance FROM? surfaceDistance WITHIN?");
    }

    private void capture() throws ScriptException {
        boolean isTransparent;
        if (!this.chk && !this.vwr.allowCapture()) {
            this.showString("Cannot capture on this platform");
            return;
        }
        Map<String, Object> params = this.vwr.captureParams;
        String type = params == null ? "GIF" : (String)params.get("type");
        float endTime = 0.0f;
        int mode = 0;
        int slen = this.e.slen;
        String fileName = "";
        boolean looping = this.vwr.am.animationReplayMode != 1073742070;
        int i = 1;
        int tok = this.tokAt(i);
        boolean bl = isTransparent = tok == 603979967;
        if (isTransparent) {
            tok = this.tokAt(++i);
        }
        switch (tok == 0 ? (tok = 102409) : tok) {
            case 4: {
                int pt;
                fileName = this.e.optParameterAsString(i++);
                if (fileName.length() == 0) {
                    mode = 102409;
                    break;
                }
                String lc = fileName.toLowerCase();
                if (lc.endsWith(".gift") || lc.endsWith(".pngt")) {
                    isTransparent = true;
                    fileName = fileName.substring(0, fileName.length() - 1);
                    lc = fileName.toLowerCase();
                } else if (!lc.endsWith(".gif") && !lc.contains(".png")) {
                    fileName = fileName + ".gif";
                }
                if (lc.endsWith(".png")) {
                    if (!lc.endsWith("0.png")) {
                        fileName = fileName.substring(0, fileName.length() - 4) + "0000.png";
                    }
                    type = "PNG";
                } else {
                    type = "GIF";
                }
                if (isTransparent) {
                    type = type + "T";
                }
                boolean streaming = (pt = fileName.indexOf("0000.")) < 0 || pt != fileName.lastIndexOf(".") - 4;
                boolean isRock = false;
                if (this.tokAt(i) == 528411) {
                    looping = true;
                    tok = this.tokAt(++i);
                }
                switch (this.tokAt(i)) {
                    case 1073742129: {
                        isRock = true;
                    }
                    case 1611141175: {
                        String s = null;
                        String axis = "y";
                        looping = true;
                        ++i;
                        if (isRock) {
                            int n;
                            if (i < slen && this.tokAt(i) != 2) {
                                axis = this.e.optParameterAsString(i++).toLowerCase();
                            }
                            s = "rotate Y 10 10;rotate Y -10 -10;rotate Y -10 -10;rotate Y 10 10";
                            int n2 = n = i < slen ? this.intParameter(i++) : 5;
                            s = n < 0 ? PT.rep(s, "10;", "" + -n + ";") : PT.rep(s, "10", "" + n);
                        } else {
                            if (i < slen) {
                                axis = this.e.optParameterAsString(i++).toLowerCase();
                            }
                            s = "rotate Y 360 30;";
                        }
                        if (this.chk) {
                            return;
                        }
                        this.vwr.setNavigationMode(false);
                        if (axis == "" || "xyz".indexOf(axis) < 0) {
                            axis = "y";
                        }
                        boolean wf = this.vwr.g.waitForMoveTo;
                        s = "set waitformoveto true;" + PT.rep(s, "Y", axis) + ";set waitformoveto " + wf;
                        s = "capture " + (isTransparent ? "transparent " : "") + PT.esc(fileName) + " LOOP;" + s + ";capture end;";
                        this.e.cmdScript(0, null, s);
                        return;
                    }
                    case 2: 
                    case 3: {
                        endTime = this.floatParameter(i++);
                    }
                }
                if (this.chk) {
                    return;
                }
                mode = 1073742031;
                params = new Hashtable<String, Object>();
                int fps = this.vwr.getInt(553648132);
                if (streaming) {
                    params.put("streaming", Boolean.TRUE);
                    if (!looping) {
                        this.showString(GT.o(GT._("Note: Enable looping using {0}"), new Object[]{"ANIMATION MODE LOOP"}));
                    }
                    this.showString(GT.o(GT._("Animation delay based on: {0}"), new Object[]{"ANIMATION FPS " + fps}));
                }
                params.put("captureFps", fps);
                break;
            }
            case 102409: 
            case 1073741874: {
                if (params != null) {
                    params.put("captureSilent", Boolean.TRUE);
                }
            }
            case 1073742334: 
            case 1073742335: {
                this.checkLength(-2);
                mode = tok;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (this.chk || params == null) {
            return;
        }
        params.put("type", type);
        Integer c = this.vwr.getBackgroundArgb();
        params.put("backgroundColor", c);
        params.put("fileName", fileName);
        params.put("quality", -1);
        params.put("endTime", endTime <= 0.0f ? -1L : System.currentTimeMillis() + (long)(endTime * 1000.0f));
        params.put("captureMode", T.nameOf(mode).toLowerCase());
        params.put("captureLooping", looping ? Boolean.TRUE : Boolean.FALSE);
        String msg = this.vwr.processWriteOrCapture(params);
        if (msg == null) {
            msg = "canceled";
        }
        Logger.info(msg);
    }

    private void centerAt() throws ScriptException {
        int tok = this.getToken((int)1).tok;
        switch (tok) {
            case 96: 
            case 0x40000002: 
            case 1678381065: {
                break;
            }
            default: {
                this.invArg();
            }
        }
        P3 pt = P3.new3(0.0f, 0.0f, 0.0f);
        if (this.slen == 5) {
            pt.x = this.floatParameter(2);
            pt.y = this.floatParameter(3);
            pt.z = this.floatParameter(4);
        } else if (this.e.isCenterParameter(2)) {
            pt = this.centerParameter(2);
            this.e.checkLast(this.e.iToken);
        } else {
            this.checkLength(2);
        }
        if (!this.chk && !this.vwr.isJmolDataFrame()) {
            this.vwr.tm.setCenterAt(tok, pt);
        }
    }

    private void compare() throws ScriptException {
        BS[] bsFrames;
        boolean isAtoms;
        boolean isToSubsetOfFrom;
        ScriptEval eval = this.e;
        boolean isQuaternion = false;
        boolean doRotate = false;
        boolean doTranslate = false;
        boolean doAnimate = false;
        boolean isFlexFit = false;
        Quat[] data1 = null;
        Quat[] data2 = null;
        BS bsAtoms1 = null;
        BS bsAtoms2 = null;
        Lst<Object[]> vAtomSets = null;
        Lst<Object[]> vQuatSets = null;
        eval.iToken = 0;
        float nSeconds = this.isFloatParameter(1) ? this.floatParameter(++eval.iToken) : Float.NaN;
        BS bsFrom = this.atomExpressionAt(++eval.iToken);
        P3[] coordTo = null;
        BS bsTo = null;
        if (eval.isArrayParameter(++eval.iToken)) {
            coordTo = eval.getPointArray(eval.iToken, -1, false);
        } else if (this.tokAt(eval.iToken) != 0x44000001) {
            bsTo = this.atomExpressionAt(eval.iToken);
        }
        BS bsSubset = null;
        boolean isSmiles = false;
        String strSmiles = null;
        BS bs = BSUtil.copy(bsFrom);
        if (bsTo != null) {
            bs.or(bsTo);
        }
        boolean isFrames = isToSubsetOfFrom = coordTo == null && bsTo != null && bs.equals(bsFrom);
        block19: for (int i = eval.iToken + 1; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 4115: {
                    isFrames = true;
                    continue block19;
                }
                case 134218757: {
                    isSmiles = true;
                    if (this.tokAt(i + 1) != 4) {
                        strSmiles = "*";
                        continue block19;
                    }
                }
                case 0x8000404: {
                    strSmiles = this.stringParameter(++i);
                    continue block19;
                }
                case 1677721602: {
                    isFlexFit = true;
                    doRotate = true;
                    strSmiles = this.paramAsStr(++i);
                    if (!strSmiles.equalsIgnoreCase("SMILES")) continue block19;
                    isSmiles = true;
                    strSmiles = "*";
                    continue block19;
                }
                case 2: 
                case 3: {
                    nSeconds = Math.abs(this.floatParameter(i));
                    if (!(nSeconds > 0.0f)) continue block19;
                    doAnimate = true;
                    continue block19;
                }
                case 0x10000030: {
                    continue block19;
                }
                case 2109448: {
                    bsSubset = this.atomExpressionAt(++i);
                    i = eval.iToken;
                    continue block19;
                }
                case 10: 
                case 1073742325: {
                    int tok;
                    if (vQuatSets != null) {
                        this.invArg();
                    }
                    bsAtoms1 = this.atomExpressionAt(eval.iToken);
                    int n = tok = isToSubsetOfFrom ? 0 : this.tokAt(eval.iToken + 1);
                    BS bS = coordTo == null && eval.isArrayParameter(eval.iToken + 1) ? null : (bsAtoms2 = tok == 10 || tok == 1073742325 ? this.atomExpressionAt(++eval.iToken) : BSUtil.copy(bsAtoms1));
                    if (bsSubset != null) {
                        bsAtoms1.and(bsSubset);
                        if (bsAtoms2 != null) {
                            bsAtoms2.and(bsSubset);
                        }
                    }
                    if (bsAtoms2 == null) {
                        coordTo = eval.getPointArray(++eval.iToken, -1, false);
                    } else {
                        bsAtoms2.and(bsTo);
                    }
                    if (vAtomSets == null) {
                        vAtomSets = new Lst<Object[]>();
                    }
                    vAtomSets.addLast(new BS[]{bsAtoms1, bsAtoms2});
                    i = eval.iToken;
                    continue block19;
                }
                case 7: {
                    if (vAtomSets != null) {
                        this.invArg();
                    }
                    isQuaternion = true;
                    data1 = eval.getQuaternionArray(((SV)eval.theToken).getList(), 1073742001);
                    this.getToken(++i);
                    data2 = eval.getQuaternionArray(((SV)eval.theToken).getList(), 1073742001);
                    if (vQuatSets == null) {
                        vQuatSets = new Lst<Object[]>();
                    }
                    vQuatSets.addLast(new Object[]{data1, data2});
                    continue block19;
                }
                case 1073742077: {
                    isQuaternion = true;
                    continue block19;
                }
                case 134217751: 
                case 0x44000001: {
                    isQuaternion = false;
                    continue block19;
                }
                case 528432: {
                    doRotate = true;
                    continue block19;
                }
                case 4160: {
                    doTranslate = true;
                    continue block19;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (this.chk) {
            return;
        }
        if (isFrames) {
            nSeconds = 0.0f;
        }
        if (Float.isNaN(nSeconds) || nSeconds < 0.0f) {
            nSeconds = 1.0f;
        } else if (!doRotate && !doTranslate) {
            doTranslate = true;
            doRotate = true;
        }
        doAnimate = nSeconds != 0.0f;
        boolean bl = isAtoms = !isQuaternion && strSmiles == null || coordTo != null;
        if (isAtoms) {
            Interface.getInterface("javajs.util.Eigen", this.vwr, "script");
        }
        if (vAtomSets == null && vQuatSets == null) {
            if (bsSubset == null) {
                BS bS = bsAtoms1 = isAtoms ? this.vwr.getAtomBitSet("spine") : new BS();
                if (bsAtoms1.nextSetBit(0) < 0) {
                    bsAtoms1 = bsFrom;
                    bsAtoms2 = bsTo;
                } else {
                    bsAtoms2 = BSUtil.copy(bsAtoms1);
                    bsAtoms1.and(bsFrom);
                    bsAtoms2.and(bsTo);
                }
            } else {
                bsAtoms1 = BSUtil.copy(bsFrom);
                bsAtoms2 = BSUtil.copy(bsTo);
                bsAtoms1.and(bsSubset);
                bsAtoms2.and(bsSubset);
                bsAtoms1.and(bsFrom);
                bsAtoms2.and(bsTo);
            }
            vAtomSets = new Lst();
            vAtomSets.addLast(new BS[]{bsAtoms1, bsAtoms2});
        }
        if (isFrames) {
            BS bsModels = this.vwr.ms.getModelBS(bsFrom, false);
            bsFrames = new BS[bsModels.cardinality()];
            int i = 0;
            int iModel = bsModels.nextSetBit(0);
            while (iModel >= 0) {
                bsFrames[i] = this.vwr.getModelUndeletedAtomsBitSet(iModel);
                iModel = bsModels.nextSetBit(iModel + 1);
                ++i;
            }
        } else {
            bsFrames = new BS[]{bsFrom};
        }
        for (int iFrame = 0; iFrame < bsFrames.length; ++iFrame) {
            bsFrom = bsFrames[iFrame];
            float[] retStddev = new float[2];
            Quat q = null;
            Lst<Quat> vQ = new Lst<Quat>();
            P3[][] centerAndPoints = null;
            Lst<Object[]> vAtomSets2 = isFrames ? new Lst<Object[]>() : vAtomSets;
            for (int i = 0; i < vAtomSets.size(); ++i) {
                BS[] bss = (BS[])vAtomSets.get(i);
                if (isFrames) {
                    bss = new BS[]{BSUtil.copy(bss[0]), bss[1]};
                    vAtomSets2.addLast(bss);
                }
                bss[0].and(bsFrom);
            }
            P3 center = null;
            V3 translation = null;
            if (isAtoms) {
                if (coordTo != null) {
                    vAtomSets2.clear();
                    vAtomSets2.addLast(new Object[]{bsAtoms1, coordTo});
                }
                try {
                    centerAndPoints = this.vwr.getCenterAndPoints(vAtomSets2, true);
                }
                catch (Exception ex) {
                    this.invArg();
                }
                int n = centerAndPoints[0].length - 1;
                for (int i = 1; i <= n; ++i) {
                    P3 aij = centerAndPoints[0][i];
                    P3 bij = centerAndPoints[1][i];
                    if (!(aij instanceof Atom) || !(bij instanceof Atom)) break;
                    Logger.info(" atom 1 " + ((Atom)aij).getInfo() + "\tatom 2 " + ((Atom)bij).getInfo());
                }
                q = Measure.calculateQuaternionRotation(centerAndPoints, retStddev);
                float r0 = Float.isNaN(retStddev[1]) ? Float.NaN : (float)Math.round(retStddev[0] * 100.0f) / 100.0f;
                float r1 = Float.isNaN(retStddev[1]) ? Float.NaN : (float)Math.round(retStddev[1] * 100.0f) / 100.0f;
                this.showString("RMSD " + r0 + " --> " + r1 + " Angstroms");
            } else if (isQuaternion) {
                if (vQuatSets == null) {
                    for (int i = 0; i < vAtomSets2.size(); ++i) {
                        BS[] bss = (BS[])vAtomSets2.get(i);
                        data1 = this.vwr.getAtomGroupQuaternions(bss[0], Integer.MAX_VALUE);
                        data2 = this.vwr.getAtomGroupQuaternions(bss[1], Integer.MAX_VALUE);
                        for (int j = 0; j < data1.length && j < data2.length; ++j) {
                            vQ.addLast(data2[j].div(data1[j]));
                        }
                    }
                } else {
                    for (int j = 0; j < data1.length && j < data2.length; ++j) {
                        vQ.addLast(data2[j].div(data1[j]));
                    }
                }
                retStddev[0] = 0.0f;
                data1 = vQ.toArray(new Quat[vQ.size()]);
                q = Quat.sphereMean(data1, retStddev, 1.0E-4f);
                this.showString("RMSD = " + retStddev[0] + " degrees");
            } else {
                float stddev;
                M4 m4 = new M4();
                center = new P3();
                if (("*".equals(strSmiles) || "".equals(strSmiles)) && bsFrom != null) {
                    try {
                        strSmiles = this.vwr.getSmiles(bsFrom);
                    }
                    catch (Exception ex) {
                        eval.evalError(ex.getMessage(), null);
                    }
                }
                if (isFlexFit) {
                    float[] list;
                    if (bsFrom == null || bsTo == null || (list = eval.getSmilesExt().getFlexFitList(bsFrom, bsTo, strSmiles, !isSmiles)) == null) {
                        return;
                    }
                    this.vwr.setDihedrals(list, null, 1.0f);
                }
                if (Float.isNaN(stddev = eval.getSmilesExt().getSmilesCorrelation(bsFrom, bsTo, strSmiles, null, null, m4, null, false, null, center, false, 0x20 | (isSmiles ? 1 : 2)))) {
                    this.showString("structures do not match");
                    return;
                }
                if (doTranslate) {
                    translation = new V3();
                    m4.getTranslation(translation);
                }
                if (doRotate) {
                    M3 m3 = new M3();
                    m4.getRotationScale(m3);
                    q = Quat.newM(m3);
                }
                this.showString("RMSD = " + stddev + " Angstroms");
            }
            if (centerAndPoints != null) {
                center = centerAndPoints[0][0];
            }
            if (center == null) {
                centerAndPoints = this.vwr.getCenterAndPoints(vAtomSets2, true);
                center = centerAndPoints[0][0];
            }
            P3 pt1 = new P3();
            float endDegrees = Float.NaN;
            if (doTranslate) {
                if (translation == null) {
                    translation = V3.newVsub(centerAndPoints[1][0], center);
                }
                endDegrees = 1.0E10f;
            }
            if (doRotate) {
                if (q == null) {
                    eval.evalError("option not implemented", null);
                }
                pt1.add2(center, q.getNormal());
                endDegrees = q.getTheta();
                if (endDegrees == 0.0f && doTranslate) {
                    if (translation.length() > 0.01f) {
                        endDegrees = 1.0E10f;
                    } else {
                        doAnimate = false;
                        doTranslate = false;
                        doRotate = false;
                    }
                }
            }
            if (Float.isNaN(endDegrees) || Float.isNaN(pt1.x)) continue;
            Lst<P3> ptsB = null;
            if (doRotate && doTranslate && nSeconds != 0.0f) {
                Lst<P3> ptsA = this.vwr.ms.getAtomPointVector(bsFrom);
                M4 m4 = ScriptMathProcessor.getMatrix4f(q.getMatrix(), translation);
                ptsB = Measure.transformPoints(ptsA, m4, center);
            }
            if (!eval.useThreads()) {
                doAnimate = false;
            }
            if (!this.vwr.rotateAboutPointsInternal(eval, center, pt1, endDegrees / nSeconds, endDegrees, doAnimate, bsFrom, translation, ptsB, null, null) || !doAnimate || !eval.isJS) continue;
            throw new ScriptInterruption(eval, "compare", 1);
        }
    }

    private void configuration() throws ScriptException {
        BS bsAtoms = null;
        BS bsSelected = this.vwr.bsA();
        if (this.slen == 1) {
            if (this.chk) {
                return;
            }
            bsAtoms = this.vwr.ms.setConformation(bsSelected);
            this.vwr.ms.addStateScript("select", null, bsSelected, null, "configuration", true, false);
        } else if (this.isFloatParameter(1)) {
            int n = this.intParameter(this.e.checkLast(1));
            if (this.chk) {
                return;
            }
            bsAtoms = this.vwr.ms.getConformation(this.vwr.am.cmi, n - 1, true, null);
            this.vwr.addStateScript("configuration " + n + ";", true, false);
        } else {
            bsAtoms = this.atomExpressionAt(1);
            if (this.chk) {
                return;
            }
            int n = this.intParameter(this.e.checkLast(this.e.iToken + 1));
            this.vwr.addStateScript("configuration " + Escape.eBS(bsAtoms) + " " + n + ";", true, false);
            bsAtoms = this.vwr.ms.getConformation(this.vwr.am.cmi, n - 1, true, bsAtoms);
        }
        this.setShapeProperty(1, "type", 30720);
        this.e.setShapeSizeBs(1, 0, bsAtoms);
        this.vwr.autoHbond(bsAtoms, bsAtoms, true);
        this.vwr.select(bsAtoms, false, 0, this.e.tQuiet);
    }

    private void measure() throws ScriptException {
        ScriptEval eval = this.e;
        String id = null;
        int pt = 1;
        short colix = 0;
        float[] offset = null;
        if (this.slen == 2) {
            switch (this.tokAt(1)) {
                case 1073742334: {
                    this.setShapeProperty(6, "hideAll", Boolean.TRUE);
                    return;
                }
                case 12291: {
                    if (!this.chk) {
                        this.vwr.clearAllMeasurements();
                    }
                    return;
                }
            }
        }
        this.vwr.shm.loadShape(6);
        switch (this.tokAt(1)) {
            case 0x8000404: {
                String smarts = this.stringParameter(this.slen == 3 ? 2 : 4);
                if (this.chk) {
                    return;
                }
                Node[] atoms = this.vwr.ms.at;
                int ac = this.vwr.ms.ac;
                int[][] maps = null;
                try {
                    maps = this.vwr.getSmilesMatcher().getCorrelationMaps(smarts, atoms, ac, this.vwr.bsA(), 2);
                }
                catch (Exception ex) {
                    eval.evalError(ex.getMessage(), null);
                }
                if (maps == null) {
                    return;
                }
                this.setShapeProperty(6, "maps", maps);
                return;
            }
        }
        switch (this.slen) {
            case 2: {
                switch (this.getToken((int)pt).tok) {
                    case 0: 
                    case 1073742335: {
                        this.vwr.shm.loadShape(6);
                        this.setShapeProperty(6, "hideAll", Boolean.FALSE);
                        return;
                    }
                    case 1073742001: {
                        if (!this.chk) {
                            eval.showStringPrint(this.vwr.getMeasurementInfoAsString(), false);
                        }
                        return;
                    }
                    case 4: {
                        this.setShapeProperty(6, "setFormats", this.stringParameter(1));
                        return;
                    }
                }
                eval.errorStr(24, "ON, OFF, DELETE");
                break;
            }
            case 3: {
                switch (this.getToken((int)1).tok) {
                    case 12291: {
                        if (this.getToken((int)2).tok == 1073742327) {
                            if (!this.chk) {
                                this.vwr.clearAllMeasurements();
                            }
                        } else {
                            int i = this.intParameter(2) - 1;
                            if (!this.chk) {
                                this.vwr.deleteMeasurement(i);
                            }
                        }
                        return;
                    }
                }
            }
        }
        int nAtoms = 0;
        int expressionCount = 0;
        int modelIndex = -1;
        int atomIndex = -1;
        int ptFloat = -1;
        int[] countPlusIndexes = new int[5];
        float[] rangeMinMax = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        boolean isAll = false;
        boolean isAllConnected = false;
        boolean isNotConnected = false;
        boolean isRange = true;
        RadiusData rd = null;
        Boolean intramolecular = null;
        int tokAction = 268435538;
        String strFormat = null;
        Font font = null;
        Lst<Object> points = new Lst<Object>();
        BS bs = new BS();
        JSONEncodable value = null;
        TickInfo tickInfo = null;
        int nBitSets = 0;
        int mad = 0;
        String alignment = null;
        block50: for (int i = 1; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1073741974: {
                    if (i != 1) {
                        this.invArg();
                    }
                    id = eval.optParameterAsString(++i);
                    continue block50;
                }
                case 0x40000000: {
                    eval.errorStr(24, "ALL, ALLCONNECTED, DELETE");
                    continue block50;
                }
                default: {
                    this.error(15);
                    continue block50;
                }
                case 0x10000070: {
                    if (this.tokAt(i + 1) != 0x8000008) {
                        this.invArg();
                    }
                    ++i;
                    isNotConnected = true;
                    continue block50;
                }
                case 0x40000008: {
                    alignment = this.paramAsStr(++i).toLowerCase();
                    continue block50;
                }
                case 0x8000008: 
                case 0x4000000A: 
                case 1073742327: {
                    isAllConnected = eval.theTok == 0x4000000A;
                    atomIndex = -1;
                    isAll = true;
                    if (!isAllConnected || !isNotConnected) continue block50;
                    this.invArg();
                    continue block50;
                }
                case 1765808134: {
                    colix = C.getColix(eval.getArgbParam(++i));
                    i = eval.iToken;
                    continue block50;
                }
                case 1073742066: {
                    if (eval.isPoint3f(++i)) {
                        P3 p = this.getPoint3f(i, false);
                        offset = new float[]{1.0f, p.x, p.y, p.z, 0.0f, 0.0f, 0.0f};
                    } else {
                        offset = eval.floatParameterSet(i, 7, 7);
                    }
                    i = eval.iToken;
                    continue block50;
                }
                case 1073741917: 
                case 1665140738: {
                    mad = (int)((float)(eval.theTok == 1665140738 ? 2000 : 1000) * this.floatParameter(++i));
                    if (id == null || mad > 0) continue block50;
                    mad = -1;
                    continue block50;
                }
                case 3: {
                    if (rd != null) {
                        this.invArg();
                    }
                    isAll = true;
                    isRange = true;
                    ptFloat = (ptFloat + 1) % 2;
                    rangeMinMax[ptFloat] = this.floatParameter(i);
                    continue block50;
                }
                case 12291: {
                    if (tokAction != 268435538) {
                        this.invArg();
                    }
                    tokAction = 12291;
                    continue block50;
                }
                case 4114: {
                    float fontsize = this.floatParameter(++i);
                    String fontface = this.paramAsStr(++i);
                    String fontstyle = this.paramAsStr(++i);
                    if (this.chk) continue block50;
                    font = this.vwr.getFont3D(fontface, fontstyle, fontsize);
                    continue block50;
                }
                case 2: {
                    int iParam = this.intParameter(i);
                    if (isAll) {
                        isRange = true;
                        ptFloat = (ptFloat + 1) % 2;
                        rangeMinMax[ptFloat] = iParam;
                        continue block50;
                    }
                    atomIndex = this.vwr.ms.getFirstAtomIndexFromAtomNumber(iParam, this.vwr.getVisibleFramesBitSet());
                    if (!this.chk && atomIndex < 0) {
                        return;
                    }
                    if (value != null) {
                        this.invArg();
                    }
                    if ((countPlusIndexes[0] = ++nAtoms) > 4) {
                        eval.bad();
                    }
                    countPlusIndexes[nAtoms] = atomIndex;
                    continue block50;
                }
                case 1094713359: {
                    modelIndex = this.intParameter(++i);
                    continue block50;
                }
                case 1073742334: {
                    if (tokAction != 268435538) {
                        this.invArg();
                    }
                    tokAction = 1073742334;
                    continue block50;
                }
                case 1073742335: {
                    if (tokAction != 268435538) {
                        this.invArg();
                    }
                    tokAction = 1073742335;
                    continue block50;
                }
                case 1073742114: {
                    isAll = true;
                    isRange = true;
                    atomIndex = -1;
                    continue block50;
                }
                case 1073741989: 
                case 1073741990: {
                    intramolecular = eval.theTok == 1073741989;
                    isAll = true;
                    isNotConnected = eval.theTok == 1073741990;
                    continue block50;
                }
                case 1648363544: {
                    if (ptFloat >= 0) {
                        this.invArg();
                    }
                    if ((rd = eval.encodeRadiusParameter(i, false, true)) == null) {
                        return;
                    }
                    rd.values = rangeMinMax;
                    i = eval.iToken;
                    isNotConnected = true;
                    isAll = true;
                    intramolecular = false;
                    if (nBitSets != 1) continue block50;
                    ++nBitSets;
                    ++nAtoms;
                    BS bs2 = BSUtil.copy(bs);
                    BSUtil.invertInPlace(bs2, this.vwr.ms.ac);
                    bs2.and(this.vwr.ms.getAtomsWithinRadius(5.0f, bs, false, null));
                    points.addLast(bs2);
                    continue block50;
                }
                case 10: 
                case 12290: 
                case 1073742325: {
                    ++nBitSets;
                }
                case 8: 
                case 1073742330: 
                case 1073742332: {
                    if (atomIndex >= 0) {
                        this.invArg();
                    }
                    Object[] ret = new Object[1];
                    value = eval.centerParameter(i, ret);
                    if (ret[0] instanceof BS) {
                        bs = (BS)ret[0];
                        value = bs;
                        if (!this.chk && bs.length() == 0) {
                            return;
                        }
                    }
                    if (value instanceof P3) {
                        Point3fi v = new Point3fi();
                        v.setT((T3)value);
                        v.mi = (short)modelIndex;
                        value = v;
                    }
                    if ((nAtoms = ++expressionCount) > 4) {
                        eval.bad();
                    }
                    i = eval.iToken;
                    points.addLast(value);
                    continue block50;
                }
                case 4: {
                    strFormat = this.stringParameter(i);
                    continue block50;
                }
                case 1073742164: {
                    tickInfo = eval.tickParamAsStr(i, false, true, true);
                    i = eval.iToken;
                    tokAction = 12290;
                }
            }
        }
        if (rd != null && (ptFloat >= 0 || nAtoms != 2) || nAtoms < 2 && id == null && (tickInfo == null || nAtoms == 1)) {
            eval.bad();
        }
        if (strFormat != null && strFormat.indexOf(nAtoms + ":") != 0) {
            strFormat = nAtoms + ":" + strFormat;
        }
        if (isRange && rangeMinMax[1] < rangeMinMax[0]) {
            rangeMinMax[1] = rangeMinMax[0];
            float f = rangeMinMax[0] = rangeMinMax[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
        }
        if (this.chk) {
            return;
        }
        if (value != null || tickInfo != null) {
            if (rd == null) {
                rd = new RadiusData(rangeMinMax, 0.0f, null, null);
            }
            if (value == null) {
                tickInfo.id = "default";
            }
            if (value != null && strFormat != null && tokAction == 268435538) {
                tokAction = 12290;
            }
            Text text = null;
            if (font != null || alignment != null || strFormat != null && strFormat.indexOf(10) >= 0) {
                Text cfr_ignored_0 = (Text)Interface.getInterface("org.jmol.modelset.Text", this.vwr, "script");
                text = Text.newLabel(this.vwr, font, "", colix, (short)0, 0, 0.0f);
            }
            if (text != null) {
                text.pymolOffset = offset;
                text.setAlignmentLCR(alignment);
            }
            this.setShapeProperty(6, "measure", this.vwr.newMeasurementData(id, points).set(tokAction, null, rd, strFormat, null, tickInfo, isAllConnected, isNotConnected, intramolecular, isAll, mad, colix, text));
            return;
        }
        Object propertyValue = id == null ? countPlusIndexes : (Object)id;
        switch (tokAction) {
            case 12291: {
                this.setShapeProperty(6, "delete", propertyValue);
                break;
            }
            case 1073742335: {
                this.setShapeProperty(6, "show", propertyValue);
                break;
            }
            case 1073742334: {
                this.setShapeProperty(6, "hide", propertyValue);
                break;
            }
            default: {
                this.setShapeProperty(6, strFormat == null ? "toggle" : "toggleOn", propertyValue);
                if (strFormat == null) break;
                this.setShapeProperty(6, "setFormats", strFormat);
            }
        }
    }

    private void connect(int index) throws ScriptException {
        ScriptEval eval = this.e;
        float[] distances = new float[2];
        BS[] atomSets = new BS[2];
        atomSets[0] = atomSets[1] = this.vwr.bsA();
        float radius = Float.NaN;
        int[] colorArgb = new int[]{Integer.MIN_VALUE};
        int distanceCount = 0;
        int bondOrder = 131071;
        int operation = 1073742026;
        boolean isDelete = false;
        boolean haveType = false;
        boolean haveOperation = false;
        float translucentLevel = Float.MAX_VALUE;
        boolean isColorOrRadius = false;
        int nAtomSets = 0;
        int nDistances = 0;
        BS bsBonds = new BS();
        boolean isBonds = false;
        int expression2 = 0;
        int ptColor = 0;
        float energy = 0.0f;
        boolean addGroup = false;
        if (this.slen == 1) {
            if (!this.chk) {
                this.vwr.rebondState(eval.isStateScript);
            }
            return;
        }
        if (this.tokAt(1) == 1073877011) {
            if (!this.chk) {
                this.vwr.connectNBO(this.e.optParameterAsString(2));
            }
            return;
        }
        for (int i = index; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1073742334: 
                case 1073742335: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.rebondState(eval.isStateScript);
                    }
                    return;
                }
                case 2: 
                case 3: {
                    int bo;
                    if (nAtomSets > 0) {
                        if (haveType || isColorOrRadius) {
                            eval.error(23);
                        }
                        if ((bo = Edge.getBondOrderFromFloat(this.floatParameter(i))) == 131071) {
                            this.invArg();
                        }
                        bondOrder = bo;
                        haveType = true;
                        break;
                    }
                    if (++nDistances > 2) {
                        eval.bad();
                    }
                    float dist = this.floatParameter(i);
                    if (this.tokAt(i + 1) == 268435634) {
                        dist = -dist / 100.0f;
                        ++i;
                    }
                    distances[distanceCount++] = dist;
                    break;
                }
                case 10: 
                case 12290: 
                case 1073742325: {
                    if (nAtomSets > 2 || isBonds && nAtomSets > 0) {
                        eval.bad();
                    }
                    if (haveType || isColorOrRadius) {
                        this.invArg();
                    }
                    atomSets[nAtomSets++] = this.atomExpressionAt(i);
                    isBonds = eval.isBondSet;
                    if (nAtomSets == 2) {
                        int pt = eval.iToken;
                        for (int j = i; j < pt; ++j) {
                            if (this.tokAt(j) != 0x40000000 || !this.paramAsStr(j).equals("_1")) continue;
                            expression2 = i;
                            break;
                        }
                        eval.iToken = pt;
                    }
                    i = eval.iToken;
                    break;
                }
                case 1086324742: {
                    addGroup = true;
                    break;
                }
                case 603979967: 
                case 1073742074: 
                case 1765808134: {
                    isColorOrRadius = true;
                    translucentLevel = this.getColorTrans(eval, i, false, colorArgb);
                    i = eval.iToken;
                    break;
                }
                case 1073742086: {
                    boolean isAuto = this.tokAt(2) == 1073741852;
                    this.checkLength(isAuto ? 3 : 2);
                    if (this.chk) {
                        return;
                    }
                    this.vwr.clearModelDependentObjects();
                    this.vwr.ms.deleteAllBonds();
                    BS bsExclude = new BS();
                    this.vwr.ms.setPdbConectBonding(0, 0, bsExclude);
                    if (isAuto) {
                        boolean isLegacy = eval.isStateScript && this.vwr.getBoolean(603979873);
                        this.vwr.ms.autoBondBs4(null, null, bsExclude, null, this.vwr.getMadBond(), isLegacy);
                        this.vwr.addStateScript(isLegacy ? "set legacyAutoBonding TRUE;connect PDB AUTO;set legacyAutoBonding FALSE;" : "connect PDB auto;", false, true);
                        return;
                    }
                    this.vwr.addStateScript("connect PDB;", false, true);
                    return;
                }
                case 0x40000006: 
                case 1073741852: 
                case 0x40000050: 
                case 1073742025: 
                case 1073742026: {
                    haveOperation = true;
                    if (++i != this.slen) {
                        this.invArg();
                    }
                    if ((operation = eval.theTok) != 1073741852 || bondOrder == 131071 || bondOrder == 2048 || bondOrder == 515) break;
                    this.invArg();
                    break;
                }
                case 659482: {
                    if (!isColorOrRadius) {
                        colorArgb[0] = 0xFFFFFF;
                        translucentLevel = 0.5f;
                        radius = this.vwr.getFloat(570425406);
                        isColorOrRadius = true;
                    }
                    if (!haveOperation) {
                        operation = 1073742026;
                        haveOperation = true;
                    }
                }
                case 0x40000000: {
                    if (eval.isColorParam(i)) {
                        ptColor = -i;
                        break;
                    }
                }
                case 1075838996: 
                case 1613238294: {
                    String cmd = this.paramAsStr(i);
                    int bo = ScriptParam.getBondOrderFromString(cmd);
                    if (bo == 131071) {
                        this.invArg();
                    }
                    if (haveType) {
                        eval.error(18);
                    }
                    haveType = true;
                    switch (bo) {
                        case 33: {
                            switch (this.tokAt(i + 1)) {
                                case 3: {
                                    bo = ScriptParam.getPartialBondOrderFromFloatEncodedInt(this.st[++i].intValue);
                                    break;
                                }
                                case 2: {
                                    bo = (short)this.intParameter(++i);
                                }
                            }
                            break;
                        }
                        case 2048: {
                            if (this.tokAt(i + 1) != 2) break;
                            bo = (short)(this.intParameter(++i) << 11);
                            energy = this.floatParameter(++i);
                            break;
                        }
                        case 65537: {
                            if (haveOperation) break;
                            operation = 1073742025;
                            haveOperation = true;
                        }
                    }
                    bondOrder = bo;
                    break;
                }
                case 1665140738: {
                    radius = this.floatParameter(++i);
                    isColorOrRadius = true;
                    break;
                }
                case 12291: 
                case 1073742333: {
                    if (++i != this.slen) {
                        this.invArg();
                    }
                    operation = 12291;
                    isDelete = true;
                    isColorOrRadius = false;
                    break;
                }
                default: {
                    ptColor = i;
                }
            }
            if (i <= 0) continue;
            if (ptColor == -i || ptColor == i && eval.isColorParam(i)) {
                isColorOrRadius = true;
                colorArgb[0] = eval.getArgbParam(i);
                i = eval.iToken;
                continue;
            }
            if (ptColor != i) continue;
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (distanceCount < 2) {
            if (distanceCount == 0) {
                distances[0] = 1.0E8f;
            }
            distances[1] = distances[0];
            distances[0] = 0.1f;
        }
        if (isColorOrRadius) {
            if (!haveType) {
                bondOrder = 65535;
            }
            if (!haveOperation) {
                operation = 1073742025;
            }
        }
        int nNew = 0;
        int nModified = 0;
        if (expression2 > 0) {
            BS bs = new BS();
            this.vwr.definedAtomSets.put("_1", bs);
            BS bs0 = atomSets[0];
            int atom1 = bs0.nextSetBit(0);
            while (atom1 >= 0) {
                bs.set(atom1);
                int[] result = this.vwr.makeConnections(distances[0], distances[1], bondOrder, operation, bs, this.atomExpressionAt(expression2), bsBonds, isBonds, false, 0.0f);
                nNew += Math.abs(result[0]);
                nModified += result[1];
                bs.clear(atom1);
                atom1 = bs0.nextSetBit(atom1 + 1);
            }
        } else {
            int[] result = this.vwr.makeConnections(distances[0], distances[1], bondOrder, operation, atomSets[0], atomSets[1], bsBonds, isBonds, addGroup, energy);
            nNew += Math.abs(result[0]);
            nModified += result[1];
        }
        boolean report = eval.doReport();
        if (isDelete) {
            if (report) {
                eval.report(GT.i(GT._("{0} connections deleted"), nModified), false);
            }
            return;
        }
        if (isColorOrRadius) {
            this.vwr.selectBonds(bsBonds);
            if (!Float.isNaN(radius)) {
                eval.setShapeSizeBs(1, Math.round(radius * 2000.0f), null);
            }
            this.finalizeObject(1, colorArgb[0], translucentLevel, 0, false, null, 0, bsBonds);
            this.vwr.selectBonds(null);
        }
        if (report) {
            eval.report(GT.o(GT._("{0} new bonds; {1} modified"), new Object[]{nNew, nModified}), false);
        }
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 1073742334: {
                if (this.chk) break;
                this.vwr.showConsole(false);
                break;
            }
            case 1073742335: {
                if (this.chk) break;
                this.vwr.showConsole(true);
                break;
            }
            case 1073741882: {
                if (this.chk) break;
                this.vwr.sm.clearConsole();
                break;
            }
            case 134221856: {
                this.showString(this.stringParameter(2));
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void data() throws ScriptException {
        int userType;
        boolean isDefault;
        ScriptEval eval = this.e;
        String dataString = null;
        String dataLabel = null;
        boolean isOneValue = false;
        eval.iToken = this.slen;
        switch (eval.iToken) {
            case 5: {
                dataString = this.paramAsStr(2);
            }
            case 2: 
            case 4: {
                dataLabel = this.paramAsStr(1);
                if (dataLabel.equalsIgnoreCase("clear")) {
                    if (!this.chk) {
                        this.vwr.setData(null, null, 0, 0, 0, 0, 0);
                    }
                    return;
                }
                int i = dataLabel.indexOf("@");
                if (i >= 0) {
                    dataString = "" + eval.getParameter(dataLabel.substring(i + 1), 4, true);
                    dataLabel = dataLabel.substring(0, i).trim();
                    break;
                }
                if (dataString != null || (i = dataLabel.indexOf(" ")) < 0) break;
                dataString = dataLabel.substring(i + 1).trim();
                dataLabel = dataLabel.substring(0, i).trim();
                isOneValue = true;
                break;
            }
            default: {
                eval.bad();
            }
        }
        String dataType = dataLabel.substring(0, (dataLabel + " ").indexOf(" ")).toLowerCase();
        if (dataType.equals("model") || dataType.equals("append")) {
            eval.cmdLoad();
            return;
        }
        if (this.chk) {
            return;
        }
        boolean bl = isDefault = dataLabel.toLowerCase().indexOf("(default)") >= 0;
        if (dataType.equals("connect_atoms")) {
            this.vwr.ms.connect((float[][])this.parseDataArray(dataString, false));
            return;
        }
        if (dataType.indexOf("ligand_") == 0) {
            this.vwr.setLigandModel(dataLabel.substring(7).toUpperCase() + "_data", dataString.trim());
            return;
        }
        if (dataType.indexOf("file_") == 0) {
            this.vwr.setLigandModel(dataLabel.substring(5) + "_file", dataString.trim());
            return;
        }
        Object[] d = new Object[4];
        if (dataType.equals("element_vdw")) {
            d[0] = dataType;
            d[1] = dataString.replace(';', '\n');
            int n = Elements.elementNumberMax;
            int[] eArray = new int[n + 1];
            for (int ie = 1; ie <= n; ++ie) {
                eArray[ie] = ie;
            }
            d[2] = eArray;
            d[3] = 0;
            this.vwr.setData("element_vdw", d, n, 0, 0, 0, 0);
            return;
        }
        if (dataType.indexOf("data2d_") == 0) {
            d[0] = dataLabel;
            d[1] = this.parseDataArray(dataString, false);
            d[3] = 2;
            this.vwr.setData(dataLabel, d, 0, 0, 0, 0, 0);
            return;
        }
        if (dataType.indexOf("data3d_") == 0) {
            d[0] = dataLabel;
            d[1] = this.parseDataArray(dataString, true);
            d[3] = 3;
            this.vwr.setData(dataLabel, d, 0, 0, 0, 0, 0);
            return;
        }
        String[] tokens = PT.getTokens(dataLabel);
        if (!(dataType.indexOf("property_") != 0 || tokens.length == 2 && tokens[1].equals("set"))) {
            int propertyFieldColumnCount;
            BS bs = this.vwr.bsA();
            d[0] = dataType;
            int atomNumberField = isOneValue ? 0 : (Integer)this.vwr.getP("propertyAtomNumberField");
            int atomNumberFieldColumnCount = isOneValue ? 0 : (Integer)this.vwr.getP("propertyAtomNumberColumnCount");
            int propertyField = isOneValue ? Integer.MIN_VALUE : (Integer)this.vwr.getP("propertyDataField");
            int n = propertyFieldColumnCount = isOneValue ? 0 : (Integer)this.vwr.getP("propertyDataColumnCount");
            if (!isOneValue && dataLabel.indexOf(" ") >= 0) {
                if (tokens.length == 3) {
                    dataLabel = tokens[0];
                    atomNumberField = PT.parseInt(tokens[1]);
                    propertyField = PT.parseInt(tokens[2]);
                }
                if (tokens.length == 5) {
                    dataLabel = tokens[0];
                    atomNumberField = PT.parseInt(tokens[1]);
                    atomNumberFieldColumnCount = PT.parseInt(tokens[2]);
                    propertyField = PT.parseInt(tokens[3]);
                    propertyFieldColumnCount = PT.parseInt(tokens[4]);
                }
            }
            if (atomNumberField < 0) {
                atomNumberField = 0;
            }
            if (propertyField < 0) {
                propertyField = 0;
            }
            int ac = this.vwr.ms.ac;
            int[] atomMap = null;
            BS bsTemp = BS.newN(ac);
            if (atomNumberField > 0) {
                int j;
                atomMap = new int[ac + 2];
                for (j = 0; j <= ac; ++j) {
                    atomMap[j] = -1;
                }
                j = bs.nextSetBit(0);
                while (j >= 0) {
                    int atomNo = this.vwr.ms.at[j].getAtomNumber();
                    if (atomNo <= ac + 1 && atomNo >= 0 && !bsTemp.get(atomNo)) {
                        bsTemp.set(atomNo);
                        atomMap[atomNo] = j;
                    }
                    j = bs.nextSetBit(j + 1);
                }
                d[2] = atomMap;
            } else {
                d[2] = BSUtil.copy(bs);
            }
            d[1] = dataString;
            d[3] = 0;
            this.vwr.setData(dataType, d, ac, atomNumberField, atomNumberFieldColumnCount, propertyField, propertyFieldColumnCount);
            return;
        }
        if ("occupany".equals(dataType)) {
            dataType = "occupancy";
        }
        if ((userType = AtomCollection.getUserSettableType(dataType)) > -1) {
            this.vwr.setAtomData(userType, dataType, dataString, isDefault);
            return;
        }
        d[0] = dataLabel;
        d[1] = dataString;
        d[3] = 0;
        this.vwr.setData(dataType, d, 0, 0, 0, 0, 0);
    }

    private void ellipsoid() throws ScriptException {
        ScriptEval eval = this.e;
        int mad = 0;
        int i = 1;
        float translucentLevel = Float.MAX_VALUE;
        boolean checkMore = false;
        boolean isSet = false;
        this.setShapeProperty(20, "thisID", null);
        switch (this.getToken((int)1).tok) {
            case 1073742335: {
                mad = Integer.MAX_VALUE;
                break;
            }
            case 1073742334: {
                break;
            }
            case 2: {
                mad = this.intParameter(1);
                break;
            }
            case 36867: {
                this.e.sm.loadShape(20);
                this.setShapeProperty(20, "select", this.paramAsStr(2));
                i = eval.iToken;
                checkMore = true;
                isSet = true;
                break;
            }
            case 0x100000B1: 
            case 0x40000000: 
            case 1073741974: {
                this.e.sm.loadShape(20);
                if (eval.theTok == 1073741974) {
                    ++i;
                }
                this.setShapeId(20, i, false);
                i = eval.iToken;
                checkMore = true;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (!checkMore) {
            eval.setShapeSizeBs(20, mad, null);
            return;
        }
        int[] colorArgb = new int[]{Integer.MIN_VALUE};
        block22: while (++i < this.slen) {
            String key = this.paramAsStr(i);
            Object[] value = null;
            this.getToken(i);
            if (!isSet) {
                switch (eval.theTok) {
                    case 1073742330: {
                        key = "points";
                        Object[] data = new Object[3];
                        data[0] = eval.objectNameParameter(++i);
                        if (this.chk) continue block22;
                        eval.getShapePropertyData(24, "getVertices", data);
                        value = data;
                        break;
                    }
                    case 1611272194: {
                        V3[] axes = new V3[3];
                        for (int j = 0; j < 3; ++j) {
                            axes[j] = new V3();
                            axes[j].setT(this.centerParameter(++i));
                            i = eval.iToken;
                        }
                        value = axes;
                        break;
                    }
                    case 12289: {
                        value = this.centerParameter(++i);
                        i = eval.iToken;
                        break;
                    }
                    case 1094713359: {
                        value = this.intParameter(++i);
                        break;
                    }
                    case 12291: {
                        value = Boolean.TRUE;
                        this.checkLength(i + 1);
                    }
                }
            }
            if (value == null) {
                switch (eval.theTok) {
                    case 1073742335: {
                        key = "on";
                        value = Boolean.TRUE;
                        break;
                    }
                    case 1073742334: {
                        key = "on";
                        value = Boolean.FALSE;
                        break;
                    }
                    case 1073742138: {
                        value = Float.valueOf(this.floatParameter(++i));
                        break;
                    }
                    case 10: 
                    case 12290: 
                    case 1073742325: {
                        key = "atoms";
                        value = this.atomExpressionAt(i);
                        i = eval.iToken;
                        break;
                    }
                    case 603979967: 
                    case 1073742074: 
                    case 1765808134: {
                        translucentLevel = this.getColorTrans(eval, i, true, colorArgb);
                        i = eval.iToken;
                        continue block22;
                    }
                    case 1073742075: {
                        value = this.paramAsStr(++i);
                    }
                }
            }
            if (value == null) {
                this.invArg();
            }
            this.setShapeProperty(20, key.toLowerCase(), value);
        }
        this.finalizeObject(20, colorArgb[0], translucentLevel, 0, false, null, 0, null);
        this.setShapeProperty(20, "thisID", null);
    }

    private void image() throws ScriptException {
        if (!this.chk) {
            this.vwr.getConsole();
        }
        int pt = 1;
        String id = null;
        if (this.tokAt(1) == 1073741974) {
            id = this.e.optParameterAsString(++pt);
            ++pt;
        }
        String fileName = this.e.optParameterAsString(pt);
        boolean isClose = this.e.optParameterAsString(this.slen - 1).equalsIgnoreCase("close");
        if (!(isClose || this.slen != pt && this.slen != pt + 2)) {
            int width = this.slen == pt + 2 ? this.intParameter(pt++) : -1;
            int height = width < 0 ? -1 : this.intParameter(pt);
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("fileName", "\u0001\u0001" + id);
            params.put("backgroundColor", this.vwr.getBackgroundArgb());
            params.put("type", "png");
            params.put("quality", -1);
            params.put("width", width);
            params.put("height", height);
            if (!this.chk) {
                this.vwr.processWriteOrCapture(params);
            }
            return;
        }
        ++pt;
        if (isClose) {
            switch (this.slen) {
                case 2: {
                    fileName = "closeall";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    this.checkLength(0);
                }
            }
        }
        if (!this.chk) {
            this.vwr.fm.loadImage(isClose ? "\u0001close" : fileName, "\u0001" + fileName + "\u0001" + ("".equals(id) || id == null ? null : id), false);
        }
    }

    private void mapProperty() throws ScriptException {
        block21: {
            String mapKey;
            String property1;
            String property2;
            BS bsTo;
            BS bsFrom;
            ScriptEval eval;
            int tokKey;
            int tokProp2;
            int tokProp1;
            block20: {
                block19: {
                    tokProp1 = 0;
                    tokProp2 = 0;
                    tokKey = 0;
                    eval = this.e;
                    if (this.tokAt(1) != 1113589787) break block19;
                    bsFrom = this.vwr.bsA();
                    bsTo = this.atomExpressionAt(2);
                    property2 = "selected";
                    property1 = "selected";
                    break block20;
                }
                bsFrom = this.atomExpressionAt(1);
                if (this.tokAt(++eval.iToken) != 0x40000200 || !T.tokAttr(tokProp1 = this.tokAt(++eval.iToken), 0x40400000)) break block21;
                property1 = this.paramAsStr(eval.iToken);
                bsTo = this.atomExpressionAt(++eval.iToken);
                if (this.tokAt(++eval.iToken) != 0x40000200 || !T.tokAttr(tokProp2 = this.tokAt(++eval.iToken), 2048)) break block21;
                property2 = this.paramAsStr(eval.iToken);
            }
            tokKey = this.tokAt(eval.iToken + 1);
            if (T.tokAttr(tokKey, 0x40400000)) {
                mapKey = this.paramAsStr(++eval.iToken);
            } else {
                tokKey = 1094715393;
                mapKey = T.nameOf(1094715393);
            }
            eval.checkLast(eval.iToken);
            if (this.chk) {
                return;
            }
            BS bsOut = null;
            this.showString("mapping " + property1.toUpperCase() + " for " + bsFrom.cardinality() + " atoms to " + property2.toUpperCase() + " for " + bsTo.cardinality() + " atoms using " + mapKey.toUpperCase());
            if (T.tokAttrOr(tokProp1, 0x41400000, 0x42400000) && T.tokAttrOr(tokProp2, 0x41400000, 0x42400000) && T.tokAttrOr(tokKey, 0x41400000, 0x42400000)) {
                float[] data1 = this.getBitsetPropertyFloat(bsFrom, tokProp1 | 0xE0, null, Float.NaN, Float.NaN);
                float[] data2 = this.getBitsetPropertyFloat(bsFrom, tokKey | 0xE0, null, Float.NaN, Float.NaN);
                float[] data3 = this.getBitsetPropertyFloat(bsTo, tokKey | 0xE0, null, Float.NaN, Float.NaN);
                boolean isProperty = tokProp2 == 1715472409;
                float[] dataOut = new float[isProperty ? this.vwr.ms.ac : data3.length];
                bsOut = new BS();
                if (data1.length == data2.length) {
                    Hashtable<Float, Float> ht = new Hashtable<Float, Float>();
                    for (int i = 0; i < data1.length; ++i) {
                        ht.put(Float.valueOf(data2[i]), Float.valueOf(data1[i]));
                    }
                    int pt = -1;
                    int nOut = 0;
                    for (int i = 0; i < data3.length; ++i) {
                        pt = bsTo.nextSetBit(pt + 1);
                        Float F = (Float)ht.get(Float.valueOf(data3[i]));
                        if (F == null) continue;
                        bsOut.set(pt);
                        dataOut[isProperty ? pt : nOut] = F.floatValue();
                        ++nOut;
                    }
                    if (isProperty) {
                        this.vwr.setData(property2, new Object[]{property2, dataOut, bsOut, 1, Boolean.TRUE}, this.vwr.ms.ac, 0, 0, Integer.MAX_VALUE, 0);
                    } else if (!T.tokAttr(tokProp2, 2048)) {
                        this.error(56);
                    } else {
                        this.vwr.setAtomProperty(bsOut, tokProp2, 0, 0.0f, null, dataOut, null);
                    }
                }
            }
            if (bsOut == null) {
                String format = "{" + mapKey + "=%[" + mapKey + "]}." + property2 + " = %[" + property1 + "]";
                String[] data = (String[])this.getBitsetIdent(bsFrom, format, null, false, Integer.MAX_VALUE, false);
                SB sb = new SB();
                for (int i = 0; i < data.length; ++i) {
                    if (data[i].indexOf("null") >= 0) continue;
                    sb.append(data[i]).appendC('\n');
                }
                if (Logger.debugging) {
                    Logger.debug(sb.toString());
                }
                BS bsSubset = BSUtil.copy(this.vwr.slm.bsSubset);
                this.vwr.slm.setSelectionSubset(bsTo);
                try {
                    eval.runScript(sb.toString());
                }
                catch (Exception ex) {
                    this.vwr.slm.setSelectionSubset(bsSubset);
                    eval.errorStr(-1, "Error: " + ex.getMessage());
                }
                catch (Error er) {
                    this.vwr.slm.setSelectionSubset(bsSubset);
                    eval.errorStr(-1, "Error: " + er.toString());
                }
                this.vwr.slm.setSelectionSubset(bsSubset);
            }
            this.showString("DONE");
            return;
        }
        this.invArg();
    }

    private void minimize() throws ScriptException {
        BS bsSelected = null;
        int steps = Integer.MAX_VALUE;
        float crit = 0.0f;
        boolean addHydrogen = false;
        boolean isSilent = false;
        BS bsFixed = null;
        boolean isOnly = false;
        Minimizer minimizer = this.vwr.getMinimizer(false);
        block15: for (int i = 1; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x40000004: {
                    addHydrogen = true;
                    continue block15;
                }
                case 1073741874: 
                case 1073742162: {
                    this.checkLength(2);
                    if (this.chk || minimizer == null) {
                        return;
                    }
                    minimizer.setProperty(this.paramAsStr(i), null);
                    return;
                }
                case 1073741882: {
                    this.checkLength(2);
                    if (this.chk || minimizer == null) {
                        return;
                    }
                    minimizer.setProperty("clear", null);
                    return;
                }
                case 0x40000046: {
                    if (i != 1) {
                        this.invArg();
                    }
                    int n = 0;
                    float targetValue = 0.0f;
                    int[] aList = new int[5];
                    if (this.tokAt(++i) == 1073741882) {
                        this.checkLength(3);
                    } else {
                        while (n < 4 && !this.isFloatParameter(i)) {
                            aList[++n] = this.atomExpressionAt(i).nextSetBit(0);
                            i = this.e.iToken + 1;
                        }
                        aList[0] = n;
                        if (n == 1) {
                            this.invArg();
                        }
                        targetValue = this.floatParameter(this.e.checkLast(i));
                    }
                    if (!this.chk) {
                        this.vwr.getMinimizer(true).setProperty("constraint", new Object[]{aList, new int[n], Float.valueOf(targetValue)});
                    }
                    return;
                }
                case 1073741905: {
                    crit = this.floatParameter(++i);
                    continue block15;
                }
                case 1073741934: {
                    steps = 0;
                    continue block15;
                }
                case 12293: {
                    if (i != 1) {
                        this.invArg();
                    }
                    if ((bsFixed = this.atomExpressionAt(++i)).nextSetBit(0) < 0) {
                        bsFixed = null;
                    }
                    i = this.e.iToken;
                    if (!this.chk) {
                        this.vwr.getMinimizer(true).setProperty("fixed", bsFixed);
                    }
                    if (i + 1 != this.slen) continue block15;
                    return;
                }
                case 10: 
                case 1073742325: {
                    isOnly = true;
                }
                case 1275082245: {
                    if (this.e.theTok == 1275082245) {
                        ++i;
                    }
                    bsSelected = this.atomExpressionAt(i);
                    i = this.e.iToken;
                    if (this.tokAt(i + 1) != 1073742072) continue block15;
                    ++i;
                    isOnly = true;
                    continue block15;
                }
                case 0x40000144: {
                    isSilent = true;
                    continue block15;
                }
                case 266298: {
                    steps = this.intParameter(++i);
                    continue block15;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (!this.chk) {
            try {
                this.vwr.minimize(this.e, steps, crit, bsSelected, bsFixed, 0.0f, addHydrogen, isOnly, isSilent, false);
            }
            catch (Exception e1) {
                throw new ScriptInterruption(this.e, "minimize", 1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void modulation() throws ScriptException {
        qtOffset = null;
        eval = this.e;
        mod = true;
        isQ = false;
        bs = null;
        i = 1;
        switch (this.getToken((int)i).tok) {
            case 1073742334: {
                mod = false;
            }
            case 0: 
            case 1073742335: {
                break;
            }
            case 10: 
            case 12290: 
            case 1073742325: {
                bs = this.atomExpressionAt(1);
                switch (this.tokAt(eval.iToken + 1)) {
                    case 0: {
                        break;
                    }
                    case 1073742334: {
                        mod = false;
                    }
                    case 1073742335: {
                        ++eval.iToken;
                    }
                }
                eval.checkLast(eval.iToken);
                break;
            }
            case 8: 
            case 1073742332: {
                qtOffset = eval.getPoint3f(1, false);
                isQ = this.tokAt(eval.iToken + 1) == 1073742335;
                break;
            }
            default: {
                s = eval.theToken.value.toString();
                ++i;
                if (!s.equalsIgnoreCase("t")) ** GOTO lbl34
                eval.theTok = 3;
                ** GOTO lbl38
lbl34:
                // 1 sources

                if (s.equalsIgnoreCase("m") || s.equalsIgnoreCase("q")) {
                    eval.theTok = 2;
                } else {
                    this.invArg();
                }
            }
lbl38:
            // 4 sources

            case 2: 
            case 3: {
                switch (eval.theTok) {
                    case 3: {
                        if (this.isFloatParameter(i)) {
                            t1 = this.floatParameter(i);
                            qtOffset = P3.new3(t1, t1, t1);
                            break;
                        }
                        qtOffset = eval.getPoint3f(i, false);
                        break;
                    }
                    case 2: {
                        if (this.tokAt(i) == 2) {
                            t = this.intParameter(i);
                            qtOffset = P3.new3(t, t, t);
                        } else {
                            qtOffset = eval.getPoint3f(i, false);
                        }
                        isQ = true;
                    }
                }
                break;
            }
            case 1073742138: {
                scale = this.floatParameter(2);
                if (!this.chk) {
                    this.vwr.setFloatProperty("modulationScale", scale);
                }
                return;
            }
        }
        if (!this.chk) {
            this.vwr.tm.setVibrationPeriod(0.0f);
            this.vwr.setModulation(bs, mod, qtOffset, isQ);
        }
    }

    private void mutate() throws ScriptException {
        int i;
        BS bs;
        switch (this.tokAt(1)) {
            case 2: {
                this.st[1] = T.o(4, "" + this.st[1].value);
            }
            default: {
                bs = this.atomExpressionAt(1);
                i = ++this.e.iToken;
                break;
            }
            case 0x100000B1: {
                bs = this.vwr.getAllAtoms();
                i = 2;
            }
        }
        bs.and(this.vwr.getModelUndeletedAtomsBitSet(this.vwr.ms.mc - 1));
        int iatom = bs.length() - 1;
        short imodel = 0;
        if (iatom < 0 || (imodel = this.vwr.ms.at[iatom].mi) != this.vwr.ms.mc - 1 || this.vwr.ms.isTrajectory(imodel)) {
            return;
        }
        String group = this.e.optParameterAsString(i);
        this.e.checkLast(i);
        if (this.chk || !this.vwr.ms.am[imodel].isBioModel) {
            return;
        }
        boolean isFile = this.tokAt(i) == 4 && !group.startsWith("~");
        String[] list = null;
        if (isFile) {
            list = new String[]{group};
            group = null;
        } else {
            boolean isOneLetter = (group = PT.replaceAllCharacters(group, ",; \t\n", " ").trim().toUpperCase()).startsWith("~");
            if (isOneLetter || group.length() != 3 || !this.vwr.getJBR().isKnownPDBGroup(group, 20)) {
                group = this.vwr.getJBR().toStdAmino3(isOneLetter ? group.substring(1) : group);
            }
            list = PT.getTokens(group);
        }
        if (list.length > 0) {
            this.vwr.ms.bioModelset.mutate(bs, group, list);
        }
    }

    private void navigate() throws ScriptException {
        ScriptEval eval = this.e;
        if (this.slen == 1) {
            eval.setBooleanProperty("navigationMode", true);
            return;
        }
        V3 rotAxis = V3.new3(0.0f, 1.0f, 0.0f);
        Lst<Object[]> list = new Lst<Object[]>();
        if (this.slen == 2) {
            switch (this.getToken((int)1).tok) {
                case 1073742334: 
                case 1073742335: {
                    if (this.chk) {
                        return;
                    }
                    eval.setObjectMad10(34, "axes", 10);
                    this.setShapeProperty(34, "position", P3.new3(50.0f, 50.0f, Float.MAX_VALUE));
                    eval.setBooleanProperty("navigationMode", true);
                    this.vwr.tm.setNavOn(eval.theTok == 1073742335);
                    return;
                }
                case 1073742162: {
                    if (!this.chk) {
                        this.vwr.tm.setNavXYZ(0.0f, 0.0f, 0.0f);
                    }
                    return;
                }
                case 8: 
                case 1112152078: {
                    break;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (!this.chk && !this.vwr.getBoolean(603979889)) {
            eval.setBooleanProperty("navigationMode", true);
        }
        block26: for (int i = 1; i < this.slen; ++i) {
            float timeSec;
            float f = timeSec = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (timeSec < 0.0f) {
                this.invArg();
            }
            if (!this.chk && timeSec > 0.0f) {
                eval.refresh(false);
            }
            switch (this.getToken((int)i).tok) {
                case 8: 
                case 1073742332: {
                    P3 pt = this.getPoint3f(i, true);
                    ++eval.iToken;
                    if (eval.iToken != this.slen) {
                        this.invArg();
                    }
                    if (!this.chk) {
                        this.vwr.tm.setNavXYZ(pt.x, pt.y, pt.z);
                    }
                    return;
                }
                case 554176526: {
                    float depth = this.floatParameter(++i);
                    if (this.chk) continue block26;
                    list.addLast(new Object[]{554176526, Float.valueOf(timeSec), Float.valueOf(depth)});
                    continue block26;
                }
                case 12289: {
                    P3 pt = this.centerParameter(++i);
                    i = eval.iToken;
                    if (this.chk) continue block26;
                    list.addLast(new Object[]{134217751, Float.valueOf(timeSec), pt});
                    continue block26;
                }
                case 528432: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1111492629: {
                            rotAxis.set(1.0f, 0.0f, 0.0f);
                            ++i;
                            break;
                        }
                        case 1111492630: {
                            rotAxis.set(0.0f, 1.0f, 0.0f);
                            ++i;
                            break;
                        }
                        case 1111492631: {
                            rotAxis.set(0.0f, 0.0f, 1.0f);
                            ++i;
                            break;
                        }
                        case 8: 
                        case 1073742332: {
                            rotAxis.setT(this.getPoint3f(i, true));
                            i = eval.iToken + 1;
                            break;
                        }
                        case 0x40000000: {
                            this.invArg();
                        }
                    }
                    float degrees = this.floatParameter(i);
                    if (this.chk) continue block26;
                    list.addLast(new Object[]{528432, Float.valueOf(timeSec), rotAxis, Float.valueOf(degrees)});
                    continue block26;
                }
                case 4160: {
                    P3 pt;
                    float x = Float.NaN;
                    float y = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        x = this.floatParameter(i);
                        y = this.floatParameter(++i);
                    } else {
                        switch (this.tokAt(i)) {
                            case 1111492629: {
                                x = this.floatParameter(++i);
                                break;
                            }
                            case 1111492630: {
                                y = this.floatParameter(++i);
                                break;
                            }
                            default: {
                                pt = this.centerParameter(i);
                                i = eval.iToken;
                                if (this.chk) continue block26;
                                list.addLast(new Object[]{4160, Float.valueOf(timeSec), pt});
                                continue block26;
                            }
                        }
                    }
                    if (this.chk) continue block26;
                    list.addLast(new Object[]{268435634, Float.valueOf(timeSec), Float.valueOf(x), Float.valueOf(y)});
                    continue block26;
                }
                case 0x100000B0: {
                    continue block26;
                }
                case 1112152078: {
                    BS bs;
                    Lst<P3[]> vp = new Lst<P3[]>();
                    if (eval.isAtomExpression(i + 1)) {
                        bs = this.atomExpressionAt(++i);
                        i = eval.iToken;
                    } else {
                        bs = this.vwr.bsA();
                    }
                    if (this.chk) {
                        return;
                    }
                    this.vwr.getPolymerPointsAndVectors(bs, vp);
                    int n = vp.size();
                    if (n <= 0) continue block26;
                    P3[][] pathGuide = new P3[n][];
                    for (int j = 0; j < n; ++j) {
                        pathGuide[j] = (P3[])vp.get(j);
                    }
                    list.addLast(new Object[]{1112152078, Float.valueOf(timeSec), pathGuide});
                    continue block26;
                }
                case 0x40000104: {
                    Object theta = null;
                    if (this.getToken((int)(i + 1)).tok == 1073742330) {
                        ++i;
                        String pathID = eval.objectNameParameter(++i);
                        if (this.chk) {
                            return;
                        }
                        this.setShapeProperty(22, "thisID", pathID);
                        P3[] path = (P3[])this.getShapeProperty(22, "vertices");
                        eval.refresh(false);
                        if (path == null) {
                            this.invArg();
                        }
                        int indexStart = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                        int indexEnd = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                        list.addLast(new Object[]{0x40000104, Float.valueOf(timeSec), path, theta, new int[]{indexStart, indexEnd}});
                        continue block26;
                    }
                    Lst<P3> v = new Lst<P3>();
                    while (eval.isCenterParameter(i + 1)) {
                        v.addLast(this.centerParameter(++i));
                        i = eval.iToken;
                    }
                    if (v.size() > 0) {
                        P3[] path = v.toArray(new P3[v.size()]);
                        if (this.chk) continue block26;
                        list.addLast(new Object[]{0x40000104, Float.valueOf(timeSec), path, theta, new int[]{0, Integer.MAX_VALUE}});
                        continue block26;
                    }
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (!this.chk && !this.vwr.isJmolDataFrame()) {
            this.vwr.tm.navigateList(eval, list);
        }
    }

    private String plot(T[] args) throws ScriptException {
        String script;
        String data;
        int ptDataFrame;
        ScriptEval eval = this.e;
        int modelIndex = this.vwr.am.cmi;
        if (modelIndex < 0) {
            eval.errorStr(30, "plot");
        }
        modelIndex = this.vwr.ms.getJmolDataSourceFrame(modelIndex);
        int pt = args.length - 1;
        boolean isReturnOnly = args != this.st;
        boolean pdbFormat = true;
        T[] statementSave = this.st;
        if (isReturnOnly) {
            this.st = args;
            eval.st = args;
        }
        int tokCmd = isReturnOnly ? 134222350 : args[0].tok;
        int pt0 = isReturnOnly || tokCmd == 134221850 || tokCmd == 4138 ? 0 : 1;
        String filename = null;
        boolean makeNewFrame = true;
        boolean isDraw = false;
        switch (tokCmd) {
            case 4133: 
            case 4138: 
            case 134221850: {
                break;
            }
            case 135176: {
                makeNewFrame = false;
                isDraw = true;
                break;
            }
            case 134222350: {
                makeNewFrame = false;
                pdbFormat = false;
                break;
            }
            case 134221856: {
                makeNewFrame = false;
                if (CmdExt.tokAtArray(pt, args) == 4) {
                    filename = this.stringParameter(pt--);
                } else if (CmdExt.tokAtArray(pt - 1, args) == 0x40000200) {
                    filename = this.paramAsStr(pt - 2) + "." + this.paramAsStr(pt);
                    pt -= 3;
                } else {
                    this.st = statementSave;
                    eval.st = statementSave;
                    eval.iToken = this.st.length;
                    this.error(13);
                }
                eval.slen = this.slen = pt + 1;
            }
        }
        String qFrame = "";
        Object[] parameters = null;
        String stateScript = "";
        boolean isQuaternion = false;
        boolean isDerivative = false;
        boolean isSecondDerivative = false;
        boolean isRamachandranRelative = false;
        String[] props = new String[3];
        int[] propToks = new int[3];
        BS bs = BSUtil.copy(this.vwr.bsA());
        String preSelected = "; select " + Escape.eBS(bs) + ";\n ";
        String type = eval.optParameterAsString(pt).toLowerCase();
        P3 minXYZ = null;
        P3 maxXYZ = null;
        String format = null;
        int tok = CmdExt.tokAtArray(pt0, args);
        if (tok == 4) {
            tok = T.getTokFromName((String)args[pt0].value);
        }
        switch (tok) {
            default: {
                eval.iToken = 1;
                this.invArg();
                break;
            }
            case 134221834: {
                eval.iToken = 1;
                type = "data";
                preSelected = "";
                break;
            }
            case 1715472409: {
                eval.iToken = pt0 + 1;
                block22: for (int i = 0; i < 3; ++i) {
                    switch (this.tokAt(eval.iToken)) {
                        case 4: {
                            propToks[i] = T.getTokFromName((String)eval.getToken((int)eval.iToken).value);
                            break;
                        }
                        default: {
                            propToks[i] = this.tokAt(eval.iToken);
                            break;
                        }
                        case 0: {
                            if (i == 0) {
                                this.invArg();
                            }
                        }
                        case 32: 
                        case 64: 
                        case 1287653388: {
                            i = 2;
                            continue block22;
                        }
                    }
                    if (propToks[i] != 1715472409 && !T.tokAttr(propToks[i], 0x40400000)) {
                        this.invArg();
                    }
                    props[i] = this.getToken((int)eval.iToken).value.toString();
                    ++eval.iToken;
                }
                if (this.tokAt(eval.iToken) == 1287653388) {
                    format = this.stringParameter(++eval.iToken);
                    pdbFormat = false;
                    ++eval.iToken;
                }
                if (this.tokAt(eval.iToken) == 32) {
                    minXYZ = this.getPoint3f(++eval.iToken, false);
                    ++eval.iToken;
                }
                if (this.tokAt(eval.iToken) == 64) {
                    maxXYZ = this.getPoint3f(++eval.iToken, false);
                    ++eval.iToken;
                }
                type = "property " + props[0] + (props[1] == null ? "" : " " + props[1]) + (props[2] == null ? "" : " " + props[2]);
                if (bs.nextSetBit(0) < 0) {
                    bs = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
                }
                stateScript = "select " + Escape.eBS(bs) + ";\n ";
                break;
            }
            case 4138: {
                if (type.equalsIgnoreCase("draw")) {
                    isDraw = true;
                    type = eval.optParameterAsString(--pt).toLowerCase();
                }
                isRamachandranRelative = pt > pt0 && type.startsWith("r");
                type = "ramachandran" + (isRamachandranRelative ? " r" : "") + (tokCmd == 135176 ? " draw" : "");
                break;
            }
            case 134221850: 
            case 136314895: {
                qFrame = " \"" + this.vwr.getQuaternionFrame() + "\"";
                stateScript = "set quaternionFrame" + qFrame + ";\n  ";
                isQuaternion = true;
                if (type.equalsIgnoreCase("draw")) {
                    isDraw = true;
                    type = eval.optParameterAsString(--pt).toLowerCase();
                }
                isDerivative = type.startsWith("deriv") || type.startsWith("diff");
                boolean bl = isSecondDerivative = isDerivative && type.indexOf("2") > 0;
                if (isDerivative) {
                    --pt;
                }
                if (type.equalsIgnoreCase("helix") || type.equalsIgnoreCase("axis")) {
                    isDraw = true;
                    isDerivative = true;
                    pt = -1;
                }
                if ((type = ((pt <= pt0 ? "" : eval.optParameterAsString(pt)) + "w").substring(0, 1)).equals("a") || type.equals("r")) {
                    isDerivative = true;
                }
                if (!PT.isOneOf(type, ";w;x;y;z;r;a;")) {
                    eval.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]", null);
                }
                type = "quaternion " + type + (isDerivative ? " difference" : "") + (isSecondDerivative ? "2" : "") + (isDraw ? " draw" : "");
            }
        }
        this.st = statementSave;
        if (this.chk) {
            return "";
        }
        if (makeNewFrame && (ptDataFrame = this.vwr.ms.getJmolDataFrameIndex(modelIndex, stateScript = stateScript + "plot " + type)) > 0 && tokCmd != 134221856 && tokCmd != 134222350) {
            this.vwr.setCurrentModelIndexClear(ptDataFrame, true);
            return "";
        }
        float[] dataX = null;
        float[] dataY = null;
        float[] dataZ = null;
        String[] propData = new String[3];
        if (tok == 1715472409) {
            dataX = this.getBitsetPropertyFloat(bs, propToks[0] | 0xE0, propToks[0] == 1715472409 ? props[0] : null, minXYZ == null ? Float.NaN : minXYZ.x, maxXYZ == null ? Float.NaN : maxXYZ.x);
            propData[0] = props[0] + " " + Escape.eAF(dataX);
            if (props[1] != null) {
                dataY = this.getBitsetPropertyFloat(bs, propToks[1] | 0xE0, propToks[1] == 1715472409 ? props[1] : null, minXYZ == null ? Float.NaN : minXYZ.y, maxXYZ == null ? Float.NaN : maxXYZ.y);
                propData[1] = props[1] + " " + Escape.eAF(dataY);
            }
            if (props[2] != null) {
                dataZ = this.getBitsetPropertyFloat(bs, propToks[2] | 0xE0, propToks[2] == 1715472409 ? props[2] : null, minXYZ == null ? Float.NaN : minXYZ.z, maxXYZ == null ? Float.NaN : maxXYZ.z);
                propData[2] = props[2] + " " + Escape.eAF(dataZ);
            }
            if (minXYZ == null) {
                minXYZ = P3.new3(this.getPlotMinMax(dataX, false, propToks[0]), this.getPlotMinMax(dataY, false, propToks[1]), this.getPlotMinMax(dataZ, false, propToks[2]));
            }
            if (maxXYZ == null) {
                maxXYZ = P3.new3(this.getPlotMinMax(dataX, true, propToks[0]), this.getPlotMinMax(dataY, true, propToks[1]), this.getPlotMinMax(dataZ, true, propToks[2]));
            }
            Logger.info("plot min/max: " + minXYZ + " " + maxXYZ);
            P3 center = null;
            P3 factors = null;
            if (pdbFormat) {
                int i;
                factors = P3.new3(1.0f, 1.0f, 1.0f);
                center = new P3();
                center.ave(maxXYZ, minXYZ);
                factors.sub2(maxXYZ, minXYZ);
                factors.set(factors.x / 200.0f, factors.y / 200.0f, factors.z / 200.0f);
                if (T.tokAttr(propToks[0], 0x41400000)) {
                    factors.x = 1.0f;
                    center.x = 0.0f;
                } else if ((double)factors.x > 0.1 && factors.x <= 10.0f) {
                    factors.x = 1.0f;
                }
                if (T.tokAttr(propToks[1], 0x41400000)) {
                    factors.y = 1.0f;
                    center.y = 0.0f;
                } else if ((double)factors.y > 0.1 && factors.y <= 10.0f) {
                    factors.y = 1.0f;
                }
                if (T.tokAttr(propToks[2], 0x41400000)) {
                    factors.z = 1.0f;
                    center.z = 0.0f;
                } else if ((double)factors.z > 0.1 && factors.z <= 10.0f) {
                    factors.z = 1.0f;
                }
                if (props[2] == null || props[1] == null) {
                    factors.z = 0.0f;
                    maxXYZ.z = 0.0f;
                    minXYZ.z = 0.0f;
                    center.z = 0.0f;
                }
                for (i = 0; i < dataX.length; ++i) {
                    dataX[i] = (dataX[i] - center.x) / factors.x;
                }
                if (props[1] != null) {
                    for (i = 0; i < dataY.length; ++i) {
                        dataY[i] = (dataY[i] - center.y) / factors.y;
                    }
                }
                if (props[2] != null) {
                    for (i = 0; i < dataZ.length; ++i) {
                        dataZ[i] = (dataZ[i] - center.z) / factors.z;
                    }
                }
            }
            parameters = new Object[]{bs, dataX, dataY, dataZ, minXYZ, maxXYZ, factors, center, format, propData};
        }
        if (tokCmd == 134221856) {
            return this.vwr.writeFileData(filename, "PLOT_" + type, modelIndex, parameters);
        }
        String string = data = type.equals("data") ? "1 0 H 0 0 0 # Jmol PDB-encoded data" : this.vwr.getPdbData(modelIndex, type, null, parameters, null, true);
        if (tokCmd == 134222350) {
            return data;
        }
        if (Logger.debugging) {
            Logger.debug(data);
        }
        if (tokCmd == 135176) {
            eval.runScript(data);
            return "";
        }
        String[] savedFileInfo = this.vwr.fm.getFileInfo();
        boolean oldAppendNew = this.vwr.getBoolean(603979792);
        this.vwr.g.appendNew = true;
        boolean isOK = data != null && this.vwr.openStringInlineParamsAppend(data, null, true) == null;
        this.vwr.g.appendNew = oldAppendNew;
        this.vwr.fm.setFileInfo(savedFileInfo);
        if (!isOK) {
            return "";
        }
        int modelCount = this.vwr.ms.mc;
        this.vwr.ms.setJmolDataFrame(stateScript, modelIndex, modelCount - 1);
        if (tok != 1715472409) {
            stateScript = stateScript + ";\n" + preSelected;
        }
        StateScript ss = this.vwr.addStateScript(stateScript, true, false);
        float radius = 150.0f;
        switch (tok) {
            default: {
                script = "frame 0.0; frame last; reset;select visible;wireframe only;";
                radius = 10.0f;
                break;
            }
            case 1715472409: {
                this.vwr.setFrameTitle(modelCount - 1, type + " plot for model " + this.vwr.getModelNumberDotted(modelIndex));
                script = "frame 0.0; frame last; reset;select visible; spacefill 3.0; wireframe 0;draw plotAxisX" + modelCount + " {100 -100 -100} {-100 -100 -100} \"" + props[0] + "\";" + "draw plotAxisY" + modelCount + " {-100 100 -100} {-100 -100 -100} \"" + props[1] + "\";";
                if (props[2] == null) break;
                script = script + "draw plotAxisZ" + modelCount + " {-100 -100 100} {-100 -100 -100} \"" + props[2] + "\";";
                break;
            }
            case 4138: {
                this.vwr.setFrameTitle(modelCount - 1, "ramachandran plot for model " + this.vwr.getModelNumberDotted(modelIndex));
                script = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + modelCount + " {100 0 0} {-100 0 0} \"phi\";" + "draw ramaAxisY" + modelCount + " {0 100 0} {0 -100 0} \"psi\";";
                break;
            }
            case 134221850: 
            case 136314895: {
                this.vwr.setFrameTitle(modelCount - 1, type.replace('w', ' ') + qFrame + " for model " + this.vwr.getModelNumberDotted(modelIndex));
                String color = C.getHexCode(this.vwr.cm.colixBackgroundContrast);
                script = "frame 0.0; frame last; reset;select visible; wireframe 0; spacefill 3.0; isosurface quatSphere" + modelCount + " color " + color + " sphere 100.0 mesh nofill frontonly translucent 0.8;" + "draw quatAxis" + modelCount + "X {100 0 0} {-100 0 0} color red \"x\";" + "draw quatAxis" + modelCount + "Y {0 100 0} {0 -100 0} color green \"y\";" + "draw quatAxis" + modelCount + "Z {0 0 100} {0 0 -100} color blue \"z\";" + "color structure;" + "draw quatCenter" + modelCount + "{0 0 0} scale 0.02;";
            }
        }
        eval.runScript(script + preSelected);
        ss.setModelIndex(this.vwr.am.cmi);
        this.vwr.setRotationRadius(radius, true);
        eval.sm.loadShape(31);
        this.showString("frame " + this.vwr.getModelNumberDotted(modelCount - 1) + (type.length() > 0 ? " created: " + type + (isQuaternion ? qFrame : "") : ""));
        return "";
    }

    private void polyhedra() throws ScriptException {
        ScriptEval eval = this.e;
        boolean haveBonds = this.slen == 1;
        boolean haveCenter = false;
        boolean needsGenerating = haveBonds;
        boolean onOffDelete = false;
        boolean typeSeen = false;
        boolean edgeParameterSeen = false;
        float scale = Float.NaN;
        int nAtomSets = 0;
        eval.sm.loadShape(21);
        this.setShapeProperty(21, "init", Boolean.TRUE);
        float translucentLevel = Float.MAX_VALUE;
        float radius = -1.0f;
        int[] colorArgb = new int[]{Integer.MIN_VALUE};
        int noToParam = -1;
        P3 offset = null;
        String id = null;
        boolean ok = false;
        int[][] faces = null;
        P3[] points = null;
        block33: for (int i = 1; i < this.slen; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            switch (this.getToken((int)i).tok) {
                case 6: {
                    propertyName = "info";
                    propertyValue = this.e.theToken.value;
                    needsGenerating = true;
                    break;
                }
                case 134217751: {
                    propertyName = "points";
                    propertyValue = Float.valueOf(this.tokAt(++i) == 1073742334 ? 0.0f : this.e.floatParameter(i));
                    ok = true;
                    break;
                }
                case 1073742138: {
                    scale = this.floatParameter(++i);
                    ok = true;
                    continue block33;
                }
                case 1814695966: {
                    if (id != null) {
                        this.invArg();
                    }
                    propertyName = "unitCell";
                    propertyValue = Boolean.TRUE;
                    needsGenerating = true;
                    break;
                }
                case 1073742072: {
                    this.e.restrictSelected(false, false);
                    eval.theTok = 1073742335;
                }
                case 12291: 
                case 1073742334: 
                case 1073742335: {
                    if (i + 1 != this.slen || needsGenerating || nAtomSets > 1) {
                        this.error(18);
                    }
                    propertyName = eval.theTok == 1073742334 ? "off" : (eval.theTok == 1073742335 ? "on" : "delete");
                    onOffDelete = true;
                    break;
                }
                case 7: {
                    if (id == null || needsGenerating) {
                        this.invArg();
                    }
                    needsGenerating = true;
                    faces = this.getIntArray2(i);
                    points = this.getAllPoints(eval.iToken + 1);
                    i = eval.iToken;
                    if (points[0] instanceof Atom) {
                        this.setShapeProperty(21, "model", ((Atom)points[0]).getModelIndex());
                    }
                    propertyName = "definedFaces";
                    propertyValue = new Object[]{faces, points};
                    break;
                }
                case 1073741961: {
                    propertyName = "full";
                    break;
                }
                case 2: {
                    if (id != null) {
                        this.invArg();
                    }
                    propertyName = "nVertices";
                    propertyValue = this.intParameter(i);
                    needsGenerating = true;
                    if (this.tokAt(i + 1) != 0x10000030) break;
                    ++i;
                    break;
                }
                case 1677721602: {
                    if (id != null) {
                        this.invArg();
                    }
                    if (nAtomSets > 0) {
                        this.invPO();
                    }
                    needsGenerating = true;
                    propertyName = "bonds";
                    haveBonds = true;
                    break;
                }
                case 1073741852: {
                    if (radius != -1.0f) {
                        this.invArg();
                    }
                    radius = 0.0f;
                    --i;
                }
                case 1665140738: {
                    ++i;
                }
                case 3: {
                    if (id != null) {
                        this.invArg();
                    }
                    if (nAtomSets > 0) {
                        this.invPO();
                    }
                    propertyName = radius <= 0.0f ? "radius" : "radius1";
                    radius = radius == 0.0f ? 0.0f : this.floatParameter(i);
                    propertyValue = Float.valueOf(radius);
                    needsGenerating = true;
                    break;
                }
                case 1073742066: {
                    if (!this.isFloatParameter(i + 1)) {
                        offset = this.getPoint3f(++i, true);
                        i = eval.iToken;
                        ok = true;
                        continue block33;
                    }
                }
                case 1073741937: {
                    this.setShapeProperty(21, "collapsed", null);
                }
                case 0x40000064: 
                case 1073742099: {
                    propertyName = T.nameOf(eval.theTok);
                    switch (this.tokAt(i + 1)) {
                        case 0x10000030: 
                        case 268435860: {
                            ++i;
                        }
                    }
                    propertyValue = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 1094717454: {
                    if (id == null) {
                        this.invArg();
                    }
                    propertyName = "model";
                    propertyValue = this.intParameter(++i);
                    break;
                }
                case 1073742170: {
                    if (nAtomSets > 1 || id != null && !haveCenter || noToParam == i) {
                        this.invPO();
                    }
                    nAtomSets = 3;
                    if (eval.isAtomExpression(++i)) {
                        propertyName = needsGenerating ? "to" : "toBitSet";
                        propertyValue = this.atomExpressionAt(i);
                    } else if (eval.isArrayParameter(i)) {
                        propertyName = "toVertices";
                        propertyValue = eval.getPointArray(i, -1, false);
                    } else {
                        this.error(19);
                    }
                    i = eval.iToken;
                    needsGenerating = true;
                    break;
                }
                case 10: 
                case 12290: 
                case 1073742325: {
                    if (typeSeen) {
                        this.invPO();
                    }
                    switch (++nAtomSets) {
                        case 1: {
                            if (id != null) {
                                this.invArg();
                            }
                            propertyName = "centers";
                            break;
                        }
                        case 2: {
                            propertyName = "to";
                            needsGenerating = true;
                            break;
                        }
                        default: {
                            eval.bad();
                        }
                    }
                    propertyValue = this.atomExpressionAt(i);
                    i = eval.iToken;
                    needsGenerating |= i + 1 == this.slen;
                    break;
                }
                case 603979967: 
                case 1073742074: 
                case 1765808134: {
                    translucentLevel = this.getColorTrans(eval, i, true, colorArgb);
                    i = eval.iToken;
                    continue block33;
                }
                case 1073741886: {
                    if (typeSeen) {
                        this.error(18);
                    }
                    typeSeen = true;
                    if (this.isFloatParameter(i + 1)) {
                        this.setShapeProperty(21, "faceCenterOffset", Float.valueOf(this.floatParameter(++i)));
                    }
                    propertyName = "collapsed";
                    break;
                }
                case 1073741933: 
                case 0x40000084: 
                case 1073742044: {
                    if (edgeParameterSeen) {
                        this.error(18);
                    }
                    edgeParameterSeen = true;
                    ok = true;
                    propertyName = T.nameOf(eval.theTok);
                    break;
                }
                case 1073741861: 
                case 1073741958: 
                case 1073741964: 
                case 1073742060: 
                case 1073742182: {
                    continue block33;
                }
                case 4: 
                case 0x100000B1: 
                case 0x40000000: 
                case 1073741974: {
                    if (!eval.isColorParam(i)) {
                        if (i != 1) {
                            this.invPO();
                        }
                        id = eval.theTok == 1073741974 ? this.stringParameter(++i) : eval.optParameterAsString(i);
                        this.setShapeProperty(21, "thisID", id);
                        this.setShapeProperty(21, "model", this.vwr.am.cmi);
                        if (!eval.isCenterParameter(i + 1)) continue block33;
                        propertyName = "center";
                        propertyValue = this.centerParameter(++i);
                        i = eval.iToken;
                        haveCenter = true;
                        break;
                    }
                }
                default: {
                    if (eval.isColorParam(i)) {
                        colorArgb[0] = eval.getArgbParam(i);
                        if (eval.isCenterParameter(i)) {
                            noToParam = eval.iToken + 1;
                        }
                        i = eval.iToken;
                        continue block33;
                    }
                    this.invArg();
                }
            }
            if (propertyName != null) {
                this.setShapeProperty(21, propertyName, propertyValue);
            }
            if (!onOffDelete) continue;
            return;
        }
        if (needsGenerating) {
            if (!typeSeen && haveBonds) {
                this.setShapeProperty(21, "bonds", null);
            }
            this.setShapeProperty(21, "generate", null);
        } else if (!ok) {
            this.error(19);
        }
        if (offset != null) {
            this.setShapeProperty(21, "offset", offset);
        }
        if (!Float.isNaN(scale)) {
            this.setShapeProperty(21, "scale", Float.valueOf(scale));
        }
        if (colorArgb[0] != Integer.MIN_VALUE) {
            this.setShapeProperty(21, "colorThis", colorArgb[0]);
        }
        if (translucentLevel != Float.MAX_VALUE) {
            eval.setShapeTranslucency(21, "", "translucentThis", translucentLevel, null);
        }
        this.setShapeProperty(21, "init", Boolean.FALSE);
    }

    private String write(T[] args) throws ScriptException {
        Hashtable<String, Object> params;
        boolean isImage;
        String s;
        T t0;
        ScriptEval eval = this.e;
        int pt = 1;
        int pt0 = 1;
        String[] scripts = null;
        String msg = null;
        String localPath = null;
        String remotePath = null;
        String type = "SPT";
        boolean isCommand = true;
        boolean showOnly = false;
        if (args == null) {
            args = this.st;
            showOnly = this.vwr.isApplet && !this.vwr.isSignedApplet || !this.vwr.haveAccess(Viewer.ACCESS.ALL) || this.vwr.fm.getPathForAllFiles().length() > 0;
        } else {
            pt0 = 0;
            pt = 0;
            isCommand = false;
            showOnly = !isCommand;
        }
        int tok = CmdExt.tokAtArray(pt, args);
        if (tok == 4 && !isCommand && (t0 = T.getTokenFromName(SV.sValue(args[0]).toLowerCase())) != null) {
            tok = t0.tok;
        }
        switch (tok) {
            case 0: {
                break;
            }
            case 4138: 
            case 134221850: 
            case 1715472409: {
                msg = this.plot(args);
                return showOnly ? msg : this.writeMsg(msg);
            }
            case 134222850: {
                if (!eval.isArrayParameter(pt + 1)) break;
                scripts = eval.stringParameterSet(++pt);
                localPath = ".";
                remotePath = ".";
                pt0 = pt = eval.iToken + 1;
                tok = this.tokAt(pt);
                break;
            }
            default: {
                type = SV.sValue(this.tokenAt(pt, args)).toUpperCase();
            }
        }
        String driverList = this.vwr.getExportDriverList();
        String data = null;
        int argCount = isCommand ? this.slen : args.length;
        String type2 = "";
        String val = null;
        SV tVar = null;
        int nVibes = 0;
        String sceneType = "PNGJ";
        boolean isCoord = false;
        BS bsFrames = null;
        int width = -1;
        int height = -1;
        boolean isExport = false;
        String fileName = null;
        if (tok != 0 && isCommand && this.slen > 1 && this.tokAt(this.slen - 2) == 1073741848) {
            type = this.paramAsStr(this.slen - 1).toUpperCase();
            pt0 = argCount;
            argCount -= 2;
            tok = 0;
        }
        switch (tok) {
            case 0: {
                break;
            }
            case 6: 
            case 15: {
                type = "VAR";
                tVar = (SV)this.tokenAt(pt++, args);
                break;
            }
            case 1073741983: {
                type = "INLINE";
                data = SV.sValue(this.tokenAt(++pt, args));
                ++pt;
                break;
            }
            case 0x8000022: {
                type = "PGRP";
                type2 = SV.sValue(this.tokenAt(++pt, args)).toLowerCase();
                if (!type2.equals("draw")) break;
                ++pt;
                break;
            }
            case 1073742329: {
                ++pt;
                isCoord = true;
                break;
            }
            case 134222850: 
            case 1073742158: {
                val = SV.sValue(this.tokenAt(++pt, args)).toLowerCase();
                while (val.equals("localpath") || val.equals("remotepath")) {
                    if (val.equals("localpath")) {
                        localPath = SV.sValue(this.tokenAt(++pt, args));
                    } else {
                        remotePath = SV.sValue(this.tokenAt(++pt, args));
                    }
                    val = SV.sValue(this.tokenAt(++pt, args)).toLowerCase();
                }
                type = "SPT";
                break;
            }
            case 135180: 
            case 135188: 
            case 134320141: 
            case 1073742015: 
            case 1073742018: 
            case 1073877010: 
            case 1073877011: 
            case 1228935687: 
            case 1610616855: {
                ++pt;
                break;
            }
            case 1073741991: {
                type = "ZIPALL";
                ++pt;
                break;
            }
            case 36868: {
                type = "VAR";
                pt += 2;
                break;
            }
            case 4: 
            case 4115: 
            case 4120: 
            case 4166: 
            case 0x40000000: 
            case 1073742139: {
                switch (tok) {
                    case 4115: {
                        BS bsAtoms;
                        if (pt + 1 < argCount && args[++pt].tok == 1073742325 || args[pt].tok == 10) {
                            bsAtoms = eval.atomExpression(args, pt, 0, true, false, null, true);
                            pt = eval.iToken + 1;
                        } else {
                            bsAtoms = this.vwr.getAllAtoms();
                        }
                        if (this.chk) break;
                        bsFrames = this.vwr.ms.getModelBS(bsAtoms, true);
                        break;
                    }
                    case 4120: {
                        type = "IMAGE";
                        ++pt;
                        break;
                    }
                    case 1073742139: {
                        val = SV.sValue(this.tokenAt(++pt, args)).toUpperCase();
                        if (!PT.isOneOf(val, ";PNG;PNGJ;")) break;
                        sceneType = val;
                        ++pt;
                        break;
                    }
                    case 4166: {
                        nVibes = eval.intParameterRange(++pt, 1, 10);
                        if (nVibes == Integer.MAX_VALUE) {
                            return "";
                        }
                        if (!this.chk) {
                            this.vwr.tm.setVibrationPeriod(0.0f);
                            if (!eval.isJS) {
                                eval.delayScript(100);
                            }
                        }
                        ++pt;
                        break;
                    }
                    default: {
                        tok = 4120;
                    }
                }
                if (tok == 4120 && pt < args.length) {
                    T t = T.getTokenFromName(SV.sValue(args[pt]).toLowerCase());
                    if (t != null) {
                        type = SV.sValue(t).toUpperCase();
                    }
                    if (PT.isOneOf(type, driverList.toUpperCase())) {
                        ++pt;
                        type = type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase();
                        isExport = true;
                        if (!isCommand) break;
                        fileName = "Jmol." + type.toLowerCase();
                        break;
                    }
                    if (PT.isOneOf(type, ";ZIP;ZIPALL;SPT;STATE;")) {
                        ++pt;
                        break;
                    }
                    type = "IMAGE";
                }
                if (CmdExt.tokAtArray(pt, args) != 2) break;
                if ((width = SV.iValue(this.tokenAt(pt++, args))) <= 0) {
                    this.invArg();
                }
                if ((height = SV.iValue(this.tokenAt(pt++, args))) > 0) break;
                this.invArg();
            }
        }
        int quality = Integer.MIN_VALUE;
        if (pt0 < argCount) {
            val = SV.sValue(this.tokenAt(pt, args));
            if (val.equalsIgnoreCase("clipboard")) {
                if (this.chk) {
                    return "";
                }
            } else if (PT.isOneOf(val.toLowerCase(), ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;")) {
                if (CmdExt.tokAtArray(pt + 1, args) == 2 && CmdExt.tokAtArray(pt + 2, args) == 2) {
                    if ((width = SV.iValue(this.tokenAt(++pt, args))) <= 0) {
                        this.invArg();
                    }
                    if ((height = SV.iValue(this.tokenAt(++pt, args))) <= 0) {
                        this.invArg();
                    }
                }
                if (CmdExt.tokAtArray(pt + 1, args) == 2) {
                    quality = SV.iValue(this.tokenAt(++pt, args));
                }
            } else if (PT.isOneOf(val.toLowerCase(), ";xyz;xyzrn;xyzvib;mol;mol67;sdf;v2000;v3000;json;pdb;pqr;cml;cif;")) {
                type = val.toUpperCase();
                if (pt + 1 == argCount) {
                    ++pt;
                }
            }
            if (type.equals("IMAGE") && PT.isOneOf(val.toLowerCase(), ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;scene;")) {
                type = val.toUpperCase();
                ++pt;
            }
        }
        if (pt + 2 == argCount && (s = SV.sValue(this.tokenAt(++pt, args))).length() > 0 && s.charAt(0) != '.') {
            type = val.toUpperCase();
        }
        switch (CmdExt.tokAtArray(pt, args)) {
            case 0: {
                showOnly = true;
                break;
            }
            case 1073741884: {
                break;
            }
            case 805306401: {
                fileName = type.equals("IMAGE") ? "?jmol.png" : "?jmol." + type.toLowerCase();
                break;
            }
            case 4: 
            case 0x40000000: {
                fileName = SV.sValue(this.tokenAt(pt, args));
                if (!fileName.equalsIgnoreCase("clipboard") && this.vwr.haveAccess(Viewer.ACCESS.ALL)) break;
                fileName = null;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (type.equals("IMAGE") || type.equals("FRAME") || type.equals("VIBRATION")) {
            String string = type = fileName != null && fileName.indexOf(".") >= 0 ? fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase() : "JPG";
        }
        if (type.equals("ISOSURFACE")) {
            String string = type = fileName != null && fileName.indexOf(".") >= 0 ? fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase() : "JVXL";
            if (type.equals("PMESH")) {
                type = "ISOMESH";
            } else if (type.equals("PMB")) {
                type = "ISOMESHBIN";
            }
        }
        if (!(isImage = PT.isOneOf(type.toLowerCase(), ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;scene;"))) {
            if (type.equals("MNU")) {
                type = "MENU";
            } else if (type.equals("WRL") || type.equals("VRML")) {
                type = "Vrml";
                isExport = true;
            } else if (type.equals("X3D")) {
                type = "X3d";
                isExport = true;
            } else if (type.equals("STL")) {
                type = "Stl";
                isExport = true;
            } else if (type.equals("IDTF")) {
                type = "Idtf";
                isExport = true;
            } else if (type.equals("MA")) {
                type = "Maya";
                isExport = true;
            } else if (type.equals("JS")) {
                type = "Js";
                isExport = true;
            } else if (type.equals("OBJ")) {
                type = "Obj";
                isExport = true;
            } else if (type.equals("JVXL")) {
                type = "ISOSURFACE";
            } else if (type.equals("XJVXL")) {
                type = "ISOSURFACE";
            } else if (type.equals("JMOL")) {
                type = "ZIPALL";
            } else if (type.equals("HIS")) {
                type = "HISTORY";
            }
            if (type.equals("COORD") || type.equals("COORDS")) {
                String string = type = fileName != null && fileName.indexOf(".") >= 0 ? fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
            }
        }
        if (scripts != null) {
            if (type.equals("PNG")) {
                type = "PNGJ";
            }
            if (!(type.equals("PNGJ") || type.equals("ZIPALL") || type.equals("ZIP"))) {
                this.invArg();
            }
        }
        if (!(isImage || isExport || PT.isOneOf(type, ";SCENE;JMOL;ZIP;ZIPALL;SPT;HISTORY;MO;NBO;ISOSURFACE;MESH;PMESH;PMB;ISOMESHBIN;ISOMESH;VAR;FILE;FUNCTION;CFI;CIF;CML;JSON;XYZ;XYZRN;XYZVIB;MENU;MOL;MOL67;PDB;PGRP;PQR;QUAT;RAMA;SDF;V2000;V3000;INLINE;"))) {
            eval.errorStr2(54, "COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|INLINE|ISOSURFACE|JMOL|MENU|MO|NBO|POINTGROUP|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|SPT|STATE|VAR x|ZIP|ZIPALL  CLIPBOARD", "CIF|CML|CFI|GIF|GIFT|JPG|JPG64|JMOL|JVXL|MESH|MOL|PDB|PMESH|PNG|PNGJ|PNGT|PPM|PQR|SDF|CD|JSON|V2000|V3000|SPT|XJVXL|XYZ|XYZRN|XYZVIB|ZIP" + driverList.toUpperCase().replace(';', '|'));
        }
        if (this.chk) {
            return "";
        }
        String[] fullPath = new String[1];
        boolean timeMsg = this.vwr.getBoolean(603979934);
        if (isExport) {
            if (timeMsg) {
                Logger.startTimer("export");
            }
            Hashtable<String, Object> eparams = new Hashtable<String, Object>();
            eparams.put("type", type);
            if (fileName != null) {
                eparams.put("fileName", fileName);
            }
            if (isCommand || fileName != null) {
                eparams.put("fullPath", fullPath);
            }
            eparams.put("width", width);
            eparams.put("height", height);
            data = this.vwr.generateOutputForExport(eparams);
            if (data == null || data.length() == 0) {
                return "";
            }
            if (showOnly) {
                return data;
            }
            if (!type.equals("Povray") && !type.equals("Idtf") || fullPath[0] == null) {
                return this.writeMsg(data);
            }
            String ext = type.equals("Idtf") ? ".tex" : ".ini";
            fileName = fullPath[0] + ext;
            Hashtable<String, Object> params2 = new Hashtable<String, Object>();
            params2.put("fileName", fileName);
            params2.put("type", ext);
            params2.put("text", data);
            params2.put("fullPath", fullPath);
            msg = this.vwr.processWriteOrCapture(params2);
            if (type.equals("Idtf")) {
                data = data.substring(0, data.indexOf("\\begin{comment}"));
            }
            data = "Created " + fullPath[0] + ":\n\n" + data;
            if (timeMsg) {
                this.showString(Logger.getTimerMsg("export", 0));
            }
            if (msg != null) {
                boolean isError;
                boolean bl = isError = !msg.startsWith("OK");
                if (isError) {
                    eval.evalError(msg, null);
                }
                eval.report(data, isError);
            }
            return "";
        }
        Object bytes = null;
        boolean writeFileData = false;
        if (data == null) {
            int len = 0;
            data = type.intern();
            if (data == "MENU") {
                data = this.vwr.getMenu("");
            } else if (data == "PGRP") {
                data = this.vwr.ms.getPointGroupAsString(this.vwr.bsA(), null, 0, 1.0f, null, null, type2.equals("draw") ? "" : null);
            } else if (data == "PDB" || data == "PQR") {
                if (showOnly) {
                    data = this.vwr.getPdbAtomData(null, null, data == "PQR", isCoord);
                } else {
                    writeFileData = true;
                    type = "PDB_" + data + "-coord " + isCoord;
                }
            } else if (data == "FILE") {
                if ("?".equals(fileName)) {
                    fileName = "?Jmol." + this.vwr.getP("_fileType");
                }
                if (showOnly) {
                    data = this.vwr.getCurrentFileAsString("script");
                } else {
                    writeFileData = true;
                }
            } else if (data == "CIF" || data == "SDF" || data == "MOL" || data == "MOL67" || data == "V2000" || data == "V3000" || data == "CD" || data == "JSON" || data == "XYZ" || data == "XYZRN" || data == "XYZVIB" || data == "CML") {
                if ((data = this.vwr.getModelExtract("selected", isCoord, false, data)).startsWith("ERROR:")) {
                    bytes = data;
                }
            } else if (data == "CFI") {
                data = this.vwr.getModelFileData("selected", "cfi", false);
            } else if (data == "FUNCTION") {
                data = this.vwr.getFunctionCalls(null);
                type = "TXT";
            } else if (data == "VAR") {
                if (tVar == null) {
                    tVar = (SV)eval.getParameter(SV.sValue(this.tokenAt(isCommand ? 2 : 1, args)), 1073742190, true);
                }
                Lst<byte[]> v = null;
                if (tVar.tok == 15) {
                    v = new Lst<byte[]>();
                    v.addLast(((BArray)tVar.value).data);
                } else if (tVar.tok == 6) {
                    Lst<Object> lst = v = fileName == null ? new Lst() : this.prepareBinaryOutput(tVar);
                }
                if (v == null) {
                    data = tVar.asString();
                    type = "TXT";
                } else if (fileName != null) {
                    params = new Hashtable();
                    params.put("data", v);
                    data = (String)this.vwr.createZip(fileName, v.size() == 1 || fileName.endsWith(".png") || fileName.endsWith(".pngj") ? "BINARY" : "ZIPDATA", params);
                    bytes = data;
                    if (data == null) {
                        eval.evalError("#CANCELED#", null);
                    }
                }
            } else if (data == "SPT") {
                if (isCoord) {
                    BS tainted = this.vwr.ms.getTaintedAtoms(2);
                    this.vwr.setAtomCoordsRelative(P3.new3(0.0f, 0.0f, 0.0f), null);
                    data = this.vwr.getStateInfo();
                    this.vwr.ms.setTaintedAtoms(tainted, 2);
                } else {
                    data = this.vwr.getStateInfo();
                    if (localPath != null || remotePath != null) {
                        data = FileManager.setScriptFileReferences(data, localPath, remotePath, null);
                    }
                }
            } else if (data == "ZIP" || data == "ZIPALL") {
                if (fileName != null) {
                    params = new Hashtable();
                    if (scripts != null) {
                        params.put("data", scripts);
                    }
                    data = (String)this.vwr.createZip(fileName, type, params);
                    bytes = data;
                    if (data == null) {
                        eval.evalError("#CANCELED#", null);
                    }
                }
            } else if (data == "HISTORY") {
                data = this.vwr.getSetHistory(Integer.MAX_VALUE);
                type = "SPT";
            } else if (data == "MO" || data == "NBO") {
                data = this.getMoJvxl(Integer.MAX_VALUE, data == "NBO");
                type = "XJVXL";
            } else if (data == "PMESH" || data == "PMB") {
                if ((data = (String)this.getIsosurfaceJvxl(29, data)) == null) {
                    this.error(31);
                }
                type = "XJVXL";
            } else if (data == "ISOMESH") {
                if ((data = (String)this.getIsosurfaceJvxl(24, data)) == null) {
                    this.error(31);
                }
                type = "PMESH";
            } else if (data == "ISOMESHBIN") {
                bytes = this.getIsosurfaceJvxl(24, "ISOMESHBIN");
                if (bytes == null) {
                    this.error(31);
                }
                type = "PMB";
            } else if (data == "ISOSURFACE" || data == "MESH") {
                if ((data = (String)this.getIsosurfaceJvxl(24, data)) == null) {
                    this.error(31);
                }
                String string = type = data.indexOf("<?xml") >= 0 ? "XJVXL" : "JVXL";
                if (!showOnly) {
                    this.showString((String)this.getShapeProperty(24, "jvxlFileInfo"));
                }
            } else {
                if (isCommand && showOnly && fileName == null) {
                    showOnly = false;
                    fileName = "\u0001";
                }
                len = -1;
                if (quality < 0) {
                    quality = -1;
                }
            }
            if (data == null) {
                data = "";
            }
            if (len == 0) {
                int n = bytes == null ? data.length() : (len = bytes instanceof String ? ((String)bytes).length() : ((byte[])bytes).length);
            }
        }
        if (!isCommand) {
            return data;
        }
        if (showOnly) {
            eval.showStringPrint(data, true);
            return "";
        }
        if (bytes != null && bytes instanceof String) {
            return this.writeMsg((String)bytes);
        }
        if (writeFileData) {
            return this.writeMsg(this.vwr.writeFileData(fileName, type, 0, null));
        }
        if (type.equals("SCENE")) {
            bytes = sceneType;
        } else if (!(bytes != null || isImage && fileName == null)) {
            bytes = data;
        }
        if (timeMsg) {
            Logger.startTimer("write");
        }
        if (isImage) {
            eval.refresh(false);
            if (width < 0) {
                width = this.vwr.getScreenWidth();
            }
            if (height < 0) {
                height = this.vwr.getScreenHeight();
            }
        }
        params = new Hashtable<String, Object>();
        if (fileName != null) {
            params.put("fileName", fileName);
        }
        params.put("backgroundColor", this.vwr.getBackgroundArgb());
        params.put("type", type);
        if (bytes instanceof String && quality == Integer.MIN_VALUE) {
            params.put("text", bytes);
        } else if (bytes instanceof byte[]) {
            params.put("bytes", bytes);
        }
        if (scripts != null) {
            params.put("scripts", scripts);
        }
        if (bsFrames != null) {
            params.put("bsFrames", bsFrames);
        }
        params.put("fullPath", fullPath);
        params.put("quality", quality);
        params.put("width", width);
        params.put("height", height);
        params.put("nVibes", nVibes);
        msg = this.vwr.processWriteOrCapture(params);
        if (msg == null) {
            msg = "canceled";
        }
        if (isImage && msg.startsWith("OK")) {
            msg = msg + "; width=" + width + "; height=" + height;
        }
        if (timeMsg) {
            this.showString(Logger.getTimerMsg("write", 0));
        }
        return this.writeMsg(msg);
    }

    public Lst<Object> prepareBinaryOutput(SV tvar) {
        Map<String, SV> m = tvar.getMap();
        if (m == null || !m.containsKey("$_BINARY_$")) {
            return null;
        }
        Lst<Object> v = new Lst<Object>();
        for (Map.Entry<String, SV> e : m.entrySet()) {
            byte[] bytes;
            String key = e.getKey();
            if (key.equals("$_BINARY_$")) continue;
            SV o = e.getValue();
            byte[] byArray = bytes = o.tok == 15 ? ((BArray)o.value).data : null;
            if (bytes == null) {
                String s = o.asString();
                byte[] byArray2 = bytes = s.startsWith(";base64,") ? Base64.decodeBase64(s) : s.getBytes();
            }
            if (key.equals("_DATA_")) {
                v = new Lst();
                v.addLast(bytes);
                return v;
            }
            if (key.equals("_IMAGE_")) {
                v.add(0, key);
                v.add(1, null);
                v.add(2, bytes);
                continue;
            }
            v.addLast(key);
            v.addLast((Object)null);
            v.addLast(bytes);
        }
        return v;
    }

    private String writeMsg(String msg) throws ScriptException {
        boolean isError;
        if (this.chk || msg == null) {
            return "";
        }
        boolean bl = isError = !msg.startsWith("OK");
        if (isError) {
            this.e.evalError(msg, null);
        }
        this.e.report(msg, isError);
        return msg;
    }

    private void show() throws ScriptException {
        int tok;
        ScriptEval eval = this.e;
        String value = null;
        String str = this.paramAsStr(1);
        String filter = null;
        int filterLen = 0;
        if (this.slen > 2 && this.tokAt(this.slen - 2) == 0x100000B0) {
            filter = "/" + this.paramAsStr(this.slen - 1);
            this.slen -= 2;
            filterLen = 2;
        } else {
            filter = this.paramAsStr(this.slen - 1);
            if (filter.lastIndexOf("/") == 0) {
                --this.slen;
                filterLen = 1;
            } else {
                filter = null;
            }
        }
        String msg = null;
        String name = null;
        int len = 2;
        T token = this.getToken(1);
        int n = tok = token instanceof SV && token.tok != 0x40000000 ? 0 : token.tok;
        if (tok == 4 && (token = T.getTokenFromName(str.toLowerCase())) != null) {
            tok = token.tok;
        }
        if (tok != 1296041986 && tok != 1073742158 && tok != 1715472409 && tok != 1228935687) {
            this.checkLength(-3);
        }
        if (this.slen == 2 && str.indexOf("?") >= 0) {
            msg = this.vwr.getAllSettings(str.substring(0, str.indexOf("?")));
            tok = -1;
        }
        block1 : switch (tok) {
            case -1: {
                break;
            }
            case 0: {
                if (this.chk) break;
                msg = ((SV)eval.theToken).escape();
                break;
            }
            case 1073741925: {
                eval.checkLength23();
                len = this.st.length;
                if (this.chk) break;
                Object d = this.vwr.ms.getInfo(this.vwr.am.cmi, "domains");
                if (d instanceof SV) {
                    msg = this.vwr.getAnnotationInfo((SV)d, eval.optParameterAsString(2), 1073741925);
                    break;
                }
                msg = "domain information has not been loaded";
                break;
            }
            case 1715472409: {
                msg = this.plot(this.st);
                len = this.st.length;
                break;
            }
            case 1073742189: {
                eval.checkLength23();
                len = this.st.length;
                if (this.chk) break;
                Object d = this.vwr.ms.getInfo(this.vwr.am.cmi, "validation");
                if (d instanceof SV) {
                    msg = this.vwr.getAnnotationInfo((SV)d, eval.optParameterAsString(2), 1073742189);
                    break;
                }
                msg = "validation information has not been loaded";
                break;
            }
            case 134221829: {
                if (this.chk) break;
                msg = Escape.e(this.vwr.fm.cacheList());
                break;
            }
            case 1111490587: {
                eval.checkLength23();
                len = this.st.length;
                if (this.chk) break;
                Object d = this.vwr.ms.getInfo(this.vwr.am.cmi, "dssr");
                msg = d == null ? "no DSSR information has been read" : (len > 2 ? SV.getVariable(this.vwr.extractProperty(d, this.stringParameter(2), -1)).asString() : "" + SV.getVariable(d).asString());
                break;
            }
            case 1073741915: {
                int version = 2;
                if (this.slen == 3) {
                    len = 3;
                    version = (int)this.floatParameter(3 - 1);
                } else {
                    this.checkLength(2 + filterLen);
                }
                if (this.chk) break;
                msg = this.vwr.calculateStructures(null, true, false, version);
                break;
            }
            case 545259572: {
                this.checkLength(2 + filterLen);
                if (this.chk) break;
                msg = this.vwr.fm.getPathForAllFiles();
                break;
            }
            case 1275203608: {
                if (this.chk) break;
                Object[] info = new Object[2];
                this.vwr.shm.getShapePropertyData(21, "allInfo", info);
                msg = SV.getVariable(info[1]).asString();
                break;
            }
            case 1073742038: {
                if (!this.chk) {
                    this.vwr.getNMRPredict(eval.optParameterAsString(2));
                }
                return;
            }
            case 134218757: 
            case 1073741879: 
            case 1073741929: {
                this.checkLength((tok == 1073741879 || tok == 134218757 && this.tokAt(2) == 1073742335 ? (len = 3) : 2) + filterLen);
                if (this.chk) {
                    return;
                }
                String param2 = eval.optParameterAsString(2);
                if (tok == 1073741879) {
                    if ("mf".equals(param2)) {
                        param2 = "formula";
                    }
                    if ("formula".equals(param2) && (msg = (String)this.vwr.ms.getInfo(this.vwr.am.cmi, "formula")) != null) {
                        msg = PT.rep(msg, " ", "");
                    }
                }
                if (msg != null) break;
                try {
                    if (tok != 134218757) {
                        msg = this.vwr.ms.getModelDataBaseName(this.vwr.bsA());
                        msg = msg != null && (msg.startsWith("$") || msg.startsWith(":")) ? msg.substring(1) : null;
                    } else if (param2.equalsIgnoreCase("true")) {
                        msg = this.vwr.getBioSmiles(null);
                        filter = null;
                    } else if (filter != null) {
                        msg = this.vwr.getSmilesOpt(null, -1, -1, 1, filter + "///");
                        filter = null;
                    }
                    if (msg == null) {
                        msg = tok == 134218757 ? this.vwr.getSmiles(null) : this.vwr.getOpenSmiles(null);
                    }
                }
                catch (Exception ex) {
                    msg = ex.getMessage();
                }
                switch (tok) {
                    case 134218757: {
                        break;
                    }
                    case 1073741929: {
                        if (msg.length() > 0) {
                            this.vwr.fm.loadImage(this.vwr.setLoadFormat("_" + msg, '2', false), "\u0001" + msg, false);
                            return;
                        }
                        msg = "Could not show drawing -- Either insufficient atoms are selected or the model is a PDB file.";
                        break;
                    }
                    case 1073741879: {
                        len = 3;
                        if (msg.length() > 0) {
                            if ((msg = this.vwr.getChemicalInfo(msg, param2, this.vwr.bsA())).indexOf("FileNotFound") < 0) break;
                            msg = "?";
                            break;
                        }
                        msg = "Could not show name -- Either insufficient atoms are selected or the model is a PDB file.";
                    }
                }
                break;
            }
            case 1073742152: 
            case 1296041986: {
                msg = "";
                Map<String, Object> info = null;
                len = this.slen;
                if (len == 2) {
                    if (this.chk) break;
                    info = this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, null, -1);
                } else if (tok == 1073742152) {
                    String sg = this.paramAsStr(2);
                    len = 3;
                    if (this.chk) break;
                    info = this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, PT.rep(sg, "''", "\""), -1);
                }
                if (info != null) {
                    msg = (tok == 1073742152 ? "" + info.get("spaceGroupInfo") + info.get("spaceGroupNote") : "") + info.get("symmetryInfo");
                    break;
                }
                int iop = this.tokAt(2) == 2 ? this.intParameter(2) : 0;
                String xyz = this.tokAt(2) == 4 ? this.paramAsStr(2) : null;
                P3 pt1 = null;
                P3 pt2 = null;
                int nth = -1;
                if (this.slen > 3 && this.tokAt(3) != 4) {
                    Object[] ret = new BS[]{null, this.vwr.getFrameAtoms()};
                    pt1 = eval.centerParameter(2 + (iop == 0 ? 0 : 1), ret);
                    if (ret[0] != null && ((BS)ret[0]).cardinality() == 0) {
                        len = this.slen;
                        break;
                    }
                    ret[0] = null;
                    if (iop == 0) {
                        pt2 = eval.centerParameter(++eval.iToken, ret);
                        if (ret[0] != null && ((BS)ret[0]).cardinality() == 0) {
                            len = this.slen;
                            break;
                        }
                    }
                    if (this.tokAt(eval.iToken + 1) == 2) {
                        nth = eval.getToken((int)(++eval.iToken)).intValue;
                    }
                }
                String type = eval.iToken > 1 && this.tokAt(eval.iToken + 1) == 4 ? this.stringParameter(++eval.iToken) : null;
                len = ++eval.iToken;
                this.checkLength(eval.iToken + filterLen);
                if (this.chk) break;
                Object o = this.vwr.getSymTemp().getSymmetryInfoAtom(this.vwr.ms, this.vwr.getAllAtoms().nextSetBit(0), xyz, iop, pt1, pt2, type, 0, 0.0f, nth);
                msg = o instanceof Map ? SV.getVariable(o).asString() : o.toString();
                break;
            }
            case 1648363544: {
                VDW vdwType = null;
                if (this.slen > 2) {
                    len = this.slen;
                    vdwType = VDW.getVdwType(this.paramAsStr(2));
                    if (vdwType == null) {
                        this.invArg();
                    }
                }
                if (this.chk) break;
                msg = this.vwr.getDefaultVdwNameOrData(0, vdwType, null);
                break;
            }
            case 134320141: {
                int pt;
                eval.checkLength23();
                len = this.slen;
                String s = eval.optParameterAsString(2);
                if (filter == null && (pt = s.indexOf(47)) >= 0) {
                    filter = s.substring(pt + 1);
                    s = s.substring(0, pt);
                }
                if (this.chk) break;
                msg = this.vwr.getFunctionCalls(s);
                break;
            }
            case 36867: {
                this.checkLength(2 + filterLen);
                if (this.chk) break;
                msg = this.vwr.getAllSettings(null);
                break;
            }
            case 1073742184: {
                len = this.slen;
                if (len == 2) {
                    if (!this.chk) {
                        this.vwr.showUrl(eval.getFullPathName());
                    }
                } else {
                    name = this.paramAsStr(2);
                    if (!this.chk) {
                        this.vwr.showUrl(name);
                    }
                }
                return;
            }
            case 1765808134: {
                str = "defaultColorScheme";
                break;
            }
            case 0x60000004: {
                str = "scaleAngstromsPerInch";
                break;
            }
            case 4138: 
            case 134221850: {
                if (this.chk) {
                    return;
                }
                int modelIndex = this.vwr.am.cmi;
                if (modelIndex < 0) {
                    eval.errorStr(30, "show " + eval.theToken.value);
                }
                msg = this.plot(this.st);
                len = this.slen;
                break;
            }
            case 14: 
            case 1112152078: {
                if (this.chk) break;
                msg = this.getContext(false);
                break;
            }
            case 0x40000040: {
                name = eval.optParameterAsString(2);
                if (name.length() > 0) {
                    len = 3;
                }
                if (this.chk) break;
                value = this.vwr.cm.getColorSchemeList(name);
                break;
            }
            case 1073742192: {
                if (this.chk) break;
                msg = this.vwr.getAtomDefs(this.vwr.definedAtomSets) + this.vwr.g.getVariableList() + this.getContext(true);
                break;
            }
            case 0x2000000E: {
                if (this.chk) break;
                msg = this.vwr.getTrajectoryState();
                break;
            }
            case 553648148: {
                value = "" + ScriptEval.commandHistoryLevelMax;
                break;
            }
            case 553648150: {
                value = "" + Logger.getLogLevel();
                break;
            }
            case 603979825: {
                value = "" + this.vwr.getBoolean(603979825);
                break;
            }
            case 553648178: {
                msg = "set strandCountForStrands " + this.vwr.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.vwr.getStrandCount(13);
                break;
            }
            case 536875070: {
                len = this.slen;
                msg = this.vwr.showTimeout(len == 2 ? null : this.paramAsStr(2));
                break;
            }
            case 0x20000006: {
                value = Escape.eP(this.vwr.getDefaultLattice());
                break;
            }
            case 4126: {
                if (this.chk) break;
                msg = this.vwr.getMinimizationInfo();
                break;
            }
            case 1611272194: {
                switch (this.vwr.g.axesMode) {
                    case 0x24000020: {
                        msg = "set axesUnitcell";
                        break block1;
                    }
                    case 603979804: {
                        msg = "set axesMolecular";
                        break block1;
                    }
                }
                msg = "set axesWindow";
                break;
            }
            case 0x60000001: {
                msg = "set bondMode " + (this.vwr.getBoolean(0x24000024) ? "OR" : "AND");
                break;
            }
            case 1649022989: {
                if (this.chk) break;
                msg = "set strandCountForStrands " + this.vwr.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.vwr.getStrandCount(13);
                break;
            }
            case 1613238294: {
                msg = "set hbondsBackbone " + this.vwr.getBoolean(603979852) + ";set hbondsSolid " + this.vwr.getBoolean(603979854);
                break;
            }
            case 1611141175: {
                if (this.chk) break;
                msg = this.vwr.getSpinState();
                break;
            }
            case 1611141176: {
                msg = "set ssbondsBackbone " + this.vwr.getBoolean(603979952);
                break;
            }
            case 1610625028: 
            case 1611141171: {
                msg = "selectionHalos " + (this.vwr.getSelectionHalosEnabled() ? "ON" : "OFF");
                break;
            }
            case 0x60200006: {
                msg = "set selectHetero " + this.vwr.getBoolean(0x60200006);
                break;
            }
            case 0x40000004: {
                msg = Escape.eAP(this.vwr.getAdditionalHydrogens(null, true, true, null));
                break;
            }
            case 1612709900: {
                msg = "set selectHydrogens " + this.vwr.getBoolean(1612709900);
                break;
            }
            case 0x2000000C: 
            case 0x21000002: 
            case 553648142: 
            case 553648172: 
            case 553648176: 
            case 1073741995: {
                if (this.chk) break;
                msg = this.vwr.getLightingState();
                break;
            }
            case 4146: 
            case 1073742136: {
                if (this.chk) break;
                msg = this.vwr.stm.listSavedStates();
                break;
            }
            case 1814695966: {
                if (this.chk) break;
                msg = this.vwr.getUnitCellInfoText();
                break;
            }
            case 1073742329: {
                len = this.slen;
                if (len == 2) {
                    if (this.chk) break;
                    msg = this.vwr.getCoordinateState(this.vwr.bsA());
                    break;
                }
                String nameC = this.paramAsStr(2);
                if (this.chk) break;
                msg = this.vwr.stm.getSavedCoordinates(nameC);
                break;
            }
            case 1073742158: {
                if (!this.chk && eval.outputBuffer == null) {
                    this.vwr.sm.clearConsole();
                }
                if ((len = this.slen) == 2) {
                    if (this.chk) break;
                    msg = this.vwr.getStateInfo();
                    break;
                }
                if (filter != null && this.slen == 3) {
                    if (this.chk) break;
                    msg = this.vwr.getStateInfo();
                    break;
                }
                if (this.tokAt(2) == 1228935687 && (len = this.slen) == 4) {
                    if (this.chk) break;
                    msg = this.vwr.fm.getEmbeddedFileState(this.paramAsStr(3), true);
                    break;
                }
                len = 3;
                name = this.paramAsStr(2);
                if (this.chk) break;
                msg = this.vwr.stm.getSavedState(name);
                break;
            }
            case 1639976963: {
                len = this.slen;
                if (len == 2) {
                    if (this.chk) break;
                    msg = this.vwr.ms.getProteinStructureState(this.vwr.bsA(), 134222350);
                    break;
                }
                String shape = this.paramAsStr(2);
                if (this.chk) break;
                msg = this.vwr.stm.getSavedStructure(shape);
                break;
            }
            case 134221834: {
                String dtype;
                len = this.slen;
                String string = dtype = len == 3 ? this.paramAsStr(2) : null;
                if (this.chk) break;
                Object[] data = (Object[])this.vwr.getDataObj(dtype, null, -2);
                msg = data == null ? "no data" : Escape.encapsulateData((String)data[0], data[1], (Integer)data[3]);
                break;
            }
            case 1073742330: {
                len = 3;
                msg = eval.setObjectProperty();
                break;
            }
            case 1678381065: {
                if (this.chk) break;
                msg = this.vwr.ms.getBoundBoxCommand(true);
                break;
            }
            case 12289: {
                if (this.chk) break;
                msg = "center " + Escape.eP(this.vwr.tm.fixedRotationCenter);
                break;
            }
            case 135176: {
                if (this.chk) break;
                msg = (String)this.getShapeProperty(22, "command");
                break;
            }
            case 1228935687: {
                if (this.slen == 2) {
                    if (!this.chk) {
                        if (filter == null) {
                            this.vwr.sm.clearConsole();
                        }
                        msg = this.vwr.getCurrentFileAsString("script");
                    }
                    if (msg != null) break;
                    msg = "<unavailable>";
                    break;
                }
                len = 3;
                value = this.paramAsStr(2);
                if (this.chk) break;
                if (filter == null) {
                    this.vwr.sm.clearConsole();
                }
                msg = this.vwr.getFileAsString3(value, true, null);
                break;
            }
            case 4115: {
                if (this.tokAt(2) == 1073742327) {
                    len = 3;
                    if (3 > 0) {
                        msg = this.vwr.getModelFileInfoAll();
                        break;
                    }
                }
                msg = this.vwr.getModelFileInfo();
                break;
            }
            case 1610616855: {
                int n2;
                len = this.slen;
                int n3 = n2 = len == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n2 < 1) {
                    this.invArg();
                }
                if (this.chk) break;
                this.vwr.sm.clearConsole();
                if (eval.scriptLevel == 0) {
                    this.vwr.removeCommand();
                }
                msg = this.vwr.getSetHistory(n2);
                break;
            }
            case 135180: {
                if (this.chk) break;
                msg = (String)this.getShapeProperty(24, "jvxlDataXml");
                break;
            }
            case 1073877010: 
            case 1073877011: {
                int ptMO;
                if (eval.optParameterAsString(2).equalsIgnoreCase("list")) {
                    this.e.sm.loadShape(27);
                    msg = this.chk ? "" : (String)this.getShapeProperty(27, "list -1");
                    len = 3;
                    break;
                }
                len = this.slen;
                int n4 = ptMO = len == 2 ? Integer.MIN_VALUE : this.intParameter(2);
                if (this.chk) break;
                msg = this.getMoJvxl(ptMO, tok == 1073877011);
                break;
            }
            case 1094717454: {
                if (this.chk) break;
                msg = this.vwr.ms.getModelInfoAsString();
                break;
            }
            case 0x20021010: {
                if (this.chk) break;
                msg = this.vwr.getMeasurementInfoAsString();
                break;
            }
            case 1073741864: {
                len = 3;
                if (this.chk || this.slen != len) break;
                msg = this.vwr.getOrientationText(this.tokAt(2), null);
                break;
            }
            case 1073742132: {
                tok = this.tokAt(2);
                if (tok == 0) {
                    tok = 1073742132;
                } else {
                    len = 3;
                }
            }
            case 4129: 
            case 1073742178: {
                if (this.chk) break;
                msg = this.vwr.getOrientationText(tok, null);
                break;
            }
            case 1073742077: {
                len = 2;
                if (this.slen > 3) break;
                tok = this.tokAt(2);
                switch (tok) {
                    case 0: 
                    case 4129: 
                    case 1073742132: 
                    case 1073742178: {
                        if (this.chk) break;
                        msg = this.vwr.getOrientationText(tok, null);
                        break;
                    }
                    default: {
                        name = eval.optParameterAsString(2);
                        msg = this.vwr.getOrientationText(1073742034, name);
                    }
                }
                len = this.slen;
                break;
            }
            case 1073742088: {
                if (this.chk) break;
                msg = this.vwr.ms.getPDBHeader(this.vwr.am.cmi);
                break;
            }
            case 0x8000022: {
                String typ = eval.optParameterAsString(2);
                if (typ.length() == 0) {
                    typ = null;
                }
                len = this.slen;
                if (this.chk) break;
                msg = this.vwr.ms.getPointGroupAsString(this.vwr.bsA(), "show:" + typ, 0, 0.0f, null, null, null);
                break;
            }
            case 1088421903: {
                if (this.chk) break;
                msg = this.vwr.ms.getSymmetryInfoAsString();
                break;
            }
            case 1073742176: {
                if (this.chk) break;
                msg = "transform:\n" + this.vwr.tm.matrixRotate.toString();
                break;
            }
            case 4168: {
                msg = "zoom " + (this.vwr.tm.zoomEnabled ? "" + this.vwr.tm.getZoomSetting() : "off");
                break;
            }
            case 1611272202: {
                msg = this.vwr.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 1665140738: {
                str = "solventProbeRadius";
                break;
            }
            case 1086324744: {
                len = this.slen;
                if (len == 3 && this.tokAt(2) == 1073742334) {
                    tok = 1086324743;
                }
            }
            case 1073741863: 
            case 1073741982: 
            case 1073742120: 
            case 1086324742: 
            case 1086326788: 
            case 1113589787: 
            case 0x44000001: {
                if (this.chk) break;
                msg = this.vwr.getChimeInfo(tok);
                break;
            }
            case 20482: 
            case 537022465: 
            case 0x60000002: 
            case 1612709912: {
                value = "?";
                break;
            }
            case 1073742030: {
                String qualifiers;
                len = this.slen;
                String string = qualifiers = len == 2 ? null : this.paramAsStr(2);
                if (this.chk) break;
                msg = this.vwr.getBindingInfo(qualifiers);
                break;
            }
            case 1073742015: {
                if (this.chk) break;
                value = this.vwr.getMenu("");
                break;
            }
            case 0x40000000: {
                if (!str.equalsIgnoreCase("fileHeader") || this.chk) break;
                msg = this.vwr.ms.getPDBHeader(this.vwr.am.cmi);
                break;
            }
            case 36868: 
            case 1073741992: {
                str = this.paramAsStr(len++);
                SV v = (SV)eval.getParameter(str, 1073742190, true);
                if (this.chk) break;
                msg = tok == 1073741992 ? v.toJSON() : v.escape();
            }
        }
        this.checkLength(len + filterLen);
        if (this.chk) {
            return;
        }
        if (msg != null) {
            this.showString(this.filterShow(msg, filter));
        } else if (value != null) {
            this.showString(str + " = " + value);
        } else if (str != null) {
            if (str.indexOf(" ") >= 0) {
                this.showString(str);
            } else {
                this.showString(str + " = " + ((SV)eval.getParameter(str, 1073742190, true)).escape());
            }
        }
    }

    private String filterShow(String msg, String name) {
        if (name == null) {
            return msg;
        }
        name = name.substring(1).toLowerCase();
        String[] info = PT.split(msg, "\n");
        SB sb = new SB();
        for (int i = 0; i < info.length; ++i) {
            if (info[i].toLowerCase().indexOf(name) < 0) continue;
            sb.append(info[i]).appendC('\n');
        }
        return sb.toString();
    }

    private void stereo() throws ScriptException {
        STER stereoMode = STER.DOUBLE;
        float degrees = -5.0f;
        boolean degreesSeen = false;
        int[] colors = null;
        int colorpt = 0;
        block6: for (int i = 1; i < this.slen; ++i) {
            if (this.e.isColorParam(i)) {
                if (colorpt > 1) {
                    this.e.bad();
                }
                if (colorpt == 0) {
                    colors = new int[2];
                }
                if (!degreesSeen) {
                    degrees = 3.0f;
                }
                colors[colorpt] = this.e.getArgbParam(i);
                if (colorpt++ == 0) {
                    colors[1] = ~colors[0];
                }
                i = this.e.iToken;
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 1073742335: {
                    this.e.iToken = 1;
                    this.e.checkLast(1);
                    this.e.iToken = 1;
                    continue block6;
                }
                case 1073742334: {
                    this.e.iToken = 1;
                    this.e.checkLast(1);
                    stereoMode = STER.NONE;
                    continue block6;
                }
                case 2: 
                case 3: {
                    degrees = this.floatParameter(i);
                    degreesSeen = true;
                    continue block6;
                }
                case 0x40000000: {
                    if (!degreesSeen) {
                        degrees = 3.0f;
                    }
                    if ((stereoMode = STER.getStereoMode(this.paramAsStr(i))) != null) continue block6;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (this.chk) {
            return;
        }
        this.vwr.setStereoMode(colors, stereoMode, degrees);
    }

    private boolean struts() throws ScriptException {
        ScriptEval eval = this.e;
        boolean defOn = this.tokAt(1) == 1073742072 || this.tokAt(1) == 1073742335 || this.slen == 1;
        int mad = eval.getMadParameter();
        if (mad == Integer.MAX_VALUE) {
            return false;
        }
        if (defOn) {
            mad = Math.round(this.vwr.getFloat(570425406) * 2000.0f);
        }
        this.setShapeProperty(1, "type", 32768);
        eval.setShapeSizeBs(1, mad, null);
        this.setShapeProperty(1, "type", 1023);
        return true;
    }

    private void unitcell(int i) throws ScriptException {
        ScriptEval eval = this.e;
        int icell = Integer.MAX_VALUE;
        int mad10 = Integer.MAX_VALUE;
        T3 pt = null;
        TickInfo tickInfo = eval.tickParamAsStr(i, true, false, false);
        i = eval.iToken;
        String id = null;
        T3[] oabc = null;
        Object newUC = null;
        String ucname = null;
        boolean isOffset = false;
        boolean isReset = false;
        int tok = this.tokAt(++i);
        switch (tok) {
            case 4141: 
            case 4142: {
                isReset = true;
                pt = P4.new4(0.0f, 0.0f, 0.0f, -1.0f);
                ++eval.iToken;
                break;
            }
            case 4: 
            case 0x40000000: {
                String s;
                ucname = s = this.paramAsStr(i).toLowerCase();
                if (s.indexOf(",") < 0 && !this.chk) {
                    boolean isPrimitive;
                    eval.setCurrentCagePts(null, null);
                    if (PT.isOneOf(ucname, ";parent;standard;primitive;") && (newUC = this.vwr.ms.getInfo(this.vwr.am.cmi, "unitcell_conventional")) != null) {
                        eval.setCurrentCagePts(this.vwr.getV0abc(newUC), "" + newUC);
                    }
                    if ((s = (String)this.vwr.ms.getInfo(this.vwr.am.cmi, "unitcell_" + ucname)) == null && ((isPrimitive = ucname.equals("primitive")) || ucname.equals("reciprocal"))) {
                        P3[] p3Array;
                        SymmetryInterface u = this.vwr.getCurrentUnitCell();
                        ucname = (u == null ? "" : u.getSpaceGroupName() + " ") + ucname;
                        if (u == null) {
                            P3[] p3Array2 = new P3[4];
                            p3Array2[0] = P3.new3(0.0f, 0.0f, 0.0f);
                            p3Array2[1] = P3.new3(1.0f, 0.0f, 0.0f);
                            p3Array2[2] = P3.new3(0.0f, 1.0f, 0.0f);
                            p3Array = p3Array2;
                            p3Array2[3] = P3.new3(0.0f, 0.0f, 1.0f);
                        } else {
                            p3Array = u.getUnitCellVectors();
                        }
                        oabc = p3Array;
                        String stype = (String)this.vwr.getSymTemp().getSymmetryInfoAtom(this.vwr.ms, this.vwr.getFrameAtoms().nextSetBit(0), null, 0, null, null, null, 0x400000AA, 0.0f, -1);
                        if (u == null) {
                            u = this.vwr.getSymTemp();
                        }
                        u.toFromPrimitive(true, stype.length() == 0 ? (char)'P' : (char)stype.charAt(0), oabc);
                        if (isPrimitive) break;
                        float scale = this.slen == i + 1 ? 1.0f : (this.tokAt(i + 1) == 2 ? (float)this.intParameter(++i) * (float)Math.PI : this.floatParameter(++i));
                        SimpleUnitCell.getReciprocal(oabc, oabc, scale);
                        break;
                    }
                    this.showString(s);
                }
                newUC = s;
                break;
            }
            case 135180: 
            case 1073742330: {
                id = eval.objectNameParameter(++i);
                break;
            }
            case 1678381065: {
                P3 o = P3.newP(this.vwr.getBoundBoxCenter());
                pt = this.vwr.getBoundBoxCornerVector();
                o.sub(pt);
                oabc = new P3[]{o, P3.new3(pt.x * 2.0f, 0.0f, 0.0f), P3.new3(0.0f, pt.y * 2.0f, 0.0f), P3.new3(0.0f, 0.0f, pt.z * 2.0f)};
                pt = null;
                eval.iToken = i;
                break;
            }
            case 1073742176: {
                if (this.tokAt(++i) != 12) {
                    this.invArg();
                }
                newUC = new Object[]{this.getToken((int)i).value};
                break;
            }
            case 11: 
            case 12: {
                newUC = this.getToken((int)i).value;
                break;
            }
            case 12289: {
                switch (this.tokAt(++i)) {
                    case 10: 
                    case 12290: 
                    case 1073742325: {
                        pt = this.vwr.ms.getAtomSetCenter(this.atomExpressionAt(i));
                        this.vwr.toFractional(pt, true);
                        i = eval.iToken;
                        break;
                    }
                    default: {
                        if (eval.isCenterParameter(i)) {
                            pt = this.centerParameter(i);
                            i = eval.iToken;
                            break;
                        }
                        this.invArg();
                    }
                }
                pt.x -= 0.5f;
                pt.y -= 0.5f;
                pt.z -= 0.5f;
                break;
            }
            case 10: 
            case 12290: 
            case 1073742325: {
                int iAtom = this.atomExpressionAt(i).nextSetBit(0);
                if (!this.chk) {
                    this.vwr.am.cai = iAtom;
                }
                if (iAtom < 0) {
                    return;
                }
                i = eval.iToken;
                break;
            }
            case 1073742066: {
                isOffset = true;
            }
            case 1073742114: {
                pt = (P3)eval.getPointOrPlane(++i, false, true, false, true, 3, 3);
                pt = P4.new4(pt.x, pt.y, pt.z, isOffset ? 1 : 0);
                i = eval.iToken;
                break;
            }
            case 2: 
            case 3: {
                float f = this.floatParameter(i);
                if (f < 111.0f) {
                    --i;
                    break;
                }
                icell = this.intParameter(i);
                break;
            }
            default: {
                if (eval.isArrayParameter(i)) {
                    oabc = eval.getPointArray(i, 4, false);
                    i = eval.iToken;
                    break;
                }
                if (this.slen > i + 1) {
                    pt = (P3)eval.getPointOrPlane(i, false, true, false, true, 3, 3);
                    i = eval.iToken;
                    break;
                }
                --i;
            }
        }
        mad10 = eval.getSetAxesTypeMad10(++i);
        eval.checkLast(eval.iToken);
        if (this.chk || mad10 == Integer.MAX_VALUE) {
            return;
        }
        if (mad10 == Integer.MAX_VALUE) {
            this.vwr.am.cai = -1;
        }
        if (oabc == null && newUC != null) {
            oabc = this.vwr.getV0abc(newUC);
        }
        if (icell != Integer.MAX_VALUE) {
            this.vwr.ms.setUnitCellOffset(this.vwr.getCurrentUnitCell(), null, icell);
        } else if (id != null) {
            this.vwr.setCurrentCage(id);
        } else if (isReset || oabc != null) {
            eval.setCurrentCagePts(oabc, ucname);
        }
        eval.setObjectMad10(33, "unitCell", mad10);
        if (pt != null) {
            this.vwr.ms.setUnitCellOffset(this.vwr.getCurrentUnitCell(), pt, 0);
        }
        if (tickInfo != null) {
            this.setShapeProperty(33, "tickInfo", tickInfo);
        }
    }

    private void assign() throws ScriptException {
        P3 pt;
        int atomsOrBonds = this.tokAt(1);
        int index = this.atomExpressionAt(2).nextSetBit(0);
        int index2 = -1;
        String type = null;
        if (index < 0) {
            return;
        }
        if (atomsOrBonds == 4106) {
            index2 = this.atomExpressionAt(++this.e.iToken).nextSetBit(0);
        } else {
            type = this.paramAsStr(++this.e.iToken);
        }
        P3 p3 = pt = ++this.e.iToken < this.slen ? this.centerParameter(this.e.iToken) : null;
        if (this.chk) {
            return;
        }
        this.vwr.pushState();
        switch (atomsOrBonds) {
            case 0x44000001: {
                this.e.clearDefinedVariableAtomSets();
                this.assignAtom(index, pt, type);
                break;
            }
            case 1677721602: {
                this.assignBond(index, (type + "p").charAt(0));
                break;
            }
            case 4106: {
                this.assignConnect(index, index2);
            }
        }
    }

    private void assignAtom(int atomIndex, P3 pt, String type) {
        if (type.equals("X")) {
            this.vwr.setRotateBondIndex(-1);
        }
        if (this.vwr.ms.at[atomIndex].mi != this.vwr.ms.mc - 1) {
            return;
        }
        this.vwr.clearModelDependentObjects();
        int ac = this.vwr.ms.ac;
        if (pt == null) {
            this.vwr.sm.modifySend(atomIndex, this.vwr.ms.at[atomIndex].mi, 1, this.e.fullCommand);
            this.vwr.ms.assignAtom(atomIndex, type, true);
            if (!PT.isOneOf(type, ";Mi;Pl;X;")) {
                this.vwr.ms.setAtomNamesAndNumbers(atomIndex, -ac, null);
            }
            this.vwr.sm.modifySend(atomIndex, this.vwr.ms.at[atomIndex].mi, -1, "OK");
            this.vwr.refresh(3, "assignAtom");
            return;
        }
        Atom atom = this.vwr.ms.at[atomIndex];
        BS bs = BSUtil.newAndSetBit(atomIndex);
        P3[] pts = new P3[]{pt};
        Lst<Atom> vConnections = new Lst<Atom>();
        vConnections.addLast(atom);
        short modelIndex = atom.mi;
        this.vwr.sm.modifySend(atomIndex, modelIndex, 3, this.e.fullCommand);
        try {
            bs = this.vwr.addHydrogensInline(bs, vConnections, pts);
            atomIndex = bs.nextSetBit(0);
            this.vwr.ms.assignAtom(atomIndex, type, false);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.vwr.ms.setAtomNamesAndNumbers(atomIndex, -ac, null);
        this.vwr.sm.modifySend(atomIndex, modelIndex, -3, "OK");
    }

    private void assignBond(int bondIndex, char type) {
        int modelIndex = -1;
        try {
            modelIndex = this.vwr.ms.bo[bondIndex].atom1.mi;
            this.vwr.sm.modifySend(bondIndex, modelIndex, 2, this.e.fullCommand);
            BS bsAtoms = this.vwr.ms.assignBond(bondIndex, type);
            if (bsAtoms == null || type == '0') {
                this.vwr.refresh(3, "setBondOrder");
            } else {
                this.vwr.addHydrogens(bsAtoms, false, true);
            }
            this.vwr.sm.modifySend(bondIndex, modelIndex, -2, "" + type);
        }
        catch (Exception ex) {
            Logger.error("assignBond failed");
            this.vwr.sm.modifySend(bondIndex, modelIndex, -2, "ERROR " + ex);
        }
    }

    private void assignConnect(int index, int index2) {
        this.vwr.clearModelDependentObjects();
        float[][] connections = AU.newFloat2(1);
        connections[0] = new float[]{index, index2};
        short modelIndex = this.vwr.ms.at[index].mi;
        this.vwr.sm.modifySend(index, modelIndex, 2, this.e.fullCommand);
        this.vwr.ms.connect(connections);
        this.vwr.ms.assignAtom(index, ".", true);
        this.vwr.ms.assignAtom(index2, ".", true);
        this.vwr.sm.modifySend(index, modelIndex, -2, "OK");
        this.vwr.refresh(3, "assignConnect");
    }

    private String getContext(boolean withVariables) {
        SB sb = new SB();
        ScriptContext context = this.e.thisContext;
        while (context != null) {
            if (withVariables) {
                if (context.vars != null) {
                    sb.append(this.getScriptID(context));
                    sb.append(StateManager.getVariableList(context.vars, 80, true, false));
                }
            } else {
                sb.append(ScriptError.getErrorLineMessage(context.functionName, context.scriptFileName, this.e.getLinenumber(context), context.pc, ScriptEval.statementAsString(this.vwr, context.statement, -9999, this.e.debugHigh)));
            }
            context = context.parentContext;
        }
        if (withVariables) {
            if (this.e.contextVariables != null) {
                sb.append(this.getScriptID(null));
                sb.append(StateManager.getVariableList(this.e.contextVariables, 80, true, false));
            }
        } else {
            sb.append(this.e.getErrorLineMessage2());
        }
        return sb.toString();
    }

    private Object getIsosurfaceJvxl(int iShape, String type) {
        type = type == "PMESH" || type == "MESH" ? "jvxlMeshX" : (type == "ISOMESH" ? "pmesh" : (type == "ISOMESHBIN" || type == "PMB" ? "pmeshbin" : "jvxlDataXml"));
        return this.chk ? "" : this.getShapeProperty(iShape, type);
    }

    private String getMoJvxl(int ptMO, boolean isNBO) throws ScriptException {
        Integer n;
        Map moData;
        int iShape = isNBO ? 28 : 27;
        this.e.sm.loadShape(iShape);
        int modelIndex = this.vwr.am.cmi;
        if (modelIndex < 0) {
            this.e.errorStr(30, "show/write MO/NBO");
        }
        if ((moData = (Map)this.vwr.ms.getInfo(modelIndex, "moData")) == null) {
            this.error(27);
        }
        if ((n = (Integer)this.getShapeProperty(iShape, "moNumber")) == null || n == 0) {
            this.setShapeProperty(iShape, "init", modelIndex);
        }
        this.setShapeProperty(iShape, "moData", moData);
        return (String)this.e.sm.getShapePropertyIndex(iShape, "showMO", ptMO);
    }

    private String getScriptID(ScriptContext context) {
        String fuName = context == null ? this.e.functionName : "function " + context.functionName;
        String fiName = context == null ? this.e.scriptFileName : context.scriptFileName;
        return "\n# " + fuName + " (file " + fiName + (context == null ? "" : " context " + context.id) + ")\n";
    }

    private T tokenAt(int i, T[] args) {
        return i < args.length ? args[i] : null;
    }

    private static int tokAtArray(int i, T[] args) {
        return i < args.length && args[i] != null ? args[i].tok : 0;
    }

    private float getPlotMinMax(float[] data, boolean isMax, int tok) {
        if (data == null) {
            return 0.0f;
        }
        switch (tok) {
            case 1111490568: 
            case 1111490569: 
            case 1111490570: {
                return isMax ? 180 : -180;
            }
            case 1111490565: 
            case 1111490576: {
                return isMax ? 360 : 0;
            }
            case 1111490574: {
                return isMax ? 1 : -1;
            }
        }
        float fmax = isMax ? -1.0E10f : 1.0E10f;
        int i = data.length;
        while (--i >= 0) {
            float f = data[i];
            if (Float.isNaN(f) || isMax != f > fmax) continue;
            fmax = f;
        }
        return fmax;
    }

    private Object parseDataArray(String str, boolean is3D) {
        str = Parser.fixDataString(str);
        int[] lines = Parser.markLines(str, '\n');
        int nLines = lines.length;
        if (!is3D) {
            float[][] data = AU.newFloat2(nLines);
            int iLine = 0;
            int pt = 0;
            while (iLine < nLines) {
                String[] tokens = PT.getTokens(str.substring(pt, lines[iLine]));
                data[iLine] = new float[tokens.length];
                PT.parseFloatArrayData(tokens, data[iLine]);
                pt = lines[iLine++];
            }
            return data;
        }
        String[] tokens = PT.getTokens(str.substring(0, lines[0]));
        if (tokens.length != 3) {
            return new float[0][0][0];
        }
        int nX = PT.parseInt(tokens[0]);
        int nY = PT.parseInt(tokens[1]);
        int nZ = PT.parseInt(tokens[2]);
        if (nX < 1 || nY < 1 || nZ < 1) {
            return new float[1][1][1];
        }
        float[][][] data = AU.newFloat3(nX, nY);
        int iX = 0;
        int iY = 0;
        int iLine = 1;
        int pt = lines[0];
        while (iLine < nLines && iX < nX) {
            tokens = PT.getTokens(str.substring(pt, lines[iLine]));
            if (tokens.length >= nZ) {
                float[] fArray = new float[tokens.length];
                data[iX][iY] = fArray;
                PT.parseFloatArrayData(tokens, fArray);
                if (++iY == nY) {
                    ++iX;
                    iY = 0;
                }
            }
            pt = lines[iLine++];
        }
        if (iX != nX) {
            System.out.println("Error reading 3D data -- nX = " + nX + ", but only " + iX + " blocks read");
            return new float[1][1][1];
        }
        return data;
    }

    public float[] getBitsetPropertyFloat(BS bs, int tok, String property, float min, float max) throws ScriptException {
        int i;
        Object odata;
        Object object = odata = property == null || tok == 1111490843 ? this.e.getBitsetProperty(bs, tok, null, null, property, null, false, Integer.MAX_VALUE, false) : this.vwr.getDataObj(property, bs, 1);
        if (odata == null || !AU.isAF(odata)) {
            return bs == null ? null : new float[bs.cardinality()];
        }
        float[] data = (float[])odata;
        if (!Float.isNaN(min)) {
            for (i = 0; i < data.length; ++i) {
                if (!(data[i] < min)) continue;
                data[i] = Float.NaN;
            }
        }
        if (!Float.isNaN(max)) {
            for (i = 0; i < data.length; ++i) {
                if (!(data[i] > max)) continue;
                data[i] = Float.NaN;
            }
        }
        return data;
    }
}

