/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;

public class CharSequenceSubSequence
implements CharSequenceWithStringHash,
CharArrayExternalizable,
CharSequence {
    private final CharSequence myChars;
    private final int myStart;
    private final int myEnd;
    private transient int hash;

    public CharSequenceSubSequence(@NotNull CharSequence chars, int start, int end) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharSequenceSubSequence", "<init>"));
        }
        if (start < 0 || end > chars.length() || start > end) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + chars.length() + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index2) {
        return this.myChars.charAt(index2 + this.myStart);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        if (start == this.myStart && end == this.myEnd) {
            CharSequenceSubSequence charSequenceSubSequence = this;
            if (charSequenceSubSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharSequenceSubSequence", "subSequence"));
            }
            return charSequenceSubSequence;
        }
        CharSequenceSubSequence charSequenceSubSequence = new CharSequenceSubSequence(this.myChars, this.myStart + start, this.myStart + end);
        if (charSequenceSubSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharSequenceSubSequence", "subSequence"));
        }
        return charSequenceSubSequence;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.myChars instanceof String) {
            String string = ((String)this.myChars).substring(this.myStart, this.myEnd);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharSequenceSubSequence", "toString"));
            }
            return string;
        }
        String string = StringFactory.createShared(CharArrayUtil.fromSequence(this.myChars, this.myStart, this.myEnd));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharSequenceSubSequence", "toString"));
        }
        return string;
    }

    @NotNull
    public CharSequence getBaseSequence() {
        CharSequence charSequence = this.myChars;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharSequenceSubSequence", "getBaseSequence"));
        }
        return charSequence;
    }

    @Override
    public void getChars(int start, int end, @NotNull char[] dest, int destPos) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/intellij/util/text/CharSequenceSubSequence", "getChars"));
        }
        assert (end - start <= this.myEnd - this.myStart);
        CharArrayUtil.getChars(this.myChars, dest, start + this.myStart, destPos, end - start);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, 0, this.length());
        }
        return h;
    }
}

