/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preprocessor;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.preprocessor.Conditional;
import org.jetbrains.kotlin.preprocessor.ConditionalKt;
import org.jetbrains.kotlin.preprocessor.Evaluator;
import org.jetbrains.kotlin.preprocessor.Modification;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/preprocessor/CollectModificationsVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "evaluators", "", "Lorg/jetbrains/kotlin/preprocessor/Evaluator;", "(Ljava/util/List;)V", "elementModifications", "", "", "Lorg/jetbrains/kotlin/preprocessor/Modification;", "getElementModifications", "()Ljava/util/Map;", "visitDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kotlin-compiler"})
public final class CollectModificationsVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final Map<Evaluator, List<Modification>> elementModifications;

    @NotNull
    public final Map<Evaluator, List<Modification>> getElementModifications() {
        return this.elementModifications;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitDeclaration(@NotNull KtDeclaration declaration) {
        Object object;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        super.visitDeclaration(declaration);
        List<Conditional> annotations2 = ConditionalKt.parseConditionalAnnotations(declaration);
        KtDeclaration ktDeclaration = declaration;
        if (!(ktDeclaration instanceof KtNamedDeclaration)) {
            ktDeclaration = null;
        }
        Comparable name = (object = (KtNamedDeclaration)ktDeclaration) != null && (object = object.getNameAsSafeName()) != null ? (Comparable)object : (Comparable)((Object)declaration.getName());
        ArrayList<Pair<Evaluator, Boolean>> declResults = new ArrayList<Pair<Evaluator, Boolean>>();
        Map<Evaluator, List<Modification>> map2 = this.elementModifications;
        Iterator<Map.Entry<Evaluator, List<Modification>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Map.Entry<Evaluator, List<Modification>> entry;
            Map.Entry<Evaluator, List<Modification>> entry2 = entry = iterator2.next();
            Evaluator evaluator2 = entry2.getKey();
            entry2 = entry;
            List<Modification> modifications = entry2.getValue();
            boolean conditionalResult = (Boolean)evaluator2.invoke(annotations2);
            declResults.add(TuplesKt.to(evaluator2, conditionalResult));
            if (!conditionalResult) {
                TextRange textRange = declaration.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull(textRange, "declaration.textRange");
                modifications.add(new Modification(textRange, (Function1<? super String, String>)new Function1<String, String>(evaluator2){
                    final /* synthetic */ Evaluator $evaluator;

                    @NotNull
                    public final String invoke(@NotNull String rangeText) {
                        StringBuilder stringBuilder;
                        Intrinsics.checkParameterIsNotNull(rangeText, "rangeText");
                        StringBuilder $receiver = stringBuilder = new StringBuilder();
                        $receiver.append("/* Not available on " + this.$evaluator + " */");
                        int n = StringUtil.getLineBreakCount(rangeText);
                        int n2 = 0;
                        int n3 = n - 1;
                        if (n2 <= n3) {
                            do {
                                int it = ++n2;
                                $receiver.append("\n");
                            } while (n2 != n3);
                        }
                        String string = stringBuilder.toString();
                        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
                        return string;
                    }
                    {
                        this.$evaluator = evaluator2;
                        super(1);
                    }
                }));
                continue;
            }
            Iterable iterable = $receiver$iv = (Iterable)annotations2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof Conditional.TargetName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Conditional.TargetName targetName = (Conditional.TargetName)CollectionsKt.singleOrNull((List)destination$iv$iv);
            if (targetName == null) continue;
            Name name2 = ((KtNamedDeclaration)declaration).getNameAsName();
            if (name2 == null) {
                Intrinsics.throwNpe();
            }
            String placeholderName = name2.asString();
            String realName = targetName.getName();
            TextRange textRange = ((KtNamedDeclaration)declaration).getTextRange();
            Intrinsics.checkExpressionValueIsNotNull(textRange, "declaration.textRange");
            modifications.add(new Modification(textRange, (Function1<? super String, String>)new Function1<String, String>(placeholderName, realName){
                final /* synthetic */ String $placeholderName;
                final /* synthetic */ String $realName;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    String string = this.$placeholderName;
                    Intrinsics.checkExpressionValueIsNotNull(string, "placeholderName");
                    return StringsKt.replace$default(it, string, this.$realName, false, 4, null);
                }
                {
                    this.$placeholderName = string;
                    this.$realName = string2;
                    super(1);
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    public CollectModificationsVisitor(@NotNull List<? extends Evaluator> evaluators) {
        Map map2;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(evaluators, "evaluators");
        Iterable iterable = evaluators;
        CollectModificationsVisitor collectModificationsVisitor = this;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        void var4_5 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Evaluator it;
            Evaluator evaluator2 = (Evaluator)element$iv$iv;
            map2 = destination$iv$iv;
            void var14_11 = it;
            it = (Evaluator)element$iv$iv;
            ArrayList arrayList = new ArrayList();
            map2.put(var14_11, arrayList);
        }
        collectModificationsVisitor.elementModifications = map2 = destination$iv$iv;
    }
}

