/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

public class LabelResolver {
    public static LabelResolver INSTANCE = new LabelResolver();

    private LabelResolver() {
    }

    @NotNull
    private Set<KtElement> getElementsByLabelName(@NotNull Name labelName, @NotNull KtSimpleNameExpression labelExpression) {
        if (labelName == null) {
            LabelResolver.$$$reportNull$$$0(0);
        }
        if (labelExpression == null) {
            LabelResolver.$$$reportNull$$$0(1);
        }
        LinkedHashSet<KtElement> elements = Sets.newLinkedHashSet();
        for (PsiElement parent2 = labelExpression.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            Name name = this.getLabelNameIfAny(parent2);
            if (name == null || !name.equals(labelName)) continue;
            elements.add(this.getExpressionUnderLabel((KtExpression)parent2));
        }
        LinkedHashSet<KtElement> linkedHashSet = elements;
        if (linkedHashSet == null) {
            LabelResolver.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    @Nullable
    public Name getLabelNameIfAny(@NotNull PsiElement element) {
        if (element == null) {
            LabelResolver.$$$reportNull$$$0(3);
        }
        if (element instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)element).getLabelNameAsName();
        }
        if (element instanceof KtFunctionLiteral) {
            return this.getLabelNameIfAny(element.getParent());
        }
        if (element instanceof KtLambdaExpression) {
            return this.getLabelForFunctionalExpression((KtExpression)element);
        }
        if (element instanceof KtNamedFunction) {
            Name name = ((KtNamedFunction)element).getNameAsName();
            if (name != null) {
                return name;
            }
            return this.getLabelForFunctionalExpression((KtExpression)element);
        }
        return null;
    }

    private Name getLabelForFunctionalExpression(@NotNull KtExpression element) {
        if (element == null) {
            LabelResolver.$$$reportNull$$$0(4);
        }
        if (element.getParent() instanceof KtLabeledExpression) {
            return this.getLabelNameIfAny(element.getParent());
        }
        return this.getCallerName(element);
    }

    @NotNull
    private KtExpression getExpressionUnderLabel(@NotNull KtExpression labeledExpression) {
        KtExpression expression;
        if (labeledExpression == null) {
            LabelResolver.$$$reportNull$$$0(5);
        }
        if ((expression = KtPsiUtil.safeDeparenthesize(labeledExpression)) instanceof KtLambdaExpression) {
            KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)expression).getFunctionLiteral();
            if (ktFunctionLiteral == null) {
                LabelResolver.$$$reportNull$$$0(6);
            }
            return ktFunctionLiteral;
        }
        KtExpression ktExpression = expression;
        if (ktExpression == null) {
            LabelResolver.$$$reportNull$$$0(7);
        }
        return ktExpression;
    }

    @Nullable
    private Name getCallerName(@NotNull KtExpression expression) {
        KtCallExpression callExpression;
        if (expression == null) {
            LabelResolver.$$$reportNull$$$0(8);
        }
        if ((callExpression = this.getContainingCallExpression(expression)) == null) {
            return null;
        }
        KtExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)calleeExpression;
            return nameExpression.getReferencedNameAsName();
        }
        return null;
    }

    @Nullable
    private KtCallExpression getContainingCallExpression(@NotNull KtExpression expression) {
        PsiElement call2;
        PsiElement parent2;
        if (expression == null) {
            LabelResolver.$$$reportNull$$$0(9);
        }
        if ((parent2 = expression.getParent()) instanceof KtLambdaArgument && (call2 = parent2.getParent()) instanceof KtCallExpression) {
            return (KtCallExpression)call2;
        }
        if (parent2 instanceof KtValueArgument) {
            KtValueArgument argument = (KtValueArgument)parent2;
            PsiElement argList = argument.getParent();
            if (argList == null) {
                return null;
            }
            PsiElement call3 = argList.getParent();
            if (call3 instanceof KtCallExpression) {
                return (KtCallExpression)call3;
            }
        }
        return null;
    }

    @Nullable
    public KtElement resolveControlLabel(@NotNull KtExpressionWithLabel expression, @NotNull ResolutionContext context) {
        if (expression == null) {
            LabelResolver.$$$reportNull$$$0(10);
        }
        if (context == null) {
            LabelResolver.$$$reportNull$$$0(11);
        }
        KtSimpleNameExpression labelElement = expression.getTargetLabel();
        KtPsiUtilKt.checkReservedYield(labelElement, context.trace);
        Name labelName = expression.getLabelNameAsName();
        if (labelElement == null || labelName == null) {
            return null;
        }
        Collection<DeclarationDescriptor> declarationsByLabel = ScopeUtilsKt.getDeclarationsByLabel(context.scope, labelName);
        int size = declarationsByLabel.size();
        if (size > 1) {
            BindingContextUtils.reportAmbiguousLabel(context.trace, labelElement, declarationsByLabel);
            return null;
        }
        if (size == 0) {
            KtElement element = this.resolveNamedLabel(labelName, labelElement, context.trace);
            if (element == null) {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(labelElement, labelElement));
            }
            return element;
        }
        DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
        if (!(declarationDescriptor instanceof FunctionDescriptor) && !(declarationDescriptor instanceof ClassDescriptor)) {
            throw new UnsupportedOperationException(declarationDescriptor.getClass().toString());
        }
        KtElement element = (KtElement)DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
        context.trace.record(BindingContext.LABEL_TARGET, labelElement, element);
        return element;
    }

    private KtElement resolveNamedLabel(@NotNull Name labelName, @NotNull KtSimpleNameExpression labelExpression, @NotNull BindingTrace trace) {
        Set<KtElement> list2;
        if (labelName == null) {
            LabelResolver.$$$reportNull$$$0(12);
        }
        if (labelExpression == null) {
            LabelResolver.$$$reportNull$$$0(13);
        }
        if (trace == null) {
            LabelResolver.$$$reportNull$$$0(14);
        }
        if ((list2 = this.getElementsByLabelName(labelName, labelExpression)).isEmpty()) {
            return null;
        }
        if (list2.size() > 1) {
            trace.report(Errors.LABEL_NAME_CLASH.on(labelExpression));
        }
        KtElement result2 = list2.iterator().next();
        trace.record(BindingContext.LABEL_TARGET, labelExpression, result2);
        return result2;
    }

    @NotNull
    public LabeledReceiverResolutionResult resolveThisOrSuperLabel(@NotNull KtInstanceExpressionWithLabel expression, @NotNull ResolutionContext context, @NotNull Name labelName) {
        if (expression == null) {
            LabelResolver.$$$reportNull$$$0(15);
        }
        if (context == null) {
            LabelResolver.$$$reportNull$$$0(16);
        }
        if (labelName == null) {
            LabelResolver.$$$reportNull$$$0(17);
        }
        KtReferenceExpression referenceExpression = expression.getInstanceReference();
        KtSimpleNameExpression targetLabel = expression.getTargetLabel();
        assert (targetLabel != null) : expression;
        Collection<DeclarationDescriptor> declarationsByLabel = ScopeUtilsKt.getDeclarationsByLabel(context.scope, labelName);
        int size = declarationsByLabel.size();
        if (size == 1) {
            ClassDescriptor classDescriptor;
            ReceiverParameterDescriptor thisReceiver;
            DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
            if (declarationDescriptor instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                thisReceiver = classDescriptor2.getThisAsReceiverParameter();
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                thisReceiver = functionDescriptor.getExtensionReceiverParameter();
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                thisReceiver = propertyDescriptor.getExtensionReceiverParameter();
            } else {
                throw new UnsupportedOperationException("Unsupported descriptor: " + declarationDescriptor);
            }
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            assert (element != null) : "No PSI element for descriptor: " + declarationDescriptor;
            context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
            context.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
            if (declarationDescriptor instanceof ClassDescriptor && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, targetLabel, classDescriptor = (ClassDescriptor)declarationDescriptor)) {
                LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionFailed();
                if (labeledReceiverResolutionResult == null) {
                    LabelResolver.$$$reportNull$$$0(18);
                }
                return labeledReceiverResolutionResult;
            }
            LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionSuccess(thisReceiver);
            if (labeledReceiverResolutionResult == null) {
                LabelResolver.$$$reportNull$$$0(19);
            }
            return labeledReceiverResolutionResult;
        }
        if (size == 0) {
            KtElement element = this.resolveNamedLabel(labelName, targetLabel, context.trace);
            if (element instanceof KtFunctionLiteral) {
                DeclarationDescriptor declarationDescriptor = context.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    ReceiverParameterDescriptor thisReceiver = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                    if (thisReceiver != null) {
                        context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                        context.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                    }
                    LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionSuccess(thisReceiver);
                    if (labeledReceiverResolutionResult == null) {
                        LabelResolver.$$$reportNull$$$0(20);
                    }
                    return labeledReceiverResolutionResult;
                }
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel, targetLabel));
            } else {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel, targetLabel));
            }
        } else {
            BindingContextUtils.reportAmbiguousLabel(context.trace, targetLabel, declarationsByLabel);
        }
        LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionFailed();
        if (labeledReceiverResolutionResult == null) {
            LabelResolver.$$$reportNull$$$0(21);
        }
        return labeledReceiverResolutionResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelName";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelExpression";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/LabelResolver";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledExpression";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/LabelResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByLabelName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionUnderLabel";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveThisOrSuperLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsByLabelName";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLabelNameIfAny";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLabelForFunctionalExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionUnderLabel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCallerName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContainingCallExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveControlLabel";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamedLabel";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveThisOrSuperLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class LabeledReceiverResolutionResult {
        private final Code code;
        private final ReceiverParameterDescriptor receiverParameterDescriptor;

        public static LabeledReceiverResolutionResult labelResolutionSuccess(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
            if (receiverParameterDescriptor == null) {
                return new LabeledReceiverResolutionResult(Code.NO_THIS, null);
            }
            return new LabeledReceiverResolutionResult(Code.SUCCESS, receiverParameterDescriptor);
        }

        public static LabeledReceiverResolutionResult labelResolutionFailed() {
            return new LabeledReceiverResolutionResult(Code.LABEL_RESOLUTION_ERROR, null);
        }

        private LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor) {
            this.code = code;
            this.receiverParameterDescriptor = receiverParameterDescriptor;
        }

        public Code getCode() {
            return this.code;
        }

        public boolean success() {
            return this.code == Code.SUCCESS;
        }

        public ReceiverParameterDescriptor getReceiverParameterDescriptor() {
            assert (this.success()) : "Don't try to obtain the receiver when resolution failed with " + (Object)((Object)this.code);
            return this.receiverParameterDescriptor;
        }

        public static enum Code {
            LABEL_RESOLUTION_ERROR,
            NO_THIS,
            SUCCESS;

        }
    }
}

