/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ArgsConverter;
import org.jetbrains.kotlin.utils.NamedArgument;
import org.jetbrains.kotlin.utils.StringArgsConverter;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J2\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\rH\u0016J2\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/utils/StringArgsConverter;", "Lorg/jetbrains/kotlin/utils/ArgsConverter;", "", "()V", "tryConvertSingle", "Lorg/jetbrains/kotlin/utils/ArgsConverter$Result;", "parameter", "Lkotlin/reflect/KParameter;", "arg", "Lorg/jetbrains/kotlin/utils/NamedArgument;", "tryConvertTail", "firstArg", "restArgsIt", "", "tryConvertVararg", "kotlin-compiler"})
final class StringArgsConverter
implements ArgsConverter<String> {
    @Override
    @NotNull
    public ArgsConverter.Result tryConvertSingle(@NotNull KParameter parameter, @NotNull NamedArgument<String> arg) {
        Object object;
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        Intrinsics.checkParameterIsNotNull(arg, "arg");
        String string = arg.getValue();
        if (string == null) {
            return new ArgsConverter.Result.Success((Object)null);
        }
        String value = string;
        KClassifier kClassifier = parameter.getType().getClassifier();
        if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(String.class))) {
            object = value;
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            object = StringsKt.toIntOrNull(value);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = StringsKt.toLongOrNull(value);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            object = StringsKt.toShortOrNull(value);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            object = StringsKt.toByteOrNull(value);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Character.TYPE))) {
            object = StringsKt.singleOrNull(value);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            object = StringsKt.toFloatOrNull(value);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            object = StringsKt.toDoubleOrNull(value);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            String string2 = value;
            object = Boolean.parseBoolean(string2);
        } else {
            object = null;
        }
        String primitive = object;
        return primitive != null ? (ArgsConverter.Result)new ArgsConverter.Result.Success(primitive) : (ArgsConverter.Result)ArgsConverter.Result.Failure.INSTANCE;
    }

    @Override
    @NotNull
    public ArgsConverter.Result tryConvertVararg(@NotNull KParameter parameter, @NotNull NamedArgument<String> firstArg, @NotNull Iterator<NamedArgument<String>> restArgsIt) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        Intrinsics.checkParameterIsNotNull(firstArg, "firstArg");
        Intrinsics.checkParameterIsNotNull(restArgsIt, "restArgsIt");
        tryConvertVararg.1 convertAnyArray$ = tryConvertVararg.1.INSTANCE;
        tryConvertVararg.2 convertPrimitivesArray$ = tryConvertVararg.2.INSTANCE;
        KType parameterType = parameter.getType();
        if (JvmClassMappingKt.getJavaClass(KTypesJvm.getJvmErasure(parameterType)).isArray()) {
            KType arrayElementType;
            Sequence<String> argsSequence2 = SequencesKt.plus(SequencesKt.sequenceOf(firstArg.getValue()), SequencesKt.map(SequencesKt.asSequence(restArgsIt), tryConvertVararg.argsSequence.1.INSTANCE));
            Object primArrayArgCandidate = convertPrimitivesArray$.invoke(parameterType, argsSequence2);
            if (primArrayArgCandidate != null) {
                return new ArgsConverter.Result.Success(primArrayArgCandidate);
            }
            KTypeProjection kTypeProjection = CollectionsKt.firstOrNull(parameterType.getArguments());
            KType kType = arrayElementType = kTypeProjection != null ? kTypeProjection.getType() : null;
            Object arrayArgCandidate = convertAnyArray$.invoke(kType != null ? kType.getClassifier() : null, argsSequence2);
            if (arrayArgCandidate != null) {
                return new ArgsConverter.Result.Success(arrayArgCandidate);
            }
        }
        return ArgsConverter.Result.Failure.INSTANCE;
    }

    @Override
    @NotNull
    public ArgsConverter.Result tryConvertTail(@NotNull KParameter parameter, @NotNull NamedArgument<String> firstArg, @NotNull Iterator<NamedArgument<String>> restArgsIt) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        Intrinsics.checkParameterIsNotNull(firstArg, "firstArg");
        Intrinsics.checkParameterIsNotNull(restArgsIt, "restArgsIt");
        return this.tryConvertVararg(parameter, firstArg, restArgsIt);
    }
}

