/*
 * Decompiled with CFR 0.152.
 */
package test.suite;

import dguitar.adaptors.midi.MidiAdaptor;
import dguitar.adaptors.song.Song;
import dguitar.players.sound.Arrangement;
import dguitar.players.sound.MasterPlayer;
import dguitar.players.sound.midi.MidiFiler;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import test.songs.MidiSongDefinition;
import test.songs.SongArchive;
import test.suite.MidiTestCase;

public class MidiAdaptorTest
extends MidiTestCase {
    public void testAguaMIDI() throws Exception {
        MidiSongDefinition testFile = SongArchive.testFileSongDefinition();
        MidiSongDefinition sd = SongArchive.aguaSongDefinition();
        Song song = null;
        try {
            song = MidiAdaptor.makeSong(sd.getMidiFileName());
        }
        catch (InvalidMidiDataException e1) {
            MidiAdaptorTest.fail((String)"invalid midi data exception");
        }
        catch (IOException e1) {
            MidiAdaptorTest.fail((String)"ioexception");
        }
        MasterPlayer player = new MasterPlayer();
        player.setSoundPlayer(new MidiFiler(testFile.getMidiFileName()));
        Arrangement arrangement = null;
        player.arrange(song, arrangement);
        player.start();
        player.close();
        try {
            this.compareMIDIFiles(sd.getMidiFileName(), testFile.getMidiFileName(), null, null);
        }
        catch (InvalidMidiDataException e) {
            MidiAdaptorTest.fail((String)"invalid midi data exception");
        }
        catch (IOException e) {
            MidiAdaptorTest.fail((String)"io exception");
        }
    }
}

