// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOPAlgo_CheckerSI_HeaderFile
#define _BOPAlgo_CheckerSI_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
#include <BOPCol_DataMapOfShapeShape.hxx>
#include <BOPAlgo_PaveFiller.hxx>


//! Checks shape on self-interference.
class BOPAlgo_CheckerSI  : public BOPAlgo_PaveFiller
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT BOPAlgo_CheckerSI();
Standard_EXPORT virtual ~BOPAlgo_CheckerSI();
  
  Standard_EXPORT virtual   void Perform() ;
  
  //! Sets the level of checking shape on self-interference.
  //! It defines which interferferences will be checked:
  //! 0 - only V/V;
  //! 1 - V/V and V/E;
  //! 2 - V/V, V/E and E/E;
  //! 3 - V/V, V/E, E/E and V/F;
  //! 4 - V/V, V/E, E/E, V/F and E/F;
  //! 5 - all interferences, default value.
  Standard_EXPORT   void SetLevelOfCheck (const Standard_Integer theLevel) ;
  
  //! Sets the flag <theFlag> that defines
  //! the mode of the treatment:
  //! the copy of the argument when theFlag is true
  //! the argument itself  when theFlag is false
  Standard_EXPORT   void SetNonDestructive (const Standard_Boolean theFlag) ;
  
  //! Returns the flag that defines the
  //! mode of the treatment:
  //! true when the copy of the argument is used
  //! false when the argument itself  is used
  Standard_EXPORT   Standard_Boolean NonDestructive()  const;




protected:

  
  Standard_EXPORT virtual   void Init() ;
  
  //! Provides post-treatment actions
  Standard_EXPORT   void PostTreat() ;
  
  Standard_EXPORT virtual   void PrepareCopy() ;
  
  //! Provides post-treatment actions for the copy
  Standard_EXPORT   void PostTreatCopy() ;


  Standard_Integer myLevelOfCheck;
  Standard_Boolean myNonDestructive;
  BOPCol_DataMapOfShapeShape myNewOldMap;


private:





};







#endif // _BOPAlgo_CheckerSI_HeaderFile
