/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.engine.api.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;

public abstract class TreeIterator<I, T>
implements Iterator<I> {
    private Stack<T> toInspect = new Stack();
    private Set<T> inspected = new HashSet<T>();
    private T popped = null;
    private Iterator<I> inspecting = null;

    public TreeIterator(T t) {
        this.toInspect.push(t);
        this.inspected.add(t);
    }

    @Override
    public boolean hasNext() {
        this.setupIterator();
        return this.inspecting != null && this.inspecting.hasNext();
    }

    @Override
    public I next() {
        this.setupIterator();
        if (this.inspecting == null || !this.inspecting.hasNext()) {
            throw new NoSuchElementException();
        }
        I i = this.inspecting.next();
        return i;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected abstract Iterator<I> getSameLevelIterator(T var1);

    protected abstract Iterator<T> getTraversingIterator(T var1);

    private void setupIterator() {
        while (!(this.toInspect.isEmpty() || this.inspecting != null && this.inspecting.hasNext())) {
            this.popped = this.toInspect.pop();
            if (this.popped != null) {
                this.inspecting = this.getSameLevelIterator(this.popped);
                Iterator<T> iterator = this.getTraversingIterator(this.popped);
                while (iterator.hasNext()) {
                    T t = iterator.next();
                    if (t == null || this.inspected.contains(t)) continue;
                    this.toInspect.push(t);
                    this.inspected.add(t);
                }
                continue;
            }
            this.inspecting = null;
        }
    }
}

