/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.time;

import accessories.plugins.time.JTripleCalendar;
import accessories.plugins.time.TimeManagementOrganizer;
import freemind.controller.MapModuleManager;
import freemind.controller.StructuredMenuHolder;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.common.plugins.ReminderHookBase;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.hooks.MindMapHookAdapter;
import freemind.view.MapModule;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TimeManagement
extends MindMapHookAdapter
implements PropertyChangeListener,
ActionListener,
MapModuleManager.MapModuleChangeObserver {
    public static final String REMINDER_HOOK_NAME = "plugins/TimeManagementReminder.xml";
    private static Calendar lastDate = null;
    private JTripleCalendar calendar;
    private JDialog dialog;
    private JPanel timePanel;
    private JTextField hourField;
    private JTextField minuteField;
    private MindMapController mController;
    private static TimeManagement sCurrentlyOpenTimeManagement = null;

    @Override
    public void startupMapHook() {
        super.startupMapHook();
        if (sCurrentlyOpenTimeManagement != null) {
            TimeManagement.sCurrentlyOpenTimeManagement.dialog.getContentPane().setVisible(true);
            return;
        }
        sCurrentlyOpenTimeManagement = this;
        this.mController = super.getMindMapController();
        this.getMindMapController().getController().getMapModuleManager().addListener(this);
        this.dialog = new JDialog((Frame)this.getMindMapController().getFrame().getJFrame(), false);
        this.dialog.setTitle(this.getResourceString("plugins/TimeManagement.xml_WindowTitle"));
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                TimeManagement.this.disposeDialog();
            }
        });
        CloseAction closeAction = new CloseAction();
        Tools.addEscapeActionToDialog(this.dialog, closeAction);
        StructuredMenuHolder menuHolder = new StructuredMenuHolder();
        JMenuBar menu = new JMenuBar();
        JMenu mainItem = new JMenu(this.getMindMapController().getText("TimeManagement.Actions"));
        menuHolder.addMenu(mainItem, "main/actions/.");
        this.addAccelerator(menuHolder.addAction(new AppendDateAction(), "main/actions/append"), "keystroke_plugins/TimeManagement_append");
        this.addAccelerator(menuHolder.addAction(new AppendDateToChildAction(), "main/actions/appendAsChild"), "keystroke_plugins/TimeManagement_appendAsChild");
        this.addAccelerator(menuHolder.addAction(new AppendDateToSiblingAction(), "main/actions/appendAsSibling"), "keystroke_plugins/TimeManagement_appendAsSibling");
        JMenuItem remindMenuItem = this.addAccelerator(menuHolder.addAction(new RemindAction(), "main/actions/remind"), "keystroke_plugins/TimeManagementRemind");
        remindMenuItem.setToolTipText(this.getResourceString("plugins/TimeManagement.xml_reminderButton_tooltip"));
        JMenuItem removeRemindersItem = this.addAccelerator(menuHolder.addAction(new RemoveReminders(), "main/actions/removeReminders"), "keystroke_plugins/TimeManagementRemoveReminders");
        removeRemindersItem.setToolTipText(this.getResourceString("plugins/TimeManagement.xml_removeReminderButton_tooltip"));
        this.addAccelerator(menuHolder.addAction(new TodayAction(), "main/actions/today"), "keystroke_plugins/TimeManagementToday");
        menuHolder.addAction(new CloseAction(), "main/actions/close");
        menuHolder.updateMenus(menu, "main/");
        this.dialog.setJMenuBar(menu);
        this.calendar = new JTripleCalendar();
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gb1 = new GridBagConstraints();
        gb1.gridx = 0;
        gb1.gridwidth = 4;
        gb1.fill = 1;
        gb1.gridy = 0;
        this.calendar.getDayChooser().addPropertyChangeListener(this);
        contentPane.add((Component)this.calendar, gb1);
        GridBagConstraints gb2 = new GridBagConstraints();
        gb2.gridx = 0;
        gb2.gridy = 1;
        gb2.gridwidth = 4;
        gb2.fill = 2;
        contentPane.add((Component)this.getTimePanel(), gb2);
        if (lastDate != null) {
            this.logger.info("Setting date to " + lastDate);
            this.calendar.setCalendar(lastDate);
        }
        this.dialog.pack();
        this.dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                TimeManagement.this.calendar.getDayChooser().getSelectedDay().requestFocus();
                TimeManagement.this.dialog.removeWindowFocusListener(this);
            }
        });
        this.dialog.setVisible(true);
    }

    private JPanel getTimePanel() {
        if (this.timePanel == null) {
            this.timePanel = new JPanel();
            this.timePanel.setLayout(new GridBagLayout());
            GridBagConstraints gb2 = new GridBagConstraints();
            gb2.gridx = 0;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.timePanel.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_hour")), gb2);
            gb2 = new GridBagConstraints();
            gb2.gridx = 1;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.hourField = new JTextField(2);
            this.hourField.setText(new Integer(this.getCalendar().get(11)).toString());
            this.timePanel.add((Component)this.hourField, gb2);
            gb2 = new GridBagConstraints();
            gb2.gridx = 2;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.timePanel.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_minute")), gb2);
            gb2 = new GridBagConstraints();
            gb2.gridx = 3;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.minuteField = new JTextField(2);
            String minuteString = new Integer(this.getCalendar().get(12)).toString();
            if (minuteString.length() < 2) {
                minuteString = "0" + minuteString;
            }
            this.minuteField.setText(minuteString);
            this.timePanel.add((Component)this.minuteField, gb2);
        }
        return this.timePanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("day")) {
            // empty if block
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Date date = this.getCalendarDate();
        for (MindMapNode node : this.getMindMapController().getSelecteds()) {
            ReminderHookBase alreadyPresentHook = TimeManagementOrganizer.getHook(node);
            if (alreadyPresentHook != null) {
                Object[] messageArguments = new Object[]{new Date(alreadyPresentHook.getRemindUserAt()), date};
                MessageFormat formatter = new MessageFormat(this.getMindMapController().getText("plugins/TimeManagement.xml_reminderNode_onlyOneDate"));
                String message = formatter.format(messageArguments);
                this.logger.info(messageArguments.length + ", " + message);
                int result = JOptionPane.showConfirmDialog(this.getMindMapController().getFrame().getJFrame(), message, "FreeMind", 0);
                if (result == 1) {
                    return;
                }
                this.addHook(node, 0L);
            }
            this.addHook(node, date.getTime());
            ReminderHookBase rh = TimeManagementOrganizer.getHook(node);
            if (rh == null) {
                throw new IllegalArgumentException("hook not found although it is present!!");
            }
            node.invokeHook(rh);
            this.getMindMapController().nodeChanged(node);
        }
    }

    private void addHook(MindMapNode node, long pRemindAt) {
        Properties properties = new Properties();
        if (pRemindAt != 0L) {
            properties.put("REMINDUSERAT", new Long(pRemindAt).toString());
        }
        this.getMindMapController().addHook(node, Tools.getVectorWithSingleElement(node), REMINDER_HOOK_NAME, properties);
    }

    private void disposeDialog() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        lastDate = this.getCalendar();
        sCurrentlyOpenTimeManagement = null;
    }

    private Date getCalendarDate() {
        Calendar cal = this.getCalendar();
        try {
            int value = 0;
            value = Integer.parseInt(this.hourField.getText());
            cal.set(11, value);
            value = Integer.parseInt(this.minuteField.getText());
            cal.set(12, value);
            cal.set(13, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cal.getTime();
    }

    protected Calendar getCalendar() {
        return this.calendar.getCalendar();
    }

    @Override
    public void afterMapClose(MapModule oldMapModule, Mode oldMode) {
    }

    @Override
    public void afterMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
    }

    @Override
    public void beforeMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        this.getMindMapController().getController().getMapModuleManager().removeListener(this);
        this.disposeDialog();
    }

    @Override
    public boolean isMapModuleChangeAllowed(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        return true;
    }

    @Override
    public void numberOfOpenMapInformation(int number, int pIndex) {
    }

    @Override
    public MindMapController getMindMapController() {
        return this.mController;
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(TimeManagement.this.getMindMapController().getText("plugins/TimeManagement.xml_closeButton"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TimeManagement.this.disposeDialog();
        }
    }

    private class TodayAction
    extends AbstractAction {
        public TodayAction() {
            super(TimeManagement.this.getMindMapController().getText("plugins/TimeManagement.xml_todayButton"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TimeManagement.this.calendar.setCalendar(Calendar.getInstance());
        }
    }

    private final class RemoveReminders
    extends AbstractAction {
        public RemoveReminders() {
            super(TimeManagement.this.getMindMapController().getText("plugins/TimeManagement.xml_removeReminderButton"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MindMapNode node : TimeManagement.this.getMindMapController().getSelecteds()) {
                ReminderHookBase alreadyPresentHook = TimeManagementOrganizer.getHook(node);
                if (alreadyPresentHook == null) continue;
                TimeManagement.this.addHook(node, 0L);
            }
        }
    }

    private class RemindAction
    extends AbstractAction {
        public RemindAction() {
            super(TimeManagement.this.getMindMapController().getText("plugins/TimeManagement.xml_reminderButton"));
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            TimeManagement.this.actionPerformed(pE);
        }
    }

    private class AppendDateToSiblingAction
    extends AppendDateAbstractAction {
        public AppendDateToSiblingAction() {
            this.init(new NodeFactory(){

                @Override
                public MindMapNode getNode(MindMapNode pNode) {
                    MindMapNode parent = pNode;
                    if (!pNode.isRoot()) {
                        parent = pNode.getParentNode();
                    }
                    return TimeManagement.this.getMindMapController().addNewNode(parent, parent.getIndex(pNode) + 1, parent.isLeft());
                }
            }, "plugins/TimeManagement.xml_appendAsNewSiblingButton");
        }
    }

    private class AppendDateToChildAction
    extends AppendDateAbstractAction {
        public AppendDateToChildAction() {
            this.init(new NodeFactory(){

                @Override
                public MindMapNode getNode(MindMapNode pNode) {
                    return TimeManagement.this.getMindMapController().addNewNode(pNode, pNode.getChildCount(), pNode.isLeft());
                }
            }, "plugins/TimeManagement.xml_appendAsNewButton");
        }
    }

    private class AppendDateAction
    extends AppendDateAbstractAction {
        public AppendDateAction() {
            this.init(new NodeFactory(){

                @Override
                public MindMapNode getNode(MindMapNode pNode) {
                    return pNode;
                }
            }, "plugins/TimeManagement.xml_appendButton");
        }
    }

    private class AppendDateAbstractAction
    extends AbstractAction {
        private NodeFactory mFactory;

        public void init(NodeFactory pFactory, String pText) {
            this.putValue("Name", TimeManagement.this.getMindMapController().getText(pText));
            this.mFactory = pFactory;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MindMapNode lastElement = null;
            Vector<MindMapNode> sel = new Vector<MindMapNode>();
            Iterator i = TimeManagement.this.getMindMapController().getSelecteds().iterator();
            while (i.hasNext()) {
                MindMapNode element = this.mFactory.getNode((MindMapNode)i.next());
                DateFormat df = DateFormat.getDateInstance(3);
                String dateAsString = df.format(TimeManagement.this.getCalendarDate());
                TimeManagement.this.getMindMapController().setNodeText(element, element.getText() + " " + dateAsString);
                lastElement = element;
                sel.add(element);
            }
            TimeManagement.this.getMindMapController().select(lastElement, sel);
        }
    }

    private static interface NodeFactory {
        public MindMapNode getNode(MindMapNode var1);
    }
}

