/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dialog;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import javajs.util.PT;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;

public class FilePreview
extends JPanel
implements PropertyChangeListener {
    JCheckBox active;
    JCheckBox append;
    JCheckBox cartoons;
    JFileChooser chooser;
    private static boolean pdbCartoonChecked = true;
    private FPPanel display;
    Viewer vwr;

    public FilePreview(Viewer vwr, JFileChooser fileChooser, boolean allowAppend, Map<String, Object> vwrOptions) {
        this.vwr = vwr;
        this.chooser = fileChooser;
        Box box = Box.createVerticalBox();
        this.active = new JCheckBox(GT._("Preview"), false);
        this.active.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePreview.this.doPreviewAction(FilePreview.this.active.isSelected());
            }
        });
        box.add(this.active);
        this.display = new FPPanel(vwrOptions);
        this.display.setPreferredSize(new Dimension(80, 80));
        this.display.setMinimumSize(new Dimension(50, 50));
        box.add(this.display);
        if (allowAppend) {
            this.append = new JCheckBox(GT._("Append models"), false);
            box.add(this.append);
            this.cartoons = new JCheckBox(GT._("PDB cartoons"), pdbCartoonChecked);
            this.cartoons.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FilePreview.this.active.isSelected()) {
                        FilePreview.this.doUpdatePreview(FilePreview.this.chooser.getSelectedFile());
                    }
                }
            });
            box.add(this.cartoons);
        }
        this.add(box);
        fileChooser.setAccessory(this);
        fileChooser.addPropertyChangeListener(this);
    }

    protected void doPreviewAction(boolean selected) {
        this.doUpdatePreview(selected ? this.chooser.getSelectedFile() : null);
    }

    public boolean isAppendSelected() {
        return this.append != null && this.append.isSelected();
    }

    public boolean isCartoonsSelected() {
        pdbCartoonChecked = this.cartoons != null && this.cartoons.isSelected();
        return pdbCartoonChecked;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (this.active.isSelected() && "SelectedFileChangedProperty".equals(prop = evt.getPropertyName())) {
            this.doUpdatePreview((File)evt.getNewValue());
        }
    }

    void doUpdatePreview(File file) {
        String script;
        if (file == null) {
            script = "zap";
        } else {
            String fileName = file.getAbsolutePath();
            String url = this.vwr.getLocalUrl(fileName);
            if (url != null) {
                fileName = url;
            }
            fileName = fileName.replace('\\', '/');
            script = " \"" + fileName + "\"";
            if (fileName.indexOf(".spt") >= 0) {
                script = "script " + script;
            } else {
                script = PT.rep((String)this.display.vwr.getP("defaultdropscript"), "\"%FILE\"", script + " 1");
                script = PT.rep(script, "%ALLOWCARTOONS", "" + (this.isCartoonsSelected() && !this.isAppendSelected()));
                System.out.println(script);
            }
        }
        this.display.vwr.evalStringQuiet(script);
    }

    public void setPreviewOptions(boolean TF) {
        if (this.append == null) {
            return;
        }
        this.append.setVisible(TF);
        this.cartoons.setVisible(TF);
    }

    private static class FPPanel
    extends JPanel {
        Viewer vwr;
        final Dimension currentSize = new Dimension();

        FPPanel(Map<String, Object> info) {
            info.put("previewOnly", Boolean.TRUE);
            Object display = info.get("display");
            info.put("display", this);
            this.vwr = new Viewer(info);
            info.put("display", display);
        }

        @Override
        public void paint(Graphics g) {
            this.getSize(this.currentSize);
            this.vwr.setScreenDimension(this.currentSize.width, this.currentSize.height);
            Rectangle rectClip = new Rectangle();
            g.getClipBounds(rectClip);
            this.vwr.renderScreenImage((Object)g, this.currentSize.width, this.currentSize.height);
        }
    }
}

