/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.help;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.help.SortMerge;
import javax.help.TreeItem;
import javax.help.UniteAppendMerge;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.zaproxy.zap.extension.help.ZapTocItem;

public class ZapTocMerger
extends UniteAppendMerge {
    private static final String DEFAULT_MERGE_TYPE = ZapTocMerger.class.getCanonicalName();
    private static final String ADDONS_TOC_ID = "addons";
    public static final Map<String, ForceMergeRequirement> TOC_IDS_FORCE_MERGE_MAP;

    public ZapTocMerger(NavigatorView navigatorView, NavigatorView navigatorView2) {
        super(navigatorView, navigatorView2);
    }

    public TreeNode processMerge(TreeNode treeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
        if (defaultMutableTreeNode.equals(this.slaveTopNode)) {
            return defaultMutableTreeNode;
        }
        if (this.slaveTopNode.getChildCount() == 0) {
            return defaultMutableTreeNode;
        }
        ZapTocMerger.mergeNodes(defaultMutableTreeNode, this.slaveTopNode);
        return defaultMutableTreeNode;
    }

    public static void mergeNodes(TreeNode treeNode, TreeNode treeNode2) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode2;
        int n = defaultMutableTreeNode.getChildCount();
        while (defaultMutableTreeNode2.getChildCount() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (ZapTocMerger.doCustomMerge(defaultMutableTreeNode3, defaultMutableTreeNode4)) {
                    defaultMutableTreeNode3 = null;
                    break;
                }
                if (MergeHelpUtilities.compareNames((DefaultMutableTreeNode)defaultMutableTreeNode4, (DefaultMutableTreeNode)defaultMutableTreeNode3) != 0) continue;
                if (MergeHelpUtilities.haveEqualID((DefaultMutableTreeNode)defaultMutableTreeNode4, (DefaultMutableTreeNode)defaultMutableTreeNode3)) {
                    MergeHelpUtilities.mergeNodes((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)defaultMutableTreeNode4, (DefaultMutableTreeNode)defaultMutableTreeNode3);
                    defaultMutableTreeNode3.removeFromParent();
                    defaultMutableTreeNode3 = null;
                    break;
                }
                MergeHelpUtilities.markNodes((DefaultMutableTreeNode)defaultMutableTreeNode4, (DefaultMutableTreeNode)defaultMutableTreeNode3);
                defaultMutableTreeNode.add(defaultMutableTreeNode3);
                MergeHelpUtilities.mergeNodeChildren((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)defaultMutableTreeNode3);
                defaultMutableTreeNode3 = null;
                break;
            }
            if (defaultMutableTreeNode3 == null) continue;
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            MergeHelpUtilities.mergeNodeChildren((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)defaultMutableTreeNode3);
        }
        defaultMutableTreeNode2.removeFromParent();
        defaultMutableTreeNode2 = null;
    }

    private static boolean doCustomMerge(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        if (ZapTocMerger.isSameTOCID(defaultMutableTreeNode2, defaultMutableTreeNode) || ZapTocMerger.isForceMerge(defaultMutableTreeNode2, defaultMutableTreeNode)) {
            MergeHelpUtilities.mergeNodes((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)defaultMutableTreeNode2, (DefaultMutableTreeNode)defaultMutableTreeNode);
            defaultMutableTreeNode.removeFromParent();
            if (ADDONS_TOC_ID.equals(ZapTocMerger.getTOCID(defaultMutableTreeNode2))) {
                SortMerge.sortNode((DefaultMutableTreeNode)defaultMutableTreeNode2, (Locale)MergeHelpUtilities.getLocale((DefaultMutableTreeNode)defaultMutableTreeNode2));
            }
            return true;
        }
        return false;
    }

    private static boolean isSameTOCID(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        String string = ZapTocMerger.getTOCID(defaultMutableTreeNode2);
        if (string == null) {
            return false;
        }
        return string.equals(ZapTocMerger.getTOCID(defaultMutableTreeNode));
    }

    private static String getTOCID(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeItem treeItem = (TreeItem)defaultMutableTreeNode.getUserObject();
        if (treeItem != null && treeItem instanceof ZapTocItem) {
            return ((ZapTocItem)treeItem).getTocId();
        }
        return null;
    }

    private static boolean isForceMerge(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        ForceMergeRequirement forceMergeRequirement;
        TreeItem treeItem = (TreeItem)defaultMutableTreeNode2.getUserObject();
        String string = treeItem.getName();
        if (string == null) {
            return false;
        }
        String string2 = ZapTocMerger.getTOCID(defaultMutableTreeNode);
        return string2 != null && (forceMergeRequirement = TOC_IDS_FORCE_MERGE_MAP.get(string2)) != null && forceMergeRequirement.isSameMasterLevel(defaultMutableTreeNode.getLevel()) && forceMergeRequirement.isSameSlaveName(string);
    }

    public static void mergeNodeChildren(TreeNode treeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) continue;
            MergeHelpUtilities.mergeNodeChildren((String)DEFAULT_MERGE_TYPE, (DefaultMutableTreeNode)defaultMutableTreeNode2);
        }
    }

    static {
        HashMap<String, ForceMergeRequirement> hashMap = new HashMap<String, ForceMergeRequirement>();
        hashMap.put("toplevelitem", new ForceMergeRequirement(1, "ZAP User Guide"));
        hashMap.put(ADDONS_TOC_ID, new ForceMergeRequirement(2, "Add Ons"));
        TOC_IDS_FORCE_MERGE_MAP = Collections.unmodifiableMap(hashMap);
    }

    public static final class ForceMergeRequirement {
        private final int masterNodeLevel;
        private final String slaveNodeName;

        public ForceMergeRequirement(int n, String string) {
            if (n < 0) {
                throw new IllegalArgumentException("Parameter masterNodeLevel must not be negative.");
            }
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("Parameter slaveNodeName must not be null.");
            }
            this.masterNodeLevel = n;
            this.slaveNodeName = string;
        }

        public boolean isSameMasterLevel(int n) {
            return this.masterNodeLevel == n;
        }

        public boolean isSameSlaveName(String string) {
            return this.slaveNodeName.equals(string);
        }
    }
}

