/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.stathissideris.ascii2image.core.ConfigurationParser;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.core.RenderingOptions;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.xml.sax.SAXException;

public class ConversionOptions {
    public ProcessingOptions processingOptions = new ProcessingOptions();
    public RenderingOptions renderingOptions = new RenderingOptions();

    public void setDebug(boolean bl) {
        this.processingOptions.setPrintDebugOutput(bl);
        this.renderingOptions.setRenderDebugLines(bl);
    }

    public ConversionOptions() {
    }

    public static Color parseColor(String string) {
        if (string.length() == 6) {
            return new Color(Integer.parseInt(string, 16));
        }
        if (string.length() == 8) {
            return new Color(Integer.parseInt(string.substring(0, 2), 16), Integer.parseInt(string.substring(2, 4), 16), Integer.parseInt(string.substring(4, 6), 16), Integer.parseInt(string.substring(6, 8), 16));
        }
        throw new IllegalArgumentException("Cannot interpret \"" + string + "\" as background colour. It needs to be a 6- or 8-digit hex number, depending on whether you have transparency or not (same as HTML).");
    }

    public ConversionOptions(CommandLine commandLine) throws UnsupportedEncodingException {
        Object object;
        Object object2;
        this.processingOptions.setVerbose(commandLine.hasOption("verbose"));
        this.renderingOptions.setDropShadows(!commandLine.hasOption("no-shadows"));
        this.setDebug(commandLine.hasOption("debug"));
        this.processingOptions.setOverwriteFiles(commandLine.hasOption("overwrite"));
        if (commandLine.hasOption("scale")) {
            object2 = Float.valueOf(Float.parseFloat(commandLine.getOptionValue("scale")));
            this.renderingOptions.setScale(((Float)object2).floatValue());
        }
        this.processingOptions.setAllCornersAreRound(commandLine.hasOption("round-corners"));
        this.processingOptions.setPerformSeparationOfCommonEdges(!commandLine.hasOption("no-separation"));
        this.renderingOptions.setAntialias(!commandLine.hasOption("no-antialias"));
        this.renderingOptions.setFixedSlope(commandLine.hasOption("fixed-slope"));
        if (commandLine.hasOption("background")) {
            object2 = commandLine.getOptionValue("background");
            object = ConversionOptions.parseColor((String)object2);
            this.renderingOptions.setBackgroundColor((Color)object);
        }
        if (commandLine.hasOption("transparent")) {
            this.renderingOptions.setBackgroundColor(new Color(0, 0, 0, 0));
        }
        if (commandLine.hasOption("tabs")) {
            object2 = Integer.parseInt(commandLine.getOptionValue("tabs"));
            int n = (Integer)object2;
            if (n < 0) {
                n = 0;
            }
            this.processingOptions.setTabSize(n);
        }
        if ((object2 = commandLine.getOptionValue("encoding")) != null) {
            new String(new byte[2], (String)object2);
            this.processingOptions.setCharacterEncoding((String)object2);
        }
        object = new ConfigurationParser();
        try {
            for (Option option : commandLine.getOptions()) {
                if (!option.getLongOpt().equals("config")) continue;
                String string = option.getValue();
                System.out.println("Parsing configuration file " + string);
                File file = new File(string);
                if (file.exists()) {
                    ((ConfigurationParser)object).parseFile(file);
                    HashMap<String, CustomShapeDefinition> hashMap = ((ConfigurationParser)object).getShapeDefinitionsHash();
                    this.processingOptions.putAllInCustomShapes(hashMap);
                    continue;
                }
                System.err.println("File " + file + " does not exist, skipping");
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

