/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.manager;

import org.eclipse.aether.graph.DependencyNode;

public final class DependencyManagerUtils {
    public static final String CONFIG_PROP_VERBOSE = "aether.dependencyManager.verbose";
    public static final String NODE_DATA_PREMANAGED_VERSION = "premanaged.version";
    public static final String NODE_DATA_PREMANAGED_SCOPE = "premanaged.scope";
    public static final String NODE_DATA_PREMANAGED_OPTIONAL = "premanaged.optional";

    public static String getPremanagedVersion(DependencyNode node) {
        if ((node.getManagedBits() & 1) == 0) {
            return null;
        }
        return DependencyManagerUtils.cast(node.getData().get(NODE_DATA_PREMANAGED_VERSION), String.class);
    }

    public static String getPremanagedScope(DependencyNode node) {
        if ((node.getManagedBits() & 2) == 0) {
            return null;
        }
        return DependencyManagerUtils.cast(node.getData().get(NODE_DATA_PREMANAGED_SCOPE), String.class);
    }

    public static Boolean getPremanagedOptional(DependencyNode node) {
        if ((node.getManagedBits() & 4) == 0) {
            return null;
        }
        return DependencyManagerUtils.cast(node.getData().get(NODE_DATA_PREMANAGED_OPTIONAL), Boolean.class);
    }

    private static <T> T cast(Object obj, Class<T> type) {
        return type.isInstance(obj) ? (T)type.cast(obj) : null;
    }
}

