/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.Context;
import esmska.data.Config;
import esmska.data.Gateways;
import esmska.data.History;
import esmska.data.Icons;
import esmska.data.Log;
import esmska.data.Queue;
import esmska.data.SMS;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import esmska.gui.Actions;
import esmska.gui.ContactPanel;
import esmska.gui.GUIImageCodeResolver;
import esmska.gui.GatewayMessageFrame;
import esmska.gui.NotificationIcon;
import esmska.gui.QueuePanel;
import esmska.gui.SMSPanel;
import esmska.gui.StatusPanel;
import esmska.gui.ThemeManager;
import esmska.integration.ActionBean;
import esmska.integration.IntegrationAdapter;
import esmska.transfer.ImageCodeManager;
import esmska.transfer.SMSSender;
import esmska.update.Statistics;
import esmska.update.UpdateChecker;
import esmska.update.UpdateInstaller;
import esmska.utils.L10N;
import esmska.utils.MiscUtils;
import esmska.utils.RuntimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.openide.awt.Mnemonics;

public class MainFrame
extends JFrame {
    private static MainFrame instance;
    private static final Logger logger;
    private static final String RES = "/esmska/resources/";
    private static final ResourceBundle l10n;
    private BindingGroup bindGroup = new BindingGroup();
    private static final SMSSender smsSender;
    private static final Config config;
    private static final History history;
    private static final Log log;
    private static final Queue queue;
    private Thread shutdownThread = new ShutdownThread();
    private UpdateChecker updateChecker = UpdateChecker.getInstance();
    private JMenuItem aboutMenuItem;
    private JButton compressButton;
    private JMenuItem compressMenuItem;
    private JButton configButton;
    private JMenuItem configMenuItem;
    private ContactPanel contactPanel;
    private JButton donateButton;
    private JMenuItem donateMenuItem;
    private JButton exitButton;
    private JMenuItem exitMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem faqMenuItem;
    private JMenuItem getHelpMenuItem;
    private JMenu helpMenu;
    private JSeparator helpSeparator;
    private JButton historyButton;
    private JMenuItem historyMenuItem;
    private JSplitPane horizontalSplitPane;
    private JMenuItem importMenuItem;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JMenuItem logMenuItem;
    private JMenuBar menuBar;
    private JMenu messageMenu;
    private JMenuItem problemMenuItem;
    private JMenu programMenu;
    private QueuePanel queuePanel;
    private JButton redoButton;
    private JMenuItem redoMenuItem;
    private JMenuItem sendMenuItem;
    private SMSPanel smsPanel;
    private StatusPanel statusPanel;
    private JToolBar toolBar;
    private JMenu toolsMenu;
    private JMenuItem translateMenuItem;
    private JButton undoButton;
    private JMenuItem undoMenuItem;
    private JSplitPane verticalSplitPane;

    private MainFrame() {
        Context.mainFrame = instance = this;
        if (ThemeManager.isAquaCurrentLaF()) {
            this.getRootPane().putClientProperty("apple.awt.brushMetalLook", "true");
        }
        this.initComponents();
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(Icons.get("esmska-16.png").getImage());
        images.add(Icons.get("esmska-32.png").getImage());
        images.add(Icons.get("esmska-64.png").getImage());
        images.add(Icons.get("esmska.png").getImage());
        this.setIconImages(images);
        String command = "hide";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotificationIcon.isInstalled() || RuntimeUtils.isMac()) {
                    MainFrame.this.formWindowClosing(new WindowEvent(MainFrame.this, 0));
                }
            }
        });
        if (RuntimeUtils.isMac()) {
            logger.fine("Running on Mac OS, hiding some menu items...");
            try {
                ActionBean bean = new ActionBean();
                bean.setQuitAction(Actions.getQuitAction());
                bean.setAboutAction(Actions.getAboutAction());
                bean.setConfigAction(Actions.getConfigAction());
                IntegrationAdapter integration = IntegrationAdapter.getInstance();
                integration.setActionBean(bean);
                integration.activateGUI();
                this.programMenu.setVisible(false);
                this.aboutMenuItem.setVisible(false);
                this.helpMenu.remove(this.helpSeparator);
            }
            catch (Throwable ex) {
                logger.log(Level.WARNING, "Can't integrate program menu items to Mac system menu", ex);
            }
        }
        ToolTipManager.sharedInstance().setInitialDelay(750);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        log.addRecord(new Log.Record(l10n.getString("Program_start")));
        this.loadConfig();
        if (queue.size() > 0) {
            queue.setPaused(true);
        }
        this.contactPanel.requestFocusInWindow();
        this.contactPanel.ensureContactSelected();
        queue.addValuedListener(new QueueListener());
        ImageCodeManager.setResolver(new GUIImageCodeResolver());
        AutoBinding bind = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, config, BeanProperty.create("toolbarVisible"), this.toolBar, BeanProperty.create("visible"));
        AutoBinding bind2 = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, config, BeanProperty.create("notificationIconVisible"), this.exitButton, BeanProperty.create("visible"));
        this.bindGroup.addBinding(bind);
        this.bindGroup.addBinding(bind2);
        this.bindGroup.bind();
        if (!Beans.isDesignTime()) {
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
        ActionListener verticalSplitListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 0) {
                    int prefHeight;
                    JComponent comp = (JComponent)e.getSource();
                    int dividerLocation = prefHeight = comp.getPreferredSize().height;
                    if (MainFrame.this.verticalSplitPane.getBottomComponent() == comp) {
                        dividerLocation = MainFrame.this.verticalSplitPane.getHeight() - prefHeight - MainFrame.this.verticalSplitPane.getDividerSize();
                    }
                    MainFrame.this.verticalSplitPane.setDividerLocation(dividerLocation);
                }
            }
        };
        this.smsPanel.addActionListener(verticalSplitListener);
        this.queuePanel.addActionListener(verticalSplitListener);
        final AtomicBoolean calledEverythingLoaded = new AtomicBoolean();
        Context.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!StringUtils.equals(evt.getPropertyName(), "everythingLoaded")) {
                    return;
                }
                if (!Context.everythingLoaded()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (calledEverythingLoaded.compareAndSet(false, true)) {
                            MainFrame.this.everythingLoaded();
                        }
                    }
                });
                Context.removePropertyChangeListener(this);
            }
        });
        if (Context.everythingLoaded() && calledEverythingLoaded.compareAndSet(false, true)) {
            this.everythingLoaded();
        }
    }

    private void everythingLoaded() {
        if (Gateways.getInstance().size() <= 0) {
            logger.warning("No usable gateways found");
            JOptionPane.showMessageDialog(this, new JLabel(l10n.getString("MainFrame.no_gateways")), null, 0);
        }
        Statistics.sendUsageInfo();
        this.updateChecker.addActionListener(new UpdateListener());
        this.updateChecker.checkForUpdates();
    }

    private void loadGatewaysAsync() {
        logger.fine("Loading gateways asynchronously...");
        Thread loadGwsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Context.persistenceManager.loadGateways();
                }
                catch (IntrospectionException ex) {
                    logger.log(Level.SEVERE, "Current JRE doesn't support JavaScript execution", ex);
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(null, l10n.getString("Main.no_javascript"), null, 0);
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Can't display error message", e);
                    }
                    System.exit(2);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Could not load gateways", ex);
                }
                try {
                    Context.persistenceManager.loadGatewayProperties();
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Could not load gateway properties file", ex);
                }
                Context.setGatewaysLoaded(true);
            }
        });
        loadGwsThread.setDaemon(true);
        loadGwsThread.start();
    }

    public static void instantiate() {
        if (instance != null) {
            throw new IllegalStateException("MainFrame is already instantiated");
        }
        instance = new MainFrame();
    }

    public void startAndShow() {
        logger.fine("Showing mainframe...");
        if (config.isStartMinimized() && NotificationIcon.isInstalled()) {
            logger.fine("Starting hidden in notification icon");
            SplashScreen splash = SplashScreen.getSplashScreen();
            if (splash != null && splash.isVisible()) {
                splash.close();
            }
        } else {
            this.setVisible(true);
        }
        this.loadGatewaysAsync();
    }

    public void showTipOfTheDay() {
        try {
            List tips = IOUtils.readLines(this.getClass().getResourceAsStream("/esmska/resources/tips.txt"), "UTF-8");
            int random = new Random().nextInt(tips.size());
            this.statusPanel.setStatusMessage(l10n.getString("MainFrame.tip") + " " + l10n.getString((String)tips.get(random)), null, null, false);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Can't display tip of the day", ex);
        }
    }

    public StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    public ContactPanel getContactPanel() {
        return this.contactPanel;
    }

    public SMSPanel getSMSPanel() {
        return this.smsPanel;
    }

    public SMSSender getSMSSender() {
        return smsSender;
    }

    public JToolBar getToolbar() {
        return this.toolBar;
    }

    public QueuePanel getQueuePanel() {
        return this.queuePanel;
    }

    public JSplitPane getHorizontalSplitPane() {
        return this.horizontalSplitPane;
    }

    public JSplitPane getVerticalSplitPane() {
        return this.verticalSplitPane;
    }

    public void exit() {
        logger.fine("Closing program...");
        Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        boolean saveOk = this.saveAll();
        if (!saveOk) {
            JOptionPane.showMessageDialog(this, l10n.getString("MainFrame.cant_save_config"), null, 2);
        }
        int returnCode = saveOk ? 0 : 3;
        logger.log(Level.FINE, "Exiting program with return code: {0}", returnCode);
        System.exit(returnCode);
    }

    private void initComponents() {
        this.horizontalSplitPane = new JSplitPane();
        this.verticalSplitPane = new JSplitPane();
        this.smsPanel = new SMSPanel();
        this.queuePanel = new QueuePanel();
        this.contactPanel = new ContactPanel();
        this.statusPanel = new StatusPanel();
        this.jSeparator1 = new JSeparator();
        this.toolBar = new JToolBar();
        this.compressButton = new JButton();
        this.undoButton = new JButton();
        this.redoButton = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.historyButton = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.configButton = new JButton();
        this.exitButton = new JButton();
        this.donateButton = new JButton();
        this.menuBar = new JMenuBar();
        this.programMenu = new JMenu();
        this.configMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.messageMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.compressMenuItem = new JMenuItem();
        this.sendMenuItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.historyMenuItem = new JMenuItem();
        this.logMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.importMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.faqMenuItem = new JMenuItem();
        this.getHelpMenuItem = new JMenuItem();
        this.problemMenuItem = new JMenuItem();
        this.translateMenuItem = new JMenuItem();
        this.donateMenuItem = new JMenuItem();
        this.helpSeparator = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("Esmska");
        this.setLocationByPlatform(true);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                MainFrame.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainFrame.this.formWindowClosing(evt);
            }
        });
        this.horizontalSplitPane.setBorder(null);
        this.horizontalSplitPane.setResizeWeight(0.5);
        this.horizontalSplitPane.setContinuousLayout(true);
        this.horizontalSplitPane.setOneTouchExpandable(true);
        this.horizontalSplitPane.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.verticalSplitPane.setBorder(null);
        this.verticalSplitPane.setOrientation(0);
        this.verticalSplitPane.setResizeWeight(1.0);
        this.verticalSplitPane.setContinuousLayout(true);
        this.verticalSplitPane.setOneTouchExpandable(true);
        this.verticalSplitPane.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.smsPanel.putClientProperty("substancelaf.componentFlat", Boolean.FALSE);
        this.verticalSplitPane.setLeftComponent(this.smsPanel);
        this.queuePanel.addValuedListener(new QueuePanelListener());
        this.queuePanel.putClientProperty("substancelaf.componentFlat", Boolean.FALSE);
        this.verticalSplitPane.setRightComponent(this.queuePanel);
        this.horizontalSplitPane.setLeftComponent(this.verticalSplitPane);
        this.contactPanel.addActionListener(new ContactListener());
        this.contactPanel.putClientProperty("substancelaf.componentFlat", Boolean.FALSE);
        this.horizontalSplitPane.setRightComponent(this.contactPanel);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.add(Box.createRigidArea(new Dimension(5, 1)));
        this.compressButton.setAction(this.smsPanel.getCompressAction());
        this.compressButton.setFocusable(false);
        this.compressButton.setHideActionText(true);
        this.toolBar.add(this.compressButton);
        this.undoButton.setAction(this.smsPanel.getUndoAction());
        this.undoButton.setToolTipText(l10n.getString("MainFrame.undoButton.toolTipText"));
        this.undoButton.setFocusable(false);
        this.undoButton.setHideActionText(true);
        this.toolBar.add(this.undoButton);
        this.redoButton.setAction(this.smsPanel.getRedoAction());
        this.redoButton.setToolTipText(l10n.getString("MainFrame.redoButton.toolTipText"));
        this.redoButton.setFocusable(false);
        this.redoButton.setHideActionText(true);
        this.toolBar.add(this.redoButton);
        this.toolBar.add(this.jSeparator2);
        this.historyButton.setAction(Actions.getHistoryAction());
        this.historyButton.setFocusable(false);
        this.historyButton.setHideActionText(true);
        Mnemonics.setLocalizedText(this.historyButton, l10n.getString("History"));
        this.historyButton.setToolTipText(this.historyButton.getToolTipText() + " (Ctrl+T)");
        this.toolBar.add(this.historyButton);
        this.toolBar.add(this.jSeparator3);
        this.configButton.setAction(Actions.getConfigAction());
        this.configButton.setToolTipText(Actions.getConfigAction().getValue("Name").toString());
        this.configButton.setFocusable(false);
        this.configButton.setHideActionText(true);
        this.toolBar.add(this.configButton);
        this.exitButton.setAction(Actions.getQuitAction());
        this.exitButton.setToolTipText(Actions.getQuitAction().getValue("Name").toString() + " (Ctrl+Q)");
        this.exitButton.setFocusable(false);
        this.exitButton.setHideActionText(true);
        this.toolBar.add(this.exitButton);
        this.donateButton.setAction(Actions.getBrowseAction("http://code.google.com/p/esmska/wiki/Support"));
        this.donateButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/donate-32.png")));
        Mnemonics.setLocalizedText(this.donateButton, l10n.getString("MainFrame.donateButton.text"));
        this.donateButton.setToolTipText(l10n.getString("AboutFrame.supportHyperlink.toolTipText"));
        this.donateButton.setFocusable(false);
        this.toolBar.add(Box.createHorizontalGlue());
        this.toolBar.add(this.donateButton);
        for (Component comp : this.toolBar.getComponents()) {
            if (!(comp instanceof JButton)) continue;
            JButton button = (JButton)comp;
            button.setMnemonic(0);
            button.putClientProperty("JButton.buttonType", "gradient");
        }
        Mnemonics.setLocalizedText(this.programMenu, l10n.getString("MainFrame.programMenu.text"));
        this.configMenuItem.setAction(Actions.getConfigAction());
        this.programMenu.add(this.configMenuItem);
        this.exitMenuItem.setAction(Actions.getQuitAction());
        this.programMenu.add(this.exitMenuItem);
        this.menuBar.add(this.programMenu);
        Mnemonics.setLocalizedText(this.messageMenu, l10n.getString("MainFrame.messageMenu.text"));
        this.undoMenuItem.setAction(this.smsPanel.getUndoAction());
        this.messageMenu.add(this.undoMenuItem);
        this.redoMenuItem.setAction(this.smsPanel.getRedoAction());
        this.messageMenu.add(this.redoMenuItem);
        this.messageMenu.add(this.jSeparator5);
        this.compressMenuItem.setAction(this.smsPanel.getCompressAction());
        this.messageMenu.add(this.compressMenuItem);
        this.sendMenuItem.setAction(this.smsPanel.getSendAction());
        this.messageMenu.add(this.sendMenuItem);
        this.menuBar.add(this.messageMenu);
        Mnemonics.setLocalizedText(this.toolsMenu, l10n.getString("MainFrame.toolsMenu.text"));
        this.historyMenuItem.setAction(Actions.getHistoryAction());
        this.toolsMenu.add(this.historyMenuItem);
        this.logMenuItem.setAction(Actions.getLogAction());
        this.toolsMenu.add(this.logMenuItem);
        this.toolsMenu.add(this.jSeparator4);
        this.importMenuItem.setAction(Actions.getImportAction());
        this.toolsMenu.add(this.importMenuItem);
        this.exportMenuItem.setAction(Actions.getExportAction());
        this.toolsMenu.add(this.exportMenuItem);
        this.menuBar.add(this.toolsMenu);
        Mnemonics.setLocalizedText(this.helpMenu, l10n.getString("MainFrame.helpMenu.text"));
        this.faqMenuItem.setAction(Actions.getBrowseAction("http://code.google.com/p/esmska/wiki/FAQ"));
        Mnemonics.setLocalizedText(this.faqMenuItem, l10n.getString("MainFrame.faqMenuItem.text"));
        this.faqMenuItem.setToolTipText(l10n.getString("MainFrame.faqMenuItem.toolTipText"));
        this.helpMenu.add(this.faqMenuItem);
        this.getHelpMenuItem.setAction(Actions.getBrowseAction("https://answers.launchpad.net/esmska"));
        this.getHelpMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/getHelp-16.png")));
        Mnemonics.setLocalizedText(this.getHelpMenuItem, l10n.getString("MainFrame.getHelpMenuItem.text"));
        this.getHelpMenuItem.setToolTipText(l10n.getString("MainFrame.getHelpMenuItem.toolTipText"));
        this.helpMenu.add(this.getHelpMenuItem);
        this.problemMenuItem.setAction(Actions.getBrowseAction("http://code.google.com/p/esmska/wiki/Issues"));
        Mnemonics.setLocalizedText(this.problemMenuItem, l10n.getString("MainFrame.problemMenuItem.text"));
        this.problemMenuItem.setToolTipText(l10n.getString("MainFrame.problemMenuItem.toolTipText"));
        this.helpMenu.add(this.problemMenuItem);
        this.translateMenuItem.setAction(Actions.getBrowseAction("https://translations.launchpad.net/esmska"));
        Mnemonics.setLocalizedText(this.translateMenuItem, l10n.getString("MainFrame.translateMenuItem.text"));
        this.translateMenuItem.setToolTipText(l10n.getString("MainFrame.translateMenuItem.toolTipText"));
        this.helpMenu.add(this.translateMenuItem);
        this.donateMenuItem.setAction(Actions.getBrowseAction("http://code.google.com/p/esmska/wiki/Support"));
        this.donateMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/donate-16.png")));
        Mnemonics.setLocalizedText(this.donateMenuItem, l10n.getString("MainFrame.donateMenuItem.text"));
        this.donateMenuItem.setToolTipText(l10n.getString("AboutFrame.supportHyperlink.toolTipText"));
        this.helpMenu.add(this.donateMenuItem);
        this.helpMenu.add(this.helpSeparator);
        this.aboutMenuItem.setAction(Actions.getAboutAction());
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -1, 659, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 659, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.horizontalSplitPane, -1, 647, Short.MAX_VALUE).addContainerGap()).addComponent(this.toolBar, -1, 659, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.horizontalSplitPane, -1, 450, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.statusPanel, -2, -1, -2)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        if (evt != null && (NotificationIcon.isInstalled() || RuntimeUtils.isMac())) {
            logger.fine("Hiding main window");
            if (RuntimeUtils.isMac()) {
                this.setVisible(false);
            } else {
                NotificationIcon.toggleMainFrameVisibility();
            }
            return;
        }
        this.exit();
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        if (!RuntimeUtils.isMac()) {
            this.setVisible(true);
        }
    }

    private boolean saveAll() {
        logger.fine("Saving user data...");
        boolean saveOk = true;
        try {
            saveOk = this.saveConfig() && saveOk;
            saveOk = this.saveContacts() && saveOk;
            saveOk = this.saveQueue() && saveOk;
            saveOk = this.saveHistory() && saveOk;
            saveOk = this.saveKeyring() && saveOk;
            saveOk = this.saveGatewayProperties() && saveOk;
            return saveOk;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Serious error during saving user data", t);
            return false;
        }
    }

    private void createHistory(SMS sms) {
        boolean match = false;
        if (sms.getId() != null) {
            List<History.Record> records = history.getRecords();
            ListIterator<History.Record> li = records.listIterator(records.size());
            while (li.hasPrevious()) {
                History.Record r = li.previous();
                if (!sms.getId().equals(r.getSmsId())) continue;
                r.setText(r.getText() + sms.getText());
                r.setDate(null);
                match = true;
                break;
            }
        }
        if (!match) {
            History.Record record = new History.Record(sms.getNumber(), sms.getText(), sms.getGateway(), sms.getName(), sms.getSenderNumber(), sms.getSenderName(), null, sms.getId());
            history.addRecord(record);
        }
    }

    private boolean saveConfig() {
        config.setMainDimension(this.getSize());
        config.setHorizontalSplitPaneLocation(this.horizontalSplitPane.getDividerLocation());
        config.setVerticalSplitPaneLocation(this.verticalSplitPane.getDividerLocation());
        try {
            Context.persistenceManager.saveConfig();
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not save config", ex);
            return false;
        }
    }

    private void loadConfig() {
        logger.finer("Initializing according to config...");
        Dimension mainDimension = config.getMainDimension();
        Integer horizontalSplitPaneLocation = config.getHorizontalSplitPaneLocation();
        Integer verticalSplitPaneLocation = config.getVerticalSplitPaneLocation();
        if (mainDimension != null) {
            this.setSize(mainDimension);
        }
        if (horizontalSplitPaneLocation != null) {
            this.horizontalSplitPane.setDividerLocation(horizontalSplitPaneLocation);
        }
        if (verticalSplitPaneLocation != null) {
            this.verticalSplitPane.setDividerLocation(verticalSplitPaneLocation);
        }
        if (config.isStartCentered()) {
            this.setLocationRelativeTo(null);
        }
        if (history.getRecords().size() > 0) {
            this.contactPanel.setSelectedContact(history.getRecord(history.getRecords().size() - 1).getName());
            this.contactPanel.makeNiceSelection();
        }
        if (config.isNotificationIconVisible()) {
            NotificationIcon.install();
        }
        if (config.isShowTips()) {
            this.showTipOfTheDay();
        }
    }

    private boolean saveContacts() {
        try {
            Context.persistenceManager.saveContacts();
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not save contacts", ex);
            return false;
        }
    }

    private boolean saveQueue() {
        try {
            Context.persistenceManager.saveQueue();
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not save queue", ex);
            return false;
        }
    }

    private boolean saveHistory() {
        if (config.isReducedHistory()) {
            Calendar limitCal = Calendar.getInstance();
            limitCal.add(5, -config.getReducedHistoryCount());
            Date limit = limitCal.getTime();
            history.removeRecordsOlderThan(limit);
        }
        try {
            Context.persistenceManager.saveHistory();
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not save history", ex);
            return false;
        }
    }

    private boolean saveKeyring() {
        try {
            Context.persistenceManager.saveKeyring();
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not save keyring", ex);
            return false;
        }
    }

    private boolean saveGatewayProperties() {
        if (!Context.gatewaysLoaded()) {
            logger.log(Level.FINE, "Not saving gateway properties because they were not yet even loaded.");
            return true;
        }
        try {
            Context.persistenceManager.saveGatewayProperties();
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not save gateway properties", ex);
            return false;
        }
    }

    static {
        logger = Logger.getLogger(MainFrame.class.getName());
        l10n = L10N.l10nBundle;
        smsSender = new SMSSender();
        config = Config.getInstance();
        history = History.getInstance();
        log = Log.getInstance();
        queue = Queue.getInstance();
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            logger.fine("Program closing down...");
            MainFrame.this.saveAll();
        }
    }

    private class UpdateListener
    implements ActionListener {
        private UpdateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int event = e.getID();
            switch (event) {
                case 0: {
                    this.announceProgram();
                    break;
                }
                case 1: {
                    this.updateGateways();
                    break;
                }
                case 2: {
                    this.announceProgram();
                    this.updateGateways();
                }
            }
            Timer timer = new Timer(0x6DDD00, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.updateChecker.checkForUpdates();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        private void announceProgram() {
            String message = MessageFormat.format(l10n.getString("MainFrame.new_program_version"), MainFrame.this.updateChecker.getLatestProgramVersion());
            log.addRecord(new Log.Record(MiscUtils.stripHtml(message), null, Icons.STATUS_UPDATE_IMPORTANT));
            MainFrame.this.statusPanel.setStatusMessage(message, null, Icons.STATUS_UPDATE_IMPORTANT, true);
            MainFrame.this.statusPanel.installClickHandler(new Runnable(){

                @Override
                public void run() {
                    Action browseAction = Actions.getBrowseAction("http://code.google.com/p/esmska/wiki/Download?tm=2");
                    browseAction.actionPerformed(null);
                }
            }, l10n.getString("Update.browseDownloads"));
        }

        private void updateGateways() {
            UpdateInstaller.getInstance().installNewGateways();
        }
    }

    private class ContactListener
    implements ActionListener {
        private ContactListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getID()) {
                case 0: {
                    MainFrame.this.smsPanel.setContacts(MainFrame.this.contactPanel.getSelectedContacts());
                    break;
                }
                case 1: {
                    MainFrame.this.smsPanel.requestFocusInWindow();
                }
            }
        }
    }

    private class QueuePanelListener
    implements ValuedListener<QueuePanel.Events, SMS> {
        private QueuePanelListener() {
        }

        @Override
        public void eventOccured(ValuedEvent<QueuePanel.Events, SMS> e) {
            switch (e.getEvent()) {
                case SMS_EDIT_REQUESTED: {
                    SMS sms = e.getValue();
                    if (sms == null) {
                        return;
                    }
                    if (StringUtils.isNotEmpty(MainFrame.this.smsPanel.getText().trim())) {
                        String replaceOption = l10n.getString("Replace");
                        String cancelOption = l10n.getString("Cancel");
                        Object[] options = new String[]{cancelOption, replaceOption};
                        options = RuntimeUtils.sortDialogOptions(options);
                        int result = JOptionPane.showOptionDialog(MainFrame.this, new JLabel(l10n.getString("QueuePanel.replaceSms")), null, -1, 3, null, options, replaceOption);
                        if (result != ArrayUtils.indexOf(options, replaceOption)) {
                            return;
                        }
                    }
                    SMS smsToEdit = queue.extractSMS(sms.getId(), true);
                    MainFrame.this.smsPanel.setSMS(smsToEdit);
                }
            }
        }
    }

    private class QueueListener
    implements ValuedListener<Queue.Events, SMS> {
        private QueueListener() {
        }

        @Override
        public void eventOccured(ValuedEvent<Queue.Events, SMS> e) {
            switch (e.getEvent()) {
                case SENDING_SMS: {
                    this.sendingSMS(e.getValue());
                    break;
                }
                case SMS_SENT: {
                    this.smsSent(e.getValue());
                    break;
                }
                case SMS_SENDING_FAILED: {
                    this.smsFailed(e.getValue());
                }
            }
        }

        private void sendingSMS(SMS sms) {
            String gateway = sms.getGateway();
            MainFrame.this.statusPanel.setTaskRunning(true);
            log.addRecord(new Log.Record(MessageFormat.format(l10n.getString("SMSSender.sending_message"), sms.getRecipient(), gateway == null ? l10n.getString("SMSSender.no_gateway") : gateway), null, Icons.STATUS_INFO));
        }

        private void smsSent(SMS sms) {
            log.addRecord(new Log.Record(MessageFormat.format(l10n.getString("MainFrame.sms_sent"), sms.getRecipient()), null, Icons.STATUS_MESSAGE));
            MainFrame.this.createHistory(sms);
            this.finish(sms);
        }

        private void smsFailed(SMS sms) {
            logger.log(Level.INFO, "Message could not be sent: {0}\nProblem: {1}", new Object[]{sms, sms.getProblem()});
            log.addRecord(new Log.Record(MessageFormat.format(l10n.getString("MainFrame.sms_failed"), sms.getRecipient()), null, Icons.STATUS_WARNING));
            logger.fine("Showing reason why SMS sending failed...");
            GatewayMessageFrame gatewayMessageFrame = GatewayMessageFrame.getInstance();
            gatewayMessageFrame.addErrorMsg(sms);
            this.finish(sms);
        }

        private void finish(SMS sms) {
            if (StringUtils.isNotEmpty(sms.getSupplMsg())) {
                log.addRecord(new Log.Record(sms.getGateway() + ": " + sms.getSupplMsg(), null, Icons.STATUS_MESSAGE));
            }
            if (!smsSender.isRunning()) {
                MainFrame.this.statusPanel.setTaskRunning(false);
            }
        }
    }
}

