/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class WorkMessage
extends DOMMessage {
    private final String unitId;
    private final String workLocationId;

    public WorkMessage(Unit unit, WorkLocation workLocation) {
        super(WorkMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.workLocationId = workLocation.getId();
    }

    public WorkMessage(Game game, Element element) {
        super(WorkMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.workLocationId = element.getAttribute("workLocation");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!unit.hasTile()) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        Colony colony = unit.getTile().getColony();
        if (colony == null) {
            return DOMMessage.clientError("Unit is not at a colony: " + this.unitId);
        }
        WorkLocation workLocation = game.getFreeColGameObject(this.workLocationId, WorkLocation.class);
        if (workLocation == null) {
            return DOMMessage.clientError("Not a work location: " + this.workLocationId);
        }
        if (workLocation.getColony() != colony) {
            return DOMMessage.clientError("Work location is not in the colony where the unit is: " + this.workLocationId);
        }
        if (!workLocation.canAdd(unit)) {
            return DOMMessage.clientError("Can not add " + unit + " to " + workLocation + ": " + (Object)((Object)workLocation.getNoAddReason(unit)));
        }
        return server.getInGameController().work(serverPlayer, unit, workLocation);
    }

    @Override
    public Element toXMLElement() {
        return WorkMessage.createMessage(WorkMessage.getXMLElementTagName(), "unit", this.unitId, "workLocation", this.workLocationId);
    }

    public static String getXMLElementTagName() {
        return "work";
    }
}

