/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScope;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;

public class Require
extends BaseFunction {
    private static final long serialVersionUID = 1L;
    private final ModuleScriptProvider moduleScriptProvider;
    private final Scriptable nativeScope;
    private final Scriptable paths;
    private final boolean sandboxed;
    private final Script preExec;
    private final Script postExec;
    private String mainModuleId = null;
    private Scriptable mainExports;
    private final Map<String, Scriptable> exportedModuleInterfaces = new ConcurrentHashMap<String, Scriptable>();
    private final Object loadLock = new Object();
    private static final ThreadLocal<Map<String, Scriptable>> loadingModuleInterfaces = new ThreadLocal();

    public Require(Context context, Scriptable scriptable, ModuleScriptProvider moduleScriptProvider, Script script, Script script2, boolean bl) {
        this.moduleScriptProvider = moduleScriptProvider;
        this.nativeScope = scriptable;
        this.sandboxed = bl;
        this.preExec = script;
        this.postExec = script2;
        this.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
        if (!bl) {
            this.paths = context.newArray(scriptable, 0);
            Require.defineReadOnlyProperty(this, "paths", this.paths);
        } else {
            this.paths = null;
        }
    }

    public Scriptable requireMain(Context context, String string) {
        ModuleScript moduleScript;
        if (this.mainModuleId != null) {
            if (!this.mainModuleId.equals(string)) {
                throw new IllegalStateException("Main module already set to " + this.mainModuleId);
            }
            return this.mainExports;
        }
        try {
            moduleScript = this.moduleScriptProvider.getModuleScript(context, string, null, null, this.paths);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (moduleScript != null) {
            this.mainExports = this.getExportedModuleInterface(context, string, null, null, true);
        } else if (!this.sandboxed) {
            URI uRI = null;
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (uRI == null || !uRI.isAbsolute()) {
                File file = new File(string);
                if (!file.isFile()) {
                    throw ScriptRuntime.throwError(context, this.nativeScope, "Module \"" + string + "\" not found.");
                }
                uRI = file.toURI();
            }
            this.mainExports = this.getExportedModuleInterface(context, uRI.toString(), uRI, null, true);
        }
        this.mainModuleId = string;
        return this.mainExports;
    }

    public void install(Scriptable scriptable) {
        ScriptableObject.putProperty(scriptable, "require", (Object)this);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray == null || objectArray.length < 1) {
            throw ScriptRuntime.throwError(context, scriptable, "require() needs one argument");
        }
        String string = (String)Context.jsToJava(objectArray[0], String.class);
        URI uRI = null;
        URI uRI2 = null;
        if (string.startsWith("./") || string.startsWith("../")) {
            if (!(scriptable2 instanceof ModuleScope)) {
                throw ScriptRuntime.throwError(context, scriptable, "Can't resolve relative module ID \"" + string + "\" when require() is used outside of a module");
            }
            ModuleScope moduleScope = (ModuleScope)scriptable2;
            uRI2 = moduleScope.getBase();
            URI uRI3 = moduleScope.getUri();
            uRI = uRI3.resolve(string);
            if (uRI2 == null) {
                string = uRI.toString();
            } else {
                string = uRI2.relativize(uRI3).resolve(string).toString();
                if (string.charAt(0) == '.') {
                    if (this.sandboxed) {
                        throw ScriptRuntime.throwError(context, scriptable, "Module \"" + string + "\" is not contained in sandbox.");
                    }
                    string = uRI.toString();
                }
            }
        }
        return this.getExportedModuleInterface(context, string, uRI, uRI2, false);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw ScriptRuntime.throwError(context, scriptable, "require() can not be invoked as a constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable getExportedModuleInterface(Context context, String string, URI uRI, URI uRI2, boolean bl) {
        Scriptable scriptable = this.exportedModuleInterfaces.get(string);
        if (scriptable != null) {
            if (bl) {
                throw new IllegalStateException("Attempt to set main module after it was loaded");
            }
            return scriptable;
        }
        Map<String, Scriptable> map = loadingModuleInterfaces.get();
        if (map != null && (scriptable = map.get(string)) != null) {
            return scriptable;
        }
        Object object = this.loadLock;
        synchronized (object) {
            boolean bl2;
            scriptable = this.exportedModuleInterfaces.get(string);
            if (scriptable != null) {
                return scriptable;
            }
            ModuleScript moduleScript = this.getModule(context, string, uRI, uRI2);
            if (this.sandboxed && !moduleScript.isSandboxed()) {
                throw ScriptRuntime.throwError(context, this.nativeScope, "Module \"" + string + "\" is not contained in sandbox.");
            }
            scriptable = context.newObject(this.nativeScope);
            boolean bl3 = bl2 = map == null;
            if (bl2) {
                map = new HashMap<String, Scriptable>();
                loadingModuleInterfaces.set(map);
            }
            map.put(string, scriptable);
            try {
                Scriptable scriptable2 = this.executeModuleScript(context, string, scriptable, moduleScript, bl);
                if (scriptable != scriptable2) {
                    map.put(string, scriptable2);
                    scriptable = scriptable2;
                }
            }
            catch (RuntimeException runtimeException) {
                map.remove(string);
                throw runtimeException;
            }
            finally {
                if (bl2) {
                    this.exportedModuleInterfaces.putAll(map);
                    loadingModuleInterfaces.set(null);
                }
            }
        }
        return scriptable;
    }

    private Scriptable executeModuleScript(Context context, String string, Scriptable scriptable, ModuleScript moduleScript, boolean bl) {
        ScriptableObject scriptableObject = (ScriptableObject)context.newObject(this.nativeScope);
        URI uRI = moduleScript.getUri();
        URI uRI2 = moduleScript.getBase();
        Require.defineReadOnlyProperty(scriptableObject, "id", string);
        if (!this.sandboxed) {
            Require.defineReadOnlyProperty(scriptableObject, "uri", uRI.toString());
        }
        ModuleScope moduleScope = new ModuleScope(this.nativeScope, uRI, uRI2);
        moduleScope.put("exports", (Scriptable)moduleScope, (Object)scriptable);
        moduleScope.put("module", (Scriptable)moduleScope, (Object)scriptableObject);
        scriptableObject.put("exports", (Scriptable)scriptableObject, (Object)scriptable);
        this.install(moduleScope);
        if (bl) {
            Require.defineReadOnlyProperty(this, "main", scriptableObject);
        }
        Require.executeOptionalScript(this.preExec, context, moduleScope);
        moduleScript.getScript().exec(context, moduleScope);
        Require.executeOptionalScript(this.postExec, context, moduleScope);
        return ScriptRuntime.toObject(context, this.nativeScope, ScriptableObject.getProperty((Scriptable)scriptableObject, "exports"));
    }

    private static void executeOptionalScript(Script script, Context context, Scriptable scriptable) {
        if (script != null) {
            script.exec(context, scriptable);
        }
    }

    private static void defineReadOnlyProperty(ScriptableObject scriptableObject, String string, Object object) {
        ScriptableObject.putProperty((Scriptable)scriptableObject, string, object);
        scriptableObject.setAttributes(string, 5);
    }

    private ModuleScript getModule(Context context, String string, URI uRI, URI uRI2) {
        try {
            ModuleScript moduleScript = this.moduleScriptProvider.getModuleScript(context, string, uRI, uRI2, this.paths);
            if (moduleScript == null) {
                throw ScriptRuntime.throwError(context, this.nativeScope, "Module \"" + string + "\" not found.");
            }
            return moduleScript;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    @Override
    public String getFunctionName() {
        return "require";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getLength() {
        return 1;
    }
}

