/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.artifacts.transform;

import com.google.common.hash.HashCode;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.util.BiFunction;

import java.io.File;
import java.util.List;

@ThreadSafe
public interface TransformedFileCache {
    /**
     * Returns the result of applying the given transform to the given file.
     *
     * @param inputFile The file to transform
     * @param inputsHash The hash of the input file, transform implementation and configuration
     * @param transformer The transformer to apply to produce the output, if not already available
     */
    List<File> getResult(File inputFile, HashCode inputsHash, BiFunction<List<File>, File, File> transformer);
}
