/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.path;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PathTrie<T> {
    private final Decoder decoder;
    private final TrieNode root;
    private T rootValue;
    private static final String SEPARATOR = "/";
    private static final String WILDCARD = "*";

    public PathTrie(Decoder decoder) {
        this.decoder = decoder;
        this.root = new TrieNode(SEPARATOR, null, WILDCARD);
    }

    public void insert(String path, T value) {
        String[] strings = path.split(SEPARATOR);
        if (strings.length == 0) {
            if (this.rootValue != null) {
                throw new IllegalArgumentException("Path [/] already has a value [" + this.rootValue + "]");
            }
            this.rootValue = value;
            return;
        }
        int index = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index = 1;
        }
        this.root.insert(strings, index, value);
    }

    public T retrieve(String path) {
        return this.retrieve(path, null);
    }

    public T retrieve(String path, Map<String, String> params) {
        if (path.length() == 0) {
            return this.rootValue;
        }
        String[] strings = path.split(SEPARATOR);
        if (strings.length == 0) {
            return this.rootValue;
        }
        int index = 0;
        if (strings.length > 0 && strings[0].isEmpty()) {
            index = 1;
        }
        return this.root.retrieve(strings, index, params);
    }

    public class TrieNode {
        private transient String key;
        private transient T value;
        private boolean isWildcard;
        private final String wildcard;
        private transient String namedWildcard;
        private Map<String, TrieNode> children;

        public TrieNode(String key, T value, String wildcard) {
            this.key = key;
            this.wildcard = wildcard;
            this.isWildcard = key.equals(wildcard);
            this.value = value;
            this.children = Collections.emptyMap();
            this.namedWildcard = this.isNamedWildcard(key) ? key.substring(key.indexOf(123) + 1, key.indexOf(125)) : null;
        }

        public void updateKeyWithNamedWildcard(String key) {
            this.key = key;
            this.namedWildcard = key.substring(key.indexOf(123) + 1, key.indexOf(125));
        }

        public boolean isWildcard() {
            return this.isWildcard;
        }

        public synchronized void addChild(TrieNode child) {
            this.addInnerChild(child.key, child);
        }

        private void addInnerChild(String key, TrieNode child) {
            HashMap<String, TrieNode> newChildren = new HashMap<String, TrieNode>(this.children);
            newChildren.put(key, child);
            this.children = Collections.unmodifiableMap(newChildren);
        }

        public TrieNode getChild(String key) {
            return this.children.get(key);
        }

        public synchronized void insert(String[] path, int index, T value) {
            TrieNode node;
            String token;
            if (index >= path.length) {
                return;
            }
            String key = token = path[index];
            if (this.isNamedWildcard(token)) {
                key = this.wildcard;
            }
            if ((node = this.children.get(key)) == null) {
                Object nodeValue = index == path.length - 1 ? value : null;
                node = new TrieNode(token, nodeValue, this.wildcard);
                this.addInnerChild(key, node);
            } else {
                if (this.isNamedWildcard(token)) {
                    node.updateKeyWithNamedWildcard(token);
                }
                if (index == path.length - 1) {
                    if (node.value != null) {
                        throw new IllegalArgumentException("Path [" + String.join((CharSequence)PathTrie.SEPARATOR, path) + "] already has a value [" + node.value + "]");
                    }
                    if (node.value == null) {
                        node.value = value;
                    }
                }
            }
            node.insert(path, index + 1, value);
        }

        private boolean isNamedWildcard(String key) {
            return key.indexOf(123) != -1 && key.indexOf(125) != -1;
        }

        private String namedWildcard() {
            return this.namedWildcard;
        }

        private boolean isNamedWildcard() {
            return this.namedWildcard != null;
        }

        public T retrieve(String[] path, int index, Map<String, String> params) {
            boolean usedWildcard;
            if (index >= path.length) {
                return null;
            }
            String token = path[index];
            TrieNode node = this.children.get(token);
            if (node == null) {
                node = this.children.get(this.wildcard);
                if (node == null) {
                    return null;
                }
                usedWildcard = true;
            } else if (index + 1 == path.length && node.value == null && this.children.get(this.wildcard) != null) {
                node = this.children.get(this.wildcard);
                usedWildcard = true;
            } else {
                usedWildcard = token.equals(this.wildcard);
            }
            this.put(params, node, token);
            if (index == path.length - 1) {
                return node.value;
            }
            Object res = node.retrieve(path, index + 1, params);
            if (res == null && !usedWildcard && (node = this.children.get(this.wildcard)) != null) {
                this.put(params, node, token);
                res = node.retrieve(path, index + 1, params);
            }
            return res;
        }

        private void put(Map<String, String> params, TrieNode node, String value) {
            if (params != null && node.isNamedWildcard()) {
                params.put(node.namedWildcard(), PathTrie.this.decoder.decode(value));
            }
        }

        public String toString() {
            return this.key;
        }
    }

    public static interface Decoder {
        public String decode(String var1);
    }
}

