/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis;

import java.util.Iterator;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class JavaGenericsUtil {
    public static boolean isRawToGeneric(PsiType lType, PsiType rType) {
        if (lType instanceof PsiPrimitiveType || rType instanceof PsiPrimitiveType) {
            return false;
        }
        if (lType.equals(rType)) {
            return false;
        }
        if (lType instanceof PsiArrayType && rType instanceof PsiArrayType) {
            return JavaGenericsUtil.isRawToGeneric(((PsiArrayType)lType).getComponentType(), ((PsiArrayType)rType).getComponentType());
        }
        if (lType instanceof PsiArrayType || rType instanceof PsiArrayType) {
            return false;
        }
        if (rType instanceof PsiIntersectionType) {
            for (PsiType type2 : ((PsiIntersectionType)rType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(lType, type2)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiIntersectionType) {
            for (PsiType type3 : ((PsiIntersectionType)lType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(type3, rType)) continue;
                return true;
            }
            return false;
        }
        if (!(lType instanceof PsiClassType) || !(rType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult lResolveResult = ((PsiClassType)lType).resolveGenerics();
        PsiClassType.ClassResolveResult rResolveResult = ((PsiClassType)rType).resolveGenerics();
        PsiClass lClass = lResolveResult.getElement();
        PsiClass rClass = rResolveResult.getElement();
        if (rClass instanceof PsiAnonymousClass) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiAnonymousClass)rClass).getBaseClassType());
        }
        PsiSubstitutor lSubstitutor = lResolveResult.getSubstitutor();
        PsiSubstitutor rSubstitutor = rResolveResult.getSubstitutor();
        if (lClass == null || rClass == null) {
            return false;
        }
        if (lClass instanceof PsiTypeParameter && !InheritanceUtil.isInheritorOrSelf(rClass, lClass, true)) {
            return true;
        }
        if (!lClass.getManager().areElementsEquivalent(lClass, rClass)) {
            if (lClass.isInheritor(rClass, true)) {
                lSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(rClass, lClass, lSubstitutor);
                lClass = rClass;
            } else if (rClass.isInheritor(lClass, true)) {
                rSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(lClass, rClass, rSubstitutor);
                rClass = lClass;
            } else {
                return false;
            }
        }
        Iterator<PsiTypeParameter> lIterator = PsiUtil.typeParametersIterator(lClass);
        Iterator<PsiTypeParameter> rIterator = PsiUtil.typeParametersIterator(rClass);
        while (lIterator.hasNext()) {
            if (!rIterator.hasNext()) {
                return false;
            }
            PsiTypeParameter lParameter = lIterator.next();
            PsiTypeParameter rParameter = rIterator.next();
            PsiType lTypeArg = lSubstitutor.substitute(lParameter);
            PsiType rTypeArg = rSubstitutor.substituteWithBoundsPromotion(rParameter);
            if (lTypeArg == null) continue;
            if (rTypeArg == null) {
                if (lTypeArg instanceof PsiWildcardType && ((PsiWildcardType)lTypeArg).getBound() == null) continue;
                return true;
            }
            if (TypeConversionUtil.typesAgree(lTypeArg, rTypeArg, true)) continue;
            return true;
        }
        return false;
    }
}

