/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.picocontainer.defaults;

import org.jetbrains.kotlin.org.picocontainer.ComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.Parameter;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.org.picocontainer.defaults.BasicComponentParameter;
import org.jetbrains.kotlin.org.picocontainer.defaults.CollectionComponentParameter;

public class ComponentParameter
extends BasicComponentParameter {
    public static final ComponentParameter DEFAULT = new ComponentParameter();
    public static final ComponentParameter ARRAY = new ComponentParameter(false);
    public static final ComponentParameter ARRAY_ALLOW_EMPTY = new ComponentParameter(true);
    private final Parameter collectionParameter;

    public ComponentParameter() {
        this(false);
    }

    public ComponentParameter(boolean emptyCollection) {
        this(null, emptyCollection ? CollectionComponentParameter.ARRAY_ALLOW_EMPTY : CollectionComponentParameter.ARRAY);
    }

    private ComponentParameter(Object componentKey, Parameter collectionParameter) {
        super(componentKey);
        this.collectionParameter = collectionParameter;
    }

    @Override
    public Object resolveInstance(PicoContainer container2, ComponentAdapter adapter, Class expectedType) {
        Object result2 = super.resolveInstance(container2, adapter, expectedType);
        if (result2 == null && this.collectionParameter != null) {
            result2 = this.collectionParameter.resolveInstance(container2, adapter, expectedType);
        }
        return result2;
    }

    @Override
    public boolean isResolvable(PicoContainer container2, ComponentAdapter adapter, Class expectedType) {
        if (!super.isResolvable(container2, adapter, expectedType)) {
            if (this.collectionParameter != null) {
                return this.collectionParameter.isResolvable(container2, adapter, expectedType);
            }
            return false;
        }
        return true;
    }
}

