/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.Actions;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.GccCompatibleToolChain;
import org.gradle.nativeplatform.toolchain.GccPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.ExtendableToolChain;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.UnavailablePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.gcc.DefaultGccPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.gcc.GccPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.gcc.TargetPlatformConfiguration;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.GccVersionResult;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolSearchResult;
import org.gradle.nativeplatform.toolchain.internal.tools.DefaultGccCommandLineToolConfiguration;
import org.gradle.nativeplatform.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolSearchPath;
import org.gradle.platform.base.internal.toolchain.ToolChainAvailability;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.process.internal.ExecActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGccCompatibleToolChain
extends ExtendableToolChain<GccPlatformToolChain>
implements GccCompatibleToolChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGccCompatibleToolChain.class);
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final ExecActionFactory execActionFactory;
    private final ToolSearchPath toolSearchPath;
    private final List<TargetPlatformConfiguration> platformConfigs = new ArrayList<TargetPlatformConfiguration>();
    private final Map<NativePlatform, PlatformToolProvider> toolProviders = Maps.newHashMap();
    private final CompilerMetaDataProvider metaDataProvider;
    private final Instantiator instantiator;
    private int configInsertLocation;

    public AbstractGccCompatibleToolChain(String name, BuildOperationProcessor buildOperationProcessor, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, CompilerMetaDataProvider metaDataProvider, Instantiator instantiator) {
        this(name, buildOperationProcessor, operatingSystem, fileResolver, execActionFactory, compilerOutputFileNamingSchemeFactory, new ToolSearchPath(operatingSystem), metaDataProvider, instantiator);
    }

    AbstractGccCompatibleToolChain(String name, BuildOperationProcessor buildOperationProcessor, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, ToolSearchPath tools, CompilerMetaDataProvider metaDataProvider, Instantiator instantiator) {
        super(name, buildOperationProcessor, operatingSystem, (PathToFileResolver)fileResolver);
        this.execActionFactory = execActionFactory;
        this.toolSearchPath = tools;
        this.metaDataProvider = metaDataProvider;
        this.instantiator = instantiator;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.target(new Intel32Architecture());
        this.target(new Intel64Architecture());
        this.configInsertLocation = 0;
    }

    protected CommandLineToolSearchResult locate(GccCommandLineToolConfigurationInternal gccTool) {
        return this.toolSearchPath.locate(gccTool.getToolType(), gccTool.getExecutable());
    }

    @Override
    public List<File> getPath() {
        return this.toolSearchPath.getPath();
    }

    @Override
    public void path(Object ... pathEntries) {
        for (Object path : pathEntries) {
            this.toolSearchPath.path(this.resolve(path));
        }
    }

    protected CompilerMetaDataProvider getMetaDataProvider() {
        return this.metaDataProvider;
    }

    @Override
    public void target(String platformName) {
        this.target(platformName, (Action<? super GccPlatformToolChain>)Actions.doNothing());
    }

    @Override
    public void target(String platformName, Action<? super GccPlatformToolChain> action) {
        this.target(new DefaultTargetPlatformConfiguration(Arrays.asList(platformName), action));
    }

    public void target(List<String> platformNames, Action<? super GccPlatformToolChain> action) {
        this.target(new DefaultTargetPlatformConfiguration(platformNames, action));
    }

    private void target(TargetPlatformConfiguration targetPlatformConfiguration) {
        this.platformConfigs.add(this.configInsertLocation, targetPlatformConfiguration);
        ++this.configInsertLocation;
    }

    @Override
    public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
        PlatformToolProvider toolProvider = this.toolProviders.get(targetPlatform);
        if (toolProvider == null) {
            toolProvider = this.createPlatformToolProvider(targetPlatform);
            this.toolProviders.put(targetPlatform, toolProvider);
        }
        return toolProvider;
    }

    private PlatformToolProvider createPlatformToolProvider(NativePlatformInternal targetPlatform) {
        TargetPlatformConfiguration targetPlatformConfigurationConfiguration = this.getPlatformConfiguration(targetPlatform);
        ToolChainAvailability result = new ToolChainAvailability();
        if (targetPlatformConfigurationConfiguration == null) {
            result.unavailable(String.format("Don't know how to build for platform '%s'.", targetPlatform.getName()));
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), (ToolSearchResult)result);
        }
        DefaultGccPlatformToolChain configurableToolChain = (DefaultGccPlatformToolChain)this.instantiator.newInstance(DefaultGccPlatformToolChain.class, new Object[]{targetPlatform});
        this.addDefaultTools(configurableToolChain);
        this.configureDefaultTools(configurableToolChain);
        targetPlatformConfigurationConfiguration.apply(configurableToolChain);
        this.configureActions.execute((Object)configurableToolChain);
        this.initTools(configurableToolChain, result);
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), (ToolSearchResult)result);
        }
        return new GccPlatformToolProvider(this.buildOperationProcessor, targetPlatform.getOperatingSystem(), this.toolSearchPath, configurableToolChain, this.execActionFactory, this.compilerOutputFileNamingSchemeFactory, configurableToolChain.isCanUseCommandFile());
    }

    protected void initTools(DefaultGccPlatformToolChain platformToolChain, ToolChainAvailability availability) {
        boolean found = false;
        for (GccCommandLineToolConfigurationInternal tool : platformToolChain.getCompilers()) {
            CommandLineToolSearchResult compiler = this.locate(tool);
            if (!compiler.isAvailable()) continue;
            GccVersionResult versionResult = this.getMetaDataProvider().getGccMetaData(compiler.getTool(), platformToolChain.getCompilerProbeArgs());
            availability.mustBeAvailable((ToolSearchResult)versionResult);
            if (!versionResult.isAvailable()) {
                return;
            }
            LOGGER.debug("Found {} with version {}", (Object)ToolType.C_COMPILER.getToolName(), (Object)versionResult);
            found = true;
            this.initForImplementation(platformToolChain, versionResult);
            break;
        }
        for (GccCommandLineToolConfigurationInternal tool : platformToolChain.getTools()) {
            found |= this.toolSearchPath.locate(tool.getToolType(), tool.getExecutable()).isAvailable();
        }
        if (!found) {
            GccCommandLineToolConfigurationInternal cCompiler = platformToolChain.getcCompiler();
            availability.mustBeAvailable((ToolSearchResult)this.locate(cCompiler));
        }
    }

    protected void initForImplementation(DefaultGccPlatformToolChain platformToolChain, GccVersionResult versionResult) {
    }

    private void addDefaultTools(DefaultGccPlatformToolChain toolChain) {
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.C_COMPILER, "gcc"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.CPP_COMPILER, "g++"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.LINKER, "g++"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.STATIC_LIB_ARCHIVER, "ar"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.OBJECTIVECPP_COMPILER, "g++"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.OBJECTIVEC_COMPILER, "gcc"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.ASSEMBLER, "gcc"}));
    }

    protected void configureDefaultTools(DefaultGccPlatformToolChain toolChain) {
    }

    protected TargetPlatformConfiguration getPlatformConfiguration(NativePlatformInternal targetPlatform) {
        for (TargetPlatformConfiguration platformConfig : this.platformConfigs) {
            if (!platformConfig.supportsPlatform(targetPlatform)) continue;
            return platformConfig;
        }
        return null;
    }

    private static class DefaultTargetPlatformConfiguration
    implements TargetPlatformConfiguration {
        private final Collection<String> platformNames;
        private Action<? super GccPlatformToolChain> configurationAction;

        public DefaultTargetPlatformConfiguration(Collection<String> targetPlatformNames, Action<? super GccPlatformToolChain> configurationAction) {
            this.platformNames = targetPlatformNames;
            this.configurationAction = configurationAction;
        }

        @Override
        public boolean supportsPlatform(NativePlatformInternal targetPlatform) {
            return this.platformNames.contains(targetPlatform.getName());
        }

        @Override
        public void apply(DefaultGccPlatformToolChain platformToolChain) {
            this.configurationAction.execute((Object)platformToolChain);
        }
    }

    private class Intel64Architecture
    implements TargetPlatformConfiguration {
        private Intel64Architecture() {
        }

        @Override
        public boolean supportsPlatform(NativePlatformInternal targetPlatform) {
            return targetPlatform.getOperatingSystem().isCurrent() && targetPlatform.getArchitecture().isAmd64();
        }

        @Override
        public void apply(DefaultGccPlatformToolChain gccToolChain) {
            gccToolChain.compilerProbeArgs("-m64");
            Action<List<String>> m64args = new Action<List<String>>(){

                public void execute(List<String> args) {
                    args.add("-m64");
                }
            };
            gccToolChain.getCppCompiler().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getcCompiler().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getObjcCompiler().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getObjcppCompiler().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getLinker().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getAssembler().withArguments((Action<? super List<String>>)m64args);
        }
    }

    private class Intel32Architecture
    implements TargetPlatformConfiguration {
        private Intel32Architecture() {
        }

        @Override
        public boolean supportsPlatform(NativePlatformInternal targetPlatform) {
            return targetPlatform.getOperatingSystem().isCurrent() && targetPlatform.getArchitecture().isI386();
        }

        @Override
        public void apply(DefaultGccPlatformToolChain gccToolChain) {
            gccToolChain.compilerProbeArgs("-m32");
            Action<List<String>> m32args = new Action<List<String>>(){

                public void execute(List<String> args) {
                    args.add("-m32");
                }
            };
            gccToolChain.getCppCompiler().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getcCompiler().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getObjcCompiler().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getObjcppCompiler().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getLinker().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getAssembler().withArguments((Action<? super List<String>>)m32args);
        }
    }
}

