/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableSet;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetValueSnapshot
implements ValueSnapshot {
    private final ImmutableSet<ValueSnapshot> elements;

    public SetValueSnapshot(ImmutableSet<ValueSnapshot> elements) {
        this.elements = elements;
    }

    public ImmutableSet<ValueSnapshot> getElements() {
        return this.elements;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString("Set");
        hasher.putInt(this.elements.size());
        for (ValueSnapshot element : this.elements) {
            element.appendToHasher(hasher);
        }
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot newSnapshot = snapshotter.snapshot(value);
        if (newSnapshot instanceof SetValueSnapshot) {
            SetValueSnapshot other = (SetValueSnapshot)newSnapshot;
            if (this.elements.equals(other.elements)) {
                return this;
            }
        }
        return newSnapshot;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SetValueSnapshot other = (SetValueSnapshot)obj;
        return this.elements.equals(other.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

