/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.List;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.ReportedException;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.service.scopes.BuildScopeServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleLauncher
implements GradleLauncher {
    private final InitScriptHandler initScriptHandler;
    private final SettingsLoader settingsLoader;
    private final BuildConfigurer buildConfigurer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final LoggingManagerInternal loggingManager;
    private final BuildListener buildListener;
    private final ModelConfigurationListener modelConfigurationListener;
    private final BuildCompletionListener buildCompletionListener;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildConfigurationActionExecuter buildConfigurationActionExecuter;
    private final BuildExecuter buildExecuter;
    private final BuildScopeServices buildServices;
    private final List<?> servicesToStop;
    private GradleInternal gradle;
    private SettingsInternal settings;
    private Stage stage;

    public DefaultGradleLauncher(GradleInternal gradle, InitScriptHandler initScriptHandler, SettingsLoader settingsLoader, BuildConfigurer buildConfigurer, ExceptionAnalyser exceptionAnalyser, LoggingManagerInternal loggingManager, BuildListener buildListener, ModelConfigurationListener modelConfigurationListener, BuildCompletionListener buildCompletionListener, BuildOperationExecutor operationExecutor, BuildConfigurationActionExecuter buildConfigurationActionExecuter, BuildExecuter buildExecuter, BuildScopeServices buildServices, List<?> servicesToStop) {
        this.gradle = gradle;
        this.initScriptHandler = initScriptHandler;
        this.settingsLoader = settingsLoader;
        this.buildConfigurer = buildConfigurer;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.loggingManager = loggingManager;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildOperationExecutor = operationExecutor;
        this.buildConfigurationActionExecuter = buildConfigurationActionExecuter;
        this.buildExecuter = buildExecuter;
        this.buildCompletionListener = buildCompletionListener;
        this.buildServices = buildServices;
        this.servicesToStop = servicesToStop;
        loggingManager.start();
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public SettingsInternal getSettings() {
        return this.settings;
    }

    @Override
    public BuildResult run() {
        return this.doBuild(Stage.Build);
    }

    @Override
    public BuildResult getBuildAnalysis() {
        return this.doBuild(Stage.Configure);
    }

    @Override
    public BuildResult load() throws ReportedException {
        return this.doBuild(Stage.Load);
    }

    private BuildResult doBuild(Stage upTo) {
        Throwable failure = null;
        try {
            this.buildListener.buildStarted(this.gradle);
            this.doBuildStages(upTo);
        }
        catch (Throwable t) {
            failure = this.exceptionAnalyser.transform(t);
        }
        BuildResult buildResult = new BuildResult(upTo.name(), this.gradle, failure);
        this.buildListener.buildFinished(buildResult);
        if (failure != null) {
            throw new ReportedException(failure);
        }
        return buildResult;
    }

    private void doBuildStages(Stage upTo) {
        if (this.stage == Stage.Build) {
            throw new IllegalStateException("Cannot build with GradleLauncher multiple times");
        }
        if (this.stage == null) {
            this.initScriptHandler.executeScripts(this.gradle);
            this.settings = this.settingsLoader.findAndLoadSettings(this.gradle);
            this.stage = Stage.Load;
        }
        if (upTo == Stage.Load) {
            return;
        }
        if (this.stage == Stage.Load) {
            this.buildOperationExecutor.run("Configure build", (Action<? super BuildOperationContext>)new ConfigureBuildAction());
            this.stage = Stage.Configure;
        }
        if (upTo == Stage.Configure) {
            return;
        }
        this.stage = Stage.Build;
        this.buildOperationExecutor.run("Calculate task graph", (Action<? super BuildOperationContext>)new CalculateTaskGraphAction());
        this.buildOperationExecutor.run("Run tasks", (Action<? super BuildOperationContext>)new RunTasksAction());
    }

    @Override
    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    @Override
    public void addStandardOutputListener(StandardOutputListener listener) {
        this.loggingManager.addStandardOutputListener(listener);
    }

    @Override
    public void addStandardErrorListener(StandardOutputListener listener) {
        this.loggingManager.addStandardErrorListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.loggingManager.stop();
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildServices}).add(this.servicesToStop).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    private boolean isConfigureOnDemand() {
        return this.gradle.getStartParameter().isConfigureOnDemand();
    }

    private void projectsEvaluated() {
        this.buildListener.projectsEvaluated(this.gradle);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunTasksAction
    implements Action<BuildOperationContext> {
        private RunTasksAction() {
        }

        public void execute(BuildOperationContext buildOperationContext) {
            DefaultGradleLauncher.this.buildExecuter.execute(DefaultGradleLauncher.this.gradle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CalculateTaskGraphAction
    implements Action<BuildOperationContext> {
        private CalculateTaskGraphAction() {
        }

        public void execute(BuildOperationContext buildOperationContext) {
            DefaultGradleLauncher.this.buildConfigurationActionExecuter.select(DefaultGradleLauncher.this.gradle);
            if (DefaultGradleLauncher.this.isConfigureOnDemand()) {
                DefaultGradleLauncher.this.projectsEvaluated();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigureBuildAction
    implements Action<BuildOperationContext> {
        private ConfigureBuildAction() {
        }

        public void execute(BuildOperationContext buildOperationContext) {
            DefaultGradleLauncher.this.buildConfigurer.configure(DefaultGradleLauncher.this.gradle);
            if (!DefaultGradleLauncher.this.isConfigureOnDemand()) {
                DefaultGradleLauncher.this.projectsEvaluated();
            }
            DefaultGradleLauncher.this.modelConfigurationListener.onConfigure(DefaultGradleLauncher.this.gradle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        Load,
        Configure,
        Build;

    }
}

