/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509CRL;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Utils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509StoreContext
extends RubyObject {
    private static final long serialVersionUID = -4165247923898746888L;
    private static ObjectAllocator X509STORECTX_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509StoreContext(runtime, klass);
        }
    };
    private StoreContext storeContext;

    public static void createX509StoreContext(Ruby runtime, RubyModule X5092) {
        RubyClass StoreContext2 = X5092.defineClassUnder("StoreContext", runtime.getObject(), X509STORECTX_ALLOCATOR);
        StoreContext2.defineAnnotatedMethods(X509StoreContext.class);
        StoreContext2.undefineMethod("dup");
    }

    private static RubyClass _StoreContext(Ruby runtime) {
        return X509._X509(runtime).getClass("StoreContext");
    }

    public X509StoreContext(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private X509StoreContext(Ruby runtime, RubyClass type, StoreContext storeContext) {
        super(runtime, type);
        this.storeContext = storeContext;
    }

    static X509StoreContext newStoreContext(Ruby runtime, StoreContext storeContext) {
        return new X509StoreContext(runtime, X509StoreContext._StoreContext(runtime), storeContext);
    }

    static X509StoreContext newStoreContext(ThreadContext context2, X509Store store, IRubyObject cert2, IRubyObject chain2) {
        Ruby runtime = context2.runtime;
        X509StoreContext instance = new X509StoreContext(runtime, X509StoreContext._StoreContext(runtime));
        instance.initialize(context2, new IRubyObject[]{store, cert2, chain2});
        return instance;
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        ArrayList<X509AuxCertificate> _chain;
        X509AuxCertificate _cert;
        IRubyObject chain2;
        IRubyObject cert2 = chain2 = context2.nil;
        X509Store store = (X509Store)args[0];
        if (Arity.checkArgumentCount((Ruby)context2.runtime, (IRubyObject[])args, (int)1, (int)3) > 1) {
            cert2 = args[1];
            if (args.length > 2) {
                chain2 = args[2];
            }
        }
        if (cert2.isNil()) {
            _cert = null;
        } else {
            if (!(cert2 instanceof X509Cert)) {
                throw context2.runtime.newTypeError(cert2, "OpenSSL::X509::Certificate");
            }
            _cert = ((X509Cert)cert2).getAuxCert();
        }
        if (!chain2.isNil()) {
            RubyArray certs = (RubyArray)chain2;
            _chain = new ArrayList(certs.size());
            for (int i2 = 0; i2 < certs.size(); ++i2) {
                X509Cert c = (X509Cert)certs.eltOk((long)i2);
                _chain.add(c.getAuxCert());
            }
        } else {
            _chain = new ArrayList<X509AuxCertificate>(4);
        }
        this.storeContext = new StoreContext(store.getStore());
        if (this.storeContext.init(_cert, _chain) != 1) {
            throw X509StoreContext.newStoreError(context2.runtime, null);
        }
        IRubyObject time2 = store.getInstanceVariables().getInstanceVariable("@time");
        if (!time2.isNil()) {
            this.set_time(time2);
        }
        this.setInstanceVariable("@verify_callback", store.verify_callback());
        this.setInstanceVariable("@cert", cert2);
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        this.storeContext.setExtraData(1, this.getInstanceVariable("@verify_callback"));
        try {
            int result = this.storeContext.verifyCertificate();
            return result != 0 ? runtime.getTrue() : runtime.getFalse();
        }
        catch (Exception e) {
            OpenSSL.debugStackTrace(runtime, e);
            throw X509StoreContext.newStoreError(runtime, e.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject chain(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        List<X509AuxCertificate> chain2 = this.storeContext.getChain();
        if (chain2 == null) {
            return runtime.getNil();
        }
        RubyArray result = runtime.newArray(chain2.size());
        RubyClass _Certificate = X509Cert._Certificate(runtime);
        try {
            for (X509AuxCertificate x509 : chain2) {
                RubyString encoded = StringHelper.newString(runtime, x509.getEncoded());
                result.append(_Certificate.callMethod(context2, "new", (IRubyObject)encoded));
            }
        }
        catch (CertificateEncodingException e) {
            throw X509StoreContext.newStoreError(runtime, e.getMessage());
        }
        return result;
    }

    @JRubyMethod
    public IRubyObject error(ThreadContext context2) {
        return context2.runtime.newFixnum(this.storeContext.getError());
    }

    @JRubyMethod(name={"error="})
    public IRubyObject set_error(IRubyObject error2) {
        this.storeContext.setError(RubyNumeric.fix2int((IRubyObject)error2));
        return error2;
    }

    @JRubyMethod
    public IRubyObject error_string(ThreadContext context2) {
        int error2 = this.storeContext.getError();
        return context2.runtime.newString(X509Utils.verifyCertificateErrorString(error2));
    }

    @JRubyMethod
    public IRubyObject error_depth(ThreadContext context2) {
        int depth = this.storeContext.getErrorDepth();
        return context2.runtime.newFixnum(depth);
    }

    @JRubyMethod
    public IRubyObject current_cert(ThreadContext context2) {
        X509AuxCertificate x509 = this.storeContext.getCurrentCertificate();
        try {
            return X509Cert.wrap(context2, x509.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw X509StoreContext.newStoreError(context2.runtime, e.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject current_crl(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        RubyClass _CRL = X509CRL._CRL(runtime);
        try {
            java.security.cert.X509CRL crl2 = this.storeContext.getCurrentCRL();
            return _CRL.callMethod(context2, "new", (IRubyObject)StringHelper.newString(runtime, crl2.getEncoded()));
        }
        catch (CRLException e) {
            throw X509StoreContext.newStoreError(runtime, e.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject cleanup(ThreadContext context2) {
        try {
            this.storeContext.cleanup();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            OpenSSL.debugStackTrace(context2.runtime, e);
            throw X509StoreContext.newStoreError(context2.runtime, e.getMessage());
        }
        return context2.runtime.getNil();
    }

    @JRubyMethod(name={"flags="})
    public IRubyObject set_flags(ThreadContext context2, IRubyObject arg) {
        OpenSSL.warn(context2, "WARNING: unimplemented method called: StoreContext#flags=");
        return context2.runtime.getNil();
    }

    @JRubyMethod(name={"purpose="})
    public IRubyObject set_purpose(ThreadContext context2, IRubyObject arg) {
        OpenSSL.warn(context2, "WARNING: unimplemented method called: StoreContext#purpose=");
        return context2.runtime.getNil();
    }

    @JRubyMethod(name={"trust="})
    public IRubyObject set_trust(ThreadContext context2, IRubyObject arg) {
        OpenSSL.warn(context2, "WARNING: unimplemented method called: StoreContext#trust=");
        return context2.runtime.getNil();
    }

    @JRubyMethod(name={"time="})
    public IRubyObject set_time(IRubyObject arg) {
        this.storeContext.setTime(0L, ((RubyTime)arg).getJavaDate());
        return arg;
    }

    private static RaiseException newStoreError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("StoreError"), message);
    }
}

