# ![EmojiOne Logo](https://www.emojione.com/images/vectors/emojione-typeface.svg)

> [![npm version](https://img.shields.io/npm/v/emojione.svg)](https://www.npmjs.com/package/emojione) [![npm downloads](https://img.shields.io/npm/dt/emojione.svg)](https://www.npmjs.com/package/emojione)

The web's first and only complete open source emoji set. It is 100% free for digital use and super easy to integrate.


## What's Included?

 - This project includes libraries used to convert emoji into various formats, including conversion to EmojiOne emoji images.
 - All libraries included here are available free under the MIT license.
 
 
 ## License to Use EmojiOne Images
 
### EmojiOne Version 3
 
 EmojiOne launched version 3.0 in 2017, which has several licensing options available. PNG 32px, 64px, and 128px as well as 32px and 64px sprites are available for digital use, with attribution. See [emojione.com/developers/free-license](https://www.emojione.com/developers/free-license) for more information on usage and attribution requirements.
 
 *Premium Licenses are available for larger PNG assets and SVG assets, for digital and print use.* See [emojione.com/developers/premium-license](https://www.emojione.com/developers/premium-license) for more information or to obtain a Premium License.
 
 ### EmojiOne Version 2
 
 EmojiOne version 2 assets (all SVG and PNG) are available in [the 2.2.7 branch](https://github.com/Ranks/emojione/tree/2.2.7), and they remain available for digital use (with attribution) under the Creative Commons license. Please see [INSTALLATION.md](INSTALLATION.md) for instructions on installing version 2, and [UPGRADE.md](UPGRADE.md) for instructions on upgrading from version 2 to version 3.


## Installation
To install emojione, please refer to the guide at [INSTALLATION.md](INSTALLATION.md). **Version 3 introduces many  potentially-breaking changes.** Refer to the [UPGRADE.md](UPGRADE.md) documentation for more details.


## Contributing
Please see [CONTRIBUTING.md](CONTRIBUTING.md) for more info on contributing to the emojione project. For artwork comments and questions please see the emojione-assets repo.

## Usage
You'll find basic usage examples here in the [/examples/](examples/) directory, and links to usage demos in [USAGE.md](USAGE.md).


## Information

### Bug reports

If you discover any bugs, feel free to create an issue on GitHub. We also welcome the open-source community to contribute to the project by forking it and issuing pull requests.

 *  https://github.com/Ranks/emojione/issues


### Contact

If you have any questions, comments, or concerns you are welcome to contact us.

*  [![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/Ranks/emojione?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
* [support@emojione.com](mailto:support@emojione.com)
* http://emojione.com
* https://twitter.com/emojione


### Alternatives
We sincerely hope that you choose to use EmojiOne and support our project, but if you feel like it's not for you, please have a look at these possible alternatives:

* https://github.com/hassankhan/emojify.js
* https://github.com/emojidex/ (used to be known as [Phantom Open Emoji](https://github.com/Genshin/PhantomOpenEmoji))
* https://github.com/iamcal/emoji-data (with [PHP](https://github.com/iamcal/php-emoji) and [Javascript](https://github.com/iamcal/js-emoji) interfaces)
* https://github.com/node-modules/emoji
* https://github.com/steveklabnik/emoji
* https://github.com/rockerhieu/emojicon
* https://github.com/HenrikJoreteg/emoji-images
* https://github.com/frissdiegurke/emoji-parser
* https://github.com/muan/emojilib
* https://github.com/kcthota/emoji4j