#!/usr/bin/tclsh
#
# Translation checker
#    (c) Gerhard Reithofer, Techn. EDV Reithofer 2004
#

if {$argc < 2} {
  puts "Usage: [file tail $argv0] languagefile sourcefile ..."
	exit 1
}

set langname [lindex $argv 0]
set language  [string range [file extension $langname] 1 end]
set module [file rootname [file tail $langname]]

set resultf [file tail [lindex $argv 1]].$language
set untranslated "*NoTranslation*"
set unused       "*NotUsed*"

set ntranslated 0
set ntrans_used 0
set linecounter 0
set files_done ""

set OBEXDIR [pwd]

proc quote {ns} { regsub -all "\\\n" $ns "\\\\n" ns ; return $ns }

source lib/obextool.ini
source $langname

proc get_text { msg args } {
  global untranslated ntranslated language
  if [llength $args] { 
	  set dict [lindex $args 0] 
	} else { 
	  set dict obextool 
	}
  global ${dict}_Text
#puts "Dict_Variable: ${dict}_Text"
#puts "[llength [array names ${dict}_Text]] entries found."
#puts "Message to translate: $msg"
  if { $language == "en" } { 
	  error "can't translate to english" 1000 
	}
  if { ! [array exists ${dict}_Text] } {
     "error not dictionary '$dict' exists" 1001 
  }
  if { ! [info exists ${dict}_Text($msg)] } { 
	  incr ntranslated
	  return $untranslated
	} else {
    return [set ${dict}_Text($msg)]
	}
}

proc load_Messages { dict language } {
  debug_out "load_Messages $dict $language" 3
  global OBEXDIR [string tolower $dict]_Text
  set version_var [string tolower $dict]_Text_version
puts "Dict variable: [string tolower $dict]_Text"
  set lang_file [file join $OBEXDIR lang $dict.$language]
puts "Loading file: $lang_file"
  if ![file exist $lang_file] {
    puts "Unable to open laguage file '$lang_file'!"
		exit 2
  }
  source $lang_file
	puts "[llength [array names [string tolower $dict]_Text]] entries read."
  catch {set version_val [eval set $version_var]}
debug_var $version_var 2
debug_var version_val 3
  if [info exists version_val] {
    puts "Found message file $lang_file version $version_val ..."
  } else {
    puts "No version information found in '$lang_file'!"
  }
	return [llength [array names [string tolower $dict]_Text]]
}

set rec_counter [load_Messages $module $language]

set of [open $resultf w+]
puts $of "#\n#  Language translation file for ObexTool\n#"
puts $of "\narray set ${module}_Text \[list\\"

for {set i 1} {$i<$argc} {incr i} {
  set filename [lindex $argv $i]
  puts "Checkin file $filename..."
	append files_done " $filename"
  set fd [open $filename r]
  while {![eof $fd]} {
		set line [gets $fd]
		if {[string index [string trimleft $line] 0] == "#"} continue
		if {![regexp "\\\[.*get_text" $line]}  continue

		regsub "^.*\\\[.*get_text" $line "" tres
		set ltrimmed [string trim $tres]
		set rtrimmed [string range $ltrimmed 0 [string first "\"" $ltrimmed 1]]
    set trimmed [string trim $rtrimmed "\""]
		if [info exists ChkValue("$trimmed")] continue
		set trans [get_text "$trimmed" $module] 
 		set ChkValue("$trimmed") 1
		if [string equal $trans $untranslated] {
			puts "$filename: <$trimmed>"
			puts $of "  \"$trimmed\" \"$untranslated\" \\" 
		} else {
      if $ChkValue("$trimmed") continue
      puts $of "  \"$trimmed\" \"$DlgValue($trimmed)\" \\"
		}
 		incr linecounter
  } ; ### end while {![eof $fd]} 

	close $fd
} ; ### for {set i 1} {$i<$argc} {incr i} 

## foreach name [array names DlgValue] {
##   if !$ChkValue($name) {
## puts "ChkValue: $ChkValue($name)"
## 		puts $of "\"[quote $name]\" \"$unused\" \\" 
## 		incr ntrans_used
## 	}
## }

puts $of "\]\n"
puts $of "set ${module}_Text_version \"$OBEXTOOLVERSION\""
close $of

puts "Translation file: $langname"
puts "Output file: $resultf"
puts "Input files: $files_done"
puts "Translation language: $language"
puts "Records in translation table: $rec_counter"
puts "Lines to translate: $linecounter"
puts "Untranslated lines: $ntranslated"
puts "Unused translation entries: $ntrans_used"

