# coding=utf-8
from __future__ import unicode_literals

from .. import Provider as AddressProvider

class Provider(AddressProvider):
    #city_suffixes = []
    street_suffixes = [ 'ул.', ]
    city_formats = ('{{city_prefix}} {{city_name}}', )
    street_name_formats = ('{{street_suffix}} {{street_title}}', )
    street_address_formats = ('{{street_name}}, д. {{building_number}}', )
    address_formats = ('{{city}}, {{street_address}}, {{postcode}}', )
    #building_number_formats = ('##', )
    postcode_formats = ('######', )

    city_prefixes = (
        'г.', 'п.', 'к.', 'с.', 'д.', 'клх', 'ст.'
    )

    street_titles = (
        'Советская', 'Молодежная', 'Центральная', 'Школьная', 'Новая',
        'Садовая', 'Лесная', 'Набережная', 'Ленина', 'Мира', 'Октябрьская',
        'Зеленая', 'Комсомольская', 'Заречная', 'Первомайская', 'Гагарина',
        'Полевая', 'Луговая', 'Пионерская', 'Кирова', 'Юбилейная', 'Северная',
        'Пролетарская', 'Степная', 'Пушкина', 'Калинина', 'Южная', 'Колхозная',
        'Рабочая', 'Солнечная', 'Железнодорожная', 'Восточная', 'Заводская',
        'Чапаева', 'Нагорная', 'Строителей', 'Береговая', 'Победы', 'Горького',
        'Кооперативная', 'Красноармейская', 'Совхозная', 'Речная',
        'Спортивная', 'Озерная', 'Строительная', 'Парковая', 'Чкалова',
        'Мичурина', 'Подгорная', 'Дружбы', 'Почтовая', 'Партизанская',
        'Вокзальная', 'Лермонтова', 'Свободы', 'Дорожная', 'Дачная',
        'Маяковского', 'Западная', 'Фрунзе', 'Дзержинского', 'Московская',
        'Свердлова', 'Некрасова', 'Гоголя', 'Красная', 'Трудовая', 'Шоссейная',
        'Чехова', 'Коммунистическая', 'Труда', 'Комарова', 'Матросова',
        'Островского', 'Сосновая', 'Клубная', 'Куйбышева', 'Крупской',
        'Березовая', 'Карла Маркса', '8 Марта', 'Больничная',
        'Интернациональная', 'Суворова', 'Цветочная', 'Трактовая',
        'Ломоносова', 'Горная', 'Космонавтов', 'Энергетиков', 'Шевченко',
        'Весенняя', 'Механизаторов', 'Коммунальная', '40 лет Победы',
        'Майская', 'Энгельса', 'Привокзальная', 'Таежная', 'Транспортная',
        'Овражная', 'Светлая', '1 Мая', 'Вишневая', 'Чернышевского',
        'Урицкого', 'Ключевая', 'Ворошилова', 'Тургенева', 'Толстого',
        'Песчаная', 'Ленинградская', 'Профсоюзная', 'Буденного',
        'Орджоникидзе', 'Герцена', 'Верхняя', 'Ленинская', 'Кирпичная',
        'Мостовая', 'Щорса', 'Станционная', 'Луначарского', 'Энтузиастов',
        'Титова', 'Лазо', '50 лет Октября', 'Уральская', 'Линейная',
        'Пугачева', 'Володарского', 'Кутузова', 'Фабричная', 'Чайковского',
        'Магистральная', 'Сибирская', 'Крестьянская', 'Мелиораторов',
        'Российская', 'Новоселов', 'Тихая', 'Широкая', 'Нижняя', 'Белинского',
        'Тельмана', 'Тимирязева', 'Котовского', 'Народная', '60 лет Октября',
        'Промышленная', 'Кольцевая', 'Есенина', 'К.Маркса', 'Дальняя',
        '40 лет Октября', 'Крылова', 'Декабристов', 'Базарная', 'Целинная',
        'Родниковая', '70 лет Октября', 'Фурманова', 'Революционная',
        'Социалистическая', 'Звездная', 'Студенческая', 'Гайдара', 'Мирная',
        'Терешковой', 'Кубанская', 'Гаражная', 'Фестивальная', 'Гражданская',
        'Песочная', 'Сиреневая', 'Ватутина', 'Сельская', 'Кузнечная',
        'Пушкинская', 'Крайняя', 'Коммунаров', 'Гвардейская', 'Веселая',
        'Загородная', 'Олимпийская', 'Гастелло', 'Жданова', 'Радищева',
        'Нефтяников', 'Осипенко', 'Приозерная', 'Рябиновая', 'Заозерная',
        'Нахимова', 'Боровая', 'Жукова', 'Павлова', 'Степана Разина',
        'Урожайная', 'Попова', 'Торговая', 'Жуковского', 'Королева', 'Донская',
        'Пограничная', 'Огородная', 'Пригородная', 'Грибоедова', 'Стадионная',
        'Менделеева', 'Достоевского', 'Репина', 'Виноградная', 'Циолковского',
        'Воровского', 'Киевская', 'Максима Горького', 'Революции',
        'Индустриальная', 'Красногвардейская', 'Волжская', 'Кошевого',
        'Пархоменко', 'Свободная', 'Кедровая', 'Подлесная', 'Полярная',
        'Раздольная', 'Карьерная', 'Мельничная', 'Серова', 'Украинская',
        'Шахтерская', 'Запрудная', 'Элеваторная', 'Театральная', 'Добролюбова',
        'Геологическая', '50 лет Победы', 'Болотная', 'Красина', 'Коминтерна',
        'Придорожная', '30 лет Победы', 'Кленовая', 'Разина', 'Черняховского',
        'Казачья', 'Ветеранов', 'Малая', 'Пирогова', 'Льва Толстого',
        'Геологов', 'Тукая', 'Морская', 'Волгоградская', 'Димитрова',
        'Средняя', 'М.Горького', 'Безымянная', 'Краснофлотская', 'Братская',
        'Розы Люксембург', 'Тенистая', 'Учительская', 'Маркса', 'Кавказская',
        'Ушакова', 'Короткая', 'Деповская', 'Амурская', 'Сенная', 'Поселковая',
        '9 Мая', 'Юности', 'Короленко', 'Прудовая', 'Шолохова', 'Депутатская',
        'Авиационная', '50 лет ВЛКСМ', 'Черемушки', 'Кольцова', 'Плеханова',
        'Аэродромная', 'Большая', 'Приморская', 'Алтайская', 'Макаренко',
        'Глинки', 'Специалистов', 'Халтурина', 'Морозова', 'Тополиная',
        'Ростовская', 'Тракторная', 'Коммуны', 'Мелиоративная', 'Ольховая',
        'Славянская', 'Красных Партизан', 'Зои Космодемьянской', 'Карбышева',
        'Баумана', 'Радужная', 'Марта 8', 'Правды', 'Маркса Карла',
        'Краснодарская', 'Фадеева', '60 лет СССР', 'Стахановская',
        'Ярославская', 'Челюскинцев', 'Коллективная', 'Ангарская',
        'Олега Кошевого', 'Новостройка', 'Шмидта', 'Кузнецова', 'Локомотивная',
        'Войкова', 'Панфилова', 'Ягодная', 'Смоленская', 'Тепличная',
        'Карла Либкнехта', 'Парижской Коммуны', 'Водопроводная',
        'Республиканская', 'Автомобилистов', 'Космодемьянской', 'Осенняя',
        'Байкальская', 'Седова', 'Саратовская', 'Казанская', 'Блюхера',
        'Воронежская', 'Демьяна Бедного', 'Брянская', 'Производственная',
        'Спартака', 'Техническая', 'Енисейская', 'Николаева', 'Бабушкина',
        'Севастопольская', 'Окружная', 'Октября', 'Щетинкина', 'Орловская',
        'Хуторская', 'Тупиковая', 'Каштановая', 'Омская', 'Гончарова',
        'Привольная', 'Щербакова', 'Курортная', 'Ивановская', 'Выгонная',
        'Крымская', 'Путейская', 'Азина', 'Проезжая', 'Сурикова',
        'Краснознаменная', 'Одесская', '9 Января', 'Подстанция',
        'Логовая', 'Высокая', 'Ясная', 'Портовая', 'Снежная', 'Санаторная',
        'Союзная', 'Волкова', 'Ульяновская', 'Никитина', 'Сахалинская',
        'Горняцкая', 'Рылеева', 'Прибрежная', 'Химиков', 'Рыбацкая',
        'Полтавская', 'Тамбовская', 'Красноярская', 'Новосельская',
        'Проточная', 'Черноморская', 'Курчатова', 'Минская', 'Микрорайон',
        'Главная', 'Докучаева', 'Вольная', 'Просвещения', 'Смирнова',
        'Хвойная', 'Космическая', 'Моховая', 'Макарова', 'Курская',
        'Курганная', 'Угловая', 'Камская', 'Инженерная', 'Лесозаводская',
        'Астраханская', 'Иванова', 'Л.Толстого', 'Гафури', 'Высоцкого',
        'Белорусская', 'Бажова', 'Кочубея', 'Заовражная', 'Азовская',
        'Ручейная', 'Леонова', 'Волочаевская', 'Надежды', 'Ставропольская',
        'Металлистов', 'Вавилова', 'Слободская', 'Ульянова', 'Тульская',
        'Харьковская', 'Петровская', 'Павлика Морозова', 'Владимирская',
        'Семашко', 'Высоковольтная', 'Шаумяна', 'Чайкиной', 'Лазурная',
        'Ермака', 'Дорожников', 'Покровская', 'Новгородская', 'Ленская',
        'Советской Армии', 'Сплавная', 'Ударная', 'Калужская', 'Монтажников',
        'Прудная', 'Шишкина', 'Краснопартизанская', 'Ореховая', 'Таманская',
        'Иркутская', 'Металлургов', 'Отрадная', 'Беляева', 'Большевистская',
        'Троицкая', 'Лесхозная', 'Дружба', 'Васильковая', 'Серафимовича',
        'Ильича', 'Мусы Джалиля', 'Механическая', 'Невского', 'Путевая',
        'Клары Цеткин', 'Кузнецкая', 'Физкультурная', 'Леваневского',
        'Водников', 'Вахитова', 'Станиславского', 'Черемуховая', 'Советов',
        'Флотская', 'Угольная', 'Восьмого Марта', 'Пожарского', 'Папанина',
        'Просторная', 'Поперечная', 'Городская', 'Победа', '8-е Марта',
        'Абрикосовая', 'Бульварная', 'Прохладная', 'Томская', 'Энергетическая',
        'Литейная', 'Медицинская', 'Заливная', 'Журавлева', 'Бригадная',
        'Культуры', 'Мая 1', 'Минина', 'Машиностроителей', 'Детская', 'ДОС',
        'Тюленина', 'Запорожская', 'Дальневосточная', 'Громова', 'О.Кошевого',
        'Балтийская', 'Р.Люксембург', 'Февральская', 'Толбухина', 'Лунная',
        'Дарвина', 'З.Космодемьянской', 'Высотная', 'Рязанская', 'Малиновая'
    )

    city_names = (
        'Абакан', 'Абинск', 'Агата', 'Агинское (Забайк.)', 'Адлер', 'Адыгейск',
        'Азов (Рост.)', 'Алагир', 'Алапаевск', 'Алдан', 'Александров',
        'Александров Гай', 'Александровск', 'Александровск-Сахалинский',
        'Алексин', 'Амдерма', 'Амурск', 'Анадырь', 'Анапа', 'Ангарск',
        'Андреаполь', 'Анива', 'Апатиты', 'Апрелевка', 'Апшеронск', 'Аргаяш',
        'Ардон', 'Арзамас', 'Армавир', 'Арсеньев', 'Артем', 'Архангельск',
        'Архыз', 'Аршан (Бурят.)', 'Асбест', 'Асино', 'Астрахань', 'Ахтубинск',
        'Ачинск', 'Ачхой Мартан', 'Аша', 'Бавлы', 'Байкальск', 'Баксан',
        'Балашиха', 'Балашов', 'Балтийск', 'Баргузин', 'Барнаул', 'Батайск',
        'Белгород', 'Белогорск (Амур.)', 'Белокуриха', 'Беломорск', 'Белорецк',
        'Белореченск', 'Белоярский', 'Белый Яр (Томск.)', 'Березники',
        'Беслан', 'Бийск', 'Билибино', 'Биробиджан', 'Бирск',
        'Благовещенск (Амур.)', 'Богучар', 'Бодайбо', 'Бологое', 'Бомнак',
        'Борзя', 'Боровск', 'Братск', 'Бреды', 'Бронницы', 'Брянск',
        'Бугульма', 'Бугуруслан', 'Буденновск', 'Бузулук', 'Буйнакск',
        'Быково (метеост.)', 'Валаам', 'Валдай', 'Ведено', 'Великие Луки',
        'Великий Устюг', 'Вендинга', 'Верещагино (Перм.)', 'Верхнее Пенжино',
        'Верхний Баскунчак', 'Верхний Тагил', 'Верхний Уфалей', 'Верхотурье',
        'Верхоянск', 'Видное', 'Вилюйск', 'Витим', 'Владивосток',
        'Владикавказ', 'Владимир', 'Внуково (метеост.)', 'Волгоград',
        'Волгодонск', 'Вологда', 'Волоколамск', 'Волхов', 'Воркута',
        'Воронеж', 'Воскресенск', 'Воткинск', 'Всеволожск', 'Вуктыл', 'Выборг',
        'Вытегра', 'Вязьма', 'Гаврилов-Ям', 'Гагарин', 'Галич', 'Гатчина',
        'Гдов', 'Геленджик', 'Глазов', 'Голицыно', 'Горно-Алтайск',
        'Городовиковск', 'Горячий Ключ', 'Горячинск', 'Гремячинск (Бурят.)',
        'Гремячинск (Перм.)', 'Грозный', 'Губаха', 'Губкин', 'Губкинский',
        'Гудермес', 'Гусь-Хрустальный', 'Дагомыс', 'Далматово', 'Данков',
        'Двинской', 'Дербент', 'Джейрах', 'Джубга', 'Дзержинск', 'Дивногорск',
        'Диксон', 'Дмитров', 'Дно', 'Добрянка', 'Долинск', 'Домбай',
        'Домодедово', 'Дубна', 'Дудинка', 'Егорьевск', 'Ейск', 'Екатеринбург',
        'Елабуга', 'Елатьма', 'Елец', 'Ельня', 'Енисейск', 'Ербогачен',
        'Ершов', 'Ессентуки', 'Железногорск(Курск.)', 'Жиганск', 'Жигулевск',
        'Жуковский', 'Забайкальск', 'Заводоуковск', 'Завьялиха', 'Зарайск',
        'Звенигород', 'Зеленогорск (Ленин.)', 'Зеленоград', 'Златоуст',
        'Змеиногорск', 'Иваново', 'Ивдель', 'Игарка', 'Игнашино', 'Ижевск',
        'Избербаш', 'Инта', 'Ирбит', 'Иркутск', 'Истра', 'Ишим', 'Йошкар-Ола',
        'Кабанск', 'Кажим', 'Казань', 'Калач', 'Калач-на-Дону', 'Калачинск',
        'Калевала', 'Калининград', 'Калуга', 'Калязин', 'Каменномостский',
        'Каменск-Уральский', 'Каменск-Шахтинский', 'Камень-на-Оби', 'Камышин',
        'Камышлов', 'Кандалакша', 'Каневская', 'Канск', 'Карабудахкент',
        'Карабулак', 'Карачаевск', 'Каргасок', 'Каргополь', 'Карпинск',
        'Карталы', 'Касимов', 'Каспийск', 'Катав-Ивановск', 'Катайск',
        'Качканар', 'Кашира', 'Кашхатау', 'Кедровый', 'Кежма', 'Кемерово',
        'Кетченеры', 'Кижи', 'Кизел', 'Кизилюрт', 'Кизляр', 'Кимры',
        'Кингисепп', 'Кинешма', 'Киренск', 'Киржач', 'Кириши', 'Киров (Вятка)',
        'Кирово-Чепецк', 'Кировск (Мурм.)', 'Кировск (Ленин.)', 'Кисловодск',
        'Клин', 'Ковров', 'Когалым', 'Коломна', 'Колпашево',
        'Комсомольск-на-Амуре', 'Кондопога', 'Королев', 'Корсаков',
        'Костомукша', 'Кострома', 'Котельнич', 'Котлас', 'Кош-Агач',
        'Красная Поляна', 'Красновишерск', 'Красногорск (Моск.)', 'Краснодар',
        'Краснокамск', 'Красноселькуп', 'Краснотурьинск', 'Красноуральск',
        'Красноуфимск', 'Красноярск', 'Кропоткин (Краснод.)', 'Крымск',
        'Кудымкар', 'Кузнецк', 'Кулу', 'Кулунда', 'Кунгур', 'Курган',
        'Курганинск', 'Курильск', 'Курск', 'Куртамыш', 'Курумкан', 'Курчатов',
        'Кущевская', 'Кызыл', 'Кырен', 'Кыштым', 'Кяхта', 'Лабинск',
        'Лабытнанги', 'Лагань', 'Лазаревское', 'Лесной (Сверд.)', 'Липецк',
        'Листвянка (Иркут.)', 'Лодейное Поле', 'Лотошино', 'Луга', 'Луховицы',
        'Лысьва', 'Льгов', 'Любань', 'Люберцы', 'Лянтор', 'Магадан', 'Магас',
        'Магнитогорск', 'Майкоп', 'Макаров', 'Макушино', 'Малая Вишера',
        'Малгобек', 'Малоярославец', 'Махачкала', 'Медногорск',
        'Междуреченский', 'Мезень', 'Мелеуз', 'Меренга', 'Миасс',
        'Миллерово', 'Минеральные Воды', 'Минусинск', 'Мирный', 'Мичуринск',
        'Можайск', 'Можга', 'Моздок', 'Мокшан', 'Мончегорск', 'Морозовск',
        'Моршанск', 'Москва', 'Москва, МГУ', 'Мостовской', 'Муравленко',
        'Мураши', 'Мурманск', 'Муром', 'Мценск', 'Мыс Шмидта', 'Мытищи',
        'Набережные Челны', 'Надым', 'Назрань', 'Нальчик', 'Наро-Фоминск',
        'Нарткала', 'Нарым', 'Нарьян-Мар', 'Находка', 'Невельск',
        'Невинномысск', 'Невьянск', 'Неплюевка', 'Нерчинск', 'Нефедова',
        'Нефтегорск (Самар.)', 'Нефтекамск', 'Нефтеюганск', 'Нижневартовск',
        'Нижнекамск', 'Нижнеудинск', 'Нижний Новгород', 'Нижний Тагил',
        'Новая Игирма', 'Новгород Великий', 'Новокузнецк', 'Новомичуринск',
        'Новомосковск', 'Новороссийка', 'Новороссийск', 'Новосибирск',
        'Новочеркасск', 'Новый Оскол', 'Новый Уренгой', 'Ногинск (Моск.)',
        'Ноглики', 'Норильск', 'Ноябрьск', 'Нурлат', 'Нягань', 'Нязепетровск',
        'Обнинск', 'Обоянь', 'Объячево', 'Одинцово', 'Озеры', 'Оймякон',
        'Октябрьский (Башк.)', 'Октябрьское (Хант.)', 'Октябрьское (Челяб.)',
        'Оленегорск (Якут.)', 'Оленек', 'Омск', 'Онега', 'Орел', 'Оренбург',
        'Орехово-Зуево', 'Орск', 'Оса', 'Осташков', 'Оха', 'Охотск',
        'Павловская', 'Павловский Посад', 'Палана', 'Партизанск', 'Певек',
        'Пенза', 'Переславль-Залесский', 'Пермь', 'Петрозаводск',
        'Петропавловск-Камчатский', 'Петухово', 'Петушки', 'Печенга', 'Печора',
        'Пинега', 'Плес', 'Плесецк', 'Подольск', 'Поронайск', 'Поярково',
        'Приморско-Ахтарск', 'Приозерск', 'Прохладный', 'Псебай', 'Псков',
        'Пушкин', 'Пушкино (Моск.)', 'Пушкинские Горы', 'Пышма', 'Пятигорск',
        'Радужный', 'Раменское', 'Ребриха', 'Ревда (Сверд.)', 'Ржев',
        'Рославль', 'Россошь', 'Ростов', 'Ростов-на-Дону', 'Рубцовск', 'Руза',
        'Рыбинск', 'Рыльск', 'Ряжск', 'Рязань', 'Салават', 'Салехард',
        'Сальск', 'Самара', 'Санкт-Петербург', 'Саранск', 'Сарапул', 'Саратов',
        'Саров (Морд.)', 'Сасово', 'Саянск', 'Светлогорск (Калин.)',
        'Северо-Курильск', 'Северобайкальск', 'Северодвинск', 'Североморск',
        'Североуральск', 'Сеймчан', 'Семлячики', 'Серафимович',
        'Сергиев Посад', 'Серебряные Пруды', 'Середниково', 'Серов',
        'Серпухов', 'Сибай', 'Сковородино', 'Славгород', 'Славянск-на-Кубани',
        'Сладково', 'Слюдянка', 'Смирных', 'Смоленск', 'Снежинск',
        'Снежногорск (Мурм.)', 'Соболево', 'Советский', 'Соликамск',
        'Солнечногорск', 'Соловки', 'Соль-Илецк', 'Сорочинск', 'Сортавала',
        'Сосновый Бор', 'Сосногорск', 'Сосьва (Хант.)', 'Сочи', 'Ставрополь',
        'Старая Русса', 'Старый Оскол', 'Стерлитамак', 'Стрежевой', 'Ступино',
        'Суздаль', 'Сузун', 'Сунтар', 'Сургут (Хант.)', 'Сусуман', 'Сухиничи',
        'Сызрань', 'Сыктывкар', 'Тавда', 'Таганрог', 'Тайшет', 'Талдом',
        'Тамбей', 'Тамбов', 'Тарко-Сале', 'Таштагол', 'Тверь', 'Теберда',
        'Темрюк', 'Териберка', 'Терней', 'Терскол', 'Тикси', 'Тимашевск',
        'Тихвин', 'Тихорецк', 'Тобольск', 'Токма', 'Токсово', 'Тольятти',
        'Томари', 'Томпа', 'Томск', 'Торжок', 'Тосно', 'Тотьма',
        'Троицк (Челяб.)', 'Троицк (Моск.)', 'Троицко-Печорск', 'Туапсе',
        'Тула', 'Тулпан', 'Тулун', 'Тура', 'Туруханск', 'Тутаев', 'Тутончаны',
        'Тымовское', 'Тында', 'Тырныауз', 'Тюмень', 'Уварово', 'Углегорск',
        'Углич', 'Улан-Удэ', 'Ульяновск', 'Урай', 'Уренгой', 'Урус-Мартан',
        'Урюпинск', 'Усинск', 'Усмань', 'Усолье Сибирское', 'Уссурийск',
        'Усть-Баргузин', 'Усть-Джегута', 'Усть-Илимск', 'Усть-Ишим',
        'Усть-Калманка', 'Усть-Камчатск', 'Усть-Катав', 'Усть-Кулом',
        'Усть-Кут', 'Усть-Ордынский', 'Устюжна', 'Уфа', 'Ухта', 'Учалы',
        'Уэлен', 'Фатеж', 'Хабаровск', 'Ханты-Мансийск', 'Хасавюрт',
        'Хасан', 'Хатанга', 'Химки', 'Холмогоры', 'Холмск', 'Хоста',
        'Хужир', 'Цимлянск', 'Чайковский', 'Чебаркуль', 'Чебоксары',
        'Чегем', 'Челюскин', 'Челябинск', 'Черемхово', 'Череповец',
        'Черкесск', 'Чермоз', 'Черняховск', 'Черский', 'Черусти', 'Чехов',
        'Чикола', 'Чита', 'Чокурдах', 'Чулым', 'Чусовой', 'Шадринск', 'Шали',
        'Шамары', 'Шарья', 'Шатки', 'Шатой', 'Шатура', 'Шаховская', 'Шахты',
        'Шелагонцы', 'Шелехов', 'Шенкурск', 'Шерегеш', 'Шереметьево', 'Шилка',
        'Шумиха', 'Шуя', 'Щелково', 'Щельяюр', 'Элиста', 'Эльбрус', 'Эльтон',
        'Энгельс', 'Югорск', 'Южно-Курильск', 'Южно-Сахалинск', 'Южноуральск',
        'Юровск', 'Юрьев-Польский', 'Юрьевец (Иван.)', 'Юрюзань', 'Якутск',
        'Якша', 'Ялуторовск', 'Ямбург', 'Яр-Сале', 'Ярославль',
        'Ясный (Оренб.)', 'Яхрома', 'Яшалта', 'Яшкуль'
    )

    @classmethod
    def city_prefix(cls):
        return cls.random_element(cls.city_prefixes)

    @classmethod
    def city_name(cls):
        return cls.random_element(cls.city_names)

    @classmethod
    def street_title(cls):
        return cls.random_element(cls.street_titles)
