/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.DialogAddPermittedAddress;
import org.zaproxy.zap.extension.api.DialogModifyPermittedAddress;
import org.zaproxy.zap.extension.api.ExtensionAPI;
import org.zaproxy.zap.extension.api.PermittedAddressesTableModel;
import org.zaproxy.zap.network.DomainMatcher;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsApiPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelMisc = null;
    private JCheckBox chkEnabled = null;
    private JCheckBox chkUiEnabled = null;
    private JCheckBox chkSecureOnly = null;
    private JCheckBox reportPermErrors = null;
    private JCheckBox disableKey = null;
    private JCheckBox incErrorDetails = null;
    private JCheckBox autofillKey = null;
    private JCheckBox enableJSONP = null;
    private JCheckBox noKeyForSafeOps = null;
    private ZapTextField keyField = null;
    private JButton generateKeyButton = null;
    private PermittedAddressesPanel permittedAddressesPanel;
    private PermittedAddressesTableModel permittedAddressesTableModel;

    public OptionsApiPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("api.options.title"));
        this.add((Component)this.getPanelMisc(), this.getPanelMisc().getName());
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            int n = 0;
            this.panelMisc.add((Component)this.getChkEnabled(), LayoutHelper.getGBC(0, n++, 1, 0.5));
            this.panelMisc.add((Component)this.getChkUiEnabled(), LayoutHelper.getGBC(0, n++, 1, 0.5));
            this.panelMisc.add((Component)this.getChkSecureOnly(), LayoutHelper.getGBC(0, n++, 1, 0.5));
            this.panelMisc.add((Component)new JLabel(Constant.messages.getString("api.options.label.apiKey")), LayoutHelper.getGBC(0, n, 1, 0.5));
            this.panelMisc.add((Component)this.getKeyField(), LayoutHelper.getGBC(1, n++, 1, 0.5));
            this.panelMisc.add((Component)this.getGenerateKeyButton(), LayoutHelper.getGBC(1, n++, 1, 0.5));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("api.options.addr.title"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            jPanel.add((Component)this.getProxyPermittedAddressesPanel(), LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0));
            this.panelMisc.add((Component)jPanel, LayoutHelper.getGBC(0, n++, 2, 1.0, 1.0));
            JLabel jLabel = new JLabel(Constant.messages.getString("api.options.label.testingWarning"));
            jLabel.setForeground(Color.RED);
            this.panelMisc.add((Component)jLabel, LayoutHelper.getGBC(0, n++, 2, 0.5));
            this.panelMisc.add((Component)this.getDisableKey(), LayoutHelper.getGBC(0, n++, 1, 0.5));
            this.panelMisc.add((Component)this.getNoKeyForSafeOps(), LayoutHelper.getGBC(0, n++, 1, 0.5));
            this.panelMisc.add((Component)this.getReportPermErrors(), LayoutHelper.getGBC(0, n++, 1, 0.5));
            this.panelMisc.add((Component)this.getIncErrorDetails(), LayoutHelper.getGBC(0, n++, 1, 0.5));
            this.panelMisc.add((Component)this.getAutofillKey(), LayoutHelper.getGBC(0, n++, 1, 0.5));
            this.panelMisc.add((Component)this.getEnableJSONP(), LayoutHelper.getGBC(0, n++, 1, 0.5));
            this.panelMisc.add((Component)new JLabel(), LayoutHelper.getGBC(0, n, 1, 0.5, 1.0));
        }
        return this.panelMisc;
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText(Constant.messages.getString("api.options.enabled"));
            this.chkEnabled.setVerticalAlignment(1);
            this.chkEnabled.setVerticalTextPosition(1);
        }
        return this.chkEnabled;
    }

    private JCheckBox getChkUiEnabled() {
        if (this.chkUiEnabled == null) {
            this.chkUiEnabled = new JCheckBox();
            this.chkUiEnabled.setText(Constant.messages.getString("api.options.uiEnabled"));
            this.chkUiEnabled.setVerticalAlignment(1);
            this.chkUiEnabled.setVerticalTextPosition(1);
        }
        return this.chkUiEnabled;
    }

    private JCheckBox getChkSecureOnly() {
        if (this.chkSecureOnly == null) {
            this.chkSecureOnly = new JCheckBox();
            this.chkSecureOnly.setText(Constant.messages.getString("api.options.secure"));
            this.chkSecureOnly.setVerticalAlignment(1);
            this.chkSecureOnly.setVerticalTextPosition(1);
        }
        return this.chkSecureOnly;
    }

    private JCheckBox getDisableKey() {
        if (this.disableKey == null) {
            this.disableKey = new JCheckBox();
            this.disableKey.setText(Constant.messages.getString("api.options.disableKey"));
            this.disableKey.setVerticalAlignment(1);
            this.disableKey.setVerticalTextPosition(1);
            this.disableKey.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsApiPanel.this.getKeyField().setEnabled(!OptionsApiPanel.this.disableKey.isSelected());
                    OptionsApiPanel.this.getGenerateKeyButton().setEnabled(!OptionsApiPanel.this.disableKey.isSelected());
                    if (!OptionsApiPanel.this.disableKey.isSelected()) {
                        OptionsApiPanel.this.getKeyField().setText(Model.getSingleton().getOptionsParam().getApiParam().getRealKey());
                    }
                }
            });
        }
        return this.disableKey;
    }

    private JCheckBox getEnableJSONP() {
        if (this.enableJSONP == null) {
            this.enableJSONP = new JCheckBox();
            this.enableJSONP.setText(Constant.messages.getString("api.options.enableJSONP"));
            this.enableJSONP.setVerticalAlignment(1);
            this.enableJSONP.setVerticalTextPosition(1);
        }
        return this.enableJSONP;
    }

    private JCheckBox getReportPermErrors() {
        if (this.reportPermErrors == null) {
            this.reportPermErrors = new JCheckBox();
            this.reportPermErrors.setText(Constant.messages.getString("api.options.reportPermErrors"));
            this.reportPermErrors.setVerticalAlignment(1);
            this.reportPermErrors.setVerticalTextPosition(1);
        }
        return this.reportPermErrors;
    }

    private JCheckBox getNoKeyForSafeOps() {
        if (this.noKeyForSafeOps == null) {
            this.noKeyForSafeOps = new JCheckBox();
            this.noKeyForSafeOps.setText(Constant.messages.getString("api.options.noKeyForSafeOps"));
            this.noKeyForSafeOps.setVerticalAlignment(1);
            this.noKeyForSafeOps.setVerticalTextPosition(1);
        }
        return this.noKeyForSafeOps;
    }

    private JCheckBox getIncErrorDetails() {
        if (this.incErrorDetails == null) {
            this.incErrorDetails = new JCheckBox();
            this.incErrorDetails.setText(Constant.messages.getString("api.options.incErrors"));
            this.incErrorDetails.setVerticalAlignment(1);
            this.incErrorDetails.setVerticalTextPosition(1);
        }
        return this.incErrorDetails;
    }

    private JCheckBox getAutofillKey() {
        if (this.autofillKey == null) {
            this.autofillKey = new JCheckBox();
            this.autofillKey.setText(Constant.messages.getString("api.options.autofillKey"));
            this.autofillKey.setVerticalAlignment(1);
            this.autofillKey.setVerticalTextPosition(1);
        }
        return this.autofillKey;
    }

    private ZapTextField getKeyField() {
        if (this.keyField == null) {
            this.keyField = new ZapTextField();
        }
        return this.keyField;
    }

    private JButton getGenerateKeyButton() {
        if (this.generateKeyButton == null) {
            this.generateKeyButton = new JButton(Constant.messages.getString("api.options.button.generateKey"));
            this.generateKeyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsApiPanel.this.getKeyField().setText(ExtensionAPI.generateApiKey());
                }
            });
        }
        return this.generateKeyButton;
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        this.getChkEnabled().setSelected(optionsParam.getApiParam().isEnabled());
        this.getChkUiEnabled().setSelected(optionsParam.getApiParam().isUiEnabled());
        this.getChkSecureOnly().setSelected(optionsParam.getApiParam().isSecureOnly());
        this.getDisableKey().setSelected(optionsParam.getApiParam().isDisableKey());
        this.getIncErrorDetails().setSelected(optionsParam.getApiParam().isIncErrorDetails());
        this.getAutofillKey().setSelected(optionsParam.getApiParam().isAutofillKey());
        this.getEnableJSONP().setSelected(optionsParam.getApiParam().isEnableJSONP());
        this.getReportPermErrors().setSelected(optionsParam.getApiParam().isReportPermErrors());
        this.getNoKeyForSafeOps().setSelected(optionsParam.getApiParam().isNoKeyForSafeOps());
        this.getKeyField().setText(optionsParam.getApiParam().getKey());
        this.getKeyField().setEnabled(!this.disableKey.isSelected());
        this.getGenerateKeyButton().setEnabled(!this.disableKey.isSelected());
        this.getPermittedAddressesTableModel().setAddresses(optionsParam.getApiParam().getPermittedAddresses());
        this.getProxyPermittedAddressesPanel().setRemoveWithoutConfirmation(!optionsParam.getApiParam().isConfirmRemovePermittedAddress());
    }

    @Override
    public void validateParam(Object object) throws Exception {
        if (!this.getDisableKey().isSelected() && this.getKeyField().getText().length() == 0) {
            throw new Exception(Constant.messages.getString("api.options.nokey.error"));
        }
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        optionsParam.getApiParam().setEnabled(this.getChkEnabled().isSelected());
        optionsParam.getApiParam().setUiEnabled(this.getChkUiEnabled().isSelected());
        optionsParam.getApiParam().setSecureOnly(this.getChkSecureOnly().isSelected());
        optionsParam.getApiParam().setDisableKey(this.getDisableKey().isSelected());
        optionsParam.getApiParam().setIncErrorDetails(this.getIncErrorDetails().isSelected());
        optionsParam.getApiParam().setAutofillKey(this.getAutofillKey().isSelected());
        optionsParam.getApiParam().setEnableJSONP(this.getEnableJSONP().isSelected());
        optionsParam.getApiParam().setReportPermErrors(this.getReportPermErrors().isSelected());
        optionsParam.getApiParam().setNoKeyForSafeOps(this.getNoKeyForSafeOps().isSelected());
        if (!this.getDisableKey().isSelected()) {
            optionsParam.getApiParam().setKey(this.getKeyField().getText());
        }
        optionsParam.getApiParam().setPermittedAddresses(this.getPermittedAddressesTableModel().getElements());
        optionsParam.getApiParam().setConfirmRemovePermittedAddress(!this.getProxyPermittedAddressesPanel().isRemoveWithoutConfirmation());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.api";
    }

    private PermittedAddressesPanel getProxyPermittedAddressesPanel() {
        if (this.permittedAddressesPanel == null) {
            this.permittedAddressesPanel = new PermittedAddressesPanel(this.getPermittedAddressesTableModel());
        }
        return this.permittedAddressesPanel;
    }

    private PermittedAddressesTableModel getPermittedAddressesTableModel() {
        if (this.permittedAddressesTableModel == null) {
            this.permittedAddressesTableModel = new PermittedAddressesTableModel();
        }
        return this.permittedAddressesTableModel;
    }

    private static class PermittedAddressesPanel
    extends AbstractMultipleOptionsTablePanel<DomainMatcher> {
        private static final long serialVersionUID = 2332044353650231701L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("api.options.addr.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("api.options.addr.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("api.options.addr.dialog.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("api.options.addr.dialog.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("api.options.addr.dialog.remove.checkbox.label");
        private DialogAddPermittedAddress addDialog = null;
        private DialogModifyPermittedAddress modifyDialog = null;

        public PermittedAddressesPanel(PermittedAddressesTableModel permittedAddressesTableModel) {
            super(permittedAddressesTableModel);
            this.getTable().setVisibleRowCount(5);
            this.getTable().setSortOrder(2, SortOrder.ASCENDING);
        }

        @Override
        public DomainMatcher showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddPermittedAddress(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setVisible(true);
            DomainMatcher domainMatcher = this.addDialog.getAddress();
            this.addDialog.clear();
            return domainMatcher;
        }

        @Override
        public DomainMatcher showModifyDialogue(DomainMatcher domainMatcher) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyPermittedAddress(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setAddress(domainMatcher);
            this.modifyDialog.setVisible(true);
            DomainMatcher domainMatcher2 = this.modifyDialog.getAddress();
            this.modifyDialog.clear();
            if (!domainMatcher2.equals(domainMatcher)) {
                return domainMatcher2;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(DomainMatcher domainMatcher) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

