/*
 * Decompiled with CFR 0.152.
 */
package test.suite;

import dguitar.adaptors.guitarPro.GPAdaptor;
import dguitar.adaptors.song.Song;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.players.sound.MasterPlayer;
import dguitar.players.sound.PerformanceEvent;
import dguitar.players.sound.PerformanceEventListener;
import dguitar.players.sound.PerformanceTimerEvent;
import dguitar.players.sound.PerformanceTimerListener;
import dguitar.players.sound.midi.MidiPlayer;
import java.io.IOException;
import junit.framework.TestCase;
import test.songs.SongArchive;
import test.songs.SongDefinition;
import test.tools.SingleMeasureArrangement;

public class TripletTestCase
extends TestCase {
    public void testTriplet() throws GPFormatException, IOException {
        SongDefinition sd = SongArchive.somethingSongDefinition();
        Song song = TripletTestCase.loadGPToSong(sd.getGpFileName());
        MasterPlayer player = new MasterPlayer();
        player.setSoundPlayer(new MidiPlayer());
        player.setTimerFrequency(4);
        player.enableNoteEvents(true);
        player.addTimerListener(new PerformanceTimerListener(){

            public void onTimer(PerformanceTimerEvent timerEvent) {
            }
        });
        player.addEventListener(new PerformanceEventListener(){

            public void onEvent(PerformanceEvent event) {
            }
        });
        player.arrange(song, new SingleMeasureArrangement(0));
        player.start();
        player.waitForCompletion();
        player.close();
    }

    public static Song loadGPToSong(String fileName) throws GPFormatException, IOException {
        GPInputStream gpis = new GPInputStream(fileName);
        GPSong piece = (GPSong)gpis.readObject();
        gpis.close();
        Song song = GPAdaptor.makeSong(piece);
        return song;
    }
}

