/* libnm-glib.vapi generated by vapigen-0.36, do not modify. */

[CCode (cprefix = "NM", gir_namespace = "NMClient", gir_version = "1.0", lower_case_cprefix = "nm_")]
namespace NM {
	[CCode (cheader_filename = "nm-access-point.h", type_id = "nm_access_point_get_type ()")]
	public class AccessPoint : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_BSSID")]
		public const string BSSID;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_FLAGS")]
		public const string FLAGS;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_FREQUENCY")]
		public const string FREQUENCY;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_LAST_SEEN")]
		public const string LAST_SEEN;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_MAX_BITRATE")]
		public const string MAX_BITRATE;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_MODE")]
		public const string MODE;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_RSN_FLAGS")]
		public const string RSN_FLAGS;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_SSID")]
		public const string SSID;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_STRENGTH")]
		public const string STRENGTH;
		[CCode (cheader_filename = "nm-access-point.h", cname = "NM_ACCESS_POINT_WPA_FLAGS")]
		public const string WPA_FLAGS;
		[CCode (has_construct_function = false, type = "GObject*")]
		public AccessPoint (DBus.Connection connection, string path);
		public bool connection_valid (NM.Connection connection);
		public GLib.SList<weak NM.Connection> filter_connections (GLib.SList<NM.Connection> connections);
		public unowned string get_bssid ();
		public NM.80211ApFlags get_flags ();
		public uint32 get_frequency ();
		[Version (deprecated = true, deprecated_since = "0.9")]
		public unowned string get_hw_address ();
		[Version (since = "1.2")]
		public int get_last_seen ();
		public uint32 get_max_bitrate ();
		public NM.80211Mode get_mode ();
		public NM.80211ApSecurityFlags get_rsn_flags ();
		public unowned GLib.ByteArray get_ssid ();
		public uint8 get_strength ();
		public NM.80211ApSecurityFlags get_wpa_flags ();
		public string bssid { get; }
		public uint flags { get; }
		public uint frequency { get; }
		public string hw_address { get; }
		[Version (since = "1.2")]
		public int last_seen { get; }
		public uint max_bitrate { get; }
		public uint mode { get; }
		public uint rsn_flags { get; }
		public NM.Ssid ssid { get; }
		public uint8 strength { get; }
		public uint wpa_flags { get; }
	}
	[CCode (cheader_filename = "nm-active-connection.h", type_id = "nm_active_connection_get_type ()")]
	public class ActiveConnection : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_CONNECTION")]
		public const string CONNECTION;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_DEFAULT")]
		public const string DEFAULT;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_DEFAULT6")]
		public const string DEFAULT6;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_DEVICES")]
		public const string DEVICES;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_DHCP4_CONFIG")]
		public const string DHCP4_CONFIG;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_DHCP6_CONFIG")]
		public const string DHCP6_CONFIG;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_ID")]
		public const string ID;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_IP4_CONFIG")]
		public const string IP4_CONFIG;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_IP6_CONFIG")]
		public const string IP6_CONFIG;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_MASTER")]
		public const string MASTER;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_SPECIFIC_OBJECT")]
		public const string SPECIFIC_OBJECT;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_STATE")]
		public const string STATE;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_TYPE")]
		public const string TYPE;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_UUID")]
		public const string UUID;
		[CCode (cheader_filename = "nm-active-connection.h", cname = "NM_ACTIVE_CONNECTION_VPN")]
		public const string VPN;
		[CCode (has_construct_function = false, type = "GObject*")]
		public ActiveConnection (DBus.Connection connection, string path);
		public unowned string get_connection ();
		[Version (since = "0.9.10")]
		public unowned string get_connection_type ();
		public bool get_default ();
		public bool get_default6 ();
		public unowned GLib.GenericArray<NM.Device> get_devices ();
		[Version (since = "0.9.10")]
		public unowned NM.DHCP4Config get_dhcp4_config ();
		[Version (since = "0.9.10")]
		public unowned NM.DHCP6Config get_dhcp6_config ();
		[Version (since = "0.9.10")]
		public unowned string get_id ();
		[Version (since = "0.9.10")]
		public unowned NM.IP4Config get_ip4_config ();
		[Version (since = "0.9.10")]
		public unowned NM.IP6Config get_ip6_config ();
		public unowned string get_master ();
		public unowned string get_specific_object ();
		public NM.ActiveConnectionState get_state ();
		public unowned string get_uuid ();
		[Version (since = "0.9.10")]
		public bool get_vpn ();
		public string connection { get; }
		public bool @default { get; }
		public bool default6 { get; }
		public NM.ObjectArray devices { get; }
		[Version (since = "0.9.10")]
		public NM.DHCP4Config dhcp4_config { get; }
		[Version (since = "0.9.10")]
		public NM.DHCP6Config dhcp6_config { get; }
		[Version (since = "0.9.10")]
		public string id { get; }
		[Version (since = "0.9.10")]
		public NM.IP4Config ip4_config { get; }
		[Version (since = "0.9.10")]
		public NM.IP6Config ip6_config { get; }
		public string master { get; }
		public string specific_object { get; }
		public uint state { get; }
		[NoAccessorMethod]
		[Version (since = "0.9.10")]
		public string type { owned get; }
		public string uuid { get; }
		[Version (since = "0.9.10")]
		public bool vpn { get; }
	}
	[CCode (cheader_filename = "nm-client.h", type_id = "nm_client_get_type ()")]
	public class Client : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_ACTIVATING_CONNECTION")]
		public const string ACTIVATING_CONNECTION;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_ACTIVE_CONNECTIONS")]
		public const string ACTIVE_CONNECTIONS;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_ALL_DEVICES")]
		public const string ALL_DEVICES;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_CONNECTIVITY")]
		public const string CONNECTIVITY;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_DEVICES")]
		public const string DEVICES;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_MANAGER_RUNNING")]
		public const string MANAGER_RUNNING;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_NETWORKING_ENABLED")]
		public const string NETWORKING_ENABLED;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_PRIMARY_CONNECTION")]
		public const string PRIMARY_CONNECTION;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_STARTUP")]
		public const string STARTUP;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_STATE")]
		public const string STATE;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_VERSION")]
		public const string VERSION;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_WIMAX_ENABLED")]
		public const string WIMAX_ENABLED;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_WIMAX_HARDWARE_ENABLED")]
		public const string WIMAX_HARDWARE_ENABLED;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_WIRELESS_ENABLED")]
		public const string WIRELESS_ENABLED;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_WIRELESS_HARDWARE_ENABLED")]
		public const string WIRELESS_HARDWARE_ENABLED;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_WWAN_ENABLED")]
		public const string WWAN_ENABLED;
		[CCode (cheader_filename = "nm-client.h", cname = "NM_CLIENT_WWAN_HARDWARE_ENABLED")]
		public const string WWAN_HARDWARE_ENABLED;
		[CCode (has_construct_function = false)]
		public Client ();
		public void activate_connection (NM.Connection? connection, NM.Device? device, string? specific_object, [CCode (scope = "async")] NM.ClientActivateFn? callback);
		public void add_and_activate_connection (NM.Connection? partial, NM.Device device, string? specific_object, [CCode (scope = "async")] NM.ClientAddActivateFn? callback);
		[Version (since = "0.9.8.6")]
		public NM.ConnectivityState check_connectivity (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "0.9.8.6")]
		public async NM.ConnectivityState check_connectivity_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void deactivate_connection (NM.ActiveConnection active);
		[Version (since = "0.9.8.6")]
		public unowned NM.ActiveConnection get_activating_connection ();
		public unowned GLib.GenericArray<NM.ActiveConnection> get_active_connections ();
		[Version (since = "1.2")]
		public unowned GLib.GenericArray<NM.Device> get_all_devices ();
		[Version (since = "0.9.8.6")]
		public NM.ConnectivityState get_connectivity ();
		public unowned NM.Device get_device_by_iface (string iface);
		public unowned NM.Device get_device_by_path (string object_path);
		public unowned GLib.GenericArray<NM.Device> get_devices ();
		[Version (since = "0.9.8")]
		public bool get_logging (string? level, string? domains) throws GLib.Error;
		public bool get_manager_running ();
		public NM.ClientPermissionResult get_permission_result (NM.ClientPermission permission);
		[Version (since = "0.9.8.6")]
		public unowned NM.ActiveConnection get_primary_connection ();
		[Version (since = "0.9.10")]
		public bool get_startup ();
		public NM.State get_state ();
		public unowned string get_version ();
		public bool networking_get_enabled ();
		public void networking_set_enabled (bool enabled);
		public static async NM.Client new_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.8")]
		public bool set_logging (string? level, string? domains) throws GLib.Error;
		public void sleep (bool sleep_);
		public bool wimax_get_enabled ();
		public bool wimax_hardware_get_enabled ();
		public void wimax_set_enabled (bool enabled);
		public bool wireless_get_enabled ();
		public bool wireless_hardware_get_enabled ();
		public void wireless_set_enabled (bool enabled);
		public bool wwan_get_enabled ();
		public bool wwan_hardware_get_enabled ();
		public void wwan_set_enabled (bool enabled);
		[Version (since = "0.9.8.6")]
		public NM.ActiveConnection activating_connection { get; }
		public GLib.GenericArray<void*> active_connections { get; }
		[Version (since = "1.2")]
		public NM.ObjectArray all_devices { get; }
		[Version (since = "0.9.8.6")]
		public uint connectivity { get; }
		[Version (since = "0.9.10")]
		public NM.ObjectArray devices { get; }
		public bool manager_running { get; }
		[NoAccessorMethod]
		public bool networking_enabled { get; set; }
		[Version (since = "0.9.8.6")]
		public NM.ActiveConnection primary_connection { get; }
		[Version (since = "0.9.10")]
		public bool startup { get; }
		public uint state { get; }
		public string version { get; }
		[NoAccessorMethod]
		public bool wimax_enabled { get; set; }
		[NoAccessorMethod]
		public bool wimax_hardware_enabled { get; }
		[NoAccessorMethod]
		public bool wireless_enabled { get; set; }
		[NoAccessorMethod]
		public bool wireless_hardware_enabled { get; }
		[NoAccessorMethod]
		public bool wwan_enabled { get; set; }
		[NoAccessorMethod]
		public bool wwan_hardware_enabled { get; }
		public signal void any_device_added (NM.Device device);
		public signal void any_device_removed (NM.Device device);
		public virtual signal void device_added (NM.Device device);
		public virtual signal void device_removed (NM.Device device);
		public virtual signal void permission_changed (uint permission, uint result);
	}
	[CCode (cheader_filename = "nm-dhcp4-config.h", lower_case_csuffix = "dhcp4_config", type_id = "nm_dhcp4_config_get_type ()")]
	public class DHCP4Config : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-dhcp4-config.h", cname = "NM_DHCP4_CONFIG_OPTIONS")]
		public const string OPTIONS;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DHCP4Config (DBus.Connection connection, string object_path);
		public unowned string get_one_option (string option);
		public unowned GLib.HashTable<string,GLib.Value?> get_options ();
		public GLib.HashTable<string,GLib.Value?> options { get; }
	}
	[CCode (cheader_filename = "nm-dhcp6-config.h", lower_case_csuffix = "dhcp6_config", type_id = "nm_dhcp6_config_get_type ()")]
	public class DHCP6Config : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-dhcp6-config.h", cname = "NM_DHCP6_CONFIG_OPTIONS")]
		public const string DHCP6_CONFIG_OPTIONS;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DHCP6Config (DBus.Connection connection, string object_path);
		public unowned string get_one_option (string option);
		public unowned GLib.HashTable<string,GLib.Value?> get_options ();
		public GLib.HashTable<string,GLib.Value?> options { get; }
	}
	[CCode (cheader_filename = "nm-device.h", type_id = "nm_device_get_type ()")]
	public class Device : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_ACTIVE_CONNECTION")]
		public const string ACTIVE_CONNECTION;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_AUTOCONNECT")]
		public const string AUTOCONNECT;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_AVAILABLE_CONNECTIONS")]
		public const string AVAILABLE_CONNECTIONS;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_CAPABILITIES")]
		public const string CAPABILITIES;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_DEVICE_TYPE")]
		public const string DEVICE_TYPE;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_DHCP4_CONFIG")]
		public const string DHCP4_CONFIG;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_DHCP6_CONFIG")]
		public const string DHCP6_CONFIG;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_DRIVER")]
		public const string DRIVER;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_DRIVER_VERSION")]
		public const string DRIVER_VERSION;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_FIRMWARE_MISSING")]
		public const string FIRMWARE_MISSING;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_FIRMWARE_VERSION")]
		public const string FIRMWARE_VERSION;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_INTERFACE")]
		public const string INTERFACE;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_IP4_CONFIG")]
		public const string IP4_CONFIG;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_IP6_CONFIG")]
		public const string IP6_CONFIG;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_IP_INTERFACE")]
		public const string IP_INTERFACE;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_MANAGED")]
		public const string MANAGED;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_PHYSICAL_PORT_ID")]
		public const string PHYSICAL_PORT_ID;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_PRODUCT")]
		public const string PRODUCT;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_REAL")]
		public const string REAL;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_STATE")]
		public const string STATE;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_STATE_REASON")]
		public const string STATE_REASON;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_UDI")]
		public const string UDI;
		[CCode (cheader_filename = "nm-device.h", cname = "NM_DEVICE_VENDOR")]
		public const string VENDOR;
		[CCode (has_construct_function = false, type = "GObject*")]
		public Device (DBus.Connection connection, string path);
		public virtual bool connection_compatible (NM.Connection connection) throws GLib.Error;
		public bool connection_valid (NM.Connection connection);
		[Version (since = "1.0")]
		public void @delete ([CCode (scope = "async")] NM.DeviceCallbackFn? callback);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "0.9.10")]
		public static string[] disambiguate_names ([CCode (array_length_cname = "num_devices", array_length_pos = 1.1)] NM.Device[] devices);
		public void disconnect ([CCode (scope = "async")] NM.DeviceCallbackFn? callback);
		public GLib.SList<weak NM.Connection> filter_connections (GLib.SList<NM.Connection> connections);
		public unowned NM.ActiveConnection get_active_connection ();
		public bool get_autoconnect ();
		[Version (since = "0.9.8")]
		public unowned GLib.GenericArray<NM.RemoteConnection> get_available_connections ();
		public NM.DeviceCapabilities get_capabilities ();
		[Version (since = "0.9.10")]
		public unowned string get_description ();
		public NM.DeviceType get_device_type ();
		public unowned NM.DHCP4Config get_dhcp4_config ();
		public unowned NM.DHCP6Config get_dhcp6_config ();
		public unowned string get_driver ();
		public unowned string get_driver_version ();
		public bool get_firmware_missing ();
		public unowned string get_firmware_version ();
		[Version (since = "0.9.10")]
		public virtual unowned string get_hw_address ();
		public unowned string get_iface ();
		public unowned NM.IP4Config get_ip4_config ();
		public unowned NM.IP6Config get_ip6_config ();
		public unowned string get_ip_iface ();
		public bool get_managed ();
		[Version (since = "0.9.10")]
		public uint32 get_mtu ();
		[Version (since = "0.9.10")]
		public unowned string get_physical_port_id ();
		public unowned string get_product ();
		[Version (since = "0.9.10")]
		public virtual GLib.Type get_setting_type ();
		public NM.DeviceState get_state ();
		public NM.DeviceState get_state_reason (out NM.DeviceStateReason reason);
		[Version (since = "0.9.10")]
		public virtual unowned string get_type_description ();
		public unowned string get_udi ();
		public unowned string get_vendor ();
		[Version (since = "1.2")]
		public bool is_real ();
		[Version (since = "1.0")]
		public bool is_software ();
		public void set_autoconnect (bool autoconnect);
		[Version (since = "1.2")]
		public void set_managed (bool managed);
		public NM.ActiveConnection active_connection { get; }
		public bool autoconnect { get; set; }
		[Version (since = "0.9.8")]
		public NM.ObjectArray available_connections { get; }
		public uint capabilities { get; }
		public uint device_type { get; }
		public NM.DHCP4Config dhcp4_config { get; }
		public NM.DHCP6Config dhcp6_config { get; }
		public string driver { get; }
		public string driver_version { get; }
		public bool firmware_missing { get; }
		public string firmware_version { get; }
		[NoAccessorMethod]
		public string @interface { owned get; }
		public NM.IP4Config ip4_config { get; }
		public NM.IP6Config ip6_config { get; }
		[NoAccessorMethod]
		public string ip_interface { owned get; }
		public bool managed { get; }
		[Version (since = "0.9.10")]
		public uint mtu { get; }
		[Version (since = "0.9.10")]
		public string physical_port_id { get; }
		public string product { get; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool real { get; }
		public uint state { get; }
		public string udi { get; }
		public string vendor { get; }
		public virtual signal void state_changed (uint new_state, uint old_state, uint reason);
	}
	[CCode (cheader_filename = "nm-device-adsl.h", type_id = "nm_device_adsl_get_type ()")]
	public class DeviceAdsl : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-adsl.h", cname = "NM_DEVICE_ADSL_CARRIER")]
		public const string CARRIER;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DeviceAdsl (DBus.Connection connection, string path);
		public bool get_carrier ();
		public bool carrier { get; }
	}
	[CCode (cheader_filename = "nm-device-bond.h", type_id = "nm_device_bond_get_type ()")]
	public class DeviceBond : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-bond.h", cname = "NM_DEVICE_BOND_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "nm-device-bond.h", cname = "NM_DEVICE_BOND_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-bond.h", cname = "NM_DEVICE_BOND_SLAVES")]
		public const string SLAVES;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DeviceBond (DBus.Connection connection, string path);
		public bool get_carrier ();
		public unowned string get_hw_address ();
		[Version (since = "0.9.6.4")]
		public unowned GLib.GenericArray<NM.Device> get_slaves ();
		public bool carrier { get; }
		public string hw_address { get; }
		[Version (since = "0.9.8")]
		public NM.ObjectArray slaves { get; }
	}
	[CCode (cheader_filename = "nm-device-bridge.h", type_id = "nm_device_bridge_get_type ()")]
	public class DeviceBridge : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-bridge.h", cname = "NM_DEVICE_BRIDGE_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "nm-device-bridge.h", cname = "NM_DEVICE_BRIDGE_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-bridge.h", cname = "NM_DEVICE_BRIDGE_SLAVES")]
		public const string SLAVES;
		[CCode (has_construct_function = false, type = "GObject*")]
		[Version (since = "0.9.8")]
		public DeviceBridge (DBus.Connection connection, string path);
		[Version (since = "0.9.8")]
		public bool get_carrier ();
		[Version (since = "0.9.8")]
		public unowned string get_hw_address ();
		[Version (since = "0.9.8")]
		public unowned GLib.GenericArray<NM.Device> get_slaves ();
		[Version (since = "0.9.8")]
		public bool carrier { get; }
		[Version (since = "0.9.8")]
		public string hw_address { get; }
		[Version (since = "0.9.8")]
		public NM.ObjectArray slaves { get; }
	}
	[CCode (cheader_filename = "nm-device-bt.h", type_id = "nm_device_bt_get_type ()")]
	public class DeviceBt : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-bt.h", cname = "NM_DEVICE_BT_CAPABILITIES")]
		public const string CAPABILITIES;
		[CCode (cheader_filename = "nm-device-bt.h", cname = "NM_DEVICE_BT_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-bt.h", cname = "NM_DEVICE_BT_NAME")]
		public const string NAME;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DeviceBt (DBus.Connection connection, string path);
		public NM.BluetoothCapabilities get_capabilities ();
		public unowned string get_hw_address ();
		public unowned string get_name ();
		[NoAccessorMethod]
		public uint bt_capabilities { get; }
		public string hw_address { get; }
		public string name { get; }
	}
	[CCode (cheader_filename = "nm-device-ethernet.h", type_id = "nm_device_ethernet_get_type ()")]
	public class DeviceEthernet : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-ethernet.h", cname = "NM_DEVICE_ETHERNET_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "nm-device-ethernet.h", cname = "NM_DEVICE_ETHERNET_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-ethernet.h", cname = "NM_DEVICE_ETHERNET_PERMANENT_HW_ADDRESS")]
		public const string PERMANENT_HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-ethernet.h", cname = "NM_DEVICE_ETHERNET_SPEED")]
		public const string SPEED;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DeviceEthernet (DBus.Connection connection, string path);
		public bool get_carrier ();
		public unowned string get_hw_address ();
		public unowned string get_permanent_hw_address ();
		public uint32 get_speed ();
		public bool carrier { get; }
		public string hw_address { get; }
		[NoAccessorMethod]
		public string perm_hw_address { owned get; }
		public uint speed { get; }
	}
	[CCode (cheader_filename = "nm-device-generic.h", type_id = "nm_device_generic_get_type ()")]
	public class DeviceGeneric : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-generic.h", cname = "NM_DEVICE_GENERIC_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-generic.h", cname = "NM_DEVICE_GENERIC_TYPE_DESCRIPTION")]
		public const string TYPE_DESCRIPTION;
		[CCode (has_construct_function = false, type = "GObject*")]
		[Version (since = "0.9.10")]
		public DeviceGeneric (DBus.Connection connection, string path);
		[Version (since = "0.9.10")]
		public unowned string get_hw_address ();
		public string hw_address { get; }
		[NoAccessorMethod]
		public string type_description { owned get; }
	}
	[CCode (cheader_filename = "nm-device-infiniband.h", type_id = "nm_device_infiniband_get_type ()")]
	public class DeviceInfiniband : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-infiniband.h", cname = "NM_DEVICE_INFINIBAND_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "nm-device-infiniband.h", cname = "NM_DEVICE_INFINIBAND_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DeviceInfiniband (DBus.Connection connection, string path);
		public bool get_carrier ();
		public unowned string get_hw_address ();
		public bool carrier { get; }
		public string hw_address { get; }
	}
	[CCode (cheader_filename = "nm-device-modem.h", type_id = "nm_device_modem_get_type ()")]
	public class DeviceModem : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-modem.h", cname = "NM_DEVICE_MODEM_CURRENT_CAPABILITIES")]
		public const string CURRENT_CAPABILITIES;
		[CCode (cheader_filename = "nm-device-modem.h", cname = "NM_DEVICE_MODEM_MODEM_CAPABILITIES")]
		public const string MODEM_CAPABILITIES;
		[CCode (has_construct_function = false)]
		protected DeviceModem ();
		public NM.DeviceModemCapabilities get_current_capabilities ();
		public NM.DeviceModemCapabilities get_modem_capabilities ();
		public uint current_capabilities { get; }
		public uint modem_capabilities { get; }
	}
	[CCode (cheader_filename = "nm-device-olpc-mesh.h", type_id = "nm_device_olpc_mesh_get_type ()")]
	public class DeviceOlpcMesh : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-olpc-mesh.h", cname = "NM_DEVICE_OLPC_MESH_ACTIVE_CHANNEL")]
		public const string MESH_ACTIVE_CHANNEL;
		[CCode (cheader_filename = "nm-device-olpc-mesh.h", cname = "NM_DEVICE_OLPC_MESH_COMPANION")]
		public const string MESH_COMPANION;
		[CCode (cheader_filename = "nm-device-olpc-mesh.h", cname = "NM_DEVICE_OLPC_MESH_HW_ADDRESS")]
		public const string MESH_HW_ADDRESS;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DeviceOlpcMesh (DBus.Connection connection, string path);
		public uint32 get_active_channel ();
		public unowned NM.DeviceWifi get_companion ();
		public unowned string get_hw_address ();
		public uint active_channel { get; }
		public NM.DeviceWifi companion { get; }
		public string hw_address { get; }
	}
	[CCode (cheader_filename = "nm-device-team.h", type_id = "nm_device_team_get_type ()")]
	public class DeviceTeam : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-team.h", cname = "NM_DEVICE_TEAM_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "nm-device-team.h", cname = "NM_DEVICE_TEAM_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-team.h", cname = "NM_DEVICE_TEAM_SLAVES")]
		public const string SLAVES;
		[CCode (has_construct_function = false, type = "GObject*")]
		[Version (since = "0.9.10")]
		public DeviceTeam (DBus.Connection connection, string path);
		[Version (since = "0.9.10")]
		public bool get_carrier ();
		[Version (since = "0.9.10")]
		public unowned string get_hw_address ();
		[Version (since = "0.9.10")]
		public unowned GLib.GenericArray<NM.Device> get_slaves ();
		public bool carrier { get; }
		public string hw_address { get; }
		public NM.ObjectArray slaves { get; }
	}
	[CCode (cheader_filename = "nm-device-vlan.h", type_id = "nm_device_vlan_get_type ()")]
	public class DeviceVlan : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-vlan.h", cname = "NM_DEVICE_VLAN_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "nm-device-vlan.h", cname = "NM_DEVICE_VLAN_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-vlan.h", cname = "NM_DEVICE_VLAN_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "nm-device-vlan.h", cname = "NM_DEVICE_VLAN_VLAN_ID")]
		public const string VLAN_ID;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DeviceVlan (DBus.Connection connection, string path);
		public bool get_carrier ();
		public unowned string get_hw_address ();
		[Version (since = "1.0")]
		public unowned NM.Device get_parent ();
		public uint get_vlan_id ();
		public bool carrier { get; }
		public string hw_address { get; }
		[Version (since = "1.0")]
		public NM.Device parent { get; }
		public uint vlan_id { get; }
	}
	[CCode (cheader_filename = "nm-device-wifi.h", type_id = "nm_device_wifi_get_type ()")]
	public class DeviceWifi : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-wifi.h", cname = "NM_DEVICE_WIFI_ACCESS_POINTS")]
		public const string ACCESS_POINTS;
		[CCode (cheader_filename = "nm-device-wifi.h", cname = "NM_DEVICE_WIFI_ACTIVE_ACCESS_POINT")]
		public const string ACTIVE_ACCESS_POINT;
		[CCode (cheader_filename = "nm-device-wifi.h", cname = "NM_DEVICE_WIFI_BITRATE")]
		public const string BITRATE;
		[CCode (cheader_filename = "nm-device-wifi.h", cname = "NM_DEVICE_WIFI_CAPABILITIES")]
		public const string CAPABILITIES;
		[CCode (cheader_filename = "nm-device-wifi.h", cname = "NM_DEVICE_WIFI_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-wifi.h", cname = "NM_DEVICE_WIFI_MODE")]
		public const string MODE;
		[CCode (cheader_filename = "nm-device-wifi.h", cname = "NM_DEVICE_WIFI_PERMANENT_HW_ADDRESS")]
		public const string PERMANENT_HW_ADDRESS;
		[CCode (has_construct_function = false, type = "GObject*")]
		public DeviceWifi (DBus.Connection connection, string path);
		public unowned NM.AccessPoint get_access_point_by_path (string path);
		public unowned GLib.GenericArray<NM.AccessPoint> get_access_points ();
		public unowned NM.AccessPoint get_active_access_point ();
		public uint32 get_bitrate ();
		public NM.DeviceWifiCapabilities get_capabilities ();
		public unowned string get_hw_address ();
		public NM.80211Mode get_mode ();
		public unowned string get_permanent_hw_address ();
		[Version (since = "0.9.8")]
		public void request_scan_simple ([CCode (scope = "async")] NM.DeviceWifiRequestScanFn? callback);
		[Version (since = "0.9.10")]
		public NM.ObjectArray access_points { get; }
		public NM.AccessPoint active_access_point { get; }
		public uint bitrate { get; }
		public string hw_address { get; }
		public uint mode { get; }
		[NoAccessorMethod]
		public string perm_hw_address { owned get; }
		[NoAccessorMethod]
		public uint wireless_capabilities { get; }
		public virtual signal void access_point_added (GLib.Object ap);
		public virtual signal void access_point_removed (GLib.Object ap);
	}
	[CCode (cheader_filename = "nm-device-wimax.h", type_id = "nm_device_wimax_get_type ()")]
	public class DeviceWimax : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-device-wimax.h", cname = "NM_DEVICE_WIMAX_ACTIVE_NSP")]
		public const string ACTIVE_NSP;
		[CCode (cheader_filename = "nm-device-wimax.h", cname = "NM_DEVICE_WIMAX_BSID")]
		public const string BSID;
		[CCode (cheader_filename = "nm-device-wimax.h", cname = "NM_DEVICE_WIMAX_CENTER_FREQUENCY")]
		public const string CENTER_FREQUENCY;
		[CCode (cheader_filename = "nm-device-wimax.h", cname = "NM_DEVICE_WIMAX_CINR")]
		public const string CINR;
		[CCode (cheader_filename = "nm-device-wimax.h", cname = "NM_DEVICE_WIMAX_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "nm-device-wimax.h", cname = "NM_DEVICE_WIMAX_NSPS")]
		public const string NSPS;
		[CCode (cheader_filename = "nm-device-wimax.h", cname = "NM_DEVICE_WIMAX_RSSI")]
		public const string RSSI;
		[CCode (cheader_filename = "nm-device-wimax.h", cname = "NM_DEVICE_WIMAX_TX_POWER")]
		public const string TX_POWER;
		[CCode (has_construct_function = false, type = "GObject*")]
		[Version (deprecated = true, deprecated_since = "1.2")]
		public DeviceWimax (DBus.Connection connection, string path);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public NM.WimaxNsp get_active_nsp ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned string get_bsid ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public uint get_center_frequency ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int get_cinr ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned string get_hw_address ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned NM.WimaxNsp get_nsp_by_path (string path);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned GLib.GenericArray<NM.WimaxNsp> get_nsps ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int get_rssi ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int get_tx_power ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public NM.WimaxNsp active_nsp { owned get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public string bsid { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public uint center_frequency { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int cinr { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public string hw_address { get; }
		[Version (deprecated = true, deprecated_since = "1.2", since = "0.9.10")]
		public NM.ObjectArray nsps { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int rssi { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int tx_power { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public virtual signal void nsp_added (GLib.Object nsp);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public virtual signal void nsp_removed (GLib.Object nsp);
	}
	[CCode (cheader_filename = "nm-ip4-config.h", type_id = "nm_ip4_config_get_type ()")]
	public class IP4Config : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-ip4-config.h", cname = "NM_IP4_CONFIG_ADDRESSES")]
		public const string ADDRESSES;
		[CCode (cheader_filename = "nm-ip4-config.h", cname = "NM_IP4_CONFIG_DOMAINS")]
		public const string DOMAINS;
		[CCode (cheader_filename = "nm-ip4-config.h", cname = "NM_IP4_CONFIG_GATEWAY")]
		public const string GATEWAY;
		[CCode (cheader_filename = "nm-ip4-config.h", cname = "NM_IP4_CONFIG_NAMESERVERS")]
		public const string NAMESERVERS;
		[CCode (cheader_filename = "nm-ip4-config.h", cname = "NM_IP4_CONFIG_ROUTES")]
		public const string ROUTES;
		[CCode (cheader_filename = "nm-ip4-config.h", cname = "NM_IP4_CONFIG_SEARCHES")]
		public const string SEARCHES;
		[CCode (cheader_filename = "nm-ip4-config.h", cname = "NM_IP4_CONFIG_WINS_SERVERS")]
		public const string WINS_SERVERS;
		[CCode (has_construct_function = false, type = "GObject*")]
		public IP4Config (DBus.Connection connection, string object_path);
		public unowned GLib.SList<NM.IP4Address> get_addresses ();
		public unowned GLib.GenericArray<string> get_domains ();
		[Version (since = "0.9.10")]
		public unowned string get_gateway ();
		public unowned GLib.Array<uint32> get_nameservers ();
		public unowned GLib.SList<NM.IP4Route> get_routes ();
		[Version (since = "0.9.10")]
		public unowned GLib.GenericArray<string> get_searches ();
		public unowned GLib.Array<uint32> get_wins_servers ();
		public void* addresses { get; }
		public NM.StringArray domains { get; }
		[Version (since = "0.9.10")]
		public string gateway { get; }
		public NM.UintArray nameservers { get; }
		public void* routes { get; }
		[Version (since = "0.9.10")]
		public NM.StringArray searches { get; }
		public NM.UintArray wins_servers { get; }
	}
	[CCode (cheader_filename = "nm-types.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nm_ip6_address_array_get_type ()")]
	[Compact]
	public class IP6AddressArray {
	}
	[CCode (cheader_filename = "nm-types.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nm_ip6_address_object_array_get_type ()")]
	[Compact]
	public class IP6AddressObjectArray {
	}
	[CCode (cheader_filename = "nm-ip6-config.h", type_id = "nm_ip6_config_get_type ()")]
	public class IP6Config : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-ip6-config.h", cname = "NM_IP6_CONFIG_ADDRESSES")]
		public const string ADDRESSES;
		[CCode (cheader_filename = "nm-ip6-config.h", cname = "NM_IP6_CONFIG_DOMAINS")]
		public const string DOMAINS;
		[CCode (cheader_filename = "nm-ip6-config.h", cname = "NM_IP6_CONFIG_GATEWAY")]
		public const string GATEWAY;
		[CCode (cheader_filename = "nm-ip6-config.h", cname = "NM_IP6_CONFIG_NAMESERVERS")]
		public const string NAMESERVERS;
		[CCode (cheader_filename = "nm-ip6-config.h", cname = "NM_IP6_CONFIG_ROUTES")]
		public const string ROUTES;
		[CCode (cheader_filename = "nm-ip6-config.h", cname = "NM_IP6_CONFIG_SEARCHES")]
		public const string SEARCHES;
		[CCode (has_construct_function = false, type = "GObject*")]
		public IP6Config (DBus.Connection connection, string object_path);
		public unowned GLib.SList<NM.IP6Address> get_addresses ();
		public unowned GLib.GenericArray<string> get_domains ();
		[Version (since = "0.9.10")]
		public unowned string get_gateway ();
		[CCode (array_length = false)]
		[Version (since = "0.9.10")]
		public unowned uint8[] get_nameserver (uint32 idx);
		[Version (since = "0.9.10")]
		public uint32 get_num_nameservers ();
		public unowned GLib.SList<NM.IP6Route> get_routes ();
		[Version (since = "0.9.10")]
		public unowned GLib.GenericArray<string> get_searches ();
		public NM.IP6AddressObjectArray addresses { get; }
		public NM.StringArray domains { get; }
		[Version (since = "0.9.10")]
		public string gateway { get; }
		[NoAccessorMethod]
		public NM.IP6AddressArray nameservers { owned get; }
		public NM.IP6RouteObjectArray routes { get; }
		[Version (since = "0.9.10")]
		public NM.StringArray searches { get; }
	}
	[CCode (cheader_filename = "nm-types.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nm_ip6_route_object_array_get_type ()")]
	[Compact]
	public class IP6RouteObjectArray {
	}
	[CCode (cheader_filename = "nm-object.h", type_id = "nm_object_get_type ()")]
	public abstract class Object : GLib.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-object.h", cname = "NM_OBJECT_DBUS_CONNECTION")]
		public const string DBUS_CONNECTION;
		[CCode (cheader_filename = "nm-object.h", cname = "NM_OBJECT_DBUS_PATH")]
		public const string DBUS_PATH;
		[CCode (has_construct_function = false)]
		protected Object ();
		public unowned DBus.Connection get_connection ();
		public unowned string get_path ();
		[NoAccessorMethod]
		public string dbus_path { owned get; construct; }
		public virtual signal void object_creation_failed (void* error, void* failed_path);
	}
	[CCode (cheader_filename = "nm-types.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nm_object_array_get_type ()")]
	[Compact]
	public class ObjectArray {
	}
	[CCode (cheader_filename = "nm-remote-connection.h", type_id = "nm_remote_connection_get_type ()")]
	public class RemoteConnection : NM.Connection, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-remote-connection.h", cname = "NM_REMOTE_CONNECTION_REMOVED")]
		public const string REMOVED;
		[CCode (cheader_filename = "nm-remote-connection.h", cname = "NM_REMOTE_CONNECTION_UNSAVED")]
		public const string UNSAVED;
		[CCode (cheader_filename = "nm-remote-connection.h", cname = "NM_REMOTE_CONNECTION_UPDATED")]
		public const string UPDATED;
		[CCode (has_construct_function = false)]
		public RemoteConnection (DBus.Connection bus, string path);
		public void commit_changes ([CCode (scope = "async")] NM.RemoteConnectionResultFunc? callback);
		[Version (since = "0.9.10")]
		public void commit_changes_unsaved ([CCode (scope = "async")] NM.RemoteConnectionResultFunc? callback);
		public void @delete ([CCode (scope = "async")] NM.RemoteConnectionResultFunc? callback);
		public void get_secrets (string setting_name, [CCode (scope = "async")] NM.RemoteConnectionGetSecretsFunc callback);
		[Version (since = "0.9.10")]
		public bool get_unsaved ();
		[Version (since = "0.9.10")]
		public void save ([CCode (scope = "async")] NM.RemoteConnectionResultFunc? callback);
		public string dbus_path { construct; }
		[Version (since = "0.9.10")]
		public bool unsaved { get; }
		public virtual signal void removed ();
		public virtual signal void updated ();
		public signal void visible (bool object);
	}
	[CCode (cheader_filename = "nm-remote-settings.h", type_id = "nm_remote_settings_get_type ()")]
	public class RemoteSettings : GLib.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-remote-settings.h", cname = "NM_REMOTE_SETTINGS_BUS")]
		public const string BUS;
		[CCode (cheader_filename = "nm-remote-settings.h", cname = "NM_REMOTE_SETTINGS_CAN_MODIFY")]
		public const string CAN_MODIFY;
		[CCode (cheader_filename = "nm-remote-settings.h", cname = "NM_REMOTE_SETTINGS_CONNECTIONS_READ")]
		public const string CONNECTIONS_READ;
		[CCode (cheader_filename = "nm-remote-settings.h", cname = "NM_REMOTE_SETTINGS_HOSTNAME")]
		public const string HOSTNAME;
		[CCode (cheader_filename = "nm-remote-settings.h", cname = "NM_REMOTE_SETTINGS_NEW_CONNECTION")]
		public const string NEW_CONNECTION;
		[CCode (cheader_filename = "nm-remote-settings.h", cname = "NM_REMOTE_SETTINGS_SERVICE_RUNNING")]
		public const string SERVICE_RUNNING;
		[CCode (has_construct_function = false)]
		public RemoteSettings (DBus.Connection? bus);
		public bool add_connection (NM.Connection connection, [CCode (scope = "async")] NM.RemoteSettingsAddConnectionFunc callback);
		[Version (since = "0.9.10")]
		public bool add_connection_unsaved (NM.Connection connection, [CCode (scope = "async")] NM.RemoteSettingsAddConnectionFunc callback);
		[Version (since = "0.9.10")]
		public unowned NM.RemoteConnection get_connection_by_id (string id);
		public unowned NM.RemoteConnection get_connection_by_path (string path);
		public unowned NM.RemoteConnection get_connection_by_uuid (string uuid);
		public GLib.SList<weak NM.RemoteConnection> list_connections ();
		[Version (since = "0.9.10")]
		public bool load_connections (string filenames, out string failures) throws GLib.Error;
		public static async NM.RemoteSettings new_async (DBus.Connection? bus, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "0.9.10")]
		public bool reload_connections () throws GLib.Error;
		public bool save_hostname (string hostname, [CCode (scope = "async")] NM.RemoteSettingsSaveHostnameFunc? callback);
		[NoAccessorMethod]
		public bool can_modify { get; }
		[NoAccessorMethod]
		public string hostname { owned get; }
		[NoAccessorMethod]
		public bool service_running { get; }
		public virtual signal void connections_read ();
		public virtual signal void new_connection (GLib.Object connection);
	}
	[CCode (cheader_filename = "nm-secret-agent.h", type_id = "nm_secret_agent_get_type ()")]
	public abstract class SecretAgent : GLib.Object {
		[CCode (cheader_filename = "nm-secret-agent.h", cname = "NM_SECRET_AGENT_AUTO_REGISTER")]
		public const string AUTO_REGISTER;
		[CCode (cheader_filename = "nm-secret-agent.h", cname = "NM_SECRET_AGENT_CAPABILITIES")]
		public const string CAPABILITIES;
		[CCode (cheader_filename = "nm-secret-agent.h", cname = "NM_SECRET_AGENT_IDENTIFIER")]
		public const string IDENTIFIER;
		[CCode (cheader_filename = "nm-secret-agent.h", cname = "NM_SECRET_AGENT_REGISTERED")]
		public const string REGISTERED;
		[CCode (cheader_filename = "nm-secret-agent.h", cname = "NM_SECRET_AGENT_REGISTRATION_RESULT")]
		public const string REGISTRATION_RESULT;
		[CCode (has_construct_function = false)]
		protected SecretAgent ();
		[NoWrapper]
		public virtual void cancel_get_secrets (string connection_path, string setting_name);
		public virtual void delete_secrets (NM.Connection connection, string connection_path, [CCode (scope = "async")] NM.SecretAgentDeleteSecretsFunc callback);
		public bool get_registered ();
		public virtual void get_secrets (NM.Connection connection, string connection_path, string setting_name, [CCode (array_length = false, array_null_terminated = true)] string[] hints, NM.SecretAgentGetSecretsFlags flags, [CCode (scope = "async")] NM.SecretAgentGetSecretsFunc callback);
		public bool register ();
		public virtual void save_secrets (NM.Connection connection, string connection_path, [CCode (scope = "async")] NM.SecretAgentSaveSecretsFunc callback);
		public bool unregister ();
		[NoAccessorMethod]
		public bool auto_register { get; set construct; }
		[NoAccessorMethod]
		public NM.SecretAgentCapabilities capabilities { get; set construct; }
		[NoAccessorMethod]
		public string identifier { owned get; construct; }
		public bool registered { get; }
		public virtual signal void registration_result (void* error);
	}
	[CCode (cheader_filename = "nm-types.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nm_ssid_get_type ()")]
	[Compact]
	public class Ssid {
	}
	[CCode (cheader_filename = "nm-types.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nm_string_array_get_type ()")]
	[Compact]
	public class StringArray {
	}
	[CCode (cheader_filename = "nm-types.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nm_uint_array_get_type ()")]
	[Compact]
	public class UintArray {
	}
	[CCode (cheader_filename = "nm-vpn-connection.h", type_id = "nm_vpn_connection_get_type ()")]
	public class VPNConnection : NM.ActiveConnection, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-vpn-connection.h", cname = "NM_VPN_CONNECTION_BANNER")]
		public const string BANNER;
		[CCode (cheader_filename = "nm-vpn-connection.h", cname = "NM_VPN_CONNECTION_VPN_STATE")]
		public const string VPN_STATE;
		[CCode (has_construct_function = false, type = "GObject*")]
		public VPNConnection (DBus.Connection connection, string path);
		public unowned string get_banner ();
		public NM.VPNConnectionState get_vpn_state ();
		public string banner { get; }
		public uint vpn_state { get; }
		public virtual signal void vpn_state_changed (uint state, uint reason);
	}
	[CCode (cheader_filename = "nm-wimax-nsp.h", type_id = "nm_wimax_nsp_get_type ()")]
	public class WimaxNsp : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "nm-wimax-nsp.h", cname = "NM_WIMAX_NSP_NAME")]
		public const string NAME;
		[CCode (cheader_filename = "nm-wimax-nsp.h", cname = "NM_WIMAX_NSP_NETWORK_TYPE")]
		public const string NETWORK_TYPE;
		[CCode (cheader_filename = "nm-wimax-nsp.h", cname = "NM_WIMAX_NSP_SIGNAL_QUALITY")]
		public const string SIGNAL_QUALITY;
		[CCode (has_construct_function = false, type = "GObject*")]
		public WimaxNsp (DBus.Connection connection, string path);
		public bool connection_valid (NM.Connection connection);
		public GLib.SList<weak NM.Connection> filter_connections (GLib.SList<NM.Connection> connections);
		public unowned string get_name ();
		public NM.WimaxNspNetworkType get_network_type ();
		public uint32 get_signal_quality ();
		public string name { get; }
		public uint network_type { get; }
		public uint signal_quality { get; }
	}
	[CCode (cheader_filename = "nm-client.h", cprefix = "NM_CLIENT_PERMISSION_", type_id = "nm_client_permission_get_type ()")]
	public enum ClientPermission {
		NONE,
		ENABLE_DISABLE_NETWORK,
		ENABLE_DISABLE_WIFI,
		ENABLE_DISABLE_WWAN,
		ENABLE_DISABLE_WIMAX,
		SLEEP_WAKE,
		NETWORK_CONTROL,
		WIFI_SHARE_PROTECTED,
		WIFI_SHARE_OPEN,
		SETTINGS_MODIFY_SYSTEM,
		SETTINGS_MODIFY_OWN,
		SETTINGS_MODIFY_HOSTNAME,
		SETTINGS_MODIFY_GLOBAL_DNS,
		RELOAD,
		CHECKPOINT_ROLLBACK,
		ENABLE_DISABLE_STATISTICS,
		LAST
	}
	[CCode (cheader_filename = "nm-client.h", cprefix = "NM_CLIENT_PERMISSION_RESULT_", type_id = "nm_client_permission_result_get_type ()")]
	public enum ClientPermissionResult {
		UNKNOWN,
		YES,
		AUTH,
		NO
	}
	[CCode (cheader_filename = "NMClient-1.0.h", cprefix = "NM_SECRET_AGENT_CAPABILITY_", type_id = "nm_secret_agent_capabilities_get_type ()")]
	[Flags]
	[Version (since = "0.9.10")]
	public enum SecretAgentCapabilities {
		NONE,
		VPN_HINTS,
		LAST
	}
	[CCode (cheader_filename = "nm-secret-agent.h", cprefix = "NM_SECRET_AGENT_GET_SECRETS_FLAG_", type_id = "nm_secret_agent_get_secrets_flags_get_type ()")]
	[Flags]
	public enum SecretAgentGetSecretsFlags {
		NONE,
		ALLOW_INTERACTION,
		REQUEST_NEW,
		USER_REQUESTED
	}
	[CCode (cheader_filename = "nm-wimax-nsp.h", cprefix = "NM_WIMAX_NSP_NETWORK_TYPE_", type_id = "nm_wimax_nsp_network_type_get_type ()")]
	public enum WimaxNspNetworkType {
		UNKNOWN,
		HOME,
		PARTNER,
		ROAMING_PARTNER
	}
	[CCode (cheader_filename = "NMClient-1.0.h", cprefix = "NM_CLIENT_ERROR_")]
	public errordomain ClientError {
		[CCode (cname = "NM_CLIENT_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_CLIENT_ERROR_MANAGER_NOT_RUNNING")]
		MANAGERNOTRUNNING;
		[Version (since = "0.9.10")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-adsl.h", cprefix = "NM_DEVICE_ADSL_ERROR_")]
	public errordomain DeviceAdslError {
		[CCode (cname = "NM_DEVICE_ADSL_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_ADSL_ERROR_NOT_ADSL_CONNECTION")]
		NOTADSLCONNECTION,
		[CCode (cname = "NM_DEVICE_ADSL_ERROR_INVALID_ADSL_CONNECTION")]
		INVALIDADSLCONNECTION;
		[CCode (cheader_filename = "nm-device-adsl.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-bond.h", cprefix = "NM_DEVICE_BOND_ERROR_")]
	public errordomain DeviceBondError {
		[CCode (cname = "NM_DEVICE_BOND_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_BOND_ERROR_NOT_BOND_CONNECTION")]
		NOTBONDCONNECTION,
		[CCode (cname = "NM_DEVICE_BOND_ERROR_INVALID_BOND_CONNECTION")]
		INVALIDBONDCONNECTION,
		[CCode (cname = "NM_DEVICE_BOND_ERROR_INTERFACE_MISMATCH")]
		INTERFACEMISMATCH;
		[CCode (cheader_filename = "nm-device-bond.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-bridge.h", cprefix = "NM_DEVICE_BRIDGE_ERROR_")]
	[Version (since = "0.9.8")]
	public errordomain DeviceBridgeError {
		[CCode (cname = "NM_DEVICE_BRIDGE_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_BRIDGE_ERROR_NOT_BRIDGE_CONNECTION")]
		NOTBRIDGECONNECTION,
		[CCode (cname = "NM_DEVICE_BRIDGE_ERROR_INVALID_BRIDGE_CONNECTION")]
		INVALIDBRIDGECONNECTION,
		[CCode (cname = "NM_DEVICE_BRIDGE_ERROR_INTERFACE_MISMATCH")]
		INTERFACEMISMATCH;
		[CCode (cheader_filename = "nm-device-bridge.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-bt.h", cprefix = "NM_DEVICE_BT_ERROR_")]
	public errordomain DeviceBtError {
		[CCode (cname = "NM_DEVICE_BT_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_BT_ERROR_NOT_BT_CONNECTION")]
		NOTBTCONNECTION,
		[CCode (cname = "NM_DEVICE_BT_ERROR_INVALID_BT_CONNECTION")]
		INVALIDBTCONNECTION,
		[CCode (cname = "NM_DEVICE_BT_ERROR_INVALID_DEVICE_MAC")]
		INVALIDDEVICEMAC,
		[CCode (cname = "NM_DEVICE_BT_ERROR_MAC_MISMATCH")]
		MACMISMATCH,
		[CCode (cname = "NM_DEVICE_BT_ERROR_MISSING_DEVICE_CAPS")]
		MISSINGDEVICECAPS;
		[CCode (cheader_filename = "nm-device-bt.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NMClient-1.0.h", cprefix = "NM_DEVICE_ERROR_")]
	public errordomain DeviceError {
		[CCode (cname = "NM_DEVICE_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_ERROR_INTERFACE_MISMATCH")]
		INTERFACEMISMATCH;
		[Version (since = "0.9.10")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-ethernet.h", cprefix = "NM_DEVICE_ETHERNET_ERROR_")]
	public errordomain DeviceEthernetError {
		[CCode (cname = "NM_DEVICE_ETHERNET_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_ETHERNET_ERROR_NOT_ETHERNET_CONNECTION")]
		NOTETHERNETCONNECTION,
		[CCode (cname = "NM_DEVICE_ETHERNET_ERROR_INVALID_ETHERNET_CONNECTION")]
		INVALIDETHERNETCONNECTION,
		[CCode (cname = "NM_DEVICE_ETHERNET_ERROR_INVALID_DEVICE_MAC")]
		INVALIDDEVICEMAC,
		[CCode (cname = "NM_DEVICE_ETHERNET_ERROR_MAC_MISMATCH")]
		MACMISMATCH;
		[CCode (cheader_filename = "nm-device-ethernet.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-generic.h", cprefix = "NM_DEVICE_GENERIC_ERROR_")]
	public errordomain DeviceGenericError {
		[CCode (cname = "NM_DEVICE_GENERIC_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_GENERIC_ERROR_NOT_GENERIC_CONNECTION")]
		NOTGENERICCONNECTION,
		[CCode (cname = "NM_DEVICE_GENERIC_ERROR_MISSING_INTERFACE_NAME")]
		MISSINGINTERFACENAME;
		[CCode (cheader_filename = "nm-device-generic.h")]
		[Version (since = "0.9.10")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-infiniband.h", cprefix = "NM_DEVICE_INFINIBAND_ERROR_")]
	public errordomain DeviceInfinibandError {
		[CCode (cname = "NM_DEVICE_INFINIBAND_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_INFINIBAND_ERROR_NOT_INFINIBAND_CONNECTION")]
		NOTINFINIBANDCONNECTION,
		[CCode (cname = "NM_DEVICE_INFINIBAND_ERROR_INVALID_INFINIBAND_CONNECTION")]
		INVALIDINFINIBANDCONNECTION,
		[CCode (cname = "NM_DEVICE_INFINIBAND_ERROR_INVALID_DEVICE_MAC")]
		INVALIDDEVICEMAC,
		[CCode (cname = "NM_DEVICE_INFINIBAND_ERROR_MAC_MISMATCH")]
		MACMISMATCH;
		[CCode (cheader_filename = "nm-device-infiniband.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-modem.h", cprefix = "NM_DEVICE_MODEM_ERROR_")]
	public errordomain DeviceModemError {
		[CCode (cname = "NM_DEVICE_MODEM_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_MODEM_ERROR_NOT_MODEM_CONNECTION")]
		NOTMODEMCONNECTION,
		[CCode (cname = "NM_DEVICE_MODEM_ERROR_INVALID_MODEM_CONNECTION")]
		INVALIDMODEMCONNECTION,
		[CCode (cname = "NM_DEVICE_MODEM_ERROR_MISSING_DEVICE_CAPS")]
		MISSINGDEVICECAPS;
		[CCode (cheader_filename = "nm-device-modem.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-olpc-mesh.h", cprefix = "NM_DEVICE_OLPC_MESH_ERROR_")]
	public errordomain DeviceOlpcMeshError {
		[CCode (cname = "NM_DEVICE_OLPC_MESH_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_OLPC_MESH_ERROR_NOT_OLPC_MESH_CONNECTION")]
		NOTOLPCMESHCONNECTION,
		[CCode (cname = "NM_DEVICE_OLPC_MESH_ERROR_INVALID_OLPC_MESH_CONNECTION")]
		INVALIDOLPCMESHCONNECTION;
		[CCode (cheader_filename = "nm-device-olpc-mesh.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-team.h", cprefix = "NM_DEVICE_TEAM_ERROR_")]
	public errordomain DeviceTeamError {
		[CCode (cname = "NM_DEVICE_TEAM_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_TEAM_ERROR_NOT_TEAM_CONNECTION")]
		NOTTEAMCONNECTION,
		[CCode (cname = "NM_DEVICE_TEAM_ERROR_INVALID_TEAM_CONNECTION")]
		INVALIDTEAMCONNECTION,
		[CCode (cname = "NM_DEVICE_TEAM_ERROR_INTERFACE_MISMATCH")]
		INTERFACEMISMATCH;
		[CCode (cheader_filename = "nm-device-team.h", cname = "nm_device_team_error_quark")]
		[Version (since = "0.9.10")]
		public static GLib.Quark _quark ();
	}
	[CCode (cheader_filename = "nm-device-vlan.h", cprefix = "NM_DEVICE_VLAN_ERROR_")]
	public errordomain DeviceVlanError {
		[CCode (cname = "NM_DEVICE_VLAN_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_VLAN_ERROR_NOT_VLAN_CONNECTION")]
		NOTVLANCONNECTION,
		[CCode (cname = "NM_DEVICE_VLAN_ERROR_INVALID_VLAN_CONNECTION")]
		INVALIDVLANCONNECTION,
		[CCode (cname = "NM_DEVICE_VLAN_ERROR_ID_MISMATCH")]
		IDMISMATCH,
		[CCode (cname = "NM_DEVICE_VLAN_ERROR_INTERFACE_MISMATCH")]
		INTERFACEMISMATCH,
		[CCode (cname = "NM_DEVICE_VLAN_ERROR_MAC_MISMATCH")]
		MACMISMATCH;
		[CCode (cheader_filename = "nm-device-vlan.h", cname = "nm_device_vlan_error_quark")]
		public static GLib.Quark _quark ();
	}
	[CCode (cheader_filename = "nm-device-wifi.h", cprefix = "NM_DEVICE_WIFI_ERROR_")]
	public errordomain DeviceWifiError {
		[CCode (cname = "NM_DEVICE_WIFI_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_WIFI_ERROR_NOT_WIFI_CONNECTION")]
		NOTWIFICONNECTION,
		[CCode (cname = "NM_DEVICE_WIFI_ERROR_INVALID_WIFI_CONNECTION")]
		INVALIDWIFICONNECTION,
		[CCode (cname = "NM_DEVICE_WIFI_ERROR_INVALID_DEVICE_MAC")]
		INVALIDDEVICEMAC,
		[CCode (cname = "NM_DEVICE_WIFI_ERROR_MAC_MISMATCH")]
		MACMISMATCH,
		[CCode (cname = "NM_DEVICE_WIFI_ERROR_MISSING_DEVICE_WPA_CAPS")]
		MISSINGDEVICEWPACAPS,
		[CCode (cname = "NM_DEVICE_WIFI_ERROR_MISSING_DEVICE_RSN_CAPS")]
		MISSINGDEVICERSNCAPS;
		[CCode (cheader_filename = "nm-device-wifi.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-device-wimax.h", cprefix = "NM_DEVICE_WIMAX_ERROR_")]
	public errordomain DeviceWimaxError {
		[CCode (cname = "NM_DEVICE_WIMAX_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_DEVICE_WIMAX_ERROR_NOT_WIMAX_CONNECTION")]
		NOTWIMAXCONNECTION,
		[CCode (cname = "NM_DEVICE_WIMAX_ERROR_INVALID_WIMAX_CONNECTION")]
		INVALIDWIMAXCONNECTION,
		[CCode (cname = "NM_DEVICE_WIMAX_ERROR_INVALID_DEVICE_MAC")]
		INVALIDDEVICEMAC,
		[CCode (cname = "NM_DEVICE_WIMAX_ERROR_MAC_MISMATCH")]
		MACMISMATCH;
		[CCode (cheader_filename = "nm-device-wimax.h")]
		[Version (deprecated = true, deprecated_since = "1.2")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-object.h", cprefix = "NM_OBJECT_ERROR_")]
	public errordomain ObjectError {
		UNKNOWN,
		OBJECT_CREATION_FAILURE;
		[CCode (cheader_filename = "nm-object.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NMClient-1.0.h", cprefix = "NM_REMOTE_CONNECTION_ERROR_")]
	public errordomain RemoteConnectionError {
		[CCode (cname = "NM_REMOTE_CONNECTION_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		DISCONNECTED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-remote-settings.h", cprefix = "NM_REMOTE_SETTINGS_ERROR_")]
	public errordomain RemoteSettingsError {
		[CCode (cname = "NM_REMOTE_SETTINGS_ERROR_UNKNOWN")]
		UNKNOWNERROR,
		[CCode (cname = "NM_REMOTE_SETTINGS_ERROR_CONNECTION_REMOVED")]
		CONNECTIONREMOVED,
		[CCode (cname = "NM_REMOTE_SETTINGS_ERROR_CONNECTION_UNAVAILABLE")]
		CONNECTIONUNAVAILABLE,
		[CCode (cname = "NM_REMOTE_SETTINGS_ERROR_SERVICE_UNAVAILABLE")]
		SERVICEUNAVAILABLE;
		[CCode (cheader_filename = "nm-remote-settings.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-secret-agent.h", cprefix = "NM_SECRET_AGENT_ERROR_")]
	public errordomain SecretAgentError {
		[CCode (cname = "NM_SECRET_AGENT_ERROR_NOT_AUTHORIZED")]
		NOTAUTHORIZED,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_INVALID_CONNECTION")]
		INVALIDCONNECTION,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_USER_CANCELED")]
		USERCANCELED,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_AGENT_CANCELED")]
		AGENTCANCELED,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_INTERNAL_ERROR")]
		INTERNALERROR,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_NO_SECRETS")]
		NOSECRETS;
		[CCode (cheader_filename = "nm-secret-agent.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "nm-client.h", instance_pos = 3.9)]
	public delegate void ClientActivateFn (NM.Client client, NM.ActiveConnection active_connection, GLib.Error error);
	[CCode (cheader_filename = "nm-client.h", instance_pos = 4.9)]
	public delegate void ClientAddActivateFn (NM.Client client, NM.ActiveConnection connection, string new_connection_path, GLib.Error error);
	[CCode (cheader_filename = "NMClient-1.0.h", instance_pos = 2.9)]
	public delegate void DeviceCallbackFn (NM.Device device, GLib.Error error);
	[CCode (cheader_filename = "nm-device.h", instance_pos = 2.9)]
	public delegate void DeviceDeactivateFn (NM.Device device, GLib.Error error);
	[CCode (cheader_filename = "NMClient-1.0.h", instance_pos = 2.9)]
	public delegate void DeviceWifiRequestScanFn (NM.DeviceWifi device, GLib.Error error);
	[CCode (cheader_filename = "nm-remote-connection.h", instance_pos = 2.9)]
	public delegate void RemoteConnectionCommitFunc (NM.RemoteConnection connection, GLib.Error error);
	[CCode (cheader_filename = "nm-remote-connection.h", instance_pos = 2.9)]
	public delegate void RemoteConnectionDeleteFunc (NM.RemoteConnection connection, GLib.Error error);
	[CCode (cheader_filename = "nm-remote-connection.h", instance_pos = 3.9)]
	public delegate void RemoteConnectionGetSecretsFunc (NM.RemoteConnection connection, GLib.HashTable<string,GLib.HashTable<void*,void*>> secrets, GLib.Error error);
	[CCode (cheader_filename = "nm-remote-connection.h", instance_pos = 2.9)]
	public delegate void RemoteConnectionResultFunc (NM.RemoteConnection connection, GLib.Error error);
	[CCode (cheader_filename = "nm-remote-settings.h", instance_pos = 3.9)]
	public delegate void RemoteSettingsAddConnectionFunc (NM.RemoteSettings settings, NM.RemoteConnection connection, GLib.Error error);
	[CCode (cheader_filename = "NMClient-1.0.h", instance_pos = 3.9)]
	public delegate void RemoteSettingsLoadConnectionsFunc (NM.RemoteSettings settings, string failures, GLib.Error error);
	[CCode (cheader_filename = "nm-remote-settings.h", instance_pos = 2.9)]
	public delegate void RemoteSettingsSaveHostnameFunc (NM.RemoteSettings settings, GLib.Error error);
	[CCode (cheader_filename = "nm-secret-agent.h", instance_pos = 3.9)]
	public delegate void SecretAgentDeleteSecretsFunc (NM.SecretAgent agent, NM.Connection connection, GLib.Error error);
	[CCode (cheader_filename = "nm-secret-agent.h", instance_pos = 4.9)]
	public delegate void SecretAgentGetSecretsFunc (NM.SecretAgent agent, NM.Connection connection, GLib.HashTable<string,GLib.HashTable<void*,void*>> secrets, GLib.Error error);
	[CCode (cheader_filename = "nm-secret-agent.h", instance_pos = 3.9)]
	public delegate void SecretAgentSaveSecretsFunc (NM.SecretAgent agent, NM.Connection connection, GLib.Error error);
}
