/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class FunctionReferenceGenerationStrategy
extends FunctionGenerationStrategy.CodegenBased {
    private final ResolvedCall<?> resolvedCall;
    private final FunctionDescriptor referencedFunction;
    private final FunctionDescriptor functionDescriptor;
    private final Type receiverType;
    private final StackValue receiverValue;
    private final boolean isInliningStrategy;

    public FunctionReferenceGenerationStrategy(@NotNull GenerationState state2, @NotNull FunctionDescriptor functionDescriptor, @NotNull ResolvedCall<?> resolvedCall2, @Nullable Type receiverType, @Nullable StackValue receiverValue, boolean isInliningStrategy) {
        if (state2 == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(0);
        }
        if (functionDescriptor == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(1);
        }
        if (resolvedCall2 == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(2);
        }
        super(state2);
        this.resolvedCall = resolvedCall2;
        this.referencedFunction = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        this.functionDescriptor = functionDescriptor;
        this.receiverType = receiverType;
        this.receiverValue = receiverValue;
        this.isInliningStrategy = isInliningStrategy;
        assert (receiverType != null || receiverValue == null) : "A receiver value is provided for unbound function reference. Either this is a bound reference and you forgot to pass receiverType, or you accidentally passed some receiverValue for a reference without receiver";
    }

    @Override
    public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
        StackValue result2;
        if (codegen == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(3);
        }
        if (signature == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(4);
        }
        KtCallExpression fakeExpression = CodegenUtil.constructFakeFunctionCall(this.state.getProject(), this.referencedFunction);
        final List<KtValueArgument> fakeArguments = fakeExpression.getValueArguments();
        final ReceiverValue dispatchReceiver = this.computeAndSaveReceiver(signature, codegen, this.referencedFunction.getDispatchReceiverParameter());
        final ReceiverValue extensionReceiver = this.computeAndSaveReceiver(signature, codegen, this.referencedFunction.getExtensionReceiverParameter());
        this.computeAndSaveArguments(fakeArguments, codegen);
        DelegatingResolvedCall<CallableDescriptor> fakeResolvedCall2 = new DelegatingResolvedCall<CallableDescriptor>(this.resolvedCall){
            private final Map<ValueParameterDescriptor, ResolvedValueArgument> argumentMap;
            {
                super(resolvedCall2);
                this.argumentMap = new LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument>(fakeArguments.size());
                int index2 = 0;
                List<ValueParameterDescriptor> parameters2 = FunctionReferenceGenerationStrategy.this.functionDescriptor.getValueParameters();
                for (ValueArgument argument : fakeArguments) {
                    this.argumentMap.put(parameters2.get(index2), new ExpressionValueArgument(argument));
                    ++index2;
                }
            }

            @Override
            @Nullable
            public ReceiverValue getExtensionReceiver() {
                return extensionReceiver;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return dispatchReceiver;
            }

            @Override
            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                ArrayList<ResolvedValueArgument> arrayList = new ArrayList<ResolvedValueArgument>(this.argumentMap.values());
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            @Override
            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = this.argumentMap;
                if (map2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArgumentsByIndex";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueArguments";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        Type returnType = codegen.getReturnType();
        if (this.referencedFunction instanceof ConstructorDescriptor) {
            result2 = returnType.getSort() == 9 ? codegen.generateNewArray(fakeExpression, this.referencedFunction.getReturnType(), fakeResolvedCall2) : codegen.generateConstructorCall(fakeResolvedCall2, returnType);
        } else {
            Call call2 = CallMaker.makeCall(fakeExpression, null, null, fakeExpression, fakeArguments);
            result2 = codegen.invokeFunction(call2, fakeResolvedCall2, StackValue.none());
        }
        InstructionAdapter v = codegen.v;
        result2.put(returnType, v);
        v.areturn(returnType);
    }

    private void computeAndSaveArguments(@NotNull List<? extends ValueArgument> fakeArguments, @NotNull ExpressionCodegen codegen) {
        int receivers;
        if (fakeArguments == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(5);
        }
        if (codegen == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(6);
        }
        if ((receivers = (this.referencedFunction.getDispatchReceiverParameter() != null ? 1 : 0) + (this.referencedFunction.getExtensionReceiverParameter() != null ? 1 : 0) - (this.receiverType != null ? 1 : 0)) < 0 && this.referencedFunction instanceof ConstructorDescriptor && DescriptorUtils.isObject(this.referencedFunction.getContainingDeclaration().getContainingDeclaration())) {
            receivers = 0;
        }
        List<ValueParameterDescriptor> parameters2 = CollectionsKt.drop(this.functionDescriptor.getValueParameters(), receivers);
        for (int i = 0; i < parameters2.size(); ++i) {
            ValueParameterDescriptor parameter = parameters2.get(i);
            ValueArgument fakeArgument = fakeArguments.get(i);
            Type type2 = this.state.getTypeMapper().mapType(parameter);
            int localIndex = codegen.myFrameMap.getIndex(parameter);
            codegen.tempVariables.put(fakeArgument.getArgumentExpression(), StackValue.local(localIndex, type2));
        }
    }

    @Nullable
    private ReceiverValue computeAndSaveReceiver(@NotNull JvmMethodSignature signature, @NotNull ExpressionCodegen codegen, @Nullable ReceiverParameterDescriptor receiver) {
        if (signature == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(7);
        }
        if (codegen == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(8);
        }
        if (receiver == null) {
            return null;
        }
        KtExpression receiverExpression = KtPsiFactoryKt.KtPsiFactory(this.state.getProject(), false).createExpression("callableReferenceFakeReceiver");
        codegen.tempVariables.put(receiverExpression, this.receiverParameterStackValue(signature, codegen));
        return ExpressionReceiver.Companion.create(receiverExpression, receiver.getType(), BindingContext.EMPTY);
    }

    @NotNull
    private StackValue receiverParameterStackValue(@NotNull JvmMethodSignature signature, @NotNull ExpressionCodegen codegen) {
        if (signature == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(9);
        }
        if (codegen == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(10);
        }
        if (this.receiverValue != null) {
            StackValue stackValue = this.receiverValue;
            if (stackValue == null) {
                FunctionReferenceGenerationStrategy.$$$reportNull$$$0(11);
            }
            return stackValue;
        }
        if (this.receiverType != null) {
            ClassDescriptor classDescriptor = (ClassDescriptor)codegen.getContext().getParentContext().getContextDescriptor();
            Type asmType = codegen.getState().getTypeMapper().mapClass(classDescriptor);
            StackValue stackValue = CallableReferenceUtilKt.capturedBoundReferenceReceiver(asmType, this.receiverType, this.isInliningStrategy);
            if (stackValue == null) {
                FunctionReferenceGenerationStrategy.$$$reportNull$$$0(12);
            }
            return stackValue;
        }
        StackValue.Local local = StackValue.local(1, signature.getAsmMethod().getArgumentTypes()[0]);
        if (local == null) {
            FunctionReferenceGenerationStrategy.$$$reportNull$$$0(13);
        }
        return local;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeArguments";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "receiverParameterStackValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateBody";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeAndSaveArguments";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeAndSaveReceiver";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "receiverParameterStackValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

