/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import com.google.common.collect.HashMultimap;
import com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import com.intellij.util.containers.SLRUCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.FunctionReaderKt;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.utils.JsLibraryUtils;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b*\u0002\u0006\u0016\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001d\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007RN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "functionCache", "org/jetbrains/kotlin/js/inline/FunctionReader$functionCache$1", "Lorg/jetbrains/kotlin/js/inline/FunctionReader$functionCache$1;", "moduleNameToInfo", "Lcom/google/common/collect/HashMultimap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/js/inline/FunctionReader$ModuleInfo;", "contains", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "get", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "getRootPackage", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "offset", "org/jetbrains/kotlin/js/inline/FunctionReader$offset$1", "text", "", "(Ljava/lang/String;I)Lorg/jetbrains/kotlin/js/inline/FunctionReader$offset$1;", "readFunction", "readFunctionFromSource", "info", "rewindToIdentifierStart", "index", "ModuleInfo", "kotlin-compiler"})
public final class FunctionReader {
    private final HashMultimap<String, ModuleInfo> moduleNameToInfo;
    private final functionCache.1 functionCache;
    private final TranslationContext context;

    private final int rewindToIdentifierStart(String text2, int index2) {
        int result2;
        for (result2 = index2; result2 > 0 && Character.isJavaIdentifierPart(text2.charAt(result2 - 1)); --result2) {
        }
        return result2;
    }

    private final offset.1 offset(String text2, int offset2) {
        return new CharSequence(text2, offset2){
            final /* synthetic */ String $text;
            final /* synthetic */ int $offset;

            public int getLength() {
                return this.$text.length() - this.$offset;
            }

            public char get(int index2) {
                return this.$text.charAt(index2 + this.$offset);
            }

            @NotNull
            public CharSequence subSequence(int startIndex, int endIndex) {
                return this.$text.subSequence(startIndex + this.$offset, endIndex + this.$offset);
            }

            @NotNull
            public String toString() {
                String string = this.$text;
                int n = this.$offset;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
                return string3;
            }
            {
                this.$text = $captured_local_variable$0;
                this.$offset = $captured_local_variable$1;
            }
        };
    }

    public final boolean contains(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        String moduleName = JsDescriptorUtils.getModuleName(descriptor2);
        String currentModuleName = this.context.getConfig().getModuleId();
        return Intrinsics.areEqual(currentModuleName, moduleName) ^ true && this.moduleNameToInfo.keys().contains(moduleName);
    }

    @NotNull
    public final JsFunction get(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Object v = this.functionCache.get(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(v, "functionCache.get(descriptor)");
        return (JsFunction)v;
    }

    private final JsFunction readFunction(CallableDescriptor descriptor2) {
        if (this.contains(descriptor2) ^ true) {
            return null;
        }
        String moduleName = JsDescriptorUtils.getModuleName(descriptor2);
        Iterator iterator2 = this.moduleNameToInfo.get((Object)moduleName).iterator();
        while (iterator2.hasNext()) {
            ModuleInfo info;
            ModuleInfo moduleInfo = info = (ModuleInfo)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(moduleInfo, "info");
            JsFunction function2 = this.readFunctionFromSource(descriptor2, moduleInfo);
            if (function2 == null) continue;
            return function2;
        }
        return null;
    }

    private final JsFunction readFunctionFromSource(CallableDescriptor descriptor2, ModuleInfo info) {
        int offset2;
        String source = info.getFileContent();
        String tag = Namer.getFunctionTag(descriptor2);
        CharSequence charSequence = source;
        String string = tag;
        Intrinsics.checkExpressionValueIsNotNull(string, "tag");
        int index2 = StringsKt.indexOf$default(charSequence, string, 0, false, 6, null);
        if (index2 < 0) {
            return null;
        }
        for (offset2 = index2 + tag.length() + 1; offset2 < source.length() && FunctionReaderKt.access$isWhitespaceOrComma$p(source.charAt(offset2)); ++offset2) {
        }
        JsFunction function2 = ParserUtilsKt.parseFunction(source, offset2, ThrowExceptionOnErrorReporter.INSTANCE, new JsRootScope(new JsProgram()));
        JsExpression jsExpression = this.context.getModuleExpressionFor(descriptor2);
        if (jsExpression == null) {
            jsExpression = this.getRootPackage();
        }
        JsExpression moduleReference = jsExpression;
        HashMap replacements = MapsKt.hashMapOf(TuplesKt.to(info.getModuleVariable(), moduleReference), TuplesKt.to(info.getKotlinVariable(), Namer.kotlinObject()));
        FunctionReaderKt.access$replaceExternalNames(function2, replacements);
        FunctionReaderKt.access$markInlineArguments(function2, descriptor2);
        return function2;
    }

    private final JsExpression getRootPackage() {
        JsName rootName = this.context.program().getRootScope().declareName(Namer.getRootPackageName());
        JsNameRef jsNameRef = JsAstUtils.pureFqn(rootName, null);
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "JsAstUtils.pureFqn(rootName, null)");
        return jsNameRef;
    }

    /*
     * WARNING - void declaration
     */
    public FunctionReader(@NotNull TranslationContext context) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.moduleNameToInfo = HashMultimap.create();
        Iterable iterable = $receiver$iv = (Iterable)this.context.getConfig().getLibraries();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file2 = new File((String)p1);
            collection.add(file2);
        }
        List libs = (List)destination$iv$iv;
        JsLibraryUtils.traverseJsLibraries(libs, (Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(){

            @Override
            public final void invoke(@NotNull String fileContent, @NotNull String $noName_1) {
                int index2;
                Intrinsics.checkParameterIsNotNull(fileContent, "fileContent");
                Intrinsics.checkParameterIsNotNull($noName_1, "<anonymous parameter 1>");
                int current = 0;
                while ((index2 = StringsKt.indexOf$default((CharSequence)fileContent, FunctionReaderKt.access$getDEFINE_MODULE_FIND_PATTERN$p(), current, false, 4, null)) >= 0) {
                    current = index2 + 1;
                    index2 = this.rewindToIdentifierStart(fileContent, index2);
                    Matcher preciseMatcher = FunctionReaderKt.access$getDEFINE_MODULE_PATTERN$p().matcher(this.offset(fileContent, index2));
                    if (!preciseMatcher.lookingAt()) continue;
                    String moduleName = preciseMatcher.group(3);
                    String moduleVariable = preciseMatcher.group(4);
                    String kotlinVariable = preciseMatcher.group(1);
                    HashMultimap hashMultimap = moduleNameToInfo;
                    String string = moduleVariable;
                    Intrinsics.checkExpressionValueIsNotNull(string, "moduleVariable");
                    String string2 = kotlinVariable;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "kotlinVariable");
                    hashMultimap.put(moduleName, new ModuleInfo(fileContent, string, string2));
                }
            }
        });
        this.functionCache = new SLRUCache<CallableDescriptor, JsFunction>(this, 50, 50){
            final /* synthetic */ FunctionReader this$0;

            @NotNull
            public JsFunction createValue(@NotNull CallableDescriptor descriptor2) {
                JsFunction $receiver$iv;
                Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
                JsFunction jsFunction = $receiver$iv = FunctionReader.access$readFunction(this.this$0, descriptor2);
                if (jsFunction == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "Could not read function: " + descriptor2;
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                return jsFunction;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    @Nullable
    public static final /* synthetic */ JsFunction access$readFunction(FunctionReader $this, @NotNull CallableDescriptor descriptor2) {
        return $this.readFunction(descriptor2);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/inline/FunctionReader$ModuleInfo;", "", "fileContent", "", "moduleVariable", "kotlinVariable", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileContent", "()Ljava/lang/String;", "getKotlinVariable", "getModuleVariable", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-compiler"})
    public static final class ModuleInfo {
        @NotNull
        private final String fileContent;
        @NotNull
        private final String moduleVariable;
        @NotNull
        private final String kotlinVariable;

        @NotNull
        public final String getFileContent() {
            return this.fileContent;
        }

        @NotNull
        public final String getModuleVariable() {
            return this.moduleVariable;
        }

        @NotNull
        public final String getKotlinVariable() {
            return this.kotlinVariable;
        }

        public ModuleInfo(@NotNull String fileContent, @NotNull String moduleVariable, @NotNull String kotlinVariable) {
            Intrinsics.checkParameterIsNotNull(fileContent, "fileContent");
            Intrinsics.checkParameterIsNotNull(moduleVariable, "moduleVariable");
            Intrinsics.checkParameterIsNotNull(kotlinVariable, "kotlinVariable");
            this.fileContent = fileContent;
            this.moduleVariable = moduleVariable;
            this.kotlinVariable = kotlinVariable;
        }

        @NotNull
        public final String component1() {
            return this.fileContent;
        }

        @NotNull
        public final String component2() {
            return this.moduleVariable;
        }

        @NotNull
        public final String component3() {
            return this.kotlinVariable;
        }

        @NotNull
        public final ModuleInfo copy(@NotNull String fileContent, @NotNull String moduleVariable, @NotNull String kotlinVariable) {
            Intrinsics.checkParameterIsNotNull(fileContent, "fileContent");
            Intrinsics.checkParameterIsNotNull(moduleVariable, "moduleVariable");
            Intrinsics.checkParameterIsNotNull(kotlinVariable, "kotlinVariable");
            return new ModuleInfo(fileContent, moduleVariable, kotlinVariable);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ModuleInfo copy$default(ModuleInfo moduleInfo, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleInfo.fileContent;
            }
            if ((n & 2) != 0) {
                string2 = moduleInfo.moduleVariable;
            }
            if ((n & 4) != 0) {
                string3 = moduleInfo.kotlinVariable;
            }
            return moduleInfo.copy(string, string2, string3);
        }

        public String toString() {
            return "ModuleInfo(fileContent=" + this.fileContent + ", moduleVariable=" + this.moduleVariable + ", kotlinVariable=" + this.kotlinVariable + ")";
        }

        public int hashCode() {
            String string = this.fileContent;
            String string2 = this.moduleVariable;
            String string3 = this.kotlinVariable;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModuleInfo)) break block3;
                    ModuleInfo moduleInfo = (ModuleInfo)object;
                    if (!Intrinsics.areEqual(this.fileContent, moduleInfo.fileContent) || !Intrinsics.areEqual(this.moduleVariable, moduleInfo.moduleVariable) || !Intrinsics.areEqual(this.kotlinVariable, moduleInfo.kotlinVariable)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

