/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils;", "", "()V", "PART_CLASS_NAME_SUFFIX", "", "decapitalizeAsJavaClassName", "str", "fileHasTopLevelCallables", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDefaultPartFqName", "Lorg/jetbrains/kotlin/name/FqName;", "facadeClassFqName", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileNameByFacadeName", "facadeClassName", "getFilePartShortName", "fileName", "getFilesWithCallables", "", "files", "", "getPackagePartFqName", "packageFqName", "getPathHashCode", "", "kotlin-compiler"})
public final class PackagePartClassUtils {
    private static final String PART_CLASS_NAME_SUFFIX = "Kt";
    public static final PackagePartClassUtils INSTANCE;

    @JvmStatic
    public static final int getPathHashCode(@NotNull VirtualFile file2) {
        String string;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        String string2 = string = file2.getPath();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
        return string3.hashCode();
    }

    @JvmStatic
    private static final String decapitalizeAsJavaClassName(String str) {
        String string;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            String string2;
            String string3 = str;
            int n = 0;
            int n2 = 1;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string2 = string5;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull(locale, "Locale.ENGLISH");
            Locale locale2 = locale;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull(string7, "(this as java.lang.String).toLowerCase(locale)");
            string2 = string7;
            string3 = str;
            int n3 = 1;
            stringBuilder = stringBuilder.append(string2);
            String string8 = string3;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n3);
            Intrinsics.checkExpressionValueIsNotNull(string9, "(this as java.lang.String).substring(startIndex)");
            string2 = string9;
            string = stringBuilder.append(string2).toString();
        } else if (str.charAt(0) == '_') {
            String string10 = str;
            int n = 1;
            String string11 = string10;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string12 = string11.substring(n);
            string = string12;
            Intrinsics.checkExpressionValueIsNotNull(string12, "(this as java.lang.String).substring(startIndex)");
        } else {
            string = str;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultPartFqName(@NotNull FqName facadeClassFqName, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull(facadeClassFqName, "facadeClassFqName");
        Intrinsics.checkParameterIsNotNull(file2, "file");
        FqName fqName2 = facadeClassFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "facadeClassFqName.parent()");
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return PackagePartClassUtils.getPackagePartFqName(fqName2, string);
    }

    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull FqName packageFqName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        String partClassName = PackagePartClassUtils.getFilePartShortName(fileName);
        FqName fqName2 = packageFqName.child(Name.identifier(partClassName));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFqName.child(Name\u2026dentifier(partClassName))");
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<KtFile> getFilesWithCallables(@NotNull Collection<? extends KtFile> files2) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(files2, "files");
        Iterable iterable = $receiver$iv = (Iterable)files2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            if (!PackagePartClassUtils.fileHasTopLevelCallables(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @JvmStatic
    public static final boolean fileHasTopLevelCallables(@NotNull KtFile file2) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(file2, "file");
            Iterable $receiver$iv = file2.getDeclarations();
            for (Object element$iv : $receiver$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                if (!((it instanceof KtProperty || it instanceof KtNamedFunction || it instanceof KtScript || it instanceof KtTypeAlias) && !it.hasModifier(KtTokens.HEADER_KEYWORD))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final String getFilePartShortName(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        StringBuilder stringBuilder = new StringBuilder();
        String string = FileUtil.getNameWithoutExtension(fileName);
        Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.getNameWithoutExtension(fileName)");
        return stringBuilder.append(NameUtils.getPackagePartClassNamePrefix(string)).append(PART_CLASS_NAME_SUFFIX).toString();
    }

    @JvmStatic
    @Nullable
    public static final String getFileNameByFacadeName(@NotNull String facadeClassName) {
        Intrinsics.checkParameterIsNotNull(facadeClassName, "facadeClassName");
        if (!StringsKt.endsWith$default(facadeClassName, PART_CLASS_NAME_SUFFIX, false, 2, null)) {
            return null;
        }
        String string = facadeClassName;
        int n = 0;
        int n2 = facadeClassName.length() - PART_CLASS_NAME_SUFFIX.length();
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String baseName = string2;
        if (Intrinsics.areEqual(baseName, "_")) {
            return null;
        }
        return PackagePartClassUtils.decapitalizeAsJavaClassName(baseName) + "." + "kt";
    }

    private PackagePartClassUtils() {
        INSTANCE = this;
        PART_CLASS_NAME_SUFFIX = PART_CLASS_NAME_SUFFIX;
    }

    static {
        new PackagePartClassUtils();
    }
}

