/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.tools;

import com.apple.eio.FileManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatingSystem {
    private static final String EDITOR_SUB_FOLDER;
    private static final String APPLICATION_SUB_FOLDER;
    private static final String TEMPORARY_SUB_FOLDER;
    private static final String TEMPORARY_SESSION_SUB_FOLDER;

    private OperatingSystem() {
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    public static boolean isMacOSXLeopardOrSuperior() {
        return OperatingSystem.isMacOSX() && !System.getProperty("os.version").startsWith("10.4");
    }

    public static boolean isMacOSXLionOrSuperior() {
        return OperatingSystem.isMacOSX() && OperatingSystem.compareVersions(System.getProperty("os.version"), "10.7") >= 0;
    }

    public static boolean isMacOSXYosemiteOrSuperior() {
        return OperatingSystem.isMacOSX() && OperatingSystem.compareVersions(System.getProperty("os.version"), "10.10") >= 0;
    }

    public static boolean isJavaVersionGreaterOrEqual(String string) {
        return OperatingSystem.compareVersions(string, OperatingSystem.getComparableJavaVersion()) <= 0;
    }

    public static boolean isJavaVersionBetween(String string, String string2) {
        String string3 = OperatingSystem.getComparableJavaVersion();
        return OperatingSystem.compareVersions(string, string3) <= 0 && OperatingSystem.compareVersions(string3, string2) < 0;
    }

    private static String getComparableJavaVersion() {
        String string = System.getProperty("java.version");
        try {
            if ("OpenJDK Runtime Environment".equals(System.getProperty("java.runtime.name"))) {
                string = string.replace("-u", "_");
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return string;
    }

    public static int compareVersions(String string, String string2) {
        List<Object> list = OperatingSystem.splitVersion(string);
        List<Object> list2 = OperatingSystem.splitVersion(string2);
        for (int i = 0; i < list.size() || i < list2.size(); ++i) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = i < list.size() ? OperatingSystem.convertPreReleaseVersion(list.get(i)) : BigInteger.ZERO;
            BigInteger bigInteger3 = bigInteger = i < list2.size() ? OperatingSystem.convertPreReleaseVersion(list2.get(i)) : BigInteger.ZERO;
            if (bigInteger2.getClass() == bigInteger.getClass()) {
                int n = ((Comparable)bigInteger2).compareTo(bigInteger);
                if (n == 0) continue;
                return n;
            }
            if (bigInteger2 instanceof String) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private static List<Object> splitVersion(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split("\\p{Punct}|\\s")) {
            int n = 0;
            while (n < string2.length()) {
                stringBuilder.setLength(0);
                char c = string2.charAt(n);
                if (Character.isDigit(c)) {
                    while (n < string2.length() && Character.isDigit(c = string2.charAt(n))) {
                        stringBuilder.append(c);
                        ++n;
                    }
                    arrayList.add(new BigInteger(stringBuilder.toString()));
                    continue;
                }
                while (n < string2.length() && !Character.isDigit(c = string2.charAt(n))) {
                    stringBuilder.append(c);
                    ++n;
                }
                arrayList.add(stringBuilder.toString());
            }
        }
        return arrayList;
    }

    private static Object convertPreReleaseVersion(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if ("alpha".equalsIgnoreCase(string)) {
                return new BigInteger("-3");
            }
            if ("beta".equalsIgnoreCase(string)) {
                return new BigInteger("-2");
            }
            if ("rc".equalsIgnoreCase(string)) {
                return new BigInteger("-1");
            }
        }
        return object;
    }

    public static File createTemporaryFile(String string, String string2) throws IOException {
        File file;
        try {
            file = OperatingSystem.getDefaultTemporaryFolder(true);
        }
        catch (IOException iOException) {
            file = null;
        }
        File file2 = File.createTempFile(string, string2, file);
        file2.deleteOnExit();
        return file2;
    }

    public static Comparator<File> getFileVersionComparator() {
        return new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                String string;
                String string2 = file.getName();
                String string3 = file2.getName();
                int n = string2.lastIndexOf(46);
                String string4 = n != -1 ? string2.substring(n) : null;
                int n2 = string3.lastIndexOf(46);
                String string5 = string = n2 != -1 ? string3.substring(n2) : null;
                if (string4 != null && string4.equals(string)) {
                    string2 = string2.substring(0, n);
                    string3 = string3.substring(0, n2);
                }
                return OperatingSystem.compareVersions(string2, string3);
            }
        };
    }

    public static void deleteTemporaryFiles() {
        try {
            File file = OperatingSystem.getDefaultTemporaryFolder(false);
            if (file != null) {
                for (File file2 : file.listFiles()) {
                    file2.delete();
                }
                file.delete();
            }
        }
        catch (IOException iOException) {
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private static synchronized File getDefaultTemporaryFolder(boolean bl) throws IOException {
        if (TEMPORARY_SUB_FOLDER != null) {
            File file = new File(TEMPORARY_SUB_FOLDER).isAbsolute() ? new File(TEMPORARY_SUB_FOLDER) : new File(OperatingSystem.getDefaultApplicationFolder(), TEMPORARY_SUB_FOLDER);
            final File file2 = new File(file, "5300-" + TEMPORARY_SESSION_SUB_FOLDER);
            if (!file2.exists()) {
                final File[] fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() && file.getName().startsWith("5300-");
                    }
                });
                if (!OperatingSystem.createTemporaryFolders(file2)) {
                    throw new IOException("Can't create temporary folder " + file2);
                }
                new Timer(true).schedule(new TimerTask(){

                    public void run() {
                        file2.setLastModified(Math.max(System.currentTimeMillis(), file2.lastModified() + 60000L));
                    }
                }, 60000L, 60000L);
                if (fileArray != null && fileArray.length > 0) {
                    new Timer(true).schedule(new TimerTask(){

                        public void run() {
                            long l = System.currentTimeMillis();
                            for (File file : fileArray) {
                                File[] fileArray2;
                                if (!file.exists() || l - file.lastModified() <= 604800000L) continue;
                                for (File file2 : fileArray2 = file.listFiles()) {
                                    file2.delete();
                                }
                                file.delete();
                            }
                        }
                    }, 600000L);
                }
            }
            return file2;
        }
        return null;
    }

    private static boolean createTemporaryFolders(File file) {
        if (file.exists()) {
            return false;
        }
        if (file.mkdir()) {
            file.deleteOnExit();
            return true;
        }
        File file2 = null;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        File file3 = file2.getParentFile();
        if (file3 != null && (OperatingSystem.createTemporaryFolders(file3) || file3.exists()) && file2.mkdir()) {
            file.deleteOnExit();
            return true;
        }
        return false;
    }

    public static File getDefaultApplicationFolder() throws IOException {
        File file;
        if (OperatingSystem.isMacOSX()) {
            file = new File(MacOSXFileManager.getApplicationSupportFolder());
        } else if (OperatingSystem.isWindows()) {
            file = new File(System.getProperty("user.home"), "Application Data");
            if (!file.exists()) {
                file = new File(System.getProperty("user.home"));
            }
        } else {
            file = new File(System.getProperty("user.home"));
        }
        return new File(file, EDITOR_SUB_FOLDER + File.separator + APPLICATION_SUB_FOLDER);
    }

    static {
        String string;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(OperatingSystem.class.getName());
        if (OperatingSystem.isMacOSX()) {
            EDITOR_SUB_FOLDER = resourceBundle.getString("editorSubFolder.Mac OS X");
            APPLICATION_SUB_FOLDER = resourceBundle.getString("applicationSubFolder.Mac OS X");
        } else if (OperatingSystem.isWindows()) {
            EDITOR_SUB_FOLDER = resourceBundle.getString("editorSubFolder.Windows");
            APPLICATION_SUB_FOLDER = resourceBundle.getString("applicationSubFolder.Windows");
        } else {
            EDITOR_SUB_FOLDER = resourceBundle.getString("editorSubFolder");
            APPLICATION_SUB_FOLDER = resourceBundle.getString("applicationSubFolder");
        }
        try {
            string = resourceBundle.getString("temporarySubFolder");
            if (string.trim().length() == 0) {
                string = null;
            }
        }
        catch (MissingResourceException missingResourceException) {
            string = "work";
        }
        try {
            string = System.getProperty("com.eteks.sweethome3d.tools.temporarySubFolder", string);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        TEMPORARY_SUB_FOLDER = string;
        TEMPORARY_SESSION_SUB_FOLDER = UUID.randomUUID().toString();
    }

    private static class MacOSXFileManager {
        private MacOSXFileManager() {
        }

        public static String getApplicationSupportFolder() throws IOException {
            return FileManager.findFolder((short)-32763, (int)1634956656);
        }
    }
}

