#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: statistics
version: 0.13.3.0
id: statistics-0.13.3.0-3odQbqBOMQX6SdSeB3Xpg6
key: statistics-0.13.3.0-3odQbqBOMQX6SdSeB3Xpg6
license: BSD3
copyright: 2009-2014 Bryan O'\''Sullivan
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
homepage: https://github.com/bos/statistics
synopsis: A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
    samples.
category: Math, Statistics
author: Bryan O'\''Sullivan <bos@serpentine.com>
exposed: True
exposed-modules:
    Statistics.Autocorrelation Statistics.Constants
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Normal
    Statistics.Distribution.Poisson Statistics.Distribution.StudentT
    Statistics.Distribution.Transform Statistics.Distribution.Uniform
    Statistics.Function Statistics.Math.RootFinding Statistics.Matrix
    Statistics.Matrix.Algorithms Statistics.Matrix.Mutable
    Statistics.Matrix.Types Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Powers
    Statistics.Test.ChiSquared Statistics.Test.KolmogorovSmirnov
    Statistics.Test.KruskalWallis Statistics.Test.MannWhitneyU
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types
hidden-modules: Statistics.Distribution.Poisson.Internal
                Statistics.Function.Comparison Statistics.Internal
                Statistics.Sample.Internal Statistics.Test.Internal
abi: a495a98a412c025aa3bc3a97f29238dd
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/statistics-0.13.3.0
library-dirs: /usr/lib/ghc-8.0.1/site-local/statistics-0.13.3.0
data-dir: /usr/share/arm-linux-ghc-8.0.1/statistics-0.13.3.0
hs-libraries: HSstatistics-0.13.3.0-3odQbqBOMQX6SdSeB3Xpg6
depends:
    aeson-1.1.2.0-KSzOWeOw6cI7ymVovOXtxy base-4.9.0.0 binary-0.8.3.0
    deepseq-1.4.2.0 erf-2.0.0.0-9HTdBV7htNjASgIJAT55AC
    math-functions-0.2.1.0-31FvveTLTlqClGw5YZ5Avx
    monad-par-0.3.4.8-GJRfmoTYMh6FFh5VYwcdb8
    mwc-random-0.13.6.0-FkwmwAh2ZNWGdUe7qkQMIm
    primitive-0.6.2.0-3HSsNCfUEEE4fjqDYVydYZ
    vector-0.12.0.1-FyKxZ6HyOdr5RycjHR2p0f
    vector-algorithms-0.7.0.1-5uWiEsia2ll7iojszUQtFk
    vector-binary-instances-0.2.3.5-7f4DOuSrzuCGDSfkgQUKlt
haddock-interfaces: /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html: /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
