/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.antlr;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.Pair;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.antlr.PainlessLexer;

final class EnhancedPainlessLexer
extends PainlessLexer {
    final String sourceName;
    private Token stashedNext = null;
    private Token previous = null;

    EnhancedPainlessLexer(CharStream charStream, String sourceName) {
        super(charStream);
        this.sourceName = sourceName;
    }

    public Token getPreviousToken() {
        return this.previous;
    }

    public Token nextToken() {
        if (this.stashedNext != null) {
            this.previous = this.stashedNext;
            this.stashedNext = null;
            return this.previous;
        }
        Token next = super.nextToken();
        if (EnhancedPainlessLexer.insertSemicolon(this.previous, next)) {
            this.stashedNext = next;
            this.previous = this._factory.create(new Pair((Object)this, (Object)this._input), 12, ";", 0, next.getStartIndex(), next.getStopIndex(), next.getLine(), next.getCharPositionInLine());
            return this.previous;
        }
        this.previous = next;
        return next;
    }

    public void recover(LexerNoViableAltException lnvae) {
        CharStream charStream = lnvae.getInputStream();
        int startIndex = lnvae.getStartIndex();
        String text = charStream.getText(Interval.of((int)startIndex, (int)charStream.index()));
        Location location = new Location(this.sourceName, this._tokenStartCharIndex);
        String message = "unexpected character [" + this.getErrorDisplay(text) + "].";
        char firstChar = text.charAt(0);
        if ((firstChar == '\'' || firstChar == '\"') && text.length() - 2 > 0 && text.charAt(text.length() - 2) == '\\') {
            message = message + " The only valid escape sequences in strings starting with [" + firstChar + "] are [\\\\] and [\\" + firstChar + "].";
        }
        throw location.createError(new IllegalArgumentException(message, (Throwable)lnvae));
    }

    @Override
    protected boolean isSimpleType(String name) {
        return Definition.isSimpleType(name);
    }

    @Override
    protected boolean slashIsRegex() {
        Token lastToken = this.getPreviousToken();
        if (lastToken == null) {
            return true;
        }
        switch (lastToken.getType()) {
            case 6: 
            case 8: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 82: 
            case 83: 
            case 84: {
                return false;
            }
        }
        return true;
    }

    private static boolean insertSemicolon(Token previous, Token next) {
        if (previous == null || next.getType() != 4) {
            return false;
        }
        switch (previous.getType()) {
            case 3: 
            case 4: 
            case 12: {
                return false;
            }
        }
        return true;
    }
}

