/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.syncml.pim;

import a_vcard.android.content.ContentValues;
import a_vcard.android.syncml.pim.PropertyNode;
import a_vcard.android.syncml.pim.VBuilder;
import a_vcard.android.syncml.pim.VNode;
import a_vcard.android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VDataBuilder
implements VBuilder {
    private static String LOG_TAG = "VDATABuilder";
    public static String DEFAULT_CHARSET = "UTF-8";
    public List<VNode> vNodeList = new ArrayList<VNode>();
    private int mNodeListPos = 0;
    private VNode mCurrentVNode;
    private PropertyNode mCurrentPropNode;
    private String mCurrentParamType;
    private String mSourceCharset;
    private String mTargetCharset;
    private boolean mStrictLineBreakParsing;

    public VDataBuilder() {
        this(DEFAULT_CHARSET, DEFAULT_CHARSET, false);
    }

    public VDataBuilder(String charset, boolean strictLineBreakParsing) {
        this(null, charset, strictLineBreakParsing);
    }

    public VDataBuilder(String sourceCharset, String targetCharset, boolean strictLineBreakParsing) {
        this.mSourceCharset = sourceCharset != null ? sourceCharset : DEFAULT_CHARSET;
        this.mTargetCharset = targetCharset != null ? targetCharset : DEFAULT_CHARSET;
        this.mStrictLineBreakParsing = strictLineBreakParsing;
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
    }

    @Override
    public void startRecord(String type) {
        VNode vnode = new VNode();
        vnode.parseStatus = 1;
        vnode.VName = type;
        this.vNodeList.add(vnode);
        this.mNodeListPos = this.vNodeList.size() - 1;
        this.mCurrentVNode = this.vNodeList.get(this.mNodeListPos);
    }

    @Override
    public void endRecord() {
        VNode endNode = this.vNodeList.get(this.mNodeListPos);
        endNode.parseStatus = 0;
        while (this.mNodeListPos > 0) {
            --this.mNodeListPos;
            if (this.vNodeList.get((int)this.mNodeListPos).parseStatus != 1) continue;
        }
        this.mCurrentVNode = this.vNodeList.get(this.mNodeListPos);
    }

    @Override
    public void startProperty() {
        this.mCurrentPropNode = new PropertyNode();
    }

    @Override
    public void endProperty() {
        this.mCurrentVNode.propList.add(this.mCurrentPropNode);
    }

    @Override
    public void propertyName(String name) {
        this.mCurrentPropNode.propName = name;
    }

    @Override
    public void propertyGroup(String group) {
        this.mCurrentPropNode.propGroupSet.add(group);
    }

    @Override
    public void propertyParamType(String type) {
        this.mCurrentParamType = type;
    }

    @Override
    public void propertyParamValue(String value) {
        if (this.mCurrentParamType == null || this.mCurrentParamType.equalsIgnoreCase("TYPE")) {
            this.mCurrentPropNode.paramMap_TYPE.add(value);
        } else {
            this.mCurrentPropNode.paramMap.put(this.mCurrentParamType, value);
        }
        this.mCurrentParamType = null;
    }

    private String encodeString(String originalString, String targetCharset) {
        if (this.mSourceCharset.equalsIgnoreCase(targetCharset)) {
            return originalString;
        }
        Charset charset = Charset.forName(this.mSourceCharset);
        ByteBuffer byteBuffer = charset.encode(originalString);
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        try {
            return new String(bytes, targetCharset);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(LOG_TAG, "Failed to encode: charset=" + targetCharset);
            return new String(bytes);
        }
    }

    private String handleOneValue(String value, String targetCharset, String encoding) {
        if (encoding != null) {
            if (encoding.equals("BASE64") || encoding.equals("B")) {
                this.mCurrentPropNode.propValue_bytes = Base64.decodeBase64((byte[])value.getBytes());
                return value;
            }
            if (encoding.equals("QUOTED-PRINTABLE")) {
                byte[] bytes;
                StringBuilder builder;
                String[] lines;
                String quotedPrintable = value.replaceAll("= ", " ").replaceAll("=\t", "\t");
                if (this.mStrictLineBreakParsing) {
                    lines = quotedPrintable.split("\r\n");
                } else {
                    builder = new StringBuilder();
                    int length = quotedPrintable.length();
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < length; ++i) {
                        char ch = quotedPrintable.charAt(i);
                        if (ch == '\n') {
                            list.add(builder.toString());
                            builder = new StringBuilder();
                            continue;
                        }
                        if (ch == '\r') {
                            char nextCh;
                            list.add(builder.toString());
                            builder = new StringBuilder();
                            if (i >= length - 1 || (nextCh = quotedPrintable.charAt(i + 1)) != '\n') continue;
                            ++i;
                            continue;
                        }
                        builder.append(ch);
                    }
                    String finalLine = builder.toString();
                    if (finalLine.length() > 0) {
                        list.add(finalLine);
                    }
                    lines = list.toArray(new String[0]);
                }
                builder = new StringBuilder();
                for (String line : lines) {
                    if (line.endsWith("=")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    builder.append(line);
                }
                try {
                    bytes = builder.toString().getBytes(this.mSourceCharset);
                }
                catch (UnsupportedEncodingException e1) {
                    Log.e(LOG_TAG, "Failed to encode: charset=" + this.mSourceCharset);
                    bytes = builder.toString().getBytes();
                }
                try {
                    bytes = QuotedPrintableCodec.decodeQuotedPrintable((byte[])bytes);
                }
                catch (DecoderException e) {
                    Log.e(LOG_TAG, "Failed to decode quoted-printable: " + (Object)((Object)e));
                    return "";
                }
                try {
                    return new String(bytes, targetCharset);
                }
                catch (UnsupportedEncodingException e) {
                    Log.e(LOG_TAG, "Failed to encode: charset=" + targetCharset);
                    return new String(bytes);
                }
            }
        }
        return this.encodeString(value, targetCharset);
    }

    @Override
    public void propertyValues(List<String> values) {
        if (values == null || values.size() == 0) {
            this.mCurrentPropNode.propValue_bytes = null;
            this.mCurrentPropNode.propValue_vector.clear();
            this.mCurrentPropNode.propValue_vector.add("");
            this.mCurrentPropNode.propValue = "";
            return;
        }
        ContentValues paramMap = this.mCurrentPropNode.paramMap;
        String targetCharset = DEFAULT_CHARSET;
        String encoding = paramMap.getAsString("ENCODING");
        if (targetCharset == null || targetCharset.length() == 0) {
            targetCharset = this.mTargetCharset;
        }
        for (String value : values) {
            this.mCurrentPropNode.propValue_vector.add(this.handleOneValue(value, targetCharset, encoding));
        }
        this.mCurrentPropNode.propValue = this.listToString(this.mCurrentPropNode.propValue_vector);
    }

    private String listToString(List<String> list) {
        int size = list.size();
        if (size > 1) {
            StringBuilder typeListB = new StringBuilder();
            for (String type : list) {
                typeListB.append(type).append(";");
            }
            int len = typeListB.length();
            if (len > 0 && typeListB.charAt(len - 1) == ';') {
                return typeListB.substring(0, len - 1);
            }
            return typeListB.toString();
        }
        if (size == 1) {
            return list.get(0);
        }
        return "";
    }

    public String getResult() {
        return null;
    }
}

