/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ClassCache
implements Serializable {
    private static final long serialVersionUID = -8866246036237312215L;
    private static final Object AKEY = "ClassCache";
    private volatile boolean cachingIsEnabled = true;
    private transient Map<Class<?>, JavaMembers> classTable;
    private transient Map<JavaAdapter.JavaAdapterSignature, Class<?>> classAdapterCache;
    private transient Map<Class<?>, Object> interfaceAdapterCache;
    private int generatedClassSerial;
    private Scriptable associatedScope;

    public static ClassCache get(Scriptable scriptable) {
        ClassCache classCache = (ClassCache)ScriptableObject.getTopScopeValue(scriptable, AKEY);
        if (classCache == null) {
            throw new RuntimeException("Can't find top level scope for ClassCache.get");
        }
        return classCache;
    }

    public boolean associate(ScriptableObject scriptableObject) {
        if (scriptableObject.getParentScope() != null) {
            throw new IllegalArgumentException();
        }
        if (this == scriptableObject.associateValue(AKEY, this)) {
            this.associatedScope = scriptableObject;
            return true;
        }
        return false;
    }

    public synchronized void clearCaches() {
        this.classTable = null;
        this.classAdapterCache = null;
        this.interfaceAdapterCache = null;
    }

    public final boolean isCachingEnabled() {
        return this.cachingIsEnabled;
    }

    public synchronized void setCachingEnabled(boolean bl) {
        if (bl == this.cachingIsEnabled) {
            return;
        }
        if (!bl) {
            this.clearCaches();
        }
        this.cachingIsEnabled = bl;
    }

    Map<Class<?>, JavaMembers> getClassCacheMap() {
        if (this.classTable == null) {
            this.classTable = new ConcurrentHashMap(16, 0.75f, 1);
        }
        return this.classTable;
    }

    Map<JavaAdapter.JavaAdapterSignature, Class<?>> getInterfaceAdapterCacheMap() {
        if (this.classAdapterCache == null) {
            this.classAdapterCache = new ConcurrentHashMap(16, 0.75f, 1);
        }
        return this.classAdapterCache;
    }

    @Deprecated
    public boolean isInvokerOptimizationEnabled() {
        return false;
    }

    @Deprecated
    public synchronized void setInvokerOptimizationEnabled(boolean bl) {
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }

    Object getInterfaceAdapter(Class<?> clazz) {
        return this.interfaceAdapterCache == null ? null : this.interfaceAdapterCache.get(clazz);
    }

    synchronized void cacheInterfaceAdapter(Class<?> clazz, Object object) {
        if (this.cachingIsEnabled) {
            if (this.interfaceAdapterCache == null) {
                this.interfaceAdapterCache = new ConcurrentHashMap(16, 0.75f, 1);
            }
            this.interfaceAdapterCache.put(clazz, object);
        }
    }

    Scriptable getAssociatedScope() {
        return this.associatedScope;
    }
}

