/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.CommonBundle;

public class PsiBundle {
    private static Reference<ResourceBundle> ourBundle;

    public static String message(@NotNull @PropertyKey(resourceBundle="messages.PsiBundle") String key, Object ... params) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/PsiBundle", "message"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/com/intellij/psi/PsiBundle", "message"));
        }
        return CommonBundle.message(PsiBundle.getBundle(), key, params);
    }

    private PsiBundle() {
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("messages.PsiBundle");
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    @NotNull
    public static String visibilityPresentation(@NotNull String modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/com/intellij/psi/PsiBundle", "visibilityPresentation"));
        }
        String string = PsiBundle.message(modifier + ".visibility.presentation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiBundle", "visibilityPresentation"));
        }
        return string;
    }
}

